// Type definitions for ArcGIS API for JavaScript 4.12
// Project: http://js.arcgis.com
// Definitions by: Esri <https://github.com/Esri>
//                 Bjorn Svensson <https://github.com/bsvensson>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped
// TypeScript Version: 2.7

interface HashMap<T = any> {
  [index: string]: T;
}

interface IPromiseLike<T = any> {
  then<TResult1 = T, TResult2 = never>(
    onfulfilled?: ((value: T) => TResult1 | IPromiseLike<TResult1>) | undefined | null,
    onrejected?: ((reason: any) => TResult2 | IPromiseLike<TResult2>) | undefined | null
  ): IPromiseLike<TResult1 | TResult2>;
}

interface IPromise<T = any> {
  always<TResult1 = T>(
    callback?: ((valueOrError: T | any) => TResult1 | IPromiseLike<TResult1>) | undefined | null
  ): IPromise<TResult1>;
  cancel?<U>(reason?: U, strict?: boolean): U;
  catch<TResult = never>(
    onrejected?: ((reason: any) => TResult | IPromiseLike<TResult>) | undefined | null
  ): IPromise<T | TResult>;
  isCanceled?(): boolean;
  isFulfilled(): boolean;
  isRejected(): boolean;
  isResolved(): boolean;
  otherwise<TResult = never>(
    onrejected?: ((reason: any) => TResult | IPromiseLike<TResult>) | undefined | null
  ): IPromise<T | TResult>;
  then<TResult1 = T, TResult2 = never>(
    onfulfilled?: ((value: T) => TResult1 | IPromiseLike<TResult1>) | undefined | null,
    onrejected?: ((reason: any) => TResult2 | IPromiseLike<TResult2>) | undefined | null
  ): IPromise<TResult1 | TResult2>;
}

interface IHandle {
  remove(): void;
}

declare namespace JSX {
  interface IntrinsicElements {
    [elementName: string]: any;
  }

  interface Element {}
}

declare namespace __esri {
  export class Accessor {
    constructor(obj?: any);

    destroyed: boolean;
    initialized: boolean;
    declaredClass: string;
    destroy(): void;

    get<T>(propertyName: string): T;
    get(propertyName: string): any;
    set<T>(propertyName: string, value: T): this;
    set(props: HashMap<any>): this;
    watch(path: string | string[], callback: WatchCallback, sync?: boolean): WatchHandle;

    protected notifyChange(propertyName: string): void;
    protected _get(propertyName: string): any;
    protected _get<T>(propertyName: string): T;
    protected _set<T>(propertyName: string, value: T): this;
  }

  export interface AnonymousAccessor extends Object {
    get?<T>(propertyName: string): T;
    get?(propertyName: string): any;
    set?<T>(propertyName: string, value: T): this;
    set?(props: HashMap<any>): this;
    watch?(path: string | string[], callback: WatchCallback, sync?: boolean): WatchHandle;
  }

  export type ItemCallback<T> = (item: T, index: number) => void;

  export type ItemCompareCallback<T> = (firstItem: T, secondItem: T) => number;

  export type ItemMapCallback<T, R> = (item: T, index: number) => R;

  export type ItemReduceCallback<T, R> = (previousValue: R, currentValue: T, index: number) => R;

  export type ItemTestCallback<T> = (item: T, index: number) => boolean;

  export type CollectionAfterAddEventHandler<T> = (event: CollectionAfterEvent<T>) => void;

  export type CollectionAfterChangesEventHandler<T> = (event: CollectionAfterChangesEvent<T>) => void;

  export type CollectionAfterRemoveEventHandler<T> = (event: CollectionAfterEvent<T>) => void;

  export type CollectionChangeEventHandler<T> = (event: CollectionChangeEvent<T>) => void;

  export type CollectionBeforeAddEventHandler<T> = (event: CollectionBeforeEvent<T>) => void;

  export type CollectionBeforeChangesEventHandler<T> = (event: CollectionBeforeEvent<T>) => void;

  export type CollectionBeforeRemoveEventHandler<T> = (event: CollectionBeforeEvent<T>) => void;

  export interface CollectionAfterEvent<T = any> {
    item: T;
  }

  export interface CollectionAfterChangesEvent<T = any> {}

  export interface CollectionBeforeEvent<T = any> {
    item: T;
    preventDefault(): void;
  }

  export interface CollectionChangeEvent<T = any> {
    added: T[];
    removed: T[];
    moved: T[];
  }

  interface Collection<T = any> extends Evented {
    on(type: "after-add", listener: CollectionAfterAddEventHandler<T>): IHandle;
    on(type: "after-changes", listener: CollectionAfterChangesEventHandler<T>): IHandle;
    on(type: "after-remove", listener: CollectionAfterRemoveEventHandler<T>): IHandle;
    on(type: "before-add", listener: CollectionBeforeAddEventHandler<T>): IHandle;
    on(type: "before-changes", listener: CollectionBeforeChangesEventHandler<T>): IHandle;
    on(type: "before-remove", listener: CollectionBeforeRemoveEventHandler<T>): IHandle;
    on(type: "change", listener: CollectionChangeEventHandler<T>): IHandle;
    on(type: string, listener: (event: any) => void): IHandle;
  }

  type Constructor<T> = new (...params: any[]) => T;

  interface Types<T extends Base, Base = T> {
    key: string | ((obj: any) => string);
    base: Constructor<Base> | Function;
    typeMap: HashMap<Constructor<T>>;
  }

  export class Collection<T = any> extends Accessor {
    constructor(values?: any[] | Collection<any>);

    readonly length: number;

    add(item: T, index?: number): void;
    addMany(items: T[] | Collection<T>, index?: number): void;
    clone(): Collection<T>;
    concat(value: T[] | Collection<T>): Collection<T>;
    every(callback: ItemTestCallback<T>): boolean;
    filter(callback: ItemTestCallback<T>): Collection<T>;
    find(callback: ItemTestCallback<T>): T;
    findIndex(callback: ItemTestCallback<T>): number;
    flatten(callback: ItemCallback<T>): Collection<T>;
    forEach(callback: ItemCallback<T>): void;
    getItemAt(index: number): T;
    includes(searchElement: T): boolean;
    indexOf(searchElement: T, fromIndex?: number): number;
    join(separator?: string): string;
    lastIndexOf(searchElement: T, fromIndex?: number): number;
    map<R = T>(callback: ItemMapCallback<T, R>): Collection<R>;
    pop(): T;
    push(item: T): number;
    reduce<R = T>(callback: ItemReduceCallback<T, R>, initialValue?: R): R;
    reduceRight<R = T>(callback: ItemReduceCallback<T, R>, initialValue?: R): R;
    remove(item: T): void;
    removeAll(): void;
    removeAt(index: number): any;
    removeMany(items: T[] | Collection<T>): T[];
    reorder(item: T, index: number): T;
    reverse(): Collection<T>;
    shift(): T;
    slice(begin?: number, end?: number): Collection<T>;
    some(callback: ItemCallback<T>): boolean;
    sort(compareFunction?: ItemCompareCallback<T>): void;
    splice(start: number, deleteCount: number, ...items: T[]): T[];
    toArray(): T[];
    unshift(...items: T[]): number;

    static isCollection<T = any>(value: any | Collection<T>): value is Collection<T>;

    static ofType<T extends Base, Base = T>(
      type: Constructor<T> | Types<T, Base>
    ): new (items?: (T[] | Collection<T>) | { items?: T[] | Collection<T> }) => Collection<T>;
  }

  type CollectionProperties<T = any> = T[] | Collection<T>;

  type DateProperties = number | string | Date;

  export type BaseDynamicLayerLayerviewCreateErrorEventHandler = (
    event: BaseDynamicLayerLayerviewCreateErrorEvent
  ) => void;

  export type BaseDynamicLayerLayerviewCreateEventHandler = (event: BaseDynamicLayerLayerviewCreateEvent) => void;

  export type BaseDynamicLayerLayerviewDestroyEventHandler = (event: BaseDynamicLayerLayerviewDestroyEvent) => void;

  export type BaseElevationLayerLayerviewCreateErrorEventHandler = (
    event: BaseElevationLayerLayerviewCreateErrorEvent
  ) => void;

  export type BaseElevationLayerLayerviewCreateEventHandler = (event: BaseElevationLayerLayerviewCreateEvent) => void;

  export type BaseElevationLayerLayerviewDestroyEventHandler = (event: BaseElevationLayerLayerviewDestroyEvent) => void;

  export type BaseTileLayerLayerviewCreateErrorEventHandler = (event: BaseTileLayerLayerviewCreateErrorEvent) => void;

  export type BaseTileLayerLayerviewCreateEventHandler = (event: BaseTileLayerLayerviewCreateEvent) => void;

  export type BaseTileLayerLayerviewDestroyEventHandler = (event: BaseTileLayerLayerviewDestroyEvent) => void;

  export type BingMapsLayerLayerviewCreateErrorEventHandler = (event: BingMapsLayerLayerviewCreateErrorEvent) => void;

  export type BingMapsLayerLayerviewCreateEventHandler = (event: BingMapsLayerLayerviewCreateEvent) => void;

  export type BingMapsLayerLayerviewDestroyEventHandler = (event: BingMapsLayerLayerviewDestroyEvent) => void;

  export type BuildingSceneLayerLayerviewCreateErrorEventHandler = (
    event: BuildingSceneLayerLayerviewCreateErrorEvent
  ) => void;

  export type BuildingSceneLayerLayerviewCreateEventHandler = (event: BuildingSceneLayerLayerviewCreateEvent) => void;

  export type BuildingSceneLayerLayerviewDestroyEventHandler = (event: BuildingSceneLayerLayerviewDestroyEvent) => void;

  export type ClassedColorSliderMaxChangeEventHandler = (event: ClassedColorSliderMaxChangeEvent) => void;

  export type ClassedColorSliderMinChangeEventHandler = (event: ClassedColorSliderMinChangeEvent) => void;

  export type ClassedColorSliderThumbChangeEventHandler = (event: ClassedColorSliderThumbChangeEvent) => void;

  export type ClassedColorSliderThumbDragEventHandler = (event: ClassedColorSliderThumbDragEvent) => void;

  export type ClassedColorSliderViewModelMaxChangeEventHandler = (
    event: ClassedColorSliderViewModelMaxChangeEvent
  ) => void;

  export type ClassedColorSliderViewModelMinChangeEventHandler = (
    event: ClassedColorSliderViewModelMinChangeEvent
  ) => void;

  export type ClassedColorSliderViewModelValueChangeEventHandler = (
    event: ClassedColorSliderViewModelValueChangeEvent
  ) => void;

  export type ClassedSizeSliderMaxChangeEventHandler = (event: ClassedSizeSliderMaxChangeEvent) => void;

  export type ClassedSizeSliderMinChangeEventHandler = (event: ClassedSizeSliderMinChangeEvent) => void;

  export type ClassedSizeSliderThumbChangeEventHandler = (event: ClassedSizeSliderThumbChangeEvent) => void;

  export type ClassedSizeSliderThumbDragEventHandler = (event: ClassedSizeSliderThumbDragEvent) => void;

  export type ClassedSizeSliderViewModelMaxChangeEventHandler = (
    event: ClassedSizeSliderViewModelMaxChangeEvent
  ) => void;

  export type ClassedSizeSliderViewModelMinChangeEventHandler = (
    event: ClassedSizeSliderViewModelMinChangeEvent
  ) => void;

  export type ClassedSizeSliderViewModelValueChangeEventHandler = (
    event: ClassedSizeSliderViewModelValueChangeEvent
  ) => void;

  export type ColorSizeSliderMaxChangeEventHandler = (event: ColorSizeSliderMaxChangeEvent) => void;

  export type ColorSizeSliderMinChangeEventHandler = (event: ColorSizeSliderMinChangeEvent) => void;

  export type ColorSizeSliderThumbChangeEventHandler = (event: ColorSizeSliderThumbChangeEvent) => void;

  export type ColorSizeSliderThumbDragEventHandler = (event: ColorSizeSliderThumbDragEvent) => void;

  export type ColorSizeSliderViewModelMaxChangeEventHandler = (event: ColorSizeSliderViewModelMaxChangeEvent) => void;

  export type ColorSizeSliderViewModelMinChangeEventHandler = (event: ColorSizeSliderViewModelMinChangeEvent) => void;

  export type ColorSizeSliderViewModelValueChangeEventHandler = (
    event: ColorSizeSliderViewModelValueChangeEvent
  ) => void;

  export type ColorSliderMaxChangeEventHandler = (event: ColorSliderMaxChangeEvent) => void;

  export type ColorSliderMinChangeEventHandler = (event: ColorSliderMinChangeEvent) => void;

  export type ColorSliderThumbChangeEventHandler = (event: ColorSliderThumbChangeEvent) => void;

  export type ColorSliderThumbDragEventHandler = (event: ColorSliderThumbDragEvent) => void;

  export type ColorSliderViewModelMaxChangeEventHandler = (event: ColorSliderViewModelMaxChangeEvent) => void;

  export type ColorSliderViewModelMinChangeEventHandler = (event: ColorSliderViewModelMinChangeEvent) => void;

  export type ColorSliderViewModelValueChangeEventHandler = (event: ColorSliderViewModelValueChangeEvent) => void;

  export type CredentialDestroyEventHandler = (event: CredentialDestroyEvent) => void;

  export type CredentialTokenChangeEventHandler = (event: CredentialTokenChangeEvent) => void;

  export type CSVLayerLayerviewCreateErrorEventHandler = (event: CSVLayerLayerviewCreateErrorEvent) => void;

  export type CSVLayerLayerviewCreateEventHandler = (event: CSVLayerLayerviewCreateEvent) => void;

  export type CSVLayerLayerviewDestroyEventHandler = (event: CSVLayerLayerviewDestroyEvent) => void;

  export type ElevationLayerLayerviewCreateErrorEventHandler = (event: ElevationLayerLayerviewCreateErrorEvent) => void;

  export type ElevationLayerLayerviewCreateEventHandler = (event: ElevationLayerLayerviewCreateEvent) => void;

  export type ElevationLayerLayerviewDestroyEventHandler = (event: ElevationLayerLayerviewDestroyEvent) => void;

  export type ElevationSamplerChangedEventHandler = (event: ElevationSamplerChangedEvent) => void;

  export type FeatureLayerLayerviewCreateErrorEventHandler = (event: FeatureLayerLayerviewCreateErrorEvent) => void;

  export type FeatureLayerLayerviewCreateEventHandler = (event: FeatureLayerLayerviewCreateEvent) => void;

  export type FeatureLayerLayerviewDestroyEventHandler = (event: FeatureLayerLayerviewDestroyEvent) => void;

  export type GeoJSONLayerLayerviewCreateErrorEventHandler = (event: GeoJSONLayerLayerviewCreateErrorEvent) => void;

  export type GeoJSONLayerLayerviewCreateEventHandler = (event: GeoJSONLayerLayerviewCreateEvent) => void;

  export type GeoJSONLayerLayerviewDestroyEventHandler = (event: GeoJSONLayerLayerviewDestroyEvent) => void;

  export type GeoRSSLayerLayerviewCreateErrorEventHandler = (event: GeoRSSLayerLayerviewCreateErrorEvent) => void;

  export type GeoRSSLayerLayerviewCreateEventHandler = (event: GeoRSSLayerLayerviewCreateEvent) => void;

  export type GeoRSSLayerLayerviewDestroyEventHandler = (event: GeoRSSLayerLayerviewDestroyEvent) => void;

  export type GraphicsLayerLayerviewCreateErrorEventHandler = (event: GraphicsLayerLayerviewCreateErrorEvent) => void;

  export type GraphicsLayerLayerviewCreateEventHandler = (event: GraphicsLayerLayerviewCreateEvent) => void;

  export type GraphicsLayerLayerviewDestroyEventHandler = (event: GraphicsLayerLayerviewDestroyEvent) => void;

  export type GroupLayerLayerviewCreateErrorEventHandler = (event: GroupLayerLayerviewCreateErrorEvent) => void;

  export type GroupLayerLayerviewCreateEventHandler = (event: GroupLayerLayerviewCreateEvent) => void;

  export type GroupLayerLayerviewDestroyEventHandler = (event: GroupLayerLayerviewDestroyEvent) => void;

  export type HeatmapSliderViewModelMaxChangeEventHandler = (event: HeatmapSliderViewModelMaxChangeEvent) => void;

  export type HeatmapSliderViewModelMinChangeEventHandler = (event: HeatmapSliderViewModelMinChangeEvent) => void;

  export type HeatmapSliderViewModelValueChangeEventHandler = (event: HeatmapSliderViewModelValueChangeEvent) => void;

  export type HistogramRangeSliderViewModelMaxChangeEventHandler = (
    event: HistogramRangeSliderViewModelMaxChangeEvent
  ) => void;

  export type HistogramRangeSliderViewModelMinChangeEventHandler = (
    event: HistogramRangeSliderViewModelMinChangeEvent
  ) => void;

  export type HistogramRangeSliderViewModelValueChangeEventHandler = (
    event: HistogramRangeSliderViewModelValueChangeEvent
  ) => void;

  export type ImageryLayerLayerviewCreateErrorEventHandler = (event: ImageryLayerLayerviewCreateErrorEvent) => void;

  export type ImageryLayerLayerviewCreateEventHandler = (event: ImageryLayerLayerviewCreateEvent) => void;

  export type ImageryLayerLayerviewDestroyEventHandler = (event: ImageryLayerLayerviewDestroyEvent) => void;

  export type IntegratedMeshLayerLayerviewCreateErrorEventHandler = (
    event: IntegratedMeshLayerLayerviewCreateErrorEvent
  ) => void;

  export type IntegratedMeshLayerLayerviewCreateEventHandler = (event: IntegratedMeshLayerLayerviewCreateEvent) => void;

  export type IntegratedMeshLayerLayerviewDestroyEventHandler = (
    event: IntegratedMeshLayerLayerviewDestroyEvent
  ) => void;

  export type KMLLayerLayerviewCreateErrorEventHandler = (event: KMLLayerLayerviewCreateErrorEvent) => void;

  export type KMLLayerLayerviewCreateEventHandler = (event: KMLLayerLayerviewCreateEvent) => void;

  export type KMLLayerLayerviewDestroyEventHandler = (event: KMLLayerLayerviewDestroyEvent) => void;

  export type MapImageLayerLayerviewCreateErrorEventHandler = (event: MapImageLayerLayerviewCreateErrorEvent) => void;

  export type MapImageLayerLayerviewCreateEventHandler = (event: MapImageLayerLayerviewCreateEvent) => void;

  export type MapImageLayerLayerviewDestroyEventHandler = (event: MapImageLayerLayerviewDestroyEvent) => void;

  export type MapNotesLayerLayerviewCreateErrorEventHandler = (event: MapNotesLayerLayerviewCreateErrorEvent) => void;

  export type MapNotesLayerLayerviewCreateEventHandler = (event: MapNotesLayerLayerviewCreateEvent) => void;

  export type MapNotesLayerLayerviewDestroyEventHandler = (event: MapNotesLayerLayerviewDestroyEvent) => void;

  export type MapViewBlurEventHandler = (event: MapViewBlurEvent) => void;

  export type MapViewClickEventHandler = (event: MapViewClickEvent) => void;

  export type MapViewDoubleClickEventHandler = (event: MapViewDoubleClickEvent) => void;

  export type MapViewDragEventHandler = (event: MapViewDragEvent) => void;

  export type MapViewFocusEventHandler = (event: MapViewFocusEvent) => void;

  export type MapViewHoldEventHandler = (event: MapViewHoldEvent) => void;

  export type MapViewImmediateClickEventHandler = (event: MapViewImmediateClickEvent) => void;

  export type MapViewKeyDownEventHandler = (event: MapViewKeyDownEvent) => void;

  export type MapViewKeyUpEventHandler = (event: MapViewKeyUpEvent) => void;

  export type MapViewLayerviewCreateErrorEventHandler = (event: MapViewLayerviewCreateErrorEvent) => void;

  export type MapViewLayerviewCreateEventHandler = (event: MapViewLayerviewCreateEvent) => void;

  export type MapViewLayerviewDestroyEventHandler = (event: MapViewLayerviewDestroyEvent) => void;

  export type MapViewMouseWheelEventHandler = (event: MapViewMouseWheelEvent) => void;

  export type MapViewPointerDownEventHandler = (event: MapViewPointerDownEvent) => void;

  export type MapViewPointerEnterEventHandler = (event: MapViewPointerEnterEvent) => void;

  export type MapViewPointerLeaveEventHandler = (event: MapViewPointerLeaveEvent) => void;

  export type MapViewPointerMoveEventHandler = (event: MapViewPointerMoveEvent) => void;

  export type MapViewPointerUpEventHandler = (event: MapViewPointerUpEvent) => void;

  export type MapViewResizeEventHandler = (event: MapViewResizeEvent) => void;

  interface Basemap extends Accessor, Loadable, JSONSupport {
    /**
     * A collection of tile layers that make up the basemap's features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#baseLayers)
     */
    baseLayers: Collection<Layer>;
    /**
     * An identifier used to refer to the basemap when referencing it elsewhere.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#id)
     */
    id: string;
    /**
     * Indicates whether the basemap instance has loaded. When `true`,all the properties of the object can be accessed.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#loaded)
     *
     * @default false
     */
    readonly loaded: boolean;
    /**
     * The portal item.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#portalItem)
     */
    portalItem: PortalItem;
    /**
     * A collection of tiled reference layers for displaying labels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#referenceLayers)
     */
    referenceLayers: Collection<Layer>;
    /**
     * The URL pointing to an image that represents the basemap. When using a custombasemap in the [BasemapToggle](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-BasemapToggle.html) widget, the imagespecified here will display in the widget. When the user clicks the image,the map's basemap will update to the basemap associated with the image.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#thumbnailUrl)
     */
    thumbnailUrl: string;
    /**
     * The title of the basemap.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#title)
     */
    title: string;

    /**
     * Creates a deep clone of this object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#clone)
     *
     *
     */
    clone(): Basemap;
    /**
     * Loads all the externally loadable resources associated with the basemap.For the basemap this will load all the base layers and reference layers.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#loadAll)
     *
     *
     */
    loadAll(): IPromise<Basemap>;
  }

  interface BasemapConstructor {
    new (properties?: BasemapProperties): Basemap;

    /**
     * Creates a new basemap instance from a [well known basemap ID](https://developers.arcgis.com/javascript/latest/api-reference/esri-Map.html#basemap).See [Map.basemap](https://developers.arcgis.com/javascript/latest/api-reference/esri-Map.html#basemap) for a list of possible values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#fromId)
     *
     * @param id The basemap ID.
     *
     */
    fromId(id: string): Basemap;

    fromJSON(json: any): Basemap;
  }

  export const Basemap: BasemapConstructor;

  interface BasemapProperties extends LoadableProperties {
    /**
     * A collection of tile layers that make up the basemap's features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#baseLayers)
     */
    baseLayers?: CollectionProperties<LayerProperties>;
    /**
     * An identifier used to refer to the basemap when referencing it elsewhere.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#id)
     */
    id?: string;
    /**
     * The portal item.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#portalItem)
     */
    portalItem?: PortalItemProperties;
    /**
     * A collection of tiled reference layers for displaying labels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#referenceLayers)
     */
    referenceLayers?: CollectionProperties<LayerProperties>;
    /**
     * The URL pointing to an image that represents the basemap. When using a custombasemap in the [BasemapToggle](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-BasemapToggle.html) widget, the imagespecified here will display in the widget. When the user clicks the image,the map's basemap will update to the basemap associated with the image.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#thumbnailUrl)
     */
    thumbnailUrl?: string;
    /**
     * The title of the basemap.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Basemap.html#title)
     */
    title?: string;
  }

  interface Camera extends Accessor, JSONSupport {
    /**
     * The field of view of the camera in degrees.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Camera.html#fov)
     *
     * @default 55
     */
    fov: number;
    /**
     * The compass heading of the camera in degrees. Headingis zero when north is the top of the screen. It increases as the view rotatesclockwise. The angles are always normalized between 0 and 360 degrees.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Camera.html#heading)
     *
     * @default 0
     */
    heading: number;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Camera.html#position)
     */
    position: Point;
    /**
     * The tilt of the camera in degrees with respect to the surface as projecteddown from the camera position. Tilt is zero when looking straight downat the surface and 90 degrees when the camera is looking parallel tothe surface.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Camera.html#tilt)
     *
     * @default 0
     */
    tilt: number;

    /**
     * Creates a deep clone of the camera object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Camera.html#clone)
     *
     *
     */
    clone(): Camera;
  }

  interface CameraConstructor {
    new (properties?: CameraProperties): Camera;

    fromJSON(json: any): Camera;
  }

  export const Camera: CameraConstructor;

  interface CameraProperties {
    /**
     * The field of view of the camera in degrees.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Camera.html#fov)
     *
     * @default 55
     */
    fov?: number;
    /**
     * The compass heading of the camera in degrees. Headingis zero when north is the top of the screen. It increases as the view rotatesclockwise. The angles are always normalized between 0 and 360 degrees.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Camera.html#heading)
     *
     * @default 0
     */
    heading?: number;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Camera.html#position)
     */
    position?: PointProperties;
    /**
     * The tilt of the camera in degrees with respect to the surface as projecteddown from the camera position. Tilt is zero when looking straight downat the surface and 90 degrees when the camera is looking parallel tothe surface.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Camera.html#tilt)
     *
     * @default 0
     */
    tilt?: number;
  }

  interface Color {
    /**
     * The alpha value. This value can be any number between `0` and `1` and represents the opacity of the Color.`0` indicates the color is fully transparent and `1` indicates it is fully opaque.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#a)
     */
    a: number;
    /**
     * The blue value. This value can range between `0` and `255`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#b)
     */
    b: number;
    /**
     * The green value. This value can range between `0` and `255`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#g)
     */
    g: number;
    /**
     * The red value. This value can range between `0` and `255`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#r)
     */
    r: number;

    /**
     * Creates a deep clone of the Color instance.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#clone)
     *
     *
     */
    clone(): Color;
    /**
     * Takes an array of rgb(a) values, named string, hex string or an hsl(a) string,an object with `r`, `g`, `b`, and `a` properties, or a [Color](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html) objectand sets this color instance to the input value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#setColor)
     *
     * @param color The new color value. This parameter can be a string                                          representing a named color or a hex value; an array of three                                          or four numbers representing r, g, b, a values; or an object                                          with r, g, b, a properties.
     *
     */
    setColor(color: string | number[] | any): Color;
    /**
     * Returns a CSS color string in rgba form representing the Color instance.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#toCss)
     *
     * @param includeAlpha If `true`, the alpha value will be included in the result.
     *
     */
    toCss(includeAlpha?: boolean): string;
    /**
     * Returns a CSS color string in hexadecimal form that represents the Color instance.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#toHex)
     *
     *
     */
    toHex(): string;
    /**
     * Returns a JSON object with all the values from a Color instance.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#toJSON)
     *
     *
     */
    toJSON(): any;
    /**
     * Returns a 3-component array of rgb values that represent the Color instance.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#toRgb)
     *
     *
     */
    toRgb(): number[];
    /**
     * Returns a 4-component array of rgba values that represent the Color instance.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#toRgba)
     *
     *
     */
    toRgba(): number[];
  }

  interface ColorConstructor {
    /**
     * Creates a Color instance by blending two colors using a weight factor. Optionally acceptsa Color object to update and return instead of creating a new object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#blendColors)
     *
     * @param start The start color.
     * @param end The end color.
     * @param weight The weight value is a number from 0 to 1, with 0.5 being a 50/50 blend.
     * @param out A previously allocated Color object to reuse for the result.
     *
     */
    blendColors(start: Color, end: Color, weight: number, out?: Color): Color;

    new (color: string | number[] | any): Color;
    /**
     * Creates a Color instance using a 3 or 4 element array, mapping each element in sequence tothe rgb(a) values of the color. Optionally accepts a Color object to update with the colorvalue and return instead of creating a new object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#fromArray)
     *
     * @param a The input array.
     * @param obj A previously allocated Color object to reuse for the result.
     *
     */
    fromArray(a: number[], obj?: Color): Color;
    /**
     * Creates a Color instance from a hex string with a '#' prefix. Supports 12-bit #rgb shorthand.Optionally accepts a Color object to update with the parsed value and return instead ofcreating a new object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#fromHex)
     *
     * @param color The input color in a hex string.
     * @param obj A previously allocated Color object to reuse for the result.
     *
     */
    fromHex(color: string, obj?: Color): Color;
    /**
     * Creates a new Color instance, and initializes it with values from a JSON object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#fromJSON)
     *
     * @param json A JSON representation of the instance.
     *
     */
    fromJSON(json: any): Color;
    /**
     * Creates a Color instance from a string of the form "rgb()" or "rgba()". Optionally accepts aColor object to update with the parsed value and return instead of creating a new object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#fromRgb)
     *
     * @param color The input color in a string of the form "rgb()" or "rgba()".
     * @param out A previously allocated Color object to reuse for the result.
     *
     */
    fromRgb(color: string, out?: Color): Color;
    /**
     * Creates a Color instance by parsing a generic string. Accepts hex, rgb, and rgba style colorvalues. Optionally accepts a Color object to update with the parsed value and return insteadof creating a new object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html#fromString)
     *
     * @param str The input value.
     * @param obj A previously allocated Color object to reuse for the result.
     *
     */
    fromString(str: string, obj?: Color): Color;
  }

  export const Color: ColorConstructor;

  interface config {
    /**
     * The URL for font resources used by the [Font](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-Font.html#family) class in[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html) and [CSVLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html) labels.To use your own hosted fonts, the font files need to be in `.pbf` format, and you must follow the kebab-case naming convention (e.g. "arial-unicode-ms-bold").
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#fontsUrl)
     *
     * @default "https://static.arcgis.com/fonts"
     */
    fontsUrl: string;
    /**
     * The default [GeometryService](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-GeometryService.html) used by widgets and otheroperations, such as on-the-fly projections.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#geometryServiceUrl)
     *
     * @default "https://utility.arcgisonline.com/arcgis/rest/services/Geometry/GeometryServer"
     */
    geometryServiceUrl: string;
    /**
     * The URL for the utility service used by [GeoRSSLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoRSSLayer.html) to convert GeoRSS documents.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#geoRSSServiceUrl)
     *
     * @default "https://utility.arcgis.com/sharing/rss"
     */
    geoRSSServiceUrl: string;
    /**
     * The URL for the utility service used by [KMLLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-KMLLayer.html) to convert KML documents.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#kmlServiceUrl)
     *
     * @default "https://utility.arcgis.com/sharing/kml"
     */
    kmlServiceUrl: string;
    /**
     * The URL of the portal instance. If using an on-premise portal, this valueshould be set to the portal instance, for example:`https://www.example.com/arcgis`
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#portalUrl)
     *
     * @default "https://www.arcgis.com"
     */
    portalUrl: string;
    /**
     * An object with properties that control various aspects of communicationbetween the library and web servers.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#request)
     */
    request: configRequest;
    /**
     * The AMD loader's configuration object, which is loaded with each worker. Modify the configuration to specifylocations of packages to be loaded with [the workers framework](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers.html) or to define a feature detection.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#workers)
     */
    workers: configWorkers;
  }

  export const config: config;

  export type AfterInterceptorCallback = (response: RequestResponse) => void;

  export type BeforeInterceptorCallback = (params: any) => any;

  export interface configRequest extends Object {
    /**
     * List of domain suffixes known to support https. This willautomatically upgrade requests made to such domains to use https insteadof http when the application is not running on http.Note that port numbers should not be included in the domain suffix to be matched.If no `httpsDomains` list exists , the API redirects all calls using https. If the listexists and a domain of a required http resource is not listed, the API sends theURL as it is specified within the code. Likewise, if the list exists and the domain of a required http resource islisted in it, the API sends an https request to that resource.The list includes the following domain suffixes by default: * `arcgis.com` * `arcgisonline.com`
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#request)
     */
    httpsDomains?: string[];
    /**
     * **Since:** 4.8   Allows developers to modify requests before or after they are sent.The first interceptor that matches the request URL will be used.Example:```jsconst featureLayerUrl = "http://sampleserver6.arcgisonline.com/arcgis/rest/services/USA/MapServer/0";esriConfig.request.interceptors.push({  // set the `urls` property to the URL of the FeatureLayer so that this  // interceptor only applies to requests made to the FeatureLayer URL  urls: featureLayerUrl,  // use the BeforeInterceptorCallback to check if the query of the  // FeatureLayer has a maxAllowableOffset property set.  // if so, then set the maxAllowableOffset to 0  before: function(params) {    if (params.requestOptions.query.maxAllowableOffset) {      params.requestOptions.query.maxAllowableOffset = 0;    }  },  // use the AfterInterceptorCallback to check if `ssl` is set to 'true'  // on the response to the request, if it's set to 'false', change  // the value to 'true' before returning the response  after: function(response) {    if (!response.ssl) {      response.ssl = true;    }  }});```
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#request)
     */
    interceptors?: RequestInterceptor[];
    /**
     * Maximum number of characters allowed in the URL for HTTP GET requestsmade by [request](https://developers.arcgis.com/javascript/latest/api-reference/esri-request.html). If this limit isexceeded, HTTP POST method will be used.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#request)
     *
     * @default 2000
     */
    maxUrlLength?: number;
    /**
     * A proxy rule defines a proxy for a set of resources with an identical URL prefix.When using [esriRequest](https://developers.arcgis.com/javascript/latest/api-reference/esri-request.html), if a target URL matches a rule,then the request willbe sent to the specified proxy. Rather than populating this array directly,use the urlUtils.addProxyRule() method.Rule objects have the following properties:
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#request)
     */
    proxyRules?: configRequestProxyRules[];
    /**
     * Resource proxy for your application. It is used by the library whencommunicating with a web server hosted on a domain that is differentfrom the domain where your application is hosted.The library may or may not use the proxy depending on the type of requestmade, whether the server support CORS, whether the application is beingrun on older versions of browsers etc. To keep it simple, it isrecommended that you always configure a resource proxy for your application.You can download the resource proxy from this[GitHub repo](https://github.com/Esri/resource-proxy).```jsrequire(["esri/config"], function(esriConfig) {  esriConfig.request.proxyUrl = "/resource-proxy/Java/proxy.jsp";});```
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#request)
     */
    proxyUrl?: string;
    /**
     * Number of milliseconds[request](https://developers.arcgis.com/javascript/latest/api-reference/esri-request.html) will waitfor response from a server. If a server fails to respond before this timeexpires, then the request is considered to have encountered an error.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#request)
     *
     * @default 60000
     */
    timeout?: number;
    /**
     * **Since:** 4.9   Indicates whether cross origin requests made to the associated servershould include credentials such as cookies and authorization headers.```jsrequire(["esri/config"], function(esriConfig) {  esriConfig.request.trustedServers.push("[<protocol>//]<hostname>.<domain>[:<port>]");});```
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#request)
     */
    trustedServers?: string[];
    /**
     * **Since:** 4.5   Indicates whether `esri/request` will request a credential from `IdentityManager`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#request)
     *
     * @default true
     */
    useIdentity?: boolean;
  }

  export interface configRequestProxyRules extends Object {
    /**
     * The URL of the proxy.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#request)
     */
    proxyUrl?: string;
    /**
     * URL prefix for resources that need to                           be accessed through a specific proxy.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#request)
     */
    urlPrefix?: string;
  }

  export interface configWorkers extends Object {
    /**
     * The absolute url to the AMD loader used in the worker. The default url points to the AMD loader used by the API.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#workers)
     */
    loaderUrl?: any;
    /**
     * The configuration parameters for [the workers framework](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#workers)
     */
    loaderConfig?: configWorkersLoaderConfig;
  }

  export interface configWorkersLoaderConfig extends Object {
    /**
     * The AMD loader loads all code relative to the baseUrl.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#workers)
     */
    baseUrl?: string;
    /**
     * Determines if the specified feature capabilities are supported.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#workers)
     */
    has?: any;
    /**
     * Map of module id fragments to file paths.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#workers)
     */
    paths?: any;
    /**
     * Map paths in module identifiers to different paths.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#workers)
     */
    map?: any;
    /**
     * An array of objects which provide the package name and its location.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#workers)
     */
    packages?: any[];
  }

  /**
   * Specifies the object used for intercepting and modifying requests made via [esriRequest](https://developers.arcgis.com/javascript/latest/api-reference/esri-request.html).
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#RequestInterceptor)
   */
  export interface RequestInterceptor extends Object {
    /**
     * Makes changes to the response after the request is sent, but before it's returned to the caller.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#RequestInterceptor)
     */
    after?: AfterInterceptorCallback;
    /**
     * Make changes to the request URL or options before the request is sent. A returned value will be used as the response data, which would prevent the request from being sent.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#RequestInterceptor)
     */
    before?: BeforeInterceptorCallback;
    /**
     * Sets or adds headers into `requestOptions.headers`. See also: [requestOptions](https://developers.arcgis.com/javascript/latest/api-reference/esri-request.html#RequestOptions).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#RequestInterceptor)
     */
    headers?: any;
    /**
     * Sets or adds query parameters into `requestOptions.query`. See also: [requestOptions](https://developers.arcgis.com/javascript/latest/api-reference/esri-request.html#RequestOptions).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#RequestInterceptor)
     */
    query?: any;
    /**
     * Hardcodes the [response](https://developers.arcgis.com/javascript/latest/api-reference/esri-request.html#RequestResponse). The request will not be sent. This is resolved as the response `data`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#RequestInterceptor)
     */
    responseData?: any;
    /**
     * Specifies the URL(s) to apply to the interceptors. If the value is type `String`, then it matches if the request URL starts with that string. If null or undefined, the interceptor will apply to all relevant requests.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#RequestInterceptor)
     */
    urls?: string | RegExp | (string | RegExp)[];

    /**
     * When an error occurrs during the request processing, this function is called with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) object giving the details about what happened.For example, this could be used to log specific errors occuring with layers or services.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#RequestInterceptor)
     *
     *
     */
    error(): void;
  }

  export type WatchCallback = (newValue: any, oldValue: any, propertyName: string, target: Accessor) => void;

  /**
   * Represents a watch created when an object invokes [watch()](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Accessor.html#watch).
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Accessor.html#WatchHandle)
   */
  export interface WatchHandle extends Object {
    /**
     * Removes the watch handle.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Accessor.html#WatchHandle)
     *
     *
     */
    remove(): void;
  }

  interface decorators {
    /**
     * A property decorator that creates a two-way binding between the property it decorates and an inner property of one of its members.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-accessorSupport-decorators.html#aliasOf)
     *
     * @param propertyName The aliased property name.
     *
     */
    aliasOf(propertyName: string): Function;
    /**
     * This method decorator is used to define the method that will cast a property from a class.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-accessorSupport-decorators.html#cast)
     *
     * @param propertyName The property name the function will cast.
     *
     */
    cast(propertyName: string): Function;
    /**
     * This parameter decorator is used to define the function or class for a parameter of a method.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-accessorSupport-decorators.html#cast)
     *
     * @param classFunction The function or class to cast the parameter
     *
     */
    cast(classFunction: Function): Function;
    /**
     * A function that can be used as a class. It extends [expression](https://www.typescriptlang.org/docs/handbook/release-notes/typescript-1-6.html#extending-expressions)and is used in conjunction with the `@subclass` decorator to create a classcompatible to [dojo.declare](https://dojotoolkit.org/reference-guide/1.10/dojo/declare.html).Please refer to the `subclass` documentation for further information.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-accessorSupport-decorators.html#declared)
     *
     * @param baseClass The class to extend.
     * @param mixinClasses The mixin classes used to extend the base class.
     *
     */
    declared<T>(baseClass: T, ...mixinClasses: any[]): T;
    /**
     * This convenience decorator is used to define an [Accessor](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Accessor.html) property.Any property defined with this decorator can now be `get` and `set`. In addition,you can [watch for any property changes](https://developers.arcgis.com/javascript/latest/guide/working-with-props/index.html).Many times this decorator is used in conjunction with the [@renderable](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-support-widget.html#renderable) decorator.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-accessorSupport-decorators.html#property)
     *
     * @param propertyMetadata An object describing the property.
     * @param propertyMetadata.dependsOn Property names of dependencies.
     * @param propertyMetadata.type The constructor used to [autocast](https://developers.arcgis.com/javascript/latest/guide/autocasting/index.html) the property.
     * @param propertyMetadata.cast The function to use to [autocast](https://developers.arcgis.com/javascript/latest/guide/autocasting/index.html) the property. Alternative to define the `type`. The function is called with the value set by the user and should return the cast value.
     * @param propertyMetadata.readOnly Indicates whether the property is read-only.
     * @param propertyMetadata.constructOnly Indicates whether the property can be set during construction but is otherwise read-only.
     * @param propertyMetadata.aliasOf The property decorator that creates a two-way binding between the property it decorates and an inner property of one of its members.
     * @param propertyMetadata.value The default value for the property.
     *
     */
    property(propertyMetadata?: decoratorsPropertyPropertyMetadata): Function;
    /**
     * A class decorator that must be used together with the `declared` function tocreate a class compatible to [dojo.declare](https://dojotoolkit.org/reference-guide/1.10/dojo/declare.html).It supports both single and multiple inheritance and can be considered the underlying functionalityneeded when creating 4.x classes.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-accessorSupport-decorators.html#subclass)
     *
     * @param declaredClass The subclass name.
     *
     */
    subclass(declaredClass?: string): Function;
  }

  export const decorators: decorators;

  export interface decoratorsPropertyPropertyMetadata extends Object {
    /**
     * Property names of dependencies.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-accessorSupport-decorators.html#property)
     */
    dependsOn?: string[];
    /**
     * The constructor used to [autocast](https://developers.arcgis.com/javascript/latest/guide/autocasting/index.html) the property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-accessorSupport-decorators.html#property)
     */
    type?: Function;
    /**
     * The function to use to [autocast](https://developers.arcgis.com/javascript/latest/guide/autocasting/index.html) the property. Alternative to define the `type`. The function is called with the value set by the user and should return the cast value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-accessorSupport-decorators.html#property)
     */
    cast?: Function;
    /**
     * Indicates whether the property is read-only.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-accessorSupport-decorators.html#property)
     *
     * @default false
     */
    readOnly?: boolean;
    /**
     * Indicates whether the property can be set during construction but is otherwise read-only.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-accessorSupport-decorators.html#property)
     *
     * @default false
     */
    constructOnly?: boolean;
    /**
     * The property decorator that creates a two-way binding between the property it decorates and an inner property of one of its members.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-accessorSupport-decorators.html#property)
     */
    aliasOf?: string;
    /**
     * The default value for the property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-accessorSupport-decorators.html#property)
     */
    value?: any;
  }

  interface Error {}

  interface ErrorConstructor {
    new (): Error;
  }

  export const Error: ErrorConstructor;

  interface Evented {
    /**
     * Emits an event on the instance. This method should only be used when creating subclasses of this class.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Evented.html#emit)
     *
     * @param type The name of the event.
     * @param event The event payload.
     *
     */
    emit(type: string, event?: any): boolean;
    /**
     * Indicates whether there is an event listener on the instance that matchesthe provided event name.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Evented.html#hasEventListener)
     *
     * @param type The name of the event.
     *
     */
    hasEventListener(type: string): boolean;
    /**
     * Registers an event handler on the instance. Call this method to hook anevent with a listener.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Evented.html#on)
     *
     * @param type A event type, or an array of event types, to listen for.
     * @param listener The function to call when the event is fired.
     *
     */
    on(type: string | string[], listener: EventHandler): IHandle;
  }

  interface EventedConstructor {
    new (): Evented;
  }

  export const Evented: EventedConstructor;

  export type EventHandler = (event: any) => void;

  interface HandleOwner extends Accessor {
    /**
     * Handle registry to help manage `handles`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-HandleOwner.html#handles)
     */
    handles: Handles;
  }

  interface HandleOwnerConstructor {
    new (properties?: HandleOwnerProperties): HandleOwner;
  }

  export const HandleOwner: HandleOwnerConstructor;

  interface HandleOwnerProperties {
    /**
     * Handle registry to help manage `handles`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-HandleOwner.html#handles)
     */
    handles?: HandlesProperties;
  }

  interface Handles extends Accessor {
    /**
     * Adds a group of handles.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Handles.html#add)
     *
     * @param handles An array or collection handles to group.
     * @param key group handle key
     *
     */
    add(handles: WatchHandle | WatchHandle[] | Collection<WatchHandle>, key?: any): void;
    /**
     * Returns true if a group exists for the provided key, false otherwise.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Handles.html#has)
     *
     * @param key group handle key
     *
     */
    has(key: any): boolean;
    /**
     * Removes a group of handles.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Handles.html#remove)
     *
     * @param key A group key or an array or collection of group keys to remove.
     *
     */
    remove(key?: any): void;
    /**
     * Removes all handles.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Handles.html#removeAll)
     *
     *
     */
    removeAll(): void;
  }

  interface HandlesConstructor {
    new (properties?: HandlesProperties): Handles;
  }

  export const Handles: HandlesConstructor;

  interface HandlesProperties {}

  /**
   * A handle to a [highlight](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-FeatureLayerView.html#highlight) call result.The handle can be used to remove the installed highlight.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Handles.html#Handle)
   */
  export interface Handle extends Object {
    /**
     * Removes the handle.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Handles.html#Handle)
     *
     *
     */
    remove(): void;
  }

  interface JSONSupport {
    /**
     * Converts an instance of  [this class]() to its [ArcGIS portal JSON](https://developers.arcgis.com/documentation/common-data-types/geometry-objects.htm) representation.See the [Using fromJSON()](https://developers.arcgis.com/javascript/latest/guide/using-fromjson/index.html) topic in the Guide for more information.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-JSONSupport.html#toJSON)
     *
     *
     */
    toJSON(): any;
  }

  interface JSONSupportConstructor {
    new (): JSONSupport;

    /**
     * Creates a new instance of [this class]() and initializes it with values from a JSON objectgenerated from a product in the ArcGIS platform. The object passed into the input `json`parameter often comes from a response to a query operation in the REST API or a[toJSON()](http://pro.arcgis.com/en/pro-app/tool-reference/conversion/features-to-json.htm)method from another ArcGIS product. See the [Using fromJSON()](https://developers.arcgis.com/javascript/latest/guide/using-fromjson/index.html)topic in the Guide for details and examples of when and how to use this function.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-JSONSupport.html#fromJSON)
     *
     * @param json A JSON representation of the instance in the ArcGIS format. See                     the [ArcGIS REST API documentation](https://developers.arcgis.com/documentation/common-data-types/overview-of-common-data-types.htm) for examples of the structure of                      various input JSON objects.
     *
     */
    fromJSON(json: any): any;
  }

  export const JSONSupport: JSONSupportConstructor;

  interface lang {
    /**
     * Use this method to deeply clone objects with properties that are computed or have their own `clone()` method.For example, if you are creating an object that stores an initial extent and a spatial referencefor your application, you can use `esriLang.clone(initialProps)` to clone this object so that the `extent`and `spatialReference` are properly cloned.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-lang.html#clone)
     *
     * @param elem The object to be cloned.
     *
     */
    clone(elem: any): any;
  }

  export const lang: lang;

  interface Loadable {
    /**
     * The Error object returned if an error occurred while loading.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Loadable.html#loadError)
     *
     * @default null
     */
    readonly loadError: Error;
    /**
     * Represents the status of a [load](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Loadable.html#load) operation.Value | Description------|------------not-loaded | The object's resources have not loaded.loading | The object's resources are currently loading.loaded | The object's resources have loaded without errors.failed | The object's resources failed to load. See [loadError](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Loadable.html#loadError) for more details.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Loadable.html#loadStatus)
     *
     * @default not-loaded
     */
    readonly loadStatus: string;
    /**
     * A list of warnings which occurred while loading.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Loadable.html#loadWarnings)
     */
    readonly loadWarnings: any[];

    /**
     * Cancels a [load()](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Loadable.html#load) operation if it is already in progress.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Loadable.html#cancelLoad)
     *
     *
     */
    cancelLoad(): void;
    /**
     * `isFulfilled()` may be used to verify if creating an instance of the class is fulfilled (either resolved or rejected).If it is fulfilled, `true` will be returned.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Loadable.html#isFulfilled)
     *
     *
     */
    isFulfilled(): boolean;
    /**
     * `isRejected()` may be used to verify if creating an instance of the class is rejected.If it is rejected, `true` will be returned.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Loadable.html#isRejected)
     *
     *
     */
    isRejected(): boolean;
    /**
     * `isResolved()` may be used to verify if creating an instance of the class is resolved.If it is resolved, `true` will be returned.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Loadable.html#isResolved)
     *
     *
     */
    isResolved(): boolean;
    /**
     * Loads the resources referenced by this class. This method automaticallyexecutes for a [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html) and all of the resourcesit references in [Map](https://developers.arcgis.com/javascript/latest/api-reference/esri-Map.html) if the view is constructed witha map instance.This method must be called by the developer when accessing a resource that will not beloaded in a [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html).It's possible to provide a `signal` to stop being interested into a `Loadable` instance load status.When the signal is aborted, the instance does not stop its loading process, only [cancelLoad](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Loadable.html#cancelLoad) can abort it.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Loadable.html#load)
     *
     * @param signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    load(signal?: AbortSignal): IPromise<any>;
    /**
     * `when()` may be leveraged once an instance of the class is created. This method takes two input parameters: a `callback` function and an `errback` function.The `callback` executes when the instance of the class loads. The`errback` executes if the instance of the class fails to load.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Loadable.html#when)
     *
     * @param callback The function to call when the promise resolves.
     * @param errback The function to execute when the promise fails.
     *
     */
    when(callback?: Function, errback?: Function): IPromise<any>;
  }

  interface LoadableConstructor {
    new (): Loadable;
  }

  export const Loadable: LoadableConstructor;

  interface LoadableProperties {}

  interface corePromise {
    /**
     * `isFulfilled()` may be used to verify if creating an instance of the class is fulfilled (either resolved or rejected).If it is fulfilled, `true` will be returned.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Promise.html#isFulfilled)
     *
     *
     */
    isFulfilled(): boolean;
    /**
     * `isRejected()` may be used to verify if creating an instance of the class is rejected.If it is rejected, `true` will be returned.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Promise.html#isRejected)
     *
     *
     */
    isRejected(): boolean;
    /**
     * `isResolved()` may be used to verify if creating an instance of the class is resolved.If it is resolved, `true` will be returned.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Promise.html#isResolved)
     *
     *
     */
    isResolved(): boolean;
    /**
     * `when()` may be leveraged once an instance of the class is created. This method takes two input parameters: a `callback` function and an `errback` function.The `callback` executes when the instance of the class loads. The`errback` executes if the instance of the class fails to load.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Promise.html#when)
     *
     * @param callback The function to call when the promise resolves.
     * @param errback The function to execute when the promise fails.
     *
     */
    when(callback?: Function, errback?: Function): IPromise<any>;
  }

  interface corePromiseConstructor {
    new (): corePromise;
  }

  export const corePromise: corePromiseConstructor;

  interface promiseUtils {
    /**
     * Convenience utility method for creating and resolving a promise.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-promiseUtils.html#create)
     *
     * @param executor A function that will be called with two methods, `resolve` and `reject`.
     *
     */
    create(executor: Executor): IPromise<any>;
    /**
     * A utility for ensuring an input function is not simultaneously invoked more than once at a time. Thisis useful for highly interactive applications such as those that execute statistic queries on mouse-moveor mouse-drag events. Rather than execute the query for each such event, you can "debounce", or cancelthe function execution, until the previous execution of the same function call finishes. This improvesthe performance and user experience of such applications.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-promiseUtils.html#debounce)
     *
     * @param callback A function to prevent executing during the execution of a previous call  to the same function. This is typically a function that may be called on mouse-move or mouse-drag events.
     *
     */
    debounce<T>(callback: T): T;
    /**
     * Convenience utility method to wait for a number of promises to either resolve orreject. The resulting promise resolves to an array ofresult objects containingthe promise and either a value if the promise resolved, or an error if thepromise rejected.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-promiseUtils.html#eachAlways)
     *
     * @param promises Array of promises, or object where each  property is a promise.
     *
     */
    eachAlways(promises: IPromise<any>[] | any): IPromise<EachAlwaysResult[]> | any;
    /**
     * A convenience utility method for filtering an array of values using an asynchronous predicate function.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-promiseUtils.html#filter)
     *
     * @param input The array of input values to filter.
     * @param predicate A predicate function returning a promise.  Only array entries for which the returned promise contains `true` are kept.
     *
     */
    filter<T>(input: T[], predicate: FilterPredicateCallback): IPromise<T[]>;
    /**
     * Convenience utility method to create a promise that has been rejected with aprovided error value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-promiseUtils.html#reject)
     *
     * @param error The error to reject the resulting promise with.
     *
     */
    reject<T>(error?: any): IPromise<T>;
    /**
     * Convenience utility method to create a promise that will be resolved with aprovided value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-promiseUtils.html#resolve)
     *
     * @param value The value to resolve the resulting promise with.
     *
     */
    resolve<T>(value?: T): IPromise<T>;
  }

  export const promiseUtils: promiseUtils;

  /**
   * The result object for a promise passed to [promiseUtils.eachAlways](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-promiseUtils.html#eachAlways).
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-promiseUtils.html#EachAlwaysResult)
   */
  export interface EachAlwaysResult extends Object {
    /**
     * The promise that has been fulfilled.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-promiseUtils.html#EachAlwaysResult)
     */
    promise: IPromise<any>;
    /**
     * The value with which the promise resolved. Defined  only if the promise resolved.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-promiseUtils.html#EachAlwaysResult)
     */
    value?: any;
    /**
     * The error with which the promise rejected. Defined  only if the promise rejected.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-promiseUtils.html#EachAlwaysResult)
     */
    error?: any;
  }

  export type Executor = (resolve: ResolveCallback, reject: RejectCallback) => void;

  export type FilterPredicateCallback = (value: any, index: number) => IPromise<any>;

  export type RejectCallback = (error?: any) => void;

  export type ResolveCallback = (value?: any | IPromise<any>) => void;

  interface requireUtils {
    /**
     * **Deprecated in favor of [promiseUtils.create()](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-promiseUtils.html#create).** Dynamically requires one or more modules and returns a promise thatresolves when all the specified modules have loaded.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-requireUtils.html#when)
     *
     * @param moduleRequire The `require` function used to load the modules. This is theAMD alias (e.g. the `moduleRequire` reference in the snippets below) used to reference the `require` module.
     * @param moduleNames The names of the modules to load.
     *
     */
    when(moduleRequire: any, moduleNames: string[] | string): IPromise<any>;
  }

  export const requireUtils: requireUtils;

  interface scheduling {
    /**
     * Registers a frame task. An animation frame is composed of different phases to let variousactors execute code before, after, or during the rendering of [MapView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-MapView.html)or [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#addFrameTask)
     *
     * @param phases The callbacks for each phase of the frame.
     *
     */
    addFrameTask(phases: PhaseCallbacks): FrameTaskHandle;
    /**
     * Schedules the execution of a `callback` function at the next web browser tick.Unlike [addFrameTask](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#addFrameTask), a scheduled `callback` will only runonce. Scheduling a task for the next execution tick can be useful when youwant to throttle/accumulate functionality over a single javascript executioncontext.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#schedule)
     *
     * @param callback The function to call at the next tick.
     *
     */
    schedule(callback: Function): any;
  }

  export const scheduling: scheduling;

  /**
   * An object to remove or pause a frame task registered with [addFrameTask()](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#addFrameTask).
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#FrameTaskHandle)
   */
  export interface FrameTaskHandle extends Object {
    /**
     * Pause the execution the frame task at every frame.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#FrameTaskHandle)
     *
     *
     */
    pause(): void;
    /**
     * Resumes the execution the frame task.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#FrameTaskHandle)
     *
     *
     */
    resume(): void;
    /**
     * Removes the frame task.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#FrameTaskHandle)
     *
     *
     */
    remove(): void;
  }

  export type PhaseCallback = (event?: PhaseEvent) => void;

  /**
   * A set of [callbacks](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#PhaseCallback) that will be called atspecific phases of the animation frame.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#PhaseCallbacks)
   */
  export interface PhaseCallbacks extends Object {
    /**
     * A callback called before rendering.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#PhaseCallbacks)
     */
    prepare?: PhaseCallback;
    /**
     * A callback to execute rendering logic.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#PhaseCallbacks)
     */
    render?: PhaseCallback;
    /**
     * A callback to execute state update logic.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#PhaseCallbacks)
     */
    update?: PhaseCallback;
  }

  /**
   * An object with timing information.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#PhaseEvent)
   */
  export interface PhaseEvent extends Object {
    /**
     * The absolute time at the start of the current animation frame.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#PhaseEvent)
     */
    time: number;
    /**
     * The elapsed time since the last animation frame.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#PhaseEvent)
     */
    deltaTime: number;
    /**
     * The amount of time spent within the current animation frame.                                      This can be used for budgeting (e.g. some tasks may already have run).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-scheduling.html#PhaseEvent)
     */
    elapsedFrameTime: number;
  }

  interface urlUtils {
    /**
     * Adds the given proxy rule to the proxy rules list: `esriConfig.request.proxyRules`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-urlUtils.html#addProxyRule)
     *
     * @param rule An object specifying a URL that should use the proxy. See the                     object specification table below for the required properties of this object.
     * @param rule.proxyUrl The URL of the proxy.
     * @param rule.urlPrefix The URL prefix of the resources that should be accessed                               through the given proxy.
     *
     */
    addProxyRule(rule: urlUtilsAddProxyRuleRule): number;
    /**
     * Returns the proxy rule that matches the given URL.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-urlUtils.html#getProxyRule)
     *
     * @param url The URL of the resources accessed via proxy.
     *
     */
    getProxyRule(url: string): any;
    /**
     * Converts the URL arguments to an object representation.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-urlUtils.html#urlToObject)
     *
     * @param url The input URL.
     *
     */
    urlToObject(url: string): any;
  }

  export const urlUtils: urlUtils;

  export interface urlUtilsAddProxyRuleRule extends Object {
    /**
     * The URL of the proxy.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-urlUtils.html#addProxyRule)
     */
    proxyUrl: string;
    /**
     * The URL prefix of the resources that should be accessed                               through the given proxy.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-urlUtils.html#addProxyRule)
     */
    urlPrefix: string;
  }

  interface watchUtils {
    /**
     * Watches a property for changes and calls the callback with the initial value of the property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#init)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call with the initial value of the property when the property changes.
     *
     */
    init(obj: Accessor, propertyName: string | string[], callback: WatchCallback): WatchHandle;
    /**
     * Watches a property for changes and automatically attaches and detachesan event handler for a given event to the property value as needed.The attachedHandler and detachedHandler are optional and if providedwill be called whenever the event handler is attached and detachedrespectively.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#on)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param eventName The name of the event to attach the event handler for.
     * @param eventHandler The event handler callback function.
     * @param attachedHandler Callback called each time the event handler is attached.
     * @param detachedHandler Callback called each time the event handler is detached.
     *
     */
    on(
      obj: Accessor,
      propertyName: string | string[],
      eventName: string,
      eventHandler: Function,
      attachedHandler?: EventAttachedCallback,
      detachedHandler?: EventAttachedCallback
    ): WatchHandle;
    /**
     * Watches a property for changes once. The returned watch handle is removedafter the first time the callback has been invoked.The returned handle additionally implements the Promise interface andcan be used to create a promise chain to asynchronously handle a propertyvalue becoming truthy. The promise result is an object containing a`value`, `oldValue`, `propertyName` and `target`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#once)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    once(obj: Accessor, propertyName: string | string[], callback?: WatchCallback): PromisedWatchHandle;
    /**
     * Watches a property for changes. The returned handle can be paused (and resumed)to temporarily prevent the callback from being called on property changes.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#pausable)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    pausable(obj: Accessor, propertyName: string | string[], callback?: WatchCallback): PausableWatchHandle;
    /**
     * Watches a property for changes. This is an alias for[Accessor.watch()](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Accessor.html#watch), provided for completeness.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#watch)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    watch(obj: Accessor, propertyName: string | string[], callback: WatchCallback): WatchHandle;
    /**
     * Watches a property for becoming truthy. As with module:esri/core/watchUtils#init, the callbackis called initially if the property is initially truthy.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#when)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    when(obj: Accessor, propertyName: string | string[], callback: WatchCallback): WatchHandle;
    /**
     * Watches a property for becoming `defined`. As with init(), the callbackis called if the property is initially defined.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#whenDefined)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    whenDefined(obj: Accessor, propertyName: string | string[], callback: WatchCallback): WatchHandle;
    /**
     * Watches a property for becoming `defined` once. As with init(), the callbackis called if the property is initially `defined`. The returned watchhandle is removed after the first time the callback has been invoked.The returned handle additionally implements the Promise interface andcan be used to create a promise chain to asynchronously handle a propertyvalue becoming defined. The promise result is an object containing a`value`, `oldValue`, `propertyName` and `target`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#whenDefinedOnce)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    whenDefinedOnce(obj: Accessor, propertyName: string | string[], callback?: WatchCallback): PromisedWatchHandle;
    /**
     * Watches a property for becoming `false`. As with init(), the callbackis called if the property is initially `false`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#whenFalse)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    whenFalse(obj: Accessor, propertyName: string | string[], callback: WatchCallback): WatchHandle;
    /**
     * Watches a property for becoming `false` once. As with init(), the callbackis called if the property is initially `false`. The returned watchhandle is removed after the first time the callback has been invoked.The returned handle additionally implements the Promise interface andcan be used to create a promise chain to asynchronously handle a propertyvalue becoming false. The promise result is an object containing a`value`, `oldValue`, `propertyName` and `target`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#whenFalseOnce)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    whenFalseOnce(obj: Accessor, propertyName: string | string[], callback?: WatchCallback): PromisedWatchHandle;
    /**
     * Watches a property for becoming falsy. As with module:esri/core/watchUtils#init, the callbackis called initially if the property is initially falsy.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#whenNot)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    whenNot(obj: Accessor, propertyName: string | string[], callback: WatchCallback): WatchHandle;
    /**
     * Watches a property for becoming falsy once. As with init(), the callbackis called if the property is initially falsy. The returned watchhandle is removed after the first time the callback has been invoked.The returned handle additionally implements the Promise interface andcan be used to create a promise chain to asynchronously handle a propertyvalue becoming falsy. The promise result is an object containing a`value`, `oldValue`, `propertyName` and `target`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#whenNotOnce)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    whenNotOnce(obj: Accessor, propertyName: string | string[], callback?: WatchCallback): PromisedWatchHandle;
    /**
     * Watches a property for becoming truthy once. As with init(), the callbackis called if the property is initially truthy. The returned watchhandle is removed after the first time the callback has been invoked.The returned handle additionally implements the Promise interface andcan be used to create a promise chain to asynchronously handle a propertyvalue becoming truthy. The promise result is an object containing a`value`, `oldValue`, `propertyName` and `target`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#whenOnce)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    whenOnce(obj: Accessor, propertyName: string | string[], callback?: WatchCallback): PromisedWatchHandle;
    /**
     * Watches a property for becoming `true`. As with init(), the callbackis called if the property is initially `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#whenTrue)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    whenTrue(obj: Accessor, propertyName: string | string[], callback: WatchCallback): WatchHandle;
    /**
     * Watches a property for becoming `true` once. As with init(), the callbackis called if the property is initially `true`. The returned watchhandle is removed after the first time the callback has been invoked.The returned handle additionally implements the Promise interface andcan be used to create a promise chain to asynchronously handle a propertyvalue becoming true. The promise result is an object containing a`value`, `oldValue`, `propertyName` and `target`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#whenTrueOnce)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    whenTrueOnce(obj: Accessor, propertyName: string | string[], callback?: WatchCallback): PromisedWatchHandle;
    /**
     * Watches a property for becoming `undefined`. As with init(), the callbackis called if the property is initially `undefined`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#whenUndefined)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    whenUndefined(obj: Accessor, propertyName: string | string[], callback: WatchCallback): WatchHandle;
    /**
     * Watches a property for becoming `undefined` once. As with init(), the callbackis called if the property is initially `undefined`. The returned watchhandle is removed after the first time the callback has been invoked.The returned handle additionally implements the Promise interface andcan be used to create a promise chain to asynchronously handle a propertyvalue becoming undefined. The promise result is an object containing a`value`, `oldValue`, `propertyName` and `target`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#whenUndefinedOnce)
     *
     * @param obj The object containing the property to watch.
     * @param propertyName The name of the property to watch.
     * @param callback The function to call when the property changes.
     *
     */
    whenUndefinedOnce(obj: Accessor, propertyName: string | string[], callback?: WatchCallback): PromisedWatchHandle;
  }

  export const watchUtils: watchUtils;

  export type EventAttachedCallback = (target?: any, propName?: string, obj?: Accessor, eventName?: string) => void;

  /**
   * Represents a watch created when an object invokes [watch()](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Accessor.html#watch).
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#PausableWatchHandle)
   */
  export interface PausableWatchHandle extends Object {
    /**
     * Removes the watch handle.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#PausableWatchHandle)
     *
     *
     */
    remove(): void;
    /**
     * Pauses the handle preventing changes to invoke                             the associated callback.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#PausableWatchHandle)
     *
     *
     */
    pause(): void;
    /**
     * Resumes a paused the handle.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-watchUtils.html#PausableWatchHandle)
     *
     *
     */
    resume(): void;
  }

  export interface PromisedWatchHandle extends IPromise<any> {
    remove(): void;
  }

  interface workers {
    /**
     * Opens a connection to workers and loads a script with the workers framework.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers.html#open)
     *
     * @param modulePath A fully qualified URL to a script to execute with the workers framework.
     * @param options Worker options. See properties below for object specifications.
     * @param options.client The objects defining the API accessible from the module.
     * @param options.strategy Indicates how to load the module. See thetable below for a list of possible values.
     * @param options.signal [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) allows for cancelable asynchronous job.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).Possible Value | Description---------------|------------distributed | The module is loaded in each available worker. Each call to [Connection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#invoke) will be targeting an available worker. Use this strategy if the module doesn't maintain information between invocations (stateless).dedicated | The module is loaded in one worker. Each call to [Connection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#invoke) will be targeting a same worker. Use this strategy if the module maintains information from previous invocations or communication between main and worker threads needs to be stateful.local | The module is loaded in the main thread. Use this strategy if when using the worker framework API while disabling the use of workers.
     *
     */
    open(modulePath: string, options?: workersOpenOptions): IPromise<Connection>;
  }

  export const workers: workers;

  interface Connection {
    /**
     * A convenient method that invokes a method on each worker.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#broadcast)
     *
     * @param methodName The name of the remote method to invoke on all workers.
     * @param data The unique parameter passed as argument of the remote method.
     * @param options An object specifying additional options. See the  object specification table below for the required properties of this object.
     * @param options.signal An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the executions of the remote method.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     */
    broadcast(methodName: string, data?: any, options?: ConnectionBroadcastOptions): IPromise<any>[];
    /**
     * Closes the existing connection instance to workers.Notifies all workers to destroy the connection instance and dispose the remote module.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#close)
     *
     *
     */
    close(): void;
    /**
     * Invokes a [method](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#basic-invocation) on the remote module loaded with the worker.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#invoke)
     *
     * @param methodName The name of the method to be invoked in the script.
     * @param data The unique parameter passed as argument of the remote method. See [Passing multiple parameters](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#multiple-parameters)section to pass more than one parameter to the remote method.
     * @param options An object specifying additional options. See the                           object specification table below for the required properties of this object.
     * @param options.transferList An array of [Transferable](https://developer.mozilla.org/en-US/docs/Web/API/Transferable)objects. Each transferable object in the array should have a corresponding entry in the data object.See [Using transferables](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#using-transferables) section for more information.
     * @param options.signal An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the execution of the remote method.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     */
    invoke(methodName: string, data?: any, options?: ConnectionInvokeOptions): IPromise<any>;
  }

  interface ConnectionConstructor {
    new (): Connection;
  }

  export const Connection: ConnectionConstructor;

  export interface ConnectionBroadcastOptions extends Object {
    /**
     * An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the executions of the remote method.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#broadcast)
     */
    signal?: AbortSignal;
  }

  export interface ConnectionInvokeOptions extends Object {
    /**
     * An array of [Transferable](https://developer.mozilla.org/en-US/docs/Web/API/Transferable)objects. Each transferable object in the array should have a corresponding entry in the data object.See [Using transferables](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#using-transferables) section for more information.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#invoke)
     */
    transferList?: any[];
    /**
     * An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the execution of the remote method.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#invoke)
     */
    signal?: AbortSignal;
  }

  export interface workersOpenOptions extends Object {
    /**
     * The objects defining the API accessible from the module.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers.html#open)
     */
    client?: any;
    /**
     * Indicates how to load the module. See thetable below for a list of possible values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers.html#open)
     *
     * @default distributed
     */
    strategy?: string;
    /**
     * [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) allows for cancelable asynchronous job.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).Possible Value | Description---------------|------------distributed | The module is loaded in each available worker. Each call to [Connection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#invoke) will be targeting an available worker. Use this strategy if the module doesn't maintain information between invocations (stateless).dedicated | The module is loaded in one worker. Each call to [Connection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers-Connection.html#invoke) will be targeting a same worker. Use this strategy if the module maintains information from previous invocations or communication between main and worker threads needs to be stateful.local | The module is loaded in the main thread. Use this strategy if when using the worker framework API while disabling the use of workers.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-workers.html#open)
     */
    signal?: AbortSignal;
  }

  namespace geometry {
    /**
     * Spatial Reference.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#SpatialReference)
     */
    export type SpatialReference = __esri.SpatialReference;
    export const SpatialReference: typeof __esri.SpatialReference;

    /**
     * Geometry types.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Geometry)
     */
    export type Geometry =
      | __esri.Extent
      | __esri.Multipoint
      | __esri.Point
      | __esri.Polygon
      | __esri.Polyline
      | __esri.Mesh;

    /**
     * Extent.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Extent)
     */
    export type Extent = __esri.Extent;
    export const Extent: typeof __esri.Extent;

    /**
     * Multipoint.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Multipoint)
     */
    export type Multipoint = __esri.Multipoint;
    export const Multipoint: typeof __esri.Multipoint;

    /**
     * Point.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Point)
     */
    export type Point = __esri.Point;
    export const Point: typeof __esri.Point;

    /**
     * Polygon.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Polygon)
     */
    export type Polygon = __esri.Polygon;
    export const Polygon: typeof __esri.Polygon;

    /**
     * Polyline.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Polyline)
     */
    export type Polyline = __esri.Polyline;
    export const Polyline: typeof __esri.Polyline;

    /**
     * Mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Mesh)
     */
    export type Mesh = __esri.Mesh;
    export const Mesh: typeof __esri.Mesh;
  }

  interface Circle extends Polygon {
    /**
     * The center point of the circle. The center must be specified either as a[Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) or an array of longitude/latitude coordinates.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Circle.html#center)
     */
    center: Point;
    /**
     * Applicable when the spatial reference of the center point is either set to WebMercator (wkid: 3857) or geographic/geodesic (wkid: 4326). When  either ofthose spatial references is used, set geodesic to `true` to minimizedistortion. Other coordinatesystems will not create geodesic circles.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Circle.html#geodesic)
     *
     * @default false
     */
    geodesic: boolean;
    /**
     * This value defines the number of pointsalong the curve of the circle.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Circle.html#numberOfPoints)
     *
     * @default 60
     */
    numberOfPoints: number;
    /**
     * The radius of the circle.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Circle.html#radius)
     *
     * @default 1000
     */
    radius: number;
    /**
     * Unit of the radius.**Possible Values:** feet | kilometers | meters | miles | nautical-miles | yards
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Circle.html#radiusUnit)
     *
     * @default meters
     */
    radiusUnit: string;

    /**
     * Creates a deep clone of Circle.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Circle.html#clone)
     *
     *
     */
    clone(): Circle;
  }

  interface CircleConstructor {
    new (properties?: CircleProperties): Circle;

    fromJSON(json: any): Circle;
  }

  export const Circle: CircleConstructor;

  interface CircleProperties extends PolygonProperties {
    /**
     * The center point of the circle. The center must be specified either as a[Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) or an array of longitude/latitude coordinates.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Circle.html#center)
     */
    center?: PointProperties;
    /**
     * Applicable when the spatial reference of the center point is either set to WebMercator (wkid: 3857) or geographic/geodesic (wkid: 4326). When  either ofthose spatial references is used, set geodesic to `true` to minimizedistortion. Other coordinatesystems will not create geodesic circles.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Circle.html#geodesic)
     *
     * @default false
     */
    geodesic?: boolean;
    /**
     * This value defines the number of pointsalong the curve of the circle.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Circle.html#numberOfPoints)
     *
     * @default 60
     */
    numberOfPoints?: number;
    /**
     * The radius of the circle.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Circle.html#radius)
     *
     * @default 1000
     */
    radius?: number;
    /**
     * Unit of the radius.**Possible Values:** feet | kilometers | meters | miles | nautical-miles | yards
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Circle.html#radiusUnit)
     *
     * @default meters
     */
    radiusUnit?: string;
  }

  interface coordinateFormatter {
    /**
     * Parses coordinates in latitude/longitude notation, and returns a [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) representing that location.The coordinates may use decimal degrees, degrees and decimal minutes, or degrees, minutes, and seconds format.The spatial reference provided must have an ellipsoid and datum matching those used by the source of the latitude/longitude string.If no spatial reference is provided, it is assumed the latitude/longitude coordinates are in WGS84.#### Supported characters| Symbol | Character | Name | Unicode number | HTML code || --- | --- | --- | --- | --- || Degree | * | Asterisk | U+002A | &amp;#42; ||  | ^ | Circumflex Accent | U+005E | &amp;#94;||  | ~ | Tilde | U+007E | &amp;#126; ||  | ° | Degree Sign | U+00B0 | &amp;#176; || Minute | ' | Apostrophe | U+0027 | &amp;#39; || | ′ | Prime | U+2032 | &amp;#8242; || Second | " | Quotation Mark | U+0022 | &amp;#34; |The latitude/longitude string may contain leading and trailing whitespace, and may also contain a space,comma, or vertical bar symbol to separate the latitude from the longitude. It may also contain the characters'N', 'S', 'E' and 'W', or use a minus (-) symbol to indicate the hemisphere of each value.Latitude/longitude notation examples:- 55 56 39.123N 003 09 43.034W- 55°56′39″N 3°09′43″W- 55~56.65205', -003~09.71723'- 55.9442008* | -3.1619539*
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-coordinateFormatter.html#fromLatitudeLongitude)
     *
     * @param coordinates The latitude/longitude notation string for the coordinates.
     * @param spatialReference A spatial reference object representing a[geographic coordinate system](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm).If `null`, WGS84 will be used.
     *
     */
    fromLatitudeLongitude(coordinates: string, spatialReference?: SpatialReference): Point;
    /**
     * Parses coordinates in Military Grid Reference System (MGRS) notation, and returns a [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) representing that location.The spatial reference provided must have an ellipsoid and datum matching those used by the source of the MGRS string.If no spatial reference is provided, it is assumed the MGRS string is referenced to WGS84.Note that the choice between zone 01 and 60 has no impact when reading from an MGRS notation string.The MGRS string can contain leading and trailing whitespace and can have whitespace between the grid zone designator, the 100km square identifier,and the numerical eastings and northings.MGRS notation examples:- 30UVG898998- 30UVG 89885 99877
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-coordinateFormatter.html#fromMgrs)
     *
     * @param coordinates The MGRS notation string for the coordinates.
     * @param spatialReference A spatial reference object representinga [geographic coordinate system](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm) referenced by the MGRS coordinates.If `null`, WGS84 will be used.
     * @param conversionMode The mode used by the given MGRS coordinates.**Possible Values**: automatic | new-180-in-zone-01 | new-180-in-zone-60 | old-180-in-zone-01 | old-180-in-zone-60
     *
     */
    fromMgrs(coordinates: string, spatialReference: SpatialReference, conversionMode: string): Point;
    /**
     * Parses coordinates in United States National Grid (USNG) notation, and returns a [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) representing that location.The spatial reference provided must have an ellipsoid and datum matching those used by the source of the USNG string.If no spatial reference is provided and the USNG string is suffixed with "(NAD 27)",it is assumed the USNG string is referenced to NAD 27. If no spatial reference is provided and no such suffix exists,it is assumed the USNG string is referenced to WGS84.USNG notation examples:- 13TFJ 23 59- 13TFJ2374159574
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-coordinateFormatter.html#fromUsng)
     *
     * @param coordinates The USNG notation string for the coordinates.
     * @param spatialReference A spatial reference object representing a[geographic coordinate system](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm) that the USNG coordinates are in.If `null`, WGS84 will be used.
     *
     */
    fromUsng(coordinates: string, spatialReference?: SpatialReference): Point;
    /**
     * Parses coordinates in Universal Transverse Mercator (UTM) notation, and returns a [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) representing that location.The spatial reference provided must have an ellipsoid and datum matching those used by the source of the UTM string.If no spatial reference is provided, it is assumed the UTM string is referenced to WGS84. The UTM string can containleading and trailing whitespace and can have whitespace between the zone and latitude designator and the numerical eastings and northings.UTM notation examples:- 30U 489885 6199877- 30U4898856199877- 30N 489885 6199877 (using N/S indicator)
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-coordinateFormatter.html#fromUtm)
     *
     * @param coordinates The UTM notation string for the coordinates.
     * @param spatialReference A spatial reference object representing a[geographic coordinate system](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm) that the UTM coordinates are in.If `null`, WGS84 will be used.
     * @param conversionMode The latitude notation scheme used by the given UTM coordinates,either a latitudinal band, or a hemisphere designator. **Possible Values**: latitude-band-indicators | north-south-indicators
     *
     */
    fromUtm(coordinates: string, spatialReference: SpatialReference, conversionMode: string): Point;
    /**
     * Indicates if all dependencies of this module have been loaded.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-coordinateFormatter.html#isLoaded)
     *
     *
     */
    isLoaded(): boolean;
    /**
     * Indicates if this module is supported in the current browser.The browser must support [WebAssembly](https://caniuse.com/#feat=wasm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-coordinateFormatter.html#isSupported)
     *
     *
     */
    isSupported(): boolean;
    /**
     * Load this module's dependencies.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-coordinateFormatter.html#load)
     *
     *
     */
    load(): IPromise<any>;
    /**
     * Returns formatted coordinates in latitude/longitude notation representing the given point's location.The latitude/longitude string will contain a space separating the latitude from the longitude value,and the characters 'N' or 'S', and 'E' and 'W', to indicate the hemisphere of each value. The stringwill also contain spaces separating the components (degrees, minutes, seconds) of each value.The precision of the output is controlled by both the `format` and `decimalPlaces` parameters.For example:| Decimal places | format | Example output | Angular precision | Approximate precision || --- | --- | --- | --- | --- || 0 | dd | 056N 0003W | 1deg | 100km || 1 | dd | 55.9N 003.2W | 0.1deg | 10km || 2 | dd | 55.94N 003.16W | 0.01deg | 1km || 3 | dd | 55.944N 003.162W | 0.001deg | 100m || 0 | ddm | 55 057N 003 010W | 1min | 2km || 1 | ddm | 55 56.7N 003 09.7W | 0.1min | 200m || 2 | ddm | 55 56.65N 003 09.72W | 0.01min | 20m || 3 | ddm | 55 56.650N 003 09.717W | 0.001min | 2m || 0 | dms | 55 56 039N 003 09 043W | 1sec | 30m || 1 | dms | 55 56 39.1N 003 09 43.0W | 0.1sec| 3m || 2 | dms | 55 56 39.12N 003 09 43.03W | 0.01sec | 300mm || 3 | dms | 55 56 39.123N 003 09 43.034W | 0.001sec | 30mm |
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-coordinateFormatter.html#toLatitudeLongitude)
     *
     * @param point The location to be represented as a formatted latitude/longitude string.The point's [spatial reference](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#spatialReference) should either be WGS84 or another[geographic coordinate system](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm).
     * @param format The mode to use when formatting the latitude/longitude string.**Possible Values**: dd | ddm | dms
     * @param decimalPlaces The number of decimal places to use, it should be an integer from 0 to 16.
     *
     */
    toLatitudeLongitude(point: Point, format: string, decimalPlaces?: number): string;
    /**
     * Returns formatted coordinates in Military Grid Reference System (MGRS) notation representing the given point's location.Note that the choice between zone 01 and 60 has an impact only when generating the MGRS notation string for a point withlongitude of exactly 180deg. The precision value controls the number of digits used to represent each numerical eastingand northing value within the MGRS string.For example:| precision | add_spaces | Example output | Approximate precision || --- | --- | --- | --- || 0 | false | 30UVG | 100km || 1 | false | 30UVG89 | 10km || 2 | false | 30UVG8999 | 1km || 3 | false | 30UVG898998 | 100m || 4 | false | 30UVG89889988 | 10m || 5 | false | 30UVG8988499881 | 1m || 0 | true | 30U VG | 100km || 1 | true | 30U VG 8 9 | 10m || 2 | true | 30U VG 89 99 | 1km || 3 | true | 30U VG 898 998 | 100m || 4 | true | 30U VG 8988 9988 | 10m || 5 | true | 30U VG 89884 99881 | 1m |
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-coordinateFormatter.html#toMgrs)
     *
     * @param point The location to be represented in MGRS notation.The point's [spatial reference](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#spatialReference) should either be WGS84 or another[geographic coordinate system](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm)
     * @param conversionMode The mode to use for the returned MGRS notation string.**Possible Values**: automatic | new-180-in-zone-01 | new-180-in-zone-60 | old-180-in-zone-01 | old-180-in-zone-60
     * @param precision The precision with which to represent the coordinates, it should be an integer from 0 to 8.
     * @param addSpaces If `false`, the generated string will contain no spaces. If `true`, a space separatesthe grid zone designator, the 100km square identifier, and the numerical easting and northing values.
     *
     */
    toMgrs(point: Point, conversionMode: string, precision?: number, addSpaces?: boolean): string;
    /**
     * Returns formatted coordinates in United States National Grid (USNG) notation representing the given point's location.The precision value controls the number of digits used to represent each numerical easting and northing value within the USNG string.For example:| precision | add_spaces | Example output | Approximate precision || --- | --- | --- | --- || 0 | false | 13TFJ | 100km || 1 | false | 13TFJ25 | 10km || 2 | false | 13TFJ2359 | 1km || 3 | false | 13TFJ237595 | 100m || 4 | false | 13TFJ23745951 | 10m || 5 | false | 13TFJ2374359512 | 1m || 0 | true | 13T FJ | 100km || 1 | true | 13T FJ 2 5 | 10m || 2 | true | 13T FJ 23 59 | 1km || 3 | true | 13T FJ 237 595 | 100m || 4 | true | 13T FJ 2374 5951 | 10m || 5 | true | 13T FJ 23743 59512 | 1m || 4* | false | 13TFJ23795929 (NAD 27) | 10m || 2* | true | 13T FJ 23 59 (NAD 27) | 1km |&ast; *When the point's spatial reference is based on NAD 27.*
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-coordinateFormatter.html#toUsng)
     *
     * @param point The location to be represented in USNG notation.The point's [spatial reference](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#spatialReference) should either be WGS84 or another[geographic coordinate system](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm).
     * @param precision The precision with which to represent the coordinates, it should be an integer from 0 to 8.
     * @param addSpaces If `false`, the generated string will contain no spaces. If `true`, a space separatesthe grid zone designator, the 100km square identifier, and the numerical easting and northing values.
     *
     */
    toUsng(point: Point, precision?: number, addSpaces?: boolean): string;
    /**
     * Returns formatted coordinates in Universal Transverse Mercator (UTM) notation representing the given point's location.Example output for a point in the southern hemisphere:| conversionMode | add_spaces | Example output || --- | --- | --- || latitude-band-indicators | false | 30U4898846199881 || latitude-band-indicators | true | 30U 489884 6199881 || north-south-indicators | false | 30N4898846199881 || north-south-indicators | true | 30N 489884 6199881 |
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-coordinateFormatter.html#toUtm)
     *
     * @param point The location to be represented in UTM notation.The point's [spatial reference](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#spatialReference) should either be WGS84 or another[geographic coordinate system](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm)
     * @param conversionMode The latitude notation scheme to use in the returned UTM notation string,either a latitudinal band, or a hemisphere designator.**Possible Values**: latitude-band-indicators | north-south-indicators
     * @param addSpaces If `false`, the generated string will contain no spaces. If `true`, a space separatesthe UTM zone and latitude designator and each numerical easting and northing value.
     *
     */
    toUtm(point: Point, conversionMode: string, addSpaces?: boolean): string;
  }

  export const coordinateFormatter: coordinateFormatter;

  interface Extent extends Geometry {
    /**
     * The center point of the extent in map units.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#center)
     */
    readonly center: Point;
    /**
     * The height of the extent in map units (the distance between [ymin](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#ymin) and [ymax](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#ymax)).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#height)
     */
    readonly height: number;
    /**
     * The maximum possible `m` value in an extent envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#mmax)
     *
     * @default undefined
     */
    mmax: number;
    /**
     * The minimum possible `m` value of an extent envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#mmin)
     *
     * @default undefined
     */
    mmin: number;
    /**
     * For Extent, the type is always `extent`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#type)
     */
    readonly type: "extent";
    /**
     * The width of the extent in map units (the distance between [xmin](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#xmin) and [xmax](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#xmax)).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#width)
     */
    readonly width: number;
    /**
     * The bottom-right X-coordinate of an extent envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#xmax)
     *
     * @default 0
     */
    xmax: number;
    /**
     * The top-left X-coordinate of an extent envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#xmin)
     *
     * @default 0
     */
    xmin: number;
    /**
     * The top-right Y-coordinate of an extent envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#ymax)
     *
     * @default 0
     */
    ymax: number;
    /**
     * The bottom-left Y-coordinate of an extent envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#ymin)
     *
     * @default 0
     */
    ymin: number;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#zmax)
     *
     * @default undefined
     */
    zmax: number;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#zmin)
     *
     * @default undefined
     */
    zmin: number;

    /**
     * Centers the extent to the specified [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html).This method modifies the extent geometry in-place. You should [clone](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#clone)the extent object before calling this method where appropriate.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#centerAt)
     *
     * @param point The point to center the extent.
     *
     */
    centerAt(point: Point): Extent;
    /**
     * Creates a deep clone of Extent object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#clone)
     *
     *
     */
    clone(): Extent;
    /**
     * Checks if the input geometry is contained within the extent.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#contains)
     *
     * @param geometry Input geometry to test if it is contained within the extent.
     *
     */
    contains(geometry: Point | Extent): boolean;
    /**
     * Indicates if the input extent is equal to the testing extent.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#equals)
     *
     * @param extent Input extent.
     *
     */
    equals(extent: Extent): boolean;
    /**
     * Expands the extent by the given factor. For example, a value of 1.5 willexpand the extent to be 50 percent larger than the original extent.This method modifies the extent geometry in-place. You should [clone](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#clone)the extent object before calling this method where appropriate.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#expand)
     *
     * @param factor The multiplier value.
     *
     */
    expand(factor: number): Extent;
    /**
     * Shrinks the original extent to the intersection with the input extent.This method modifies the extent geometry in-place. You should [clone](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#clone)the extent object before calling this method where appropriate.If the original extent and the input extent have no intersection, theextent is not modified and null is returned.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#intersection)
     *
     * @param extent The input extent to intersect.
     *
     */
    intersection(extent: Extent): Extent;
    /**
     * Tests to validate if the input geometry intersects the extent and returns a Boolean value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#intersects)
     *
     * @param geometry The geometry used to test the intersection. It can be a[Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html), [Polyline](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html),[Polygon](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html), [Extent](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html) or[Multipoint](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Multipoint.html).
     *
     */
    intersects(geometry: Geometry): boolean;
    /**
     * Returns an array with either one Extent that's been shifted to within +/- 180 or two Extentsif the original extent intersects the International Dateline.This method modifies the extent geometry in-place. You should [clone](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#clone)the extent object before calling this method where appropriate.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#normalize)
     *
     *
     */
    normalize(): Extent[];
    /**
     * Modifies the extent geometry in-place with X and Y offsets in map units.You should [clone](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#clone)the extent object before calling this method where appropriate.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#offset)
     *
     * @param dx The offset distance in map units for the X-coordinate.
     * @param dy The offset distance in map units for the Y-coordinate.
     * @param dz The offset distance in map units for the Z-coordinate.
     *
     */
    offset(dx: number, dy: number, dz: number): Extent;
    /**
     * Expands the original extent to include the extent of the input Extent.This method modifies the extent geometry in-place. You should [clone](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#clone)the extent object before calling this method where appropriate.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#union)
     *
     * @param extent The input extent to union.
     *
     */
    union(extent: Extent): Extent;
  }

  interface ExtentConstructor {
    new (properties?: ExtentProperties): Extent;

    fromJSON(json: any): Extent;
  }

  export const Extent: ExtentConstructor;

  interface ExtentProperties extends GeometryProperties {
    /**
     * The maximum possible `m` value in an extent envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#mmax)
     *
     * @default undefined
     */
    mmax?: number;
    /**
     * The minimum possible `m` value of an extent envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#mmin)
     *
     * @default undefined
     */
    mmin?: number;
    /**
     * The bottom-right X-coordinate of an extent envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#xmax)
     *
     * @default 0
     */
    xmax?: number;
    /**
     * The top-left X-coordinate of an extent envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#xmin)
     *
     * @default 0
     */
    xmin?: number;
    /**
     * The top-right Y-coordinate of an extent envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#ymax)
     *
     * @default 0
     */
    ymax?: number;
    /**
     * The bottom-left Y-coordinate of an extent envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#ymin)
     *
     * @default 0
     */
    ymin?: number;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#zmax)
     *
     * @default undefined
     */
    zmax?: number;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html#zmin)
     *
     * @default undefined
     */
    zmin?: number;
  }

  interface Geometry extends Accessor, JSONSupport {
    /**
     * The cache is used to store values computed from geometries that need to cleared or recomputed upon mutation.An example is the extent of a polygon.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html#cache)
     */
    readonly cache: any;
    /**
     * The extent of the geometry. For a point, the extent is null.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html#extent)
     */
    readonly extent: Extent;
    /**
     * Indicates if the geometry has M values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html#hasM)
     */
    hasM: boolean;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html#hasZ)
     */
    hasZ: boolean;
    /**
     * The spatial reference of the geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html#spatialReference)
     *
     * @default WGS84 (wkid: 4326)
     */
    spatialReference: SpatialReference;
    /**
     * The geometry type.**Possible Values:** point | multipoint | polyline | polygon | extent | mesh
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html#type)
     */
    readonly type: string;

    /**
     * Creates a deep clone of the geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html#clone)
     *
     *
     */
    clone(): Geometry;
  }

  interface GeometryConstructor {
    new (properties?: GeometryProperties): Geometry;

    fromJSON(json: any): Geometry;
  }

  export const Geometry: GeometryConstructor;

  interface GeometryProperties {
    /**
     * Indicates if the geometry has M values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html#hasM)
     */
    hasM?: boolean;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html#hasZ)
     */
    hasZ?: boolean;
    /**
     * The spatial reference of the geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html#spatialReference)
     *
     * @default WGS84 (wkid: 4326)
     */
    spatialReference?: SpatialReferenceProperties;
  }

  interface geometryEngine {
    /**
     * Creates planar (or Euclidean) buffer polygons at a specified distance around the input geometries.The GeometryEngine has two methods for buffering geometries client-side: buffer and [geodesicBuffer](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#geodesicBuffer).Use caution whendeciding which method to use. As a general rule, use [geodesicBuffer](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#geodesicBuffer) if the input geometrieshave a spatial reference of either WGS84 (wkid: 4326) or [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator). Only use buffer (this method)when attempting to buffer geometries with a [projected coordinate system](https://developers.arcgis.com/rest/services-reference/projected-coordinate-systems.htm) other than Web Mercator. If you need to buffer geometrieswith a [geographic coordinate system](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm) other than WGS84 (wkid: 4326), use[GeometryService.buffer()](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-GeometryService.html#buffer).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#buffer)
     *
     * @param geometry The buffer input geometry.       The `geometry` and `distance` parameters must be specified as either both arrays or       both non-arrays. Never specify one as an array and the other a non-array.
     * @param distance The specified distance(s) for buffering.       The `geometry` and `distance` parameters must be specified as either both arrays or       both non-arrays. Never specify one as an array and the other a non-array.           When using an array of geometries as input, the length of the geometry array does not have to       equal the length of the `distance` array. For example, if you pass an array of four geometries:       `[g1, g2, g3, g4]` and an array with one distance: `[d1]`, all four geometries will be buffered by the       single distance value. If instead you use an array of three distances: `[d1, d2, d3]`, `g1` will be buffered by       `d1`, `g2` by `d2`, and `g3` and `g4` will both be buffered by `d3`. The value of the geometry array will       be matched one to one with those in the distance array until the final value of the distance array is reached,       in which case that value will be applied to the remaining geometries.
     * @param unit Measurement unit of the distance(s).       Defaults to the units of the input geometries.       Use one of the possible values listed below or any of the       [numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).           **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     * @param unionResults Determines whether the output geometries should be unioned into a single       polygon.
     *
     */
    buffer(
      geometry: Geometry | Geometry[],
      distance: number | number[],
      unit: string | number,
      unionResults?: boolean
    ): Polygon | Polygon[];
    /**
     * Calculates the clipped geometry from a target geometry by an envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#clip)
     *
     * @param geometry The geometry to be clipped.
     * @param envelope The envelope used to clip.
     *
     */
    clip(geometry: Geometry, envelope: Extent): Geometry;
    /**
     * Indicates if one geometry contains another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#contains)
     *
     * @param containerGeometry The geometry that is tested for the "contains" relationship to the other geometry.  Think of this geometry as the potential "container" of the `insideGeometry`.
     * @param insideGeometry The geometry that is tested for the "within" relationship to the `containerGeometry`.
     *
     */
    contains(containerGeometry: Geometry, insideGeometry: Geometry): boolean;
    /**
     * Calculates the convex hull of the input geometry. A convex hull is the smallest convex polygon that encloses a group of Objects,such as points. The input geometry can be a point, multipoint, polyline or polygon. The hull is typically a polygon but can alsobe a polyline or point in degenerate cases.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#convexHull)
     *
     * @param geometry The input geometry.
     * @param merge Dictates whether to merge output geometries.
     *
     */
    convexHull(geometry: Geometry, merge?: boolean): Geometry | Geometry[];
    /**
     * Indicates if one geometry crosses another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#crosses)
     *
     * @param geometry1 The geometry to cross.
     * @param geometry2 The geometry being crossed.
     *
     */
    crosses(geometry1: Geometry, geometry2: Geometry): boolean;
    /**
     * Split the input Polyline or Polygon where it crosses a cutting Polyline. For Polylines, all left cuts aregrouped together in the first Geometry. Right cuts and coincident cuts are grouped in the second Geometry andeach undefined cut, along with any uncut parts, are output as separate Polylines. For Polygons, all left cutsare grouped in the first Polygon, all right cuts are grouped in the second Polygon, and each undefined cut, along withany left-over parts after cutting, are output as a separate Polygon. If no cuts are returned then the array willbe empty. An undefined cut will only be produced if a left cut or right cut was produced and there was a partleft over after cutting, or a cut is bounded to the left and right of the cutter.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#cut)
     *
     * @param geometry The geometry to be cut.
     * @param cutter The polyline to cut the geometry.
     *
     */
    cut(geometry: Geometry, cutter: Polyline): Geometry[];
    /**
     * Densify geometries by plotting points between existing vertices.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#densify)
     *
     * @param geometry The geometry to be densified.
     * @param maxSegmentLength The maximum segment length allowed. Must be a positive value.
     * @param maxSegmentLengthUnit Measurement unit for maxSegmentLength.Defaults to the units of the input geometry.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).    **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     *
     */
    densify(geometry: Geometry, maxSegmentLength: number, maxSegmentLengthUnit: string | number): Geometry;
    /**
     * Creates the difference of two geometries. The resultant geometry is the portion of `inputGeometry` not in the `subtractor`.The dimension of the `subtractor` has to be equal to or greater than that of the `inputGeometry`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#difference)
     *
     * @param inputGeometry The input geometry to subtract from.
     * @param subtractor The geometry being subtracted from inputGeometry.
     *
     */
    difference(inputGeometry: Geometry | Geometry[], subtractor: Geometry): Geometry | Geometry[];
    /**
     * Indicates if one geometry is disjoint (doesn't intersect in any way) with another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#disjoint)
     *
     * @param geometry1 The base geometry that is tested for the "disjoint" relationship to the other geometry.
     * @param geometry2 The comparison geometry that is tested for the "disjoint" relationship to the other geometry.
     *
     */
    disjoint(geometry1: Geometry, geometry2: Geometry): boolean;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#distance)
     *
     * @param geometry1 First input geometry.
     * @param geometry2 Second input geometry.
     * @param distanceUnit Measurement unit of the return value.Defaults to the units of the input geometries.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).    **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     *
     */
    distance(geometry1: Geometry, geometry2: Geometry, distanceUnit: string | number): number;
    /**
     * Indicates if two geometries are equal.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#equals)
     *
     * @param geometry1 First input geometry.
     * @param geometry2 Second input geometry.
     *
     */
    equals(geometry1: Geometry, geometry2: Geometry): boolean;
    /**
     * Returns an Object containing additional information about the input spatial reference.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#extendedSpatialReferenceInfo)
     *
     * @param spatialReference The input spatial reference.
     *
     */
    extendedSpatialReferenceInfo(spatialReference: SpatialReference): any;
    /**
     * Flips a geometry on the horizontal axis. Can optionally be flipped around a point.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#flipHorizontal)
     *
     * @param geometry The input geometry to be flipped.
     * @param flipOrigin Point to flip the geometry around. Defaults to the centroid of the geometry.
     *
     */
    flipHorizontal(geometry: Geometry, flipOrigin?: Point): Geometry;
    /**
     * Flips a geometry on the vertical axis. Can optionally be flipped around a point.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#flipVertical)
     *
     * @param geometry The input geometry to be flipped.
     * @param flipOrigin Point to flip the geometry around. Defaults to the centroid of the geometry.
     *
     */
    flipVertical(geometry: Geometry, flipOrigin?: Point): Geometry;
    /**
     * Performs the generalize operation on the geometries in the cursor. Point and Multipoint geometries are left unchanged.Envelope is converted to a Polygon and then generalized.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#generalize)
     *
     * @param geometry The input geometry to be generalized.
     * @param maxDeviation The maximum allowed deviation from the generalized geometry to the original geometry.
     * @param removeDegenerateParts When `true` the degenerate parts of the geometry willbe removed from the output (may be undesired for drawing).
     * @param maxDeviationUnit Measurement unit for maxDeviation.Defaults to the units of the input geometry.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).    **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     *
     */
    generalize(
      geometry: Geometry,
      maxDeviation: number,
      removeDegenerateParts?: boolean,
      maxDeviationUnit?: string | number
    ): Geometry;
    /**
     * Calculates the area of the input geometry. As opposed to [planarArea()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#planarArea), geodesicArea takes into accountthe curvature of the earth when performing this calculation. Therefore, when using input geometries with aspatial reference of either WGS84 (wkid: 4326) or [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator), it is best practice tocalculate areas using geodesicArea(). If the input geometries have a projected coordinate system other thanWeb Mercator, use [planarArea()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#planarArea) instead.This method only works with WGS84 (wkid: 4326) and [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator) spatial references.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#geodesicArea)
     *
     * @param geometry The input polygon.
     * @param unit Measurement unit of the return value.Defaults to the units of the input geometries.Use one of the possible values listed below or any of the[numeric codes for area units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.AreaUnit.Code.ACRE).    **Possible Values:** acres | ares | hectares | square-feet | square-meters | square-yards |square-kilometers | square-miles
     *
     */
    geodesicArea(geometry: Polygon, unit: string | number): number;
    /**
     * Creates geodesic buffer polygons at a specified distance around the input geometries. When calculating distances,this method takes the curvature of the earth into account, which provides highly accurate results when dealing withvery large geometries and/or geometries that spatially vary on a global scale where one projected coordinatesystem could not accurately plot coordinates and measure distances for all the geometries.This method only works with WGS84 (wkid: 4326) and [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator) spatial references. In general,if your input geometries are assigned one of those two spatial references, you should always use geodesicBuffer() toobtain the most accurate results for those geometries. If needing to buffer points assigned a [projected coordinatesystem other than Web Mercator](https://developers.arcgis.com/rest/services-reference/projected-coordinate-systems.htm), use [buffer()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#buffer) instead. If the input geometrieshave a [geographic coordinate system](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm) other than WGS84 (wkid: 4326), use[GeometryService.buffer()](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-GeometryService.html#buffer).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#geodesicBuffer)
     *
     * @param geometry The buffer input geometry.       The `geometry` and `distance` parameters must be specified as either both arrays or       both non-arrays. Never specify one as an array and the other a non-array.
     * @param distance The specified distance(s) for buffering.       The `geometry` and `distance` parameters must be specified as either both arrays or       both non-arrays. Never specify one as an array and the other a non-array.           When using an array of geometries as input, the length of the geometry array does not have to       equal the length of the `distance` array. For example, if you pass an array of four geometries:       `[g1, g2, g3, g4]` and an array with one distance: `[d1]`, all four geometries will be buffered by the       single distance value. If instead you use an array of three distances: `[d1, d2, d3]`, `g1` will be buffered by       `d1`, `g2` by `d2`, and `g3` and `g4` will both be buffered by `d3`. The value of the geometry array will       be matched one to one with those in the distance array until the final value of the distance array is reached,       in which case that value will be applied to the remaining geometries.
     * @param unit Measurement unit of the distance(s).       Defaults to the units of the input geometries.       Use one of the possible values listed below or any of the       [numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).           **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     * @param unionResults Determines whether the output geometries should be unioned into a single       polygon.
     *
     */
    geodesicBuffer(
      geometry: Geometry | Geometry[],
      distance: number | number[],
      unit: string | number,
      unionResults?: boolean
    ): Polygon | Polygon[];
    /**
     * Returns a geodesically densified version of the input geometry. Use this function to draw the line(s) of the geometry along great circles.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#geodesicDensify)
     *
     * @param geometry A polyline or polygon to densify.
     * @param maxSegmentLength The maximum segment length allowed. This must be a positive value.
     * @param maxSegmentLengthUnit Measurement unit for `maxSegmentLength`.If a unit is not specified, the units are considered to be the same as the units of the `geometry`.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).    **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     *
     */
    geodesicDensify(
      geometry: Polyline | Polygon,
      maxSegmentLength: number,
      maxSegmentLengthUnit: string | number
    ): Geometry;
    /**
     * Calculates the length of the input geometry. As opposed to [planarLength()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#planarLength), geodesicLength() takes into accountthe curvature of the earth when performing this calculation. Therefore, when using input geometries with aspatial reference of either WGS84 (wkid: 4326) or [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator), it is best practice tocalculate lengths using geodesicLength(). If the input geometries have a projected coordinate system other thanWeb Mercator, use [planarLength()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#planarLength) instead.This method only works with WGS84 (wkid: 4326) and [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator) spatial references.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#geodesicLength)
     *
     * @param geometry The input geometry.
     * @param unit Measurement unit of the return value.Defaults to the units of the input geometry.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).    **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     *
     */
    geodesicLength(geometry: Geometry, unit: string | number): number;
    /**
     * Creates a new geometry through intersection between two geometries.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#intersect)
     *
     * @param geometry The input geometry(ies).
     * @param intersector The geometry being intersected.
     *
     */
    intersect(geometry: Geometry | Geometry[], intersector: Geometry): Geometry | Geometry[];
    /**
     * Indicates if one geometry intersects another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#intersects)
     *
     * @param geometry1 The geometry that is tested for the intersects relationship to the other geometry.
     * @param geometry2 The geometry being intersected.
     *
     */
    intersects(geometry1: Geometry, geometry2: Geometry): boolean;
    /**
     * Indicates if the given geometry is topologically simple.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#isSimple)
     *
     * @param geometry The input geometry.
     *
     */
    isSimple(geometry: Geometry): boolean;
    /**
     * Finds the coordinate of the geometry that is closest to the specified point.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#nearestCoordinate)
     *
     * @param geometry The geometry to consider.
     * @param inputPoint The point used to search the nearest coordinate in the geometry.
     *
     */
    nearestCoordinate(geometry: Geometry, inputPoint: Point): NearestPointResult;
    /**
     * Finds the vertex on the geometry nearest to the specified point.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#nearestVertex)
     *
     * @param geometry The geometry to consider.
     * @param inputPoint The point used to search the nearest vertex in the geometry.
     *
     */
    nearestVertex(geometry: Geometry, inputPoint: Point): NearestPointResult;
    /**
     * Finds all vertices in the given distance from the specified point, sorted from the closest to the furthest andreturns them as an array of Objects.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#nearestVertices)
     *
     * @param geometry The geometry to consider.
     * @param inputPoint The point from which to measure.
     * @param searchRadius The distance to search from the inputPoint in the units of the view's spatial reference.
     * @param maxVertexCountToReturn The maximum number of vertices to return.
     *
     */
    nearestVertices(
      geometry: Geometry,
      inputPoint: Point,
      searchRadius: number,
      maxVertexCountToReturn: number
    ): NearestPointResult[];
    /**
     * The offset operation creates a geometry that is a constant planar distance from an inputpolyline or polygon. It is similar to buffering, but produces a one-sided result.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#offset)
     *
     * @param geometry The geometries to offset.
     * @param offsetDistance The planar distance to offset from the input geometry. If offsetDistance > 0, then the offsetgeometry is constructed to the right of the oriented input geometry, if offsetDistance = 0, then there is nochange in the geometries, otherwise it is constructed to the left. For a simple polygon, the orientation of outerrings is clockwise and for inner rings it is counter clockwise. So the "right side" of a simple polygon is always its inside.
     * @param offsetUnit Measurement unit of the offset distance.Defaults to the units of the input geometries.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).    **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     * @param joinType The join type.     **Possible values:** round | bevel | miter | square
     * @param bevelRatio Applicable when `joinType = 'miter'`; bevelRatio is multiplied by the offset distance andthe result determines how far a mitered offset intersection can be located before it is beveled.
     * @param flattenError Applicable when `joinType = 'round'`; flattenError determines the maximum distance of the resultingsegments compared to the true circular arc. The algorithm never produces more than around 180 vertices for each round join.
     *
     */
    offset(
      geometry: Geometry | Geometry[],
      offsetDistance: number,
      offsetUnit: string | number,
      joinType: string,
      bevelRatio?: number,
      flattenError?: number
    ): Geometry | Geometry[];
    /**
     * Indicates if one geometry overlaps another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#overlaps)
     *
     * @param geometry1 The base geometry that is tested for the "overlaps" relationship with the other geometry.
     * @param geometry2 The comparison geometry that is tested for the "overlaps" relationship with the other geometry.
     *
     */
    overlaps(geometry1: Geometry, geometry2: Geometry): boolean;
    /**
     * Calculates the area of the input geometry. As opposed to [geodesicArea()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#geodesicArea), planarArea() performsthis calculation using projected coordinates and does not take into account the earth's curvature. When using input geometries with aspatial reference of either WGS84 (wkid: 4326) or [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator), it is best practice tocalculate areas using [geodesicArea()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#geodesicArea). If the input geometries have a projected coordinate system other thanWeb Mercator, use planarArea() instead.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#planarArea)
     *
     * @param geometry The input polygon.
     * @param unit Measurement unit of the return value.Defaults to the units of the input geometries.Use one of the possible values listed below or any of the[numeric codes for area units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.AreaUnit.Code.ACRE).**Possible Values:** acres | ares | hectares | square-feet | square-meters | square-yards |square-kilometers | square-miles
     *
     */
    planarArea(geometry: Polygon, unit: string | number): number;
    /**
     * Calculates the length of the input geometry. As opposed to [geodesicLength()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#geodesicLength), planarLength() usesprojected coordinates and does not take into accountthe curvature of the earth when performing this calculation. When using input geometries with aspatial reference of either WGS84 (wkid: 4326) or [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator), it is best practice tocalculate lengths using [geodesicLength()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#geodesicLength). If the input geometries have a projected coordinate system other thanWeb Mercator, use planarLength() instead.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#planarLength)
     *
     * @param geometry The input geometry.
     * @param unit Measurement unit of the return value.Defaults to the units of the input geometries.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).**Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     *
     */
    planarLength(geometry: Geometry, unit: string | number): number;
    /**
     * Indicates if the given DE-9IM relation holds for the two geometries.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#relate)
     *
     * @param geometry1 The first geometry for the relation.
     * @param geometry2 The second geometry for the relation.
     * @param relation The Dimensionally Extended 9 Intersection Model (DE-9IM) matrix relation(encoded as a string) to test against the relationship of the two geometries. This string contains thetest result of each intersection represented in the DE-9IM matrix. Each result is one character of thestring and may be represented as either a number (maximum dimension returned: `0`,`1`,`2`), a Booleanvalue (`T` or `F`), or a mask character (for ignoring results: '\*').    Example: Each of the followingDE-9IM string codes are valid for testing whether a polygon geometry completely contains a line geometry:`TTTFFTFFT` (Boolean), 'T*\*\*\*\*\*FF\*' (ignore irrelevant intersections), or '102FF\*FF\*' (dimension form).Each returns the same result.    See [this article](https://en.wikipedia.org/wiki/DE-9IM) and[this ArcGIS help page](https://desktop.arcgis.com/en/arcmap/latest/manage-data/using-sql-with-gdbs/relational-functions-for-st-geometry.htm)for more information about the DE-9IM model and how string codes are constructed.
     *
     */
    relate(geometry1: Geometry, geometry2: Geometry, relation: string): boolean;
    /**
     * Rotates a geometry counterclockwise by the specified number of degrees.Rotation is around the centroid, or a given rotation point.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#rotate)
     *
     * @param geometry The geometry to rotate.
     * @param angle The rotation angle in degrees.
     * @param rotationOrigin Point to rotate the geometry around. Defaults to the centroid of the geometry.
     *
     */
    rotate(geometry: Geometry, angle: number, rotationOrigin?: Point): Geometry;
    /**
     * Performs the simplify operation on the geometry which alters the given geometries to make their definitionstopologically legal with respect to their geometry type.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#simplify)
     *
     * @param geometry The geometry to be simplified.
     *
     */
    simplify(geometry: Geometry): Geometry;
    /**
     * Creates the symmetric difference of two geometries. The symmetric difference includes the partsthat are in either of the sets, but not in both.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#symmetricDifference)
     *
     * @param leftGeometry One of the Geometry instances in the XOR operation.
     * @param rightGeometry One of the Geometry instances in the XOR operation.
     *
     */
    symmetricDifference(leftGeometry: Geometry | Geometry[], rightGeometry: Geometry): Geometry | Geometry[];
    /**
     * Indicates if one geometry touches another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#touches)
     *
     * @param geometry1 The geometry to test the "touches" relationship with the other geometry.
     * @param geometry2 The geometry to be touched.
     *
     */
    touches(geometry1: Geometry, geometry2: Geometry): boolean;
    /**
     * All inputs must be of the same type of geometries and share one spatial reference.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#union)
     *
     * @param geometries An array of Geometries to union.
     *
     */
    union(geometries: Geometry[]): Geometry;
    /**
     * Indicates if one geometry is within another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#within)
     *
     * @param innerGeometry The base geometry that is tested for the "within" relationship to the other geometry.
     * @param outerGeometry The comparison geometry that is tested for the "contains" relationship to the other geometry.
     *
     */
    within(innerGeometry: Geometry, outerGeometry: Geometry): boolean;
  }

  export const geometryEngine: geometryEngine;

  /**
   * Object returned from the [nearestCoordinate()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#nearestCoordinate), [nearestVertex()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#nearestVertex), and [nearestVertices()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#nearestVertices) methods.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#NearestPointResult)
   */
  export interface NearestPointResult extends Object {
    /**
     * A vertex within the specified distance of the search.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#NearestPointResult)
     */
    coordinate: Point;
    /**
     * The distance from the `inputPoint` in the units of the view's spatial reference.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#NearestPointResult)
     */
    distance: number;
    /**
     * Indicates if the vertex is on the right side of the `geometry`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#NearestPointResult)
     */
    isRightSide: boolean;
    /**
     * The index of the vertex within the geometry's rings or paths.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#NearestPointResult)
     */
    vertexIndex: number;
    /**
     * Indicates if it is an empty geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngine.html#NearestPointResult)
     */
    isEmpty: boolean;
  }

  interface geometryEngineAsync {
    /**
     * Creates planar (or Euclidean) buffer polygons at a specified distance around the input geometries.The GeometryEngine has two methods for buffering geometries client-side: buffer and [geodesicBuffer](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#geodesicBuffer).Use caution whendeciding which method to use. As a general rule, use [geodesicBuffer](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#geodesicBuffer) if the input geometrieshave a spatial reference of either WGS84 (wkid: 4326) or [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator). Only use buffer (this method)when attempting to buffer geometries with a [projected coordinate system](https://developers.arcgis.com/rest/services-reference/projected-coordinate-systems.htm) other than Web Mercator. If you need to buffer geometrieswith a [geographic coordinate system](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm) other than WGS84 (wkid: 4326), use[GeometryService.buffer()](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-GeometryService.html#buffer).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#buffer)
     *
     * @param geometry The buffer input geometry.       The `geometry` and `distance` parameters must be specified as either both arrays or       both non-arrays. Never specify one as an array and the other a non-array.
     * @param distance The specified distance(s) for buffering.       The `geometry` and `distance` parameters must be specified as either both arrays or       both non-arrays. Never specify one as an array and the other a non-array.           When using an array of geometries as input, the length of the geometry array does not have to       equal the length of the `distance` array. For example, if you pass an array of four geometries:       `[g1, g2, g3, g4]` and an array with one distance: `[d1]`, all four geometries will be buffered by the       single distance value. If instead you use an array of three distances: `[d1, d2, d3]`, `g1` will be buffered by       `d1`, `g2` by `d2`, and `g3` and `g4` will both be buffered by `d3`. The value of the geometry array will       be matched one to one with those in the distance array until the final value of the distance array is reached,       in which case that value will be applied to the remaining geometries.
     * @param unit Measurement unit of the distance(s).       Defaults to the units of the input geometries.       Use one of the possible values listed below or any of the       [numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).           **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     * @param unionResults Determines whether the output geometries should be unioned into a single       polygon.
     *
     */
    buffer(
      geometry: Geometry | Geometry[],
      distance: number | number[],
      unit: string | number,
      unionResults?: boolean
    ): IPromise<Polygon | Polygon[]>;
    /**
     * Calculates the clipped geometry from a target geometry by an envelope.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#clip)
     *
     * @param geometry The geometry to be clipped.
     * @param envelope The envelope used to clip.
     *
     */
    clip(geometry: Geometry, envelope: Extent): IPromise<Geometry>;
    /**
     * Indicates if one geometry contains another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#contains)
     *
     * @param containerGeometry The geometry that is tested for the "contains" relationship to the other geometry.  Think of this geometry as the potential "container" of the `insideGeometry`.
     * @param insideGeometry The geometry that is tested for the "within" relationship to the `containerGeometry`.
     *
     */
    contains(containerGeometry: Geometry, insideGeometry: Geometry): IPromise<boolean>;
    /**
     * Calculates the convex hull of the input geometry. A convex hull is the smallest convex polygon that encloses a group of Objects,such as points. The input geometry can be a point, multipoint, polyline or polygon. The hull is typically a polygon but can alsobe a polyline or point in degenerate cases.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#convexHull)
     *
     * @param geometry The input geometry.
     * @param merge Dictates whether to merge output geometries.
     *
     */
    convexHull(geometry: Geometry, merge?: boolean): IPromise<Geometry>;
    /**
     * Indicates if one geometry crosses another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#crosses)
     *
     * @param geometry1 The geometry to cross.
     * @param geometry2 The geometry being crossed.
     *
     */
    crosses(geometry1: Geometry, geometry2: Geometry): IPromise<boolean>;
    /**
     * Split the input Polyline or Polygon where it crosses a cutting Polyline. For Polylines, all left cuts aregrouped together in the first Geometry. Right cuts and coincident cuts are grouped in the second Geometry andeach undefined cut, along with any uncut parts, are output as separate Polylines. For Polygons, all left cutsare grouped in the first Polygon, all right cuts are grouped in the second Polygon, and each undefined cut, along withany left-over parts after cutting, are output as a separate Polygon. If no cuts are returned then the array willbe empty. An undefined cut will only be produced if a left cut or right cut was produced and there was a partleft over after cutting, or a cut is bounded to the left and right of the cutter.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#cut)
     *
     * @param geometry The geometry to be cut.
     * @param cutter The polyline to cut the geometry.
     *
     */
    cut(geometry: Geometry, cutter: Polyline): IPromise<Geometry[]>;
    /**
     * Densify geometries by plotting points between existing vertices.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#densify)
     *
     * @param geometry The geometry to be densified.
     * @param maxSegmentLength The maximum segment length allowed. Must be a positive value.
     * @param maxSegmentLengthUnit Measurement unit for maxSegmentLength.Defaults to the units of the input geometry.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).    **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     *
     */
    densify(geometry: Geometry, maxSegmentLength: number, maxSegmentLengthUnit: string | number): IPromise<Geometry>;
    /**
     * Creates the difference of two geometries. The resultant geometry is the portion of inputGeometry not in the subtractor.The dimension of the subtractor has to be equal to or greater than that of the inputGeometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#difference)
     *
     * @param inputGeometry The input geometry to subtract from.
     * @param subtractor The geometry being subtracted from inputGeometry.
     *
     */
    difference(inputGeometry: Geometry | Geometry[], subtractor: Geometry): IPromise<Geometry>;
    /**
     * Indicates if one geometry is disjoint (doesn't intersect in any way) with another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#disjoint)
     *
     * @param geometry1 The base geometry that is tested for the "disjoint" relationship to the other geometry.
     * @param geometry2 The comparison geometry that is tested for the "disjoint" relationship to the other geometry.
     *
     */
    disjoint(geometry1: Geometry, geometry2: Geometry): IPromise<boolean>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#distance)
     *
     * @param geometry1 First input geometry.
     * @param geometry2 Second input geometry.
     * @param distanceUnit Measurement unit of the return value.Defaults to the units of the input geometries.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).    **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     *
     */
    distance(geometry1: Geometry, geometry2: Geometry, distanceUnit: string | number): IPromise<number>;
    /**
     * Indicates if two geometries are equal.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#equals)
     *
     * @param geometry1 First input geometry.
     * @param geometry2 Second input geometry.
     *
     */
    equals(geometry1: Geometry, geometry2: Geometry): IPromise<boolean>;
    /**
     * Returns an Object containing additional information about the input spatial reference.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#extendedSpatialReferenceInfo)
     *
     * @param spatialReference The input spatial reference.
     *
     */
    extendedSpatialReferenceInfo(spatialReference: SpatialReference): IPromise<any>;
    /**
     * Flips a geometry on the horizontal axis. Can optionally be flipped around a point.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#flipHorizontal)
     *
     * @param geometry The input geometry to be flipped.
     * @param flipOrigin Point to flip the geometry around. Defaults to the centroid of the geometry.
     *
     */
    flipHorizontal(geometry: Geometry, flipOrigin?: Point): IPromise<Geometry>;
    /**
     * Flips a geometry on the vertical axis. Can optionally be flipped around a point.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#flipVertical)
     *
     * @param geometry The input geometry to be flipped.
     * @param flipOrigin Point to flip the geometry around. Defaults to the centroid of the geometry.
     *
     */
    flipVertical(geometry: Geometry, flipOrigin?: Point): IPromise<Geometry>;
    /**
     * Performs the generalize operation on the geometries in the cursor. Point and Multipoint geometries are left unchanged.Envelope is converted to a Polygon and then generalized.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#generalize)
     *
     * @param geometry The input geometry to be generalized.
     * @param maxDeviation The maximum allowed deviation from the generalized geometry to the original geometry.
     * @param removeDegenerateParts When `true` the degenerate parts of the geometry willbe removed from the output (may be undesired for drawing).
     * @param maxDeviationUnit Measurement unit for maxDeviation.Defaults to the units of the input geometry.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).    **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     *
     */
    generalize(
      geometry: Geometry,
      maxDeviation: number,
      removeDegenerateParts?: boolean,
      maxDeviationUnit?: string | number
    ): IPromise<Geometry>;
    /**
     * Calculates the area of the input geometry. As opposed to [planarArea()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#planarArea), geodesicArea takes into accountthe curvature of the earth when performing this calculation. Therefore, when using input geometries with aspatial reference of either WGS84 (wkid: 4326) or [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator), it is best practice tocalculate areas using geodesicArea(). If the input geometries have a projected coordinate system other thanWeb Mercator, use [planarArea()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#planarArea) instead.This method only works with WGS84 (wkid: 4326) and [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator) spatial references.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#geodesicArea)
     *
     * @param geometry The input polygon.
     * @param unit Measurement unit of the return value.Defaults to the units of the input geometries.Use one of the possible values listed below or any of the[numeric codes for area units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.AreaUnit.Code.ACRE).    **Possible Values:** acres | ares | hectares | square-feet | square-meters | square-yards |square-kilometers | square-miles
     *
     */
    geodesicArea(geometry: Polygon, unit: string | number): IPromise<number>;
    /**
     * Creates geodesic buffer polygons at a specified distance around the input geometries. When calculating distances,this method takes the curvature of the earth into account, which provides highly accurate results when dealing withvery large geometries and/or geometries that spatially vary on a global scale where one projected coordinatesystem could not accurately plot coordinates and measure distances for all the geometries.This method only works with WGS84 (wkid: 4326) and [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator) spatial references. In general,if your input geometries are assigned one of those two spatial references, you should always use geodesicBuffer() toobtain the most accurate results for those geometries. If needing to buffer points assigned a [projected coordinatesystem other than Web Mercator](https://developers.arcgis.com/rest/services-reference/projected-coordinate-systems.htm), use [buffer()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#buffer) instead. If the input geometrieshave a [geographic coordinate system](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm) other than WGS84 (wkid: 4326), use[GeometryService.buffer()](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-GeometryService.html#buffer).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#geodesicBuffer)
     *
     * @param geometry The buffer input geometry.       The `geometry` and `distance` parameters must be specified as either both arrays or       both non-arrays. Never specify one as an array and the other a non-array.
     * @param distance The specified distance(s) for buffering.       The `geometry` and `distance` parameters must be specified as either both arrays or       both non-arrays. Never specify one as an array and the other a non-array.           When using an array of geometries as input, the length of the geometry array does not have to       equal the length of the `distance` array. For example, if you pass an array of four geometries:       `[g1, g2, g3, g4]` and an array with one distance: `[d1]`, all four geometries will be buffered by the       single distance value. If instead you use an array of three distances: `[d1, d2, d3]`, `g1` will be buffered by       `d1`, `g2` by `d2`, and `g3` and `g4` will both be buffered by `d3`. The value of the geometry array will       be matched one to one with those in the distance array until the final value of the distance array is reached,       in which case that value will be applied to the remaining geometries.
     * @param unit Measurement unit of the distance(s).       Defaults to the units of the input geometries.       Use one of the possible values listed below or any of the       [numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).           **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     * @param unionResults Determines whether the output geometries should be unioned into a single       polygon.
     *
     */
    geodesicBuffer(
      geometry: Geometry | Geometry[],
      distance: number | number[],
      unit: string | number,
      unionResults?: boolean
    ): IPromise<Polygon | Polygon[]>;
    /**
     * Returns a geodesically densified version of the input geometry. Use this function to draw the line(s) of the geometry along great circles.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#geodesicDensify)
     *
     * @param geometry A polyline or polygon to densify.
     * @param maxSegmentLength The maximum segment length allowed. This must be a positive value.
     * @param maxSegmentLengthUnit Measurement unit for `maxSegmentLength`.If a unit is not specified, the units are considered to be the same as the units of the `geometry`.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).    **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     *
     */
    geodesicDensify(
      geometry: Polyline | Polygon,
      maxSegmentLength: number,
      maxSegmentLengthUnit: string | number
    ): IPromise<Geometry>;
    /**
     * Calculates the length of the input geometry. As opposed to [planarLength()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#planarLength), geodesicLength() takes into accountthe curvature of the earth when performing this calculation. Therefore, when using input geometries with aspatial reference of either WGS84 (wkid: 4326) or [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator), it is best practice tocalculate lengths using geodesicLength(). If the input geometries have a projected coordinate system other thanWeb Mercator, use [planarLength()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#planarLength) instead.This method only works with WGS84 (wkid: 4326) and [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator) spatial references.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#geodesicLength)
     *
     * @param geometry The input geometry.
     * @param unit Measurement unit of the return value.Defaults to the units of the input geometry.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).    **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     *
     */
    geodesicLength(geometry: Geometry, unit: string | number): IPromise<number>;
    /**
     * Creates a new geometry through intersection between two geometries.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#intersect)
     *
     * @param geometry The input geometry(ies).
     * @param intersector The geometry being intersected.
     *
     */
    intersect(geometry: Geometry | Geometry[], intersector: Geometry): IPromise<Geometry>;
    /**
     * Indicates if one geometry intersects another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#intersects)
     *
     * @param geometry1 The geometry that is tested for the intersects relationship to the other geometry.
     * @param geometry2 The geometry being intersected.
     *
     */
    intersects(geometry1: Geometry, geometry2: Geometry): IPromise<boolean>;
    /**
     * Indicates if the given geometry is topologically simple.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#isSimple)
     *
     * @param geometry The input geometry.
     *
     */
    isSimple(geometry: Geometry): IPromise<boolean>;
    /**
     * Finds the coordinate of the geometry that is closest to the specified point.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#nearestCoordinate)
     *
     * @param geometry The geometry to consider.
     * @param inputPoint The point used to search the nearest coordinate in the geometry.
     *
     */
    nearestCoordinate(geometry: Geometry, inputPoint: Point): IPromise<NearestPointResult>;
    /**
     * Finds vertex on the geometry nearest to the specified point.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#nearestVertex)
     *
     * @param geometry The geometry to consider.
     * @param inputPoint The point used to search the nearest vertex in the geometry.
     *
     */
    nearestVertex(geometry: Geometry, inputPoint: Point): IPromise<NearestPointResult>;
    /**
     * Finds all vertices in the given distance from the specified point, sorted from the closest to the furthest andreturns them as an array of Objects.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#nearestVertices)
     *
     * @param geometry The geometry to consider.
     * @param inputPoint The point from which to measure.
     * @param searchRadius The distance to search from the inputPoint in the units of the view's spatial reference.
     * @param maxVertexCountToReturn The maximum number of vertices to return.
     *
     */
    nearestVertices(
      geometry: Geometry,
      inputPoint: Point,
      searchRadius: number,
      maxVertexCountToReturn: number
    ): IPromise<NearestPointResult>;
    /**
     * The offset operation creates a geometry that is a constant planar distance from an inputpolyline or polygon. It is similar to buffering, but produces a one-sided result.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#offset)
     *
     * @param geometry The geometries to offset.
     * @param offsetDistance The planar distance to offset from the input geometry. If offsetDistance > 0, then the offsetgeometry is constructed to the right of the oriented input geometry, if offsetDistance = 0, then there is nochange in the geometries, otherwise it is constructed to the left. For a simple polygon, the orientation of outerrings is clockwise and for inner rings it is counter clockwise. So the "right side" of a simple polygon is always its inside.
     * @param offsetUnit Measurement unit of the offset distance.Defaults to the units of the input geometries.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).    **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     * @param joinType The join type.     **Possible values:** round | bevel | miter | square
     * @param bevelRatio Applicable when `joinType = 'miter'`; bevelRatio is multiplied by the offset distance andthe result determines how far a mitered offset intersection can be located before it is beveled.
     * @param flattenError Applicable when `joinType = 'round'`; flattenError determines the maximum distance of the resultingsegments compared to the true circular arc. The algorithm never produces more than around 180 vertices for each round join.
     *
     */
    offset(
      geometry: Geometry | Geometry[],
      offsetDistance: number,
      offsetUnit: string | number,
      joinType: string,
      bevelRatio?: number,
      flattenError?: number
    ): IPromise<Geometry[]>;
    /**
     * Indicates if one geometry overlaps another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#overlaps)
     *
     * @param geometry1 The base geometry that is tested for the "overlaps" relationship with the other geometry.
     * @param geometry2 The comparison geometry that is tested for the "overlaps" relationship with the other geometry.
     *
     */
    overlaps(geometry1: Geometry, geometry2: Geometry): IPromise<boolean>;
    /**
     * Calculates the area of the input geometry. As opposed to [geodesicArea()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#geodesicArea), planarArea() performsthis calculation using projected coordinates and does not take into account the earth's curvature. When using input geometries with aspatial reference of either WGS84 (wkid: 4326) or [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator), it is best practice tocalculate areas using [geodesicArea()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#geodesicArea). If the input geometries have a projected coordinate system other thanWeb Mercator, use planarArea() instead.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#planarArea)
     *
     * @param geometry The input polygon.
     * @param unit Measurement unit of the return value.Defaults to the units of the input geometries.Use one of the possible values listed below or any of the[numeric codes for area units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.AreaUnit.Code.ACRE).    **Possible Values:** acres | ares | hectares | square-feet | square-meters | square-yards |square-kilometers | square-miles
     *
     */
    planarArea(geometry: Polygon, unit: string | number): IPromise<number>;
    /**
     * Calculates the length of the input geometry. As opposed to [geodesicLength()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#geodesicLength), planarLength() usesprojected coordinates and does not take into accountthe curvature of the earth when performing this calculation. When using input geometries with aspatial reference of either WGS84 (wkid: 4326) or [Web Mercator](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator), it is best practice tocalculate lengths using [geodesicLength()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#geodesicLength). If the input geometries have a projected coordinate system other thanWeb Mercator, use planarLength() instead.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#planarLength)
     *
     * @param geometry The input geometry.
     * @param unit Measurement unit of the return value.Defaults to the units of the input geometries.Use one of the possible values listed below or any of the[numeric codes for linear units](https://developers.arcgis.com/java/api-reference/constant-values.html#com.esri.core.geometry.LinearUnit.Code.CENTIMETER).    **Possible Values:** meters | feet | kilometers | miles | nautical-miles | yards
     *
     */
    planarLength(geometry: Geometry, unit: string | number): IPromise<number>;
    /**
     * Indicates if the given DE-9IM relation holds for the two geometries.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#relate)
     *
     * @param geometry1 The first geometry for the relation.
     * @param geometry2 The second geometry for the relation.
     * @param relation The Dimensionally Extended 9 Intersection Model (DE-9IM) matrix relation(encoded as a string) to test against the relationship of the two geometries. This string contains thetest result of each intersection represented in the DE-9IM matrix. Each result is one character of thestring and may be represented as either a number (maximum dimension returned: `0`,`1`,`2`), a Booleanvalue (`T` or `F`), or a mask character (for ignoring results: '\*').    Example: Each of the followingDE-9IM string codes are valid for testing whether a polygon geometry completely contains a line geometry:`TTTFFTFFT` (Boolean), 'T\*\*\*\*\*FF\*' (ignore irrelevant intersections), or '102FF\*FF\*' (dimension form).Each returns the same result.    See [this article](https://en.wikipedia.org/wiki/DE-9IM) and[this ArcGIS help page](https://desktop.arcgis.com/en/arcmap/latest/manage-data/using-sql-with-gdbs/relational-functions-for-st-geometry.htm)for more information about the DE-9IM model and how string codes are constructed.
     *
     */
    relate(geometry1: Geometry, geometry2: Geometry, relation: string): IPromise<boolean>;
    /**
     * Rotates a geometry counterclockwise by the specified number of degrees.Rotation is around the centroid, or a given rotation point.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#rotate)
     *
     * @param geometry The geometry to rotate.
     * @param angle The rotation angle in degrees.
     * @param rotationOrigin Point to rotate the geometry around. Defaults to the centroid of the geometry.
     *
     */
    rotate(geometry: Geometry, angle: number, rotationOrigin?: Point): IPromise<Geometry>;
    /**
     * Performs the simplify operation on the geometry which alters the given geometries to make their definitionstopologically legal with respect to their geometry type.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#simplify)
     *
     * @param geometry The geometry to be simplified.
     *
     */
    simplify(geometry: Geometry): IPromise<Geometry>;
    /**
     * Creates the symmetric difference of two geometries. The symmetric difference includes the partsthat are in either of the sets, but not in both.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#symmetricDifference)
     *
     * @param leftGeometry One of the Geometry instances in the XOR operation.
     * @param rightGeometry One of the Geometry instances in the XOR operation.
     *
     */
    symmetricDifference(leftGeometry: Geometry | Geometry[], rightGeometry: Geometry): IPromise<Geometry | Geometry[]>;
    /**
     * Indicates if one geometry touches another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#touches)
     *
     * @param geometry1 The geometry to test the "touches" relationship with the other geometry.
     * @param geometry2 The geometry to be touched.
     *
     */
    touches(geometry1: Geometry, geometry2: Geometry): IPromise<boolean>;
    /**
     * All inputs must be of the same type of geometries and share one spatial reference.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#union)
     *
     * @param geometries An array of Geometries to union.
     *
     */
    union(geometries: Geometry[]): IPromise<Geometry>;
    /**
     * Indicates if one geometry is within another geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-geometryEngineAsync.html#within)
     *
     * @param innerGeometry The base geometry that is tested for the "within" relationship to the other geometry.
     * @param outerGeometry The comparison geometry that is tested for the "contains" relationship to the other geometry.
     *
     */
    within(innerGeometry: Geometry, outerGeometry: Geometry): IPromise<boolean>;
  }

  export const geometryEngineAsync: geometryEngineAsync;

  interface HeightModelInfo extends Accessor, JSONSupport {
    /**
     * The surface type or height model of the vertical coordinate system (VCS). A[SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html) will only render layers containing data thatis compatible with the HeightModelInfo of the scene.Value | Description------|------------gravity-related-height | A gravity-related VCS may set its zero point through a local mean sea level or a benchmark, and is compatible with other gravity-related VCS for the purposes of rendering.ellipsoidal | An ellipsoidal VCS defines heights that are referenced to an ellipsoid of a geographic coordinate system.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-HeightModelInfo.html#heightModel)
     *
     * @default "gravity-related-height"
     */
    readonly heightModel: string;
    /**
     * The unit of the vertical coordinate system. A [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html)will use this property to check that the vertical data of layers thatdefine a HeightModelInfo is compatible with the view.**Possible Values:** meters | feet | us-feet | clarke-feet | clarke-yards | clarke-links | sears-yards |sears-feet | sears-chains | benoit-1895-b-chains | indian-yards | indian-1937-yards | gold-coast-feet |sears-1922-truncated-chains | 50-kilometers | 150-kilometers
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-HeightModelInfo.html#heightUnit)
     *
     * @default "meters"
     */
    readonly heightUnit: string;
    /**
     * The datum realization of the vertical coordinate system. A[SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html) will only render layers that define aHeightModelInfo with an identical `vertCRS` to that of the scene,when using an `ellipsoidal` height model.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-HeightModelInfo.html#vertCRS)
     */
    readonly vertCRS: string;
  }

  interface HeightModelInfoConstructor {
    new (properties?: HeightModelInfoProperties): HeightModelInfo;

    fromJSON(json: any): HeightModelInfo;
  }

  export const HeightModelInfo: HeightModelInfoConstructor;

  interface HeightModelInfoProperties {
    /**
     * The surface type or height model of the vertical coordinate system (VCS). A[SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html) will only render layers containing data thatis compatible with the HeightModelInfo of the scene.Value | Description------|------------gravity-related-height | A gravity-related VCS may set its zero point through a local mean sea level or a benchmark, and is compatible with other gravity-related VCS for the purposes of rendering.ellipsoidal | An ellipsoidal VCS defines heights that are referenced to an ellipsoid of a geographic coordinate system.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-HeightModelInfo.html#heightModel)
     *
     * @default "gravity-related-height"
     */
    heightModel?: string;
    /**
     * The unit of the vertical coordinate system. A [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html)will use this property to check that the vertical data of layers thatdefine a HeightModelInfo is compatible with the view.**Possible Values:** meters | feet | us-feet | clarke-feet | clarke-yards | clarke-links | sears-yards |sears-feet | sears-chains | benoit-1895-b-chains | indian-yards | indian-1937-yards | gold-coast-feet |sears-1922-truncated-chains | 50-kilometers | 150-kilometers
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-HeightModelInfo.html#heightUnit)
     *
     * @default "meters"
     */
    heightUnit?: string;
    /**
     * The datum realization of the vertical coordinate system. A[SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html) will only render layers that define aHeightModelInfo with an identical `vertCRS` to that of the scene,when using an `ellipsoidal` height model.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-HeightModelInfo.html#vertCRS)
     */
    vertCRS?: string;
  }

  interface Mesh extends Geometry {
    /**
     * An array of mesh components that can be used to apply materialsto different regions of the same mesh. There are three commonusage patterns for components.1. **Specify a material for the whole mesh.** In this case, use a single   component with only a material (leaving faces as `null`).2. **Reuse vertex attributes.** When modeling continuous surfaces,   it can be convenient to only specify vertices once and then   simply refer to them. In this case, use a single component   with faces set to index the vertex attributes that form   triangles.3. **Specify multiple materials for the same mesh.** In this case,   use multiple components with faces that determine to which region   of the mesh the material of the component applies.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#components)
     */
    components: MeshComponent[];
    /**
     * For Mesh, the type is always `mesh`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#type)
     */
    readonly type: "mesh";
    /**
     * Object describing the attributes of each vertex of the mesh. Vertex attributesare flat numerical arrays that describe the position (mandatory), normal (used forlighting calculations and shading) and uv (used for mapping material images to themesh surface) for each vertex.Vertex attributes can be addressed by indices specified in the components[faces](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshComponent.html#faces) property. If themesh does not contain any components, or if a component does not specify any faces,then the vertex attributes are interpreted as if each consecutive vertex triplemakes up a triangle.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes)
     */
    vertexAttributes: MeshVertexAttributes;

    /**
     * Adds a component to the mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#addComponent)
     *
     * @param component The component to add.
     *
     */
    addComponent(component: MeshComponent | MeshComponentProperties): void;
    /**
     * Centers the mesh at the specified location without changing its scale.The mesh will be modified in place. To modify a copy of the mesh instead, use [clone()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#clone)before calling [centerAt()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#centerAt).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#centerAt)
     *
     * @param location The location at which to center the mesh.
     * @param params Additional parameters.
     * @param params.geographic Indicates whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the offset applied to center the mesh is applied in a Cartesian system with respect to the local  coordinate system on the globe and is specified in meters.
     * @param params.origin The origin at which to center. If not specified,  the mesh will be centered at the mesh extent center.
     *
     */
    centerAt(location: Point, params?: MeshCenterAtParams): Mesh;
    /**
     * Creates a deep clone of the Mesh object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#clone)
     *
     *
     */
    clone(): Mesh;
    /**
     * Offsets the mesh geometry by the specified distance in x, y, and z. The units of x, y, and z are theunits of the spatial reference. When the offset is applied geographically (default for either WGS84or WebMercator), then the offsets are interpreted in meters.The mesh will be modified in place. To modify a copy of the mesh instead, use [clone()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#clone)before calling [offset()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#offset).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#offset)
     *
     * @param dx The amount to offset the geometry in the x direction.
     * @param dy The amount to offset the geometry in the y direction.
     * @param dz The amount to offset the geometry in the z direction.
     * @param params Additional parameters.
     * @param params.geographic Whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the offset is applied in a Cartesian system with respect to the local  coordinate system on the globe and is specified in meters.
     *
     */
    offset(dx: number, dy: number, dz: number, params?: MeshOffsetParams): Mesh;
    /**
     * Removes a component from the mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#removeComponent)
     *
     * @param component The component to remove.
     *
     */
    removeComponent(component: MeshComponent): void;
    /**
     * Rotates the mesh geometry around its x, y and z axis (in that order). For each rotation angle,the rotation direction is clockwise when looking in the direction of the respective axis.The mesh will be modified in place. To modify a copy of the mesh instead, use [clone()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#clone)before calling [rotate()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#rotate).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#rotate)
     *
     * @param angleX The angle by which to rotate around the x-axis (in degrees).
     * @param angleY The angle by which to rotate around the y-axis (in degrees).
     * @param angleZ The angle by which to rotate around the z-axis (in degrees).
     * @param params Additional parameters.
     * @param params.geographic Whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the rotation is applied in a Cartesian system with respect to the local  coordinate system on the globe and is specified in meters.
     * @param params.origin The origin around which to rotate. If not specified, the mesh will  be rotated around the mesh extent center.
     *
     */
    rotate(angleX: number, angleY: number, angleZ: number, params?: MeshRotateParams): Mesh;
    /**
     * Scales the mesh geometry by the specified factor. The mesh will be modified in place.To modify a copy of the mesh instead, use [clone()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#clone) before calling [scale()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#scale).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#scale)
     *
     * @param factor The amount to scale the geometry.
     * @param params Additional parameters.
     * @param params.geographic Whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the offset is applied in a Cartesian system with respect to the local  coordinate system on the globe and is specified in meters.
     * @param params.origin The origin point for scaling. If not specified, the mesh will  be scaled around the mesh extent center.
     *
     */
    scale(factor: number, params?: MeshScaleParams): Mesh;
    /**
     * Notifies that any cached values that depend on vertex attributes need to be recalculated. Use thismethod after modifying the vertex attributes in place so that values that depend on them (such asthe calculation of the extent) are recalculated accordingly.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributesChanged)
     *
     *
     */
    vertexAttributesChanged(): void;
  }

  interface MeshConstructor {
    new (properties?: MeshProperties): Mesh;

    /**
     * Creates a mesh representing a box. The spatial reference of the resulting mesh is the sameas the location where it is placed.#### Box UV coordinate spaceThe box geometry will have UV coordinates generated according to the following scheme:<img src="../../assets/img/apiref/geometry/mesh-box-uv.png" width="300" height="300"/>
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createBox)
     *
     * @param location The location bottom center of the box.
     * @param params Additional parameters.
     * @param params.size A uniform size value or an object containing individual  values width, height and depth. The unit of the size values is derived from the spatial reference  of the provided location, unless a unit is specified.
     * @param params.geographic Whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the mesh is created in a Cartesian system with respect to the local  coordinate system on the globe and sizes are specified in meters.
     * @param params.unit The unit of the size (defaults to the unit of the location's spatial reference).**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     * @param params.material The material to be used for the mesh.
     * @param params.imageFace The face for generating image uv coordinates. By default, a single set of unwrapped  UV coordinates are generated for all the faces. By setting the `imageFace` parameter to one of `east`, `west`,  `north`, `south`, `up` or `down`, the specified face will have full sized UV coordinates while the other faces  will pertain their regular unwrapped UV coordinates. This is useful for applying an image only to a single face of the box.  The provided `material` parameter will be applied to the specified `imageFace`. The resulting mesh will have two components,  the first contains the selected image face and the second contains the other faces of the box.
     *
     */
    createBox(location: Point, params?: MeshCreateBoxParams): Mesh;
    /**
     * Creates a mesh representing a cylinder. The spatial reference of the resulting mesh is the sameas the location where it is placed.#### Cylinder UV coordinate spaceThe cylinder geometry will have UV coordinates generated according to the following scheme(example is shown for 8 vertices cylinder):<img src="../../assets/img/apiref/geometry/mesh-cylinder-uv.png" width="300" height="300"/>
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createCylinder)
     *
     * @param location The location of the bottom center of the cylinder.
     * @param params Additional parameters.
     * @param params.size A uniform size value or an object containing individual  values width, height and depth. The unit of the size values is derived from the spatial reference  of the provided location, unless a specific unit is specified.
     * @param params.geographic Whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the mesh is created in a Cartesian system with respect to the local  coordinate system on the globe and sizes are specified in meters.
     * @param params.unit The unit of the size (defaults to the unit of the location's spatial reference).**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     * @param params.densificationFactor The additional number of subdivisions for generating  the mesh representing a cylinder. A densificationFactor parameter of 0 will generate a default of  16 vertices to approximate the cylinder. A densificationFactor of 1 will generate 32 vertices, etc. The larger the  densificationFactor, the better the mesh will approximate a perfect cylinder (at the cost of processing  and rendering performance).
     * @param params.material The material to be used for the mesh.
     *
     */
    createCylinder(location: Point, params?: MeshCreateCylinderParams): Mesh;
    /**
     * Creates a new mesh geometry from a glTF model referenced by the `url` parameter. The spatial reference of the resulting mesh is the sameas the `location` parameter. For more information on the supported glTF features you can read the [Visualizing points with 3D symbols](https://developers.arcgis.com/javascript/latest/guide/visualizing-points-3d/index.html)guide topic. Animations are currently not supported.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createFromGLTF)
     *
     * @param location The location of the origin of the model. If the location doesn't contain a z value,z is assumed to be `0`.
     * @param url The URL of the glTF model. The URL should point to a glTF file (.gltf or .glb)which can reference additional binary (.bin) and image files (.jpg, .png).
     * @param params Additional parameters.
     * @param params.geographic Whether the model coordinates should be relative to the geographic or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the mesh is created in a Cartesian system with respect to the local  coordinate system on the globe and sizes are specified in meters.
     * @param params.signal An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the loading process.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     */
    createFromGLTF(location: Point, url: string, params?: MeshCreateFromGLTFParams): IPromise<Mesh>;
    /**
     * Creates a new mesh geometry from a polygon geometry. The resulting mesh contains onlya position vertex attribute and a single component with faces. The default shading will beset to `flat`. The spatial reference of the resulting mesh is the sameas the input polygon. The resulting mesh will not contain any uv nor normal vertex attributes.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createFromPolygon)
     *
     * @param polygon The input polygon.
     * @param params Optional parameters.
     * @param params.material The material to be used for the mesh.
     *
     */
    createFromPolygon(polygon: Polygon, params?: MeshCreateFromPolygonParams): Mesh;
    /**
     * Creates a mesh representing a plane. The spatial reference of the resulting mesh is the sameas the location where it is placed. A plane consists of two triangles and may be convenientlyoriented at creation time.#### Plane UV coordinate spaceThe plane geometry will have UV coordinates generated according to the following scheme:<img src="../../assets/img/apiref/geometry/mesh-plane-uv.png" width="300" height="300"/>
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createPlane)
     *
     * @param location The location of the bottom center of the plane.
     * @param params Additional parameters.
     * @param params.size A uniform size value or an object containing individual  values width and height. The unit of the size values is derived from the spatial reference  of the provided location, unless a unit is specified.
     * @param params.facing Direction the plane is facing. Possible values are `east`, `west`, `north`, `south`, `up` and `down`. Defaults to `up`,
     * @param params.geographic Whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the mesh is created in a Cartesian system with respect to the local  coordinate system on the globe and sizes are specified in meters.
     * @param params.unit The unit of the size (defaults to the unit of the location's spatial reference).**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     * @param params.material The material to be used for the mesh.
     *
     */
    createPlane(location: Point, params?: MeshCreatePlaneParams): Mesh;
    /**
     * Creates a mesh representing a sphere. The spatial reference of the resulting mesh is the sameas the location where it is placed.#### Sphere UV coordinate spaceThe sphere geometry will have UV coordinates generated according to the following scheme(example is shown for 8x8 vertices sphere):<img src="../../assets/img/apiref/geometry/mesh-sphere-uv.png" width="300" height="300"/>
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createSphere)
     *
     * @param location The location of the bottom center of the sphere.
     * @param params Additional parameters.
     * @param params.size A uniform size value or an object containing individual  values width, height and depth. The unit of the size values is derived from the spatial reference  of the provided location, unless a unit is specified.
     * @param params.geographic Indicates whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the mesh is created in a Cartesian system with respect to the local  coordinate system on the globe and sizes are specified in meters.
     * @param params.unit The unit of the size (defaults to the unit of the location's spatial reference).**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     * @param params.densificationFactor The additional number of subdivisions for generating  the mesh representing a sphere. A densificationFactor parameter of 0 will generate a default of  16-by-16 vertices to approximate the sphere. A densificationFactor of 1 will generate 32-by-32 vertices, etc.  The larger the densificationFactor, the better the mesh will approximate a perfect sphere (at the cost of  processing and rendering performance).
     * @param params.material The material to be used for the mesh.
     *
     */
    createSphere(location: Point, params?: MeshCreateSphereParams): Mesh;

    fromJSON(json: any): Mesh;
  }

  export const Mesh: MeshConstructor;

  interface MeshProperties extends GeometryProperties {
    /**
     * An array of mesh components that can be used to apply materialsto different regions of the same mesh. There are three commonusage patterns for components.1. **Specify a material for the whole mesh.** In this case, use a single   component with only a material (leaving faces as `null`).2. **Reuse vertex attributes.** When modeling continuous surfaces,   it can be convenient to only specify vertices once and then   simply refer to them. In this case, use a single component   with faces set to index the vertex attributes that form   triangles.3. **Specify multiple materials for the same mesh.** In this case,   use multiple components with faces that determine to which region   of the mesh the material of the component applies.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#components)
     */
    components?: MeshComponentProperties[];
    /**
     * Object describing the attributes of each vertex of the mesh. Vertex attributesare flat numerical arrays that describe the position (mandatory), normal (used forlighting calculations and shading) and uv (used for mapping material images to themesh surface) for each vertex.Vertex attributes can be addressed by indices specified in the components[faces](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshComponent.html#faces) property. If themesh does not contain any components, or if a component does not specify any faces,then the vertex attributes are interpreted as if each consecutive vertex triplemakes up a triangle.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes)
     */
    vertexAttributes?: MeshVertexAttributesProperties;
  }

  export interface MeshCenterAtParams extends Object {
    /**
     * Indicates whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the offset applied to center the mesh is applied in a Cartesian system with respect to the local  coordinate system on the globe and is specified in meters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#centerAt)
     */
    geographic?: boolean;
    /**
     * The origin at which to center. If not specified,  the mesh will be centered at the mesh extent center.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#centerAt)
     */
    origin?: Point;
  }

  export interface MeshCreateBoxParams extends Object {
    /**
     * A uniform size value or an object containing individual  values width, height and depth. The unit of the size values is derived from the spatial reference  of the provided location, unless a unit is specified.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createBox)
     */
    size?: number | MeshCreateBoxParamsSize;
    /**
     * Whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the mesh is created in a Cartesian system with respect to the local  coordinate system on the globe and sizes are specified in meters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createBox)
     */
    geographic?: boolean;
    /**
     * The unit of the size (defaults to the unit of the location's spatial reference).**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createBox)
     */
    unit?: string;
    /**
     * The material to be used for the mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createBox)
     */
    material?: MeshMaterial;
    /**
     * The face for generating image uv coordinates. By default, a single set of unwrapped  UV coordinates are generated for all the faces. By setting the `imageFace` parameter to one of `east`, `west`,  `north`, `south`, `up` or `down`, the specified face will have full sized UV coordinates while the other faces  will pertain their regular unwrapped UV coordinates. This is useful for applying an image only to a single face of the box.  The provided `material` parameter will be applied to the specified `imageFace`. The resulting mesh will have two components,  the first contains the selected image face and the second contains the other faces of the box.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createBox)
     */
    imageFace?: string;
  }

  export interface MeshCreateBoxParamsSize extends Object {
    /**
     * The width of the created mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createBox)
     */
    width?: number;
    /**
     * The depth of the created mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createBox)
     */
    depth?: number;
    /**
     * The height of the created mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createBox)
     */
    height?: number;
  }

  export interface MeshCreateCylinderParams extends Object {
    /**
     * A uniform size value or an object containing individual  values width, height and depth. The unit of the size values is derived from the spatial reference  of the provided location, unless a specific unit is specified.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createCylinder)
     */
    size?: number | MeshCreateCylinderParamsSize;
    /**
     * Whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the mesh is created in a Cartesian system with respect to the local  coordinate system on the globe and sizes are specified in meters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createCylinder)
     */
    geographic?: boolean;
    /**
     * The unit of the size (defaults to the unit of the location's spatial reference).**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createCylinder)
     */
    unit?: string;
    /**
     * The additional number of subdivisions for generating  the mesh representing a cylinder. A densificationFactor parameter of 0 will generate a default of  16 vertices to approximate the cylinder. A densificationFactor of 1 will generate 32 vertices, etc. The larger the  densificationFactor, the better the mesh will approximate a perfect cylinder (at the cost of processing  and rendering performance).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createCylinder)
     */
    densificationFactor?: number;
    /**
     * The material to be used for the mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createCylinder)
     */
    material?: MeshMaterial;
  }

  export interface MeshCreateCylinderParamsSize extends Object {
    /**
     * The width of the created mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createCylinder)
     */
    width?: number;
    /**
     * The depth of the created mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createCylinder)
     */
    depth?: number;
    /**
     * The height of the created mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createCylinder)
     */
    height?: number;
  }

  export interface MeshCreateFromGLTFParams extends Object {
    /**
     * Whether the model coordinates should be relative to the geographic or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the mesh is created in a Cartesian system with respect to the local  coordinate system on the globe and sizes are specified in meters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createFromGLTF)
     */
    geographic?: boolean;
    /**
     * An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the loading process.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createFromGLTF)
     */
    signal?: AbortSignal;
  }

  export interface MeshCreateFromPolygonParams extends Object {
    /**
     * The material to be used for the mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createFromPolygon)
     */
    material?: MeshMaterial;
  }

  export interface MeshCreatePlaneParams extends Object {
    /**
     * A uniform size value or an object containing individual  values width and height. The unit of the size values is derived from the spatial reference  of the provided location, unless a unit is specified.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createPlane)
     */
    size?: number | MeshCreatePlaneParamsSize;
    /**
     * Direction the plane is facing. Possible values are `east`, `west`, `north`, `south`, `up` and `down`. Defaults to `up`,
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createPlane)
     */
    facing?: string;
    /**
     * Whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the mesh is created in a Cartesian system with respect to the local  coordinate system on the globe and sizes are specified in meters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createPlane)
     */
    geographic?: boolean;
    /**
     * The unit of the size (defaults to the unit of the location's spatial reference).**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createPlane)
     */
    unit?: string;
    /**
     * The material to be used for the mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createPlane)
     */
    material?: MeshMaterial;
  }

  export interface MeshCreatePlaneParamsSize extends Object {
    /**
     * The width of the created mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createPlane)
     */
    width?: number;
    /**
     * The height of the created mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createPlane)
     */
    height?: number;
  }

  export interface MeshCreateSphereParams extends Object {
    /**
     * A uniform size value or an object containing individual  values width, height and depth. The unit of the size values is derived from the spatial reference  of the provided location, unless a unit is specified.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createSphere)
     */
    size?: number | MeshCreateSphereParamsSize;
    /**
     * Indicates whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the mesh is created in a Cartesian system with respect to the local  coordinate system on the globe and sizes are specified in meters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createSphere)
     */
    geographic?: boolean;
    /**
     * The unit of the size (defaults to the unit of the location's spatial reference).**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createSphere)
     */
    unit?: string;
    /**
     * The additional number of subdivisions for generating  the mesh representing a sphere. A densificationFactor parameter of 0 will generate a default of  16-by-16 vertices to approximate the sphere. A densificationFactor of 1 will generate 32-by-32 vertices, etc.  The larger the densificationFactor, the better the mesh will approximate a perfect sphere (at the cost of  processing and rendering performance).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createSphere)
     */
    densificationFactor?: number;
    /**
     * The material to be used for the mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createSphere)
     */
    material?: MeshMaterial;
  }

  export interface MeshCreateSphereParamsSize extends Object {
    /**
     * The width of the created mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createSphere)
     */
    width?: number;
    /**
     * The depth of the created mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createSphere)
     */
    depth?: number;
    /**
     * The height of the created mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#createSphere)
     */
    height?: number;
  }

  export interface MeshOffsetParams extends Object {
    /**
     * Whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the offset is applied in a Cartesian system with respect to the local  coordinate system on the globe and is specified in meters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#offset)
     */
    geographic?: boolean;
  }

  export interface MeshRotateParams extends Object {
    /**
     * Whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the rotation is applied in a Cartesian system with respect to the local  coordinate system on the globe and is specified in meters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#rotate)
     */
    geographic?: boolean;
    /**
     * The origin around which to rotate. If not specified, the mesh will  be rotated around the mesh extent center.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#rotate)
     */
    origin?: Point;
  }

  export interface MeshScaleParams extends Object {
    /**
     * Whether to georeference relative to the globe or the  projected coordinate system (PCS). This parameter is only relevant for spatial references that can  be used in both local and global viewing modes (currently only WebMercator). This parameter  defaults to `true` for WebMercator and WGS84, and `false` for any other PCS. When true,  the offset is applied in a Cartesian system with respect to the local  coordinate system on the globe and is specified in meters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#scale)
     */
    geographic?: boolean;
    /**
     * The origin point for scaling. If not specified, the mesh will  be scaled around the mesh extent center.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#scale)
     */
    origin?: Point;
  }

  export interface MeshVertexAttributesProperties extends Object {
    /**
     * A flat array of vertex positions. Vertex positions have x, y and z coordinates and they should be in the spatial reference system of the geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes)
     */
    position?: Float64Array | number[] | Float32Array;
    /**
     * A flat array of vertex uv coordinates (2 elements per vertex).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes)
     */
    uv?: Float32Array | number[] | Float64Array;
    /**
     * A flat array of the vertex normals (3 elements per vertex ranging from -1 to 1).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes)
     */
    normal?: Float32Array | number[] | Float64Array;
    /**
     * **Since: 4.9**    A flat array of the vertex colors (4 elements per vertex ranging from 0 to 255).  Vertex colors are multiplied by the component material color (if any is defined).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes)
     */
    color?: Uint8Array | number[] | Uint8ClampedArray;
  }

  export interface MeshVertexAttributes extends AnonymousAccessor {
    /**
     * A flat array of vertex positions. Vertex positions have x, y and z coordinates and they should be in the spatial reference system of the geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes)
     */
    position: Float64Array;
    /**
     * A flat array of vertex uv coordinates (2 elements per vertex).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes)
     */
    uv?: Float32Array;
    /**
     * A flat array of the vertex normals (3 elements per vertex ranging from -1 to 1).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes)
     */
    normal?: Float32Array;
    /**
     * **Since: 4.9**    A flat array of the vertex colors (4 elements per vertex ranging from 0 to 255).  Vertex colors are multiplied by the component material color (if any is defined).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes)
     */
    color?: Uint8Array;
  }

  interface Multipoint extends Geometry {
    /**
     * An array of points.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Multipoint.html#points)
     */
    points: number[][];
    /**
     * For Multipoint, the type is always `multipoint`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Multipoint.html#type)
     */
    readonly type: "multipoint";

    /**
     * Adds a point to the Multipoint.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Multipoint.html#addPoint)
     *
     * @param point The point to add to the multipoint. The point can either be a [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) or                                           an array of numbers representing XY coordinates.
     *
     */
    addPoint(point: Point | number[]): Multipoint;
    /**
     * Creates a deep clone of Multipoint object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Multipoint.html#clone)
     *
     *
     */
    clone(): Multipoint;
    /**
     * Returns the point at the specified index.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Multipoint.html#getPoint)
     *
     * @param index The index of the point in the [points](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Multipoint.html#points) property.
     *
     */
    getPoint(index: number): Point;
    /**
     * Removes a point from the Multipoint. The index specifies which point to remove.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Multipoint.html#removePoint)
     *
     * @param index The index of the point to remove.
     *
     */
    removePoint(index: number): Point;
    /**
     * Updates the point at the specified index.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Multipoint.html#setPoint)
     *
     * @param index The index of the point in the [points](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Multipoint.html#points) property.
     * @param point Point geometry that specifies the new location.
     *
     */
    setPoint(index: number, point: Point): Multipoint;
  }

  interface MultipointConstructor {
    new (properties?: MultipointProperties): Multipoint;

    fromJSON(json: any): Multipoint;
  }

  export const Multipoint: MultipointConstructor;

  interface MultipointProperties extends GeometryProperties {
    /**
     * An array of points.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Multipoint.html#points)
     */
    points?: number[][];
  }

  interface Point extends Geometry {
    /**
     * The latitude of the point. If the spatial reference is Web Mercator, the latitude will be given in WGS84. In anygeographic spatial reference, the latitude will equal the [y](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#y) coordinate. In all other cases the latitudewill be null.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#latitude)
     */
    latitude: number;
    /**
     * The longitude of the point. If the spatial reference is Web Mercator, the longitude will be given in WGS84. In anygeographic spatial reference, the longitude will equal the [x](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#x) coordinate. In all other cases the longitudewill be null.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#longitude)
     */
    longitude: number;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#m)
     *
     * @default undefined
     */
    m: number;
    /**
     * For Point, the type is always `point`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#type)
     */
    readonly type: "point";
    /**
     * The x-coordinate (easting) of the point in map units.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#x)
     *
     * @default 0
     */
    x: number;
    /**
     * The y-coordinate (northing) of the point in map units.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#y)
     *
     * @default 0
     */
    y: number;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#z)
     *
     * @default undefined
     */
    z: number;

    /**
     * Creates a deep clone of Point object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#clone)
     *
     *
     */
    clone(): Point;
    /**
     * Copies all values from another Point instance.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#copy)
     *
     * @param other The point to copy from.
     *
     */
    copy(other: Point): void;
    /**
     * Computes the Euclidean distance between this Point and a given Point. Points must have the same spatial reference.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#distance)
     *
     * @param other The point to compute the distance to.
     *
     */
    distance(other: Point): number;
    /**
     * Determines if the input point is equal to the point calling the function.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#equals)
     *
     * @param point The input point to test.
     *
     */
    equals(point: Point): boolean;
    /**
     * Modifies the point geometry in-place by shifting the X-coordinate to within+/- 180 span in map units. You should [clone](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#clone)the point object before calling this method where appropriate.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#normalize)
     *
     *
     */
    normalize(): Point;
  }

  interface PointConstructor {
    new (properties?: PointProperties): Point;

    fromJSON(json: any): Point;
  }

  export const Point: PointConstructor;

  interface PointProperties extends GeometryProperties {
    /**
     * The latitude of the point. If the spatial reference is Web Mercator, the latitude will be given in WGS84. In anygeographic spatial reference, the latitude will equal the [y](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#y) coordinate. In all other cases the latitudewill be null.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#latitude)
     */
    latitude?: number;
    /**
     * The longitude of the point. If the spatial reference is Web Mercator, the longitude will be given in WGS84. In anygeographic spatial reference, the longitude will equal the [x](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#x) coordinate. In all other cases the longitudewill be null.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#longitude)
     */
    longitude?: number;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#m)
     *
     * @default undefined
     */
    m?: number;
    /**
     * The x-coordinate (easting) of the point in map units.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#x)
     *
     * @default 0
     */
    x?: number;
    /**
     * The y-coordinate (northing) of the point in map units.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#y)
     *
     * @default 0
     */
    y?: number;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html#z)
     *
     * @default undefined
     */
    z?: number;
  }

  interface Polygon extends Geometry {
    /**
     * The centroid of the polygon. For a polygon with multiple rings,it represents the centroid of the largest ring.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#centroid)
     */
    centroid: Point;
    /**
     * Checks to see if polygon rings cross each other and indicates if the polygon isself-intersecting, which means the ring of the polygon crosses itself.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#isSelfIntersecting)
     */
    isSelfIntersecting: boolean;
    /**
     * An array of rings. Each ring is a two-dimensional array of numbers representing the coordinates ofeach vertex in the ring in the spatial reference of the view. The first vertex of each ring should always bethe same as the last vertex. Each vertex is an array of two, three, or four numbers.The table below shows the various structures of a vertex array.Case | Vertex array--- | ---[without z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasZ) and [without m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasM)| [x, y][without z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasZ) and [with m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasM) | [x, y, m][with z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasZ) and [without m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasM) | [x, y, z][with z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasZ) and [with m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasM) | [x, y, z, m]
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#rings)
     */
    rings: number[][][];
    /**
     * For Polygon, the type is always `polygon`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#type)
     */
    readonly type: "polygon";

    /**
     * Adds a ring to the Polygon. The ring can be one of the following: an array of numbers or an array of points.When added the index of the ring is incremented by one.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#addRing)
     *
     * @param points A polygon ring. The first and last coordinates/points                                                          in the ring must be the same. This can either be defined as an array of                                                          Point geometries or an array of XY coordinates.
     *
     */
    addRing(points: Point[] | number[][]): Polygon;
    /**
     * Creates a deep clone of Polygon object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#clone)
     *
     *
     */
    clone(): Polygon;
    /**
     * Checks on the client if the input point is inside the polygon. A point on the polygon line is considered inside.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#contains)
     *
     * @param point The point to test whether it is contained within the testing polygon.
     *
     */
    contains(point: Point): boolean;
    /**
     * Returns a point specified by a ring and point in the path.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#getPoint)
     *
     * @param ringIndex The index of the ring containing the desired point.
     * @param pointIndex The index of the desired point within the ring.
     *
     */
    getPoint(ringIndex: number, pointIndex: number): Point;
    /**
     * Inserts a new point into the polygon.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#insertPoint)
     *
     * @param ringIndex The index of the ring in which to insert the point.
     * @param pointIndex The index of the point to insert within the ring.
     * @param point The point to insert.
     *
     */
    insertPoint(ringIndex: number, pointIndex: number, point: Point | number[]): Polygon;
    /**
     * Checks if a Polygon ring is clockwise.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#isClockwise)
     *
     * @param ring A polygon ring. The first and last coordinates/points                                                          in the ring must be the same. This can either be defined as an array of                                                          Point geometries or an array of XY coordinates.
     *
     */
    isClockwise(ring: Point[] | number[][]): boolean;
    /**
     * Removes a point from the polygon at the given `pointIndex` within the ring identified by `ringIndex`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#removePoint)
     *
     * @param ringIndex The index of the ring containing the point to remove.
     * @param pointIndex The index of the point to remove within the ring.
     *
     */
    removePoint(ringIndex: number, pointIndex: number): Point[];
    /**
     * Removes a ring from the Polygon. The index specifies which ring to remove.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#removeRing)
     *
     * @param index The index of the ring to remove.
     *
     */
    removeRing(index: number): Point[];
    /**
     * Updates a point in the polygon.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#setPoint)
     *
     * @param ringIndex The index of the ring containing the point to update.
     * @param pointIndex The index of the point to update within the ring.
     * @param point The new point geometry.
     *
     */
    setPoint(ringIndex: number, pointIndex: number, point: Point | number[]): Polygon;
  }

  interface PolygonConstructor {
    new (properties?: PolygonProperties): Polygon;

    /**
     * Converts the given Extent to a Polygon instance. This is useful for scenarios in whichyou would like to display an area of interest, which is typically defined by an Extent or bounding box,as a polygon with a fill symbol in the view. Some geoprocessing tools require inputgeometries to be of a Polygon type and not an Extent.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#fromExtent)
     *
     * @param extent An extent object to convert to a polygon.
     *
     */
    fromExtent(extent: Extent): Polygon;

    fromJSON(json: any): Polygon;
  }

  export const Polygon: PolygonConstructor;

  interface PolygonProperties extends GeometryProperties {
    /**
     * The centroid of the polygon. For a polygon with multiple rings,it represents the centroid of the largest ring.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#centroid)
     */
    centroid?: PointProperties;
    /**
     * Checks to see if polygon rings cross each other and indicates if the polygon isself-intersecting, which means the ring of the polygon crosses itself.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#isSelfIntersecting)
     */
    isSelfIntersecting?: boolean;
    /**
     * An array of rings. Each ring is a two-dimensional array of numbers representing the coordinates ofeach vertex in the ring in the spatial reference of the view. The first vertex of each ring should always bethe same as the last vertex. Each vertex is an array of two, three, or four numbers.The table below shows the various structures of a vertex array.Case | Vertex array--- | ---[without z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasZ) and [without m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasM)| [x, y][without z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasZ) and [with m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasM) | [x, y, m][with z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasZ) and [without m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasM) | [x, y, z][with z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasZ) and [with m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#hasM) | [x, y, z, m]
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html#rings)
     */
    rings?: number[][][];
  }

  interface Polyline extends Geometry {
    /**
     * An array of paths, or line segments, that make up the polyline. Each path is a two-dimensionalarray of numbers representing the coordinates of each vertex in the path in the spatial reference of the view.Each vertex is represented as an array of two, three, or four numbers.The table below shows the various structures of a vertex array.Case | Vertex array--- | ---[without z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasZ) and [without m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasM) | [x, y][without z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasZ) and [with m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasM) | [x, y, m][with z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasZ) and [without m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasM) | [x, y, z][with z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasZ) and [with m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasM) | [x, y, z, m]
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#paths)
     */
    paths: number[][][];
    /**
     * For Polyline, the type is always `polyline`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#type)
     */
    readonly type: "polyline";

    /**
     * Adds a path, or line segment, to the polyline. When added, the index of the path is incremented by one.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#addPath)
     *
     * @param points A polyline path. This can either be defined as an array of                             Point geometries or an array of XY coordinates.
     *
     */
    addPath(points: Point[] | number[][]): Polyline;
    /**
     * Creates a deep clone of Polyline object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#clone)
     *
     *
     */
    clone(): Polyline;
    /**
     * Returns a point specified by a path and point in the path.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#getPoint)
     *
     * @param pathIndex The index of a path in the polyline.
     * @param pointIndex The index of a point in a path.
     *
     */
    getPoint(pathIndex: number, pointIndex: number): Point;
    /**
     * Inserts a new point into a polyline.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#insertPoint)
     *
     * @param pathIndex The index of the path in which to insert a point.
     * @param pointIndex The index of the inserted point in the path.
     * @param point The point to insert.
     *
     */
    insertPoint(pathIndex: number, pointIndex: number, point: Point | number[]): Polyline;
    /**
     * Removes a path from the Polyline. The index specifies which path to remove.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#removePath)
     *
     * @param index The index of the path to remove from the polyline.
     *
     */
    removePath(index: number): Point[];
    /**
     * Removes a point from the polyline at the given `pointIndex` within the path identified by the given `pathIndex`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#removePoint)
     *
     * @param pathIndex The index of the path containing the point to be removed.
     * @param pointIndex The index of the point to be removed within the path.
     *
     */
    removePoint(pathIndex: number, pointIndex: number): Point;
    /**
     * Updates a point in a polyline.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#setPoint)
     *
     * @param pathIndex The index of the path that contains the point to be updated.
     * @param pointIndex The index of the point to be updated in the path.
     * @param point Point geometry to update in the path.
     *
     */
    setPoint(pathIndex: number, pointIndex: number, point: Point | number[]): Polyline;
  }

  interface PolylineConstructor {
    new (properties?: PolylineProperties): Polyline;

    fromJSON(json: any): Polyline;
  }

  export const Polyline: PolylineConstructor;

  interface PolylineProperties extends GeometryProperties {
    /**
     * An array of paths, or line segments, that make up the polyline. Each path is a two-dimensionalarray of numbers representing the coordinates of each vertex in the path in the spatial reference of the view.Each vertex is represented as an array of two, three, or four numbers.The table below shows the various structures of a vertex array.Case | Vertex array--- | ---[without z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasZ) and [without m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasM) | [x, y][without z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasZ) and [with m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasM) | [x, y, m][with z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasZ) and [without m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasM) | [x, y, z][with z](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasZ) and [with m](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#hasM) | [x, y, z, m]
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html#paths)
     */
    paths?: number[][][];
  }

  interface projection {
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-projection.html#getTransformation)
     *
     * @param inSpatialReference The input spatial reference from which to project geometries.  This is the spatial reference of the input geometries.
     * @param outSpatialReference The spatial reference to which you are converting the geometries.
     * @param extent An extent used to determine the suitability of the returned transformation.The extent will be re-projected to the `inSpatialReference` if it has a different spatial reference.
     *
     */
    getTransformation(
      inSpatialReference: SpatialReference | SpatialReferenceProperties,
      outSpatialReference: SpatialReference | SpatialReferenceProperties,
      extent?: Extent
    ): GeographicTransformation;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-projection.html#getTransformations)
     *
     * @param inSpatialReference The spatial reference that the geometries are currently using.
     * @param outSpatialReference The spatial reference to which you are converting the geometries to.
     * @param extent An extent used to determine the suitability of the returned transformations.The extent will be re-projected to the input spatial reference if necessary.
     *
     */
    getTransformations(
      inSpatialReference: SpatialReference | SpatialReferenceProperties,
      outSpatialReference: SpatialReference | SpatialReferenceProperties,
      extent?: Extent
    ): GeographicTransformation[];
    /**
     * Indicates if all dependencies of this module have been loaded.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-projection.html#isLoaded)
     *
     *
     */
    isLoaded(): boolean;
    /**
     * Indicates if this module is supported in the browser.The browser must support [WebAssembly](https://caniuse.com/#feat=wasm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-projection.html#isSupported)
     *
     *
     */
    isSupported(): boolean;
    /**
     * Loads this module's dependencies. This method must be called before [projecting](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-projection.html#project) geometries.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-projection.html#load)
     *
     *
     */
    load(): IPromise<any>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-projection.html#project)
     *
     * @param geometry The geometry or geometries to project.
     * @param outSpatialReference The spatial reference to which you are converting the geometries' coordinates.
     * @param geographicTransformation The geographic transformation used totransform the geometries. Specify this parameter to project a geometry when the default transformation is not appropriate foryour requirements.
     *
     */
    project(
      geometry: Geometry | Geometry[],
      outSpatialReference: SpatialReference | SpatialReferenceProperties,
      geographicTransformation?: GeographicTransformation
    ): Geometry | Geometry[];
  }

  export const projection: projection;

  interface SpatialReference extends Accessor, JSONSupport {
    /**
     * Indicates if the spatial reference refers to a geographic coordinate system.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isGeographic)
     */
    readonly isGeographic: boolean;
    /**
     * Indicates if the [wkid](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#wkid) of the spatial reference object is one of the following values:`102113`, `102100`, `3857`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWebMercator)
     */
    readonly isWebMercator: boolean;
    /**
     * Indicates if the [wkid](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#wkid) of the spatial reference object is`4326`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWGS84)
     */
    readonly isWGS84: boolean;
    /**
     * Indicates if the spatial reference of the map supports wrapping around the InternationalDate Line. Value is `true` if the spatial reference is Web Mercator or WGS84.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#isWrappable)
     */
    readonly isWrappable: boolean;
    /**
     * The well-known ID of a spatial reference. See [Projected Coordinate Systems](https://developers.arcgis.com/rest/services-reference/projected-coordinate-systems.htm) and[Geographic Coordinate Systems](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm)for the list of supported spatial references.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#wkid)
     */
    wkid: number;
    /**
     * The well-known text that defines a spatial reference.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#wkt)
     */
    wkt: string;

    /**
     * Returns a deep clone of the spatial reference object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#clone)
     *
     *
     */
    clone(): SpatialReference;
    /**
     * Checks if the specified spatial reference object has the same [wkid](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#wkid) or[wkt](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#wkt) as this spatial reference object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#equals)
     *
     * @param spatialReference The spatial reference to compare to.
     *
     */
    equals(spatialReference: SpatialReference): boolean;
  }

  interface SpatialReferenceConstructor {
    new (properties?: SpatialReferenceProperties): SpatialReference;

    /**
     * A convenience spatial reference instance for Web Mercator.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#WebMercator)
     */
    WebMercator: SpatialReference;
    /**
     * A convenience spatial reference instance for WGS84.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#WGS84)
     */
    WGS84: SpatialReference;

    fromJSON(json: any): SpatialReference;
  }

  export const SpatialReference: SpatialReferenceConstructor;

  interface SpatialReferenceProperties {
    /**
     * The well-known ID of a spatial reference. See [Projected Coordinate Systems](https://developers.arcgis.com/rest/services-reference/projected-coordinate-systems.htm) and[Geographic Coordinate Systems](https://developers.arcgis.com/rest/services-reference/geographic-coordinate-systems.htm)for the list of supported spatial references.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#wkid)
     */
    wkid?: number;
    /**
     * The well-known text that defines a spatial reference.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html#wkt)
     */
    wkt?: string;
  }

  interface geodesicUtils {
    /**
     * Geodetically computes the area for one or more polygons.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-geodesicUtils.html#geodesicAreas)
     *
     * @param polygons The polygons to compute the area for.
     * @param unit Output area units.**Possible Values:** square-millimeters | square-centimeters | square-decimeters | square-meters | square-kilometers | square-inches | square-feet | square-yards | square-miles | square-us-feet | acres | ares | hectares
     *
     */
    geodesicAreas(polygons: Polygon[], unit?: string): number[];
    /**
     * Computes and returns a densified polyline or polygon.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-geodesicUtils.html#geodesicDensify)
     *
     * @param geometry The input polyline or polygon.
     * @param maxSegmentLength The maximum length (in meters) between vertices.
     *
     */
    geodesicDensify(geometry: Polyline | Polygon, maxSegmentLength: number): Polyline | Polygon;
    /**
     * Geodetically computes the direction and distance between two known locations.Both input points must have the same geographic coordinate system.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-geodesicUtils.html#geodesicDistance)
     *
     * @param from The origin location.
     * @param to The destination location.
     * @param unit Output linear units.**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     *
     */
    geodesicDistance(from: Point, to: Point, unit?: string): GeodesicDistanceResult;
    /**
     * Geodetically computes polygon perimeter or polyline length for one or more geometries.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-geodesicUtils.html#geodesicLengths)
     *
     * @param geometries The input polylines or polygons.
     * @param unit Output linear units.**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     *
     */
    geodesicLengths(geometries: Polyline[] | Polygon[], unit?: string): number[];
    /**
     * Geodetically computes the location at a defined distance and direction from a known location.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-geodesicUtils.html#pointFromDistance)
     *
     * @param point Origin location.
     * @param distance Distance from the origin in meters.
     * @param azimuth Direction from the origin in degrees.
     *
     */
    pointFromDistance(point: Point, distance: number, azimuth: number): Point;
  }

  export const geodesicUtils: geodesicUtils;

  /**
   * Computed distance and direction between two known locations.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-geodesicUtils.html#GeodesicDistanceResult)
   */
  export interface GeodesicDistanceResult extends Object {
    /**
     * The distance between the two locations.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-geodesicUtils.html#GeodesicDistanceResult)
     */
    distance?: number;
    /**
     * The azimuth (or "bearing") in degrees.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-geodesicUtils.html#GeodesicDistanceResult)
     */
    azimuth?: number;
    /**
     * The azimuth in degrees in the reverse direction.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-geodesicUtils.html#GeodesicDistanceResult)
     */
    reverseAzimuth?: number;
  }

  interface GeographicTransformation {
    /**
     * Geographic transformation steps. Each step represents a geographic transformation that will be used in theprocess of transforming coordinates from one geographic coordinate system to another.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-GeographicTransformation.html#steps)
     */
    steps: GeographicTransformationStep[];

    /**
     * Returns the inverse of the geographic transformation calling this method or `null` if the transformation is not invertible.The inverse of a transformation converts coordinates using the same method and parameters, but in the oppositedirection of the original object. For example if the original object represents the `NAD_1983_HARN_To_NAD_1983_NSRS2007_1`transformation, then the inverse will transform from `NAD 83 (NSRS 2007)` to `NAD 83 (HARN)`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-GeographicTransformation.html#getInverse)
     *
     *
     */
    getInverse(): GeographicTransformation;
  }

  interface GeographicTransformationConstructor {
    new (properties?: any): GeographicTransformation;
  }

  export const GeographicTransformation: GeographicTransformationConstructor;

  interface GeographicTransformationStep {
    /**
     * Indicates with the geographic transformation is inverted.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-GeographicTransformationStep.html#isInverse)
     *
     * @default false
     */
    isInverse: boolean;
    /**
     * The well-known id (wkid) hat represents a known geographic transformation.See [Geographic datum transformations](https://developers.arcgis.com/java/10-2/guide/datum-transformations.htm#ESRI_SECTION1_7635FE2A60E6449898D5AD0ADE2CA0C3)for the list of supported equation-based geographic transformations.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-GeographicTransformationStep.html#wkid)
     */
    wkid: number;
    /**
     * The well-known text (wkt) that represents a known geographic transformation.See [Geographic datum transformations](https://developers.arcgis.com/java/10-2/guide/datum-transformations.htm#ESRI_SECTION1_7635FE2A60E6449898D5AD0ADE2CA0C3)for the list of supported equation-based geographic transformations.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-GeographicTransformationStep.html#wkt)
     */
    wkt: string;

    /**
     * Gets the inverse of the geographic transformation step used to call this method or `null` if the transformation step is not invertible.The inverse of a transformation converts coordinates using the same method and parameters, but in the oppositedirection of the original object. For example if the original object represents the `NAD_1983_HARN_To_NAD_1983_NSRS2007_1`transformation, then the inverse will transform from `NAD 83 (NSRS 2007)` to `NAD 83 (HARN)`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-GeographicTransformationStep.html#getInverse)
     *
     *
     */
    getInverse(): GeographicTransformationStep;
  }

  interface GeographicTransformationStepConstructor {
    new (properties?: any): GeographicTransformationStep;
  }

  export const GeographicTransformationStep: GeographicTransformationStepConstructor;

  interface ImageMeshColor extends Accessor {
    /**
     * A direct reference to the image data. The image data can be an[image element](https://developer.mozilla.org/en-US/docs/Web/API/HTMLImageElement),[canvas element](https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement)or [ImageData](https://developer.mozilla.org/en-US/docs/Web/API/ImageData).The data property is mutually exclusive with the url property, setting the data will clear theurl (if there is one).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-ImageMeshColor.html#data)
     */
    data: HTMLImageElement | HTMLCanvasElement | ImageData;
    /**
     * Indicates whether the image data should be interpreted as being semi-transparent.The default value is automatically derived when the data property contains a canvaselement or an ImageData object. If instead a url to a .png file was provided, it isassumed that transparency is present. In all other cases it defaults to `false`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-ImageMeshColor.html#transparent)
     *
     * @default undefined
     */
    transparent: boolean;
    /**
     * For ImageMeshColor the type is always `image`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-ImageMeshColor.html#type)
     */
    readonly type: "image";
    /**
     * The url to the image resource. This can either be a remote url (absolute or relative) or a data url.The url property is mutually exclusive with the data property, setting the url will clear thedata (if there is one).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-ImageMeshColor.html#url)
     */
    url: string;

    /**
     * Creates a deep clone.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-ImageMeshColor.html#clone)
     *
     *
     */
    clone(): ImageMeshColor;
  }

  interface ImageMeshColorConstructor {
    new (properties?: ImageMeshColorProperties): ImageMeshColor;
  }

  export const ImageMeshColor: ImageMeshColorConstructor;

  interface ImageMeshColorProperties {
    /**
     * A direct reference to the image data. The image data can be an[image element](https://developer.mozilla.org/en-US/docs/Web/API/HTMLImageElement),[canvas element](https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement)or [ImageData](https://developer.mozilla.org/en-US/docs/Web/API/ImageData).The data property is mutually exclusive with the url property, setting the data will clear theurl (if there is one).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-ImageMeshColor.html#data)
     */
    data?: HTMLImageElement | HTMLCanvasElement | ImageData;
    /**
     * Indicates whether the image data should be interpreted as being semi-transparent.The default value is automatically derived when the data property contains a canvaselement or an ImageData object. If instead a url to a .png file was provided, it isassumed that transparency is present. In all other cases it defaults to `false`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-ImageMeshColor.html#transparent)
     *
     * @default undefined
     */
    transparent?: boolean;
    /**
     * The url to the image resource. This can either be a remote url (absolute or relative) or a data url.The url property is mutually exclusive with the data property, setting the url will clear thedata (if there is one).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-ImageMeshColor.html#url)
     */
    url?: string;
  }

  interface jsonUtils {
    /**
     * Creates a new instance of an appropriate [Geometry](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html) class and initializes it with values from a JSON objectgenerated from a product in the ArcGIS platform. The object passed into the input `json`parameter often comes from a response to a query operation in the REST API or a[toJSON()](http://pro.arcgis.com/en/pro-app/tool-reference/conversion/features-to-json.htm)method from another ArcGIS product. See the [Using fromJSON()](https://developers.arcgis.com/javascript/latest/guide/using-fromjson/index.html)topic in the Guide for details and examples of when and how to use this function.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-jsonUtils.html#fromJSON)
     *
     * @param json A JSON representation of the instance in the ArcGIS format. See                     the [ArcGIS REST API documentation](https://developers.arcgis.com/documentation/common-data-types/overview-of-common-data-types.htm)                     for examples of the structure of various input JSON objects.
     *
     */
    fromJSON(json: any): Geometry;
    /**
     * Returns the type for a given geometry in the JSON format used by the ArcGIS platform.This only applies to geometries that can be processed by the server.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-jsonUtils.html#getJsonType)
     *
     * @param geometry The input geometry object.
     *
     */
    getJsonType(geometry: Geometry): string;
  }

  export const jsonUtils: jsonUtils;

  interface MeshComponent extends Accessor {
    /**
     * A flat array of indices that refer to vertices in the[vertexAttributes](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes) of themesh to which the component belongs. Each triple of indices defines a triangleto render (i.e. the faces array must always have a length that is a multiple of 3).Note that the indices refer to **vertices** and not to the index of the first coordinateof a vertex in the [vertexAttributes.position](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes)array.If faces is `null`, then all the vertices in the mesh will be renderedas triangles for this component.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshComponent.html#faces)
     */
    faces: Uint32Array;
    /**
     * The material determines how the component is visualized.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshComponent.html#material)
     */
    material: MeshMaterial;
    /**
     * Specifies the type of normals used for lighting. This determines whether the objecthas a smooth or an angular appearance. The following shading types are supported:| Type | Description ||------|-------------|| source | Shading uses the normals as defined in the vertex attributes. If no normals are defined, then shading defaults back to `flat` || flat | Shading uses normals created per triangle face. This type of shading is good for objects with sharp edges such as boxes. || smooth | Shading uses per-vertex normals that average the normals of all the faces a vertex is a part of. This type of shading is good for meshes that approximate curved surfaces such as spheres. |
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshComponent.html#shading)
     */
    shading: string;

    /**
     * Creates a deep clone.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshComponent.html#clone)
     *
     *
     */
    clone(): MeshComponent;
  }

  interface MeshComponentConstructor {
    new (properties?: MeshComponentProperties): MeshComponent;
  }

  export const MeshComponent: MeshComponentConstructor;

  interface MeshComponentProperties {
    /**
     * A flat array of indices that refer to vertices in the[vertexAttributes](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes) of themesh to which the component belongs. Each triple of indices defines a triangleto render (i.e. the faces array must always have a length that is a multiple of 3).Note that the indices refer to **vertices** and not to the index of the first coordinateof a vertex in the [vertexAttributes.position](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Mesh.html#vertexAttributes)array.If faces is `null`, then all the vertices in the mesh will be renderedas triangles for this component.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshComponent.html#faces)
     */
    faces?: Uint32Array | number[] | Uint16Array;
    /**
     * The material determines how the component is visualized.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshComponent.html#material)
     */
    material?: MeshMaterialProperties;
    /**
     * Specifies the type of normals used for lighting. This determines whether the objecthas a smooth or an angular appearance. The following shading types are supported:| Type | Description ||------|-------------|| source | Shading uses the normals as defined in the vertex attributes. If no normals are defined, then shading defaults back to `flat` || flat | Shading uses normals created per triangle face. This type of shading is good for objects with sharp edges such as boxes. || smooth | Shading uses per-vertex normals that average the normals of all the faces a vertex is a part of. This type of shading is good for meshes that approximate curved surfaces such as spheres. |
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshComponent.html#shading)
     */
    shading?: string;
  }

  interface MeshMaterial extends Accessor {
    /**
     * Specifies how transparency on the object is handled.If `alphaMode` is set to either `mask` or `auto` this property specifies the cutoff value below whichmasking happens (that is, the coresponding part of the Mesh is rendered fully transparent).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshMaterial.html#alphaCutoff)
     *
     * @default 0.5
     */
    alphaCutoff: number;
    /**
     * Specifies how transparency on the object is handled. See also `alphaCutoff`.| Type | Description ||------|-------------|| opaque | Alpha is ignored, and the object is rendered fully opaque. || blend | Alpha values are used for gradual transparency, blending between the object and its background. || mask | Alpha values are used for binary transparency, either displaying the object, or its background. See also `alphaCutoff`. || auto | The implementation mixes the `mask` and `blend` settings, masking below `alphaCutoff` and blending above it. |
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshMaterial.html#alphaMode)
     *
     * @default "auto"
     */
    alphaMode: string;
    /**
     * Allows to specify a single, uniform color for the mesh component. This can be autocast witha named string, hex string, array of rgb or rgba values, an object with `r`, `g`, `b`, and `a`properties, or a [Color](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html) object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshMaterial.html#color)
     */
    color: Color;
    /**
     * Allows to specify a texture to get color information from.The texture is accessed using the uv coordinate specified for each vertexin the mesh vertex attributes.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshMaterial.html#colorTexture)
     */
    colorTexture: MeshTexture;
    /**
     * Specifies whether both sides of each triangle are displayed, or only the front sides.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshMaterial.html#doubleSided)
     *
     * @default true
     */
    doubleSided: boolean;
    /**
     * Allows to specify a texture to get normal information from.The texture is accessed using the uv coordinate specified for each vertexin the mesh vertex attributes. Normal mapping requires also for tangents to bespecified in the mesh vertex attributes.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshMaterial.html#normalTexture)
     */
    normalTexture: MeshTexture;
  }

  interface MeshMaterialConstructor {
    new (properties?: MeshMaterialProperties): MeshMaterial;
  }

  export const MeshMaterial: MeshMaterialConstructor;

  interface MeshMaterialProperties {
    /**
     * Specifies how transparency on the object is handled.If `alphaMode` is set to either `mask` or `auto` this property specifies the cutoff value below whichmasking happens (that is, the coresponding part of the Mesh is rendered fully transparent).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshMaterial.html#alphaCutoff)
     *
     * @default 0.5
     */
    alphaCutoff?: number;
    /**
     * Specifies how transparency on the object is handled. See also `alphaCutoff`.| Type | Description ||------|-------------|| opaque | Alpha is ignored, and the object is rendered fully opaque. || blend | Alpha values are used for gradual transparency, blending between the object and its background. || mask | Alpha values are used for binary transparency, either displaying the object, or its background. See also `alphaCutoff`. || auto | The implementation mixes the `mask` and `blend` settings, masking below `alphaCutoff` and blending above it. |
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshMaterial.html#alphaMode)
     *
     * @default "auto"
     */
    alphaMode?: string;
    /**
     * Allows to specify a single, uniform color for the mesh component. This can be autocast witha named string, hex string, array of rgb or rgba values, an object with `r`, `g`, `b`, and `a`properties, or a [Color](https://developers.arcgis.com/javascript/latest/api-reference/esri-Color.html) object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshMaterial.html#color)
     */
    color?: Color | number[] | string;
    /**
     * Allows to specify a texture to get color information from.The texture is accessed using the uv coordinate specified for each vertexin the mesh vertex attributes.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshMaterial.html#colorTexture)
     */
    colorTexture?: MeshTextureProperties | HTMLImageElement | HTMLCanvasElement | ImageData | string;
    /**
     * Specifies whether both sides of each triangle are displayed, or only the front sides.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshMaterial.html#doubleSided)
     *
     * @default true
     */
    doubleSided?: boolean;
    /**
     * Allows to specify a texture to get normal information from.The texture is accessed using the uv coordinate specified for each vertexin the mesh vertex attributes. Normal mapping requires also for tangents to bespecified in the mesh vertex attributes.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshMaterial.html#normalTexture)
     */
    normalTexture?: MeshTextureProperties | HTMLImageElement | HTMLCanvasElement | ImageData | string;
  }

  interface MeshTexture extends Accessor {
    /**
     * A direct reference to the image data. The image data can be an[image element](https://developer.mozilla.org/en-US/docs/Web/API/HTMLImageElement),[canvas element](https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement)or [ImageData](https://developer.mozilla.org/en-US/docs/Web/API/ImageData).The data property is mutually exclusive with the url property, setting the data will clear theurl (if there is one).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshTexture.html#data)
     */
    data: HTMLImageElement | HTMLCanvasElement | ImageData;
    /**
     * Indicates whether the image data should be interpreted as being semi-transparent.The default value is automatically derived when the data property contains a canvaselement or an ImageData object. If instead a url to a .png file was provided, it isassumed that transparency is present. In all other cases it defaults to `false`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshTexture.html#transparent)
     *
     * @default undefined
     */
    transparent: boolean;
    /**
     * The url to the image resource. This can either be a remote url (absolute or relative) or a data url.The url property is mutually exclusive with the data property, setting the url will clear thedata (if there is one).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshTexture.html#url)
     */
    url: string;
    /**
     * Specifies how uv coordinates outside the [0, 1] range are handled. One of "repeat", "clamp" or "mirror".Can also be specified separately for the two texture axes using an object:```js{  vertical: "clamp",  horizontal: "repeat"}```
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshTexture.html#wrap)
     *
     * @default "repeat"
     */
    wrap: string | any;

    /**
     * Creates a deep clone.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshTexture.html#clone)
     *
     *
     */
    clone(): MeshTexture;
  }

  interface MeshTextureConstructor {
    new (properties?: MeshTextureProperties): MeshTexture;
  }

  export const MeshTexture: MeshTextureConstructor;

  interface MeshTextureProperties {
    /**
     * A direct reference to the image data. The image data can be an[image element](https://developer.mozilla.org/en-US/docs/Web/API/HTMLImageElement),[canvas element](https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement)or [ImageData](https://developer.mozilla.org/en-US/docs/Web/API/ImageData).The data property is mutually exclusive with the url property, setting the data will clear theurl (if there is one).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshTexture.html#data)
     */
    data?: HTMLImageElement | HTMLCanvasElement | ImageData;
    /**
     * Indicates whether the image data should be interpreted as being semi-transparent.The default value is automatically derived when the data property contains a canvaselement or an ImageData object. If instead a url to a .png file was provided, it isassumed that transparency is present. In all other cases it defaults to `false`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshTexture.html#transparent)
     *
     * @default undefined
     */
    transparent?: boolean;
    /**
     * The url to the image resource. This can either be a remote url (absolute or relative) or a data url.The url property is mutually exclusive with the data property, setting the url will clear thedata (if there is one).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshTexture.html#url)
     */
    url?: string;
    /**
     * Specifies how uv coordinates outside the [0, 1] range are handled. One of "repeat", "clamp" or "mirror".Can also be specified separately for the two texture axes using an object:```js{  vertical: "clamp",  horizontal: "repeat"}```
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-MeshTexture.html#wrap)
     *
     * @default "repeat"
     */
    wrap?: string | any;
  }

  interface meshUtils {
    /**
     * Creates an elevation sampler from a mesh. The sampler can be used to query elevation valueson the surface of the mesh. The elevation sampler uses a snapshot of the Mesh geometry andwill not update if the mesh changes after the sampler has been created.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#createElevationSampler)
     *
     * @param mesh The mesh geometry used to create the elevation sampler.
     * @param options Additional options.
     * @param options.noDataValue The value to use when there is no data available.
     *
     */
    createElevationSampler(mesh: Mesh, options?: meshUtilsCreateElevationSamplerOptions): IPromise<ElevationSampler>;
    /**
     * Creates a mesh geometry by sampling elevation data from an elevation service on a regular grid.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#createFromElevation)
     *
     * @param source The source from which to query the elevation data.
     * @param extent The extent from which to create the mesh.
     * @param options Additional options.
     * @param options.demResolution Controls the horizontal resolution (cell size)  in meters from which elevation data is sampled (defaults to `auto`). See [ElevationLayer.queryElevation](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#queryElevation)  for more details on the different settings.
     *
     */
    createFromElevation(
      source: ElevationLayer | Ground | ElevationSampler,
      extent: Extent,
      options?: meshUtilsCreateFromElevationOptions
    ): IPromise<Mesh>;
    /**
     * Georeferences vertices specified in a Cartesian coordinate system. This is usefulwhen converting general 3D model meshes not typically georeferenced. This methodoperates on mesh vertex attributes and will convert positions and normals (if specified)from a local (0, 0, 0) Cartesian system to the properly georeferenced coordinates at thespecified `location`. The unit of the source data defaults to the unit of the `location`'s spatial reference.If the coordinate system is WGS84, metric units are used as the default. The unit of the source data may bespecified in the additional `options` in which case a linear unit scale will automatically be applied to bringthe source data in the unit of the spatial reference.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#georeference)
     *
     * @param vertexAttributes The position and normal buffers to georeference.
     * @param location The location at which to georeference the position and normal buffers.
     * @param options Additional options.
     * @param options.geographic Indicates whether to georeference relative to the globe or the projected coordinate system.
     * @param options.unit Indicates the unit of the source data. A linear scale will be applied to the position attributes  to convert the source data to the unit of the spatial reference at which the mesh is being georeferenced. By default the unit  of the source data is assumed to be the same as the target spatial reference.**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     *
     */
    georeference(
      vertexAttributes: VertexAttributes,
      location: Point,
      options?: meshUtilsGeoreferenceOptions
    ): VertexAttributes;
    /**
     * Merges multiple meshes into a single mesh. All mesh geometriesmust be in the same spatial reference.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#merge)
     *
     * @param geometries One or more meshes.
     *
     */
    merge(geometries: Mesh[]): Mesh;
    /**
     * Projects georeferenced vertices to a Cartesian coordinate system.This is useful for converting existing scene geometry so that it can be usedas source material for generating new 3D meshes. This methodoperates on mesh vertex attributes and will convert positions and normals (if specified)from georeferenced coordinates at the specified `location` to a local (0, 0, 0) Cartesian system.The unit of the resulting data defaults to the unit of the `location`'s spatial reference.If the coordinate system is WGS84, metric units are used as the default. The unit of the resulting data may bespecified in the additional `options` in which case a linear unit scale will automatically be applied.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#ungeoreference)
     *
     * @param vertexAttributes The georeferenced position and normal buffers.
     * @param location The location to which the position and normal buffers are georeferenced.
     * @param options Additional options.
     * @param options.geographic Indicates whether the coordinates are georeferenced relative to the globe or the projected coordinate system.
     * @param options.unit Indicates the unit of the resulting data. A linear scale will be applied to the position attributes  to convert the source data to the specified unit. By default the unit of the resulting data will be the same as the source spatial reference.**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     *
     */
    ungeoreference(
      vertexAttributes: VertexAttributes,
      location: Point,
      options?: meshUtilsUngeoreferenceOptions
    ): VertexAttributes;
  }

  export const meshUtils: meshUtils;

  export interface meshUtilsCreateElevationSamplerOptions extends Object {
    /**
     * The value to use when there is no data available.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#createElevationSampler)
     *
     * @default 0
     */
    noDataValue?: number;
  }

  export interface meshUtilsCreateFromElevationOptions extends Object {
    /**
     * Controls the horizontal resolution (cell size)  in meters from which elevation data is sampled (defaults to `auto`). See [ElevationLayer.queryElevation](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#queryElevation)  for more details on the different settings.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#createFromElevation)
     *
     * @default auto
     */
    demResolution?: number | string;
  }

  export interface meshUtilsGeoreferenceOptions extends Object {
    /**
     * Indicates whether to georeference relative to the globe or the projected coordinate system.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#georeference)
     */
    geographic?: boolean;
    /**
     * Indicates the unit of the source data. A linear scale will be applied to the position attributes  to convert the source data to the unit of the spatial reference at which the mesh is being georeferenced. By default the unit  of the source data is assumed to be the same as the target spatial reference.**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#georeference)
     */
    unit?: string;
  }

  export interface meshUtilsUngeoreferenceOptions extends Object {
    /**
     * Indicates whether the coordinates are georeferenced relative to the globe or the projected coordinate system.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#ungeoreference)
     */
    geographic?: boolean;
    /**
     * Indicates the unit of the resulting data. A linear scale will be applied to the position attributes  to convert the source data to the specified unit. By default the unit of the resulting data will be the same as the source spatial reference.**Possible Values:** millimeters | centimeters | decimeters | meters | kilometers | inches | feet | yards | miles | nautical-miles | us-feet
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#ungeoreference)
     */
    unit?: string;
  }

  /**
   * Represents the position and normal vertex attribute buffers of a mesh.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#VertexAttributes)
   */
  export interface VertexAttributes extends Object {
    /**
     * The position buffer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#VertexAttributes)
     */
    position: Float64Array;
    /**
     * The normal buffer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-meshUtils.html#VertexAttributes)
     */
    normal?: Float32Array;
  }

  interface normalizeUtils {
    /**
     * Normalizes geometries that intersect the central meridian or fall outside theworld extent so they stay within the coordinate system of the view. Only supportedfor Web Mercator and WGS84 spatial references.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-normalizeUtils.html#normalizeCentralMeridian)
     *
     * @param geometries An array of geometries to normalize.
     * @param geometryService A geometry service used toperform the normalization. If this value is `null` then the default geometry service in[esriConfig.geometryServiceUrl](https://developers.arcgis.com/javascript/latest/api-reference/esri-config.html#geometryServiceUrl) is used.
     * @param requestOptions Additional [options](https://developers.arcgis.com/javascript/latest/api-reference/esri-request.html#esriRequest) to be used for the data request.
     *
     */
    normalizeCentralMeridian(
      geometries: Geometry[],
      geometryService?: GeometryService,
      requestOptions?: any
    ): IPromise<Geometry[]>;
  }

  export const normalizeUtils: normalizeUtils;

  interface ValueMeshColor extends Accessor {
    /**
     * For ValueMeshColor the type is always `value`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-ValueMeshColor.html#type)
     */
    readonly type: "value";
    /**
     * The color value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-ValueMeshColor.html#value)
     */
    value: Color;

    /**
     * Creates a deep clone.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-ValueMeshColor.html#clone)
     *
     *
     */
    clone(): ValueMeshColor;
  }

  interface ValueMeshColorConstructor {
    new (properties?: ValueMeshColorProperties): ValueMeshColor;
  }

  export const ValueMeshColor: ValueMeshColorConstructor;

  interface ValueMeshColorProperties {
    /**
     * The color value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-ValueMeshColor.html#value)
     */
    value?: Color | number[] | string;
  }

  interface webMercatorUtils {
    /**
     * Returns `true` if the `source` spatial reference can be projected to the `target` spatial reference with the [project()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-webMercatorUtils.html#project) function, orif the `source` and `target` are the same [SpatialReference](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-webMercatorUtils.html#canProject)
     *
     * @param source The input [SpatialReference](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html) or an object with                                                                 `spatialReference` property such as [Geometry](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html)                                                                 or [Map](https://developers.arcgis.com/javascript/latest/api-reference/esri-Map.html).
     * @param target The target [SpatialReference](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html) or an object with                                                                 `spatialReference` property such as [Geometry](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html)                                                                 or [Map](https://developers.arcgis.com/javascript/latest/api-reference/esri-Map.html).
     *
     */
    canProject(source: SpatialReference | any, target: SpatialReference | any): boolean;
    /**
     * Converts a geometry from geographic units (wkid: 4326) to Web Mercator units (wkid: 3857).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-webMercatorUtils.html#geographicToWebMercator)
     *
     * @param geometry The input geometry to convert.
     *
     */
    geographicToWebMercator(geometry: Geometry): Geometry;
    /**
     * Translates the given latitude and longitude (decimal degree) values to Web Mercator XY values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-webMercatorUtils.html#lngLatToXY)
     *
     * @param long The longitude value to convert.
     * @param lat The latitude value to convert.
     *
     */
    lngLatToXY(long: number, lat: number): number[];
    /**
     * Projects the geometry clientside (if possible). You should test the input geometry in [canProject()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-webMercatorUtils.html#canProject) prior to using this function.If the result of [canProject()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-webMercatorUtils.html#canProject) is `true`, then proceed to project. If [canProject()](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-webMercatorUtils.html#canProject) returns `false`, then`project()` won't return useful results. Use [GeometryService.project()](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-GeometryService.html#project) instead.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-webMercatorUtils.html#project)
     *
     * @param geometry The input geometry.
     * @param spatialReference The target [SpatialReference](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html) or an object with                                                                 `spatialReference` property such as [Geometry](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html)                                                                 or [Map](https://developers.arcgis.com/javascript/latest/api-reference/esri-Map.html).
     *
     */
    project(geometry: Geometry, spatialReference: SpatialReference | any): Geometry;
    /**
     * Converts a geometry from Web Mercator units (wkid: 3857) to geographic units (wkid: 4326).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-webMercatorUtils.html#webMercatorToGeographic)
     *
     * @param geometry The input geometry to convert.
     *
     */
    webMercatorToGeographic(geometry: Geometry): Geometry;
    /**
     * Translates the given Web Mercator coordinates to Longitude and Latitude values (decimal degrees).By default the returned longitude is normalized so that it is within -180 and +180.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-support-webMercatorUtils.html#xyToLngLat)
     *
     * @param x The X coordinate value to convert.
     * @param y The Y coordinate value to convert.
     *
     */
    xyToLngLat(x: number, y: number): number[];
  }

  export const webMercatorUtils: webMercatorUtils;

  /**
   * Extent.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Extent)
   */
  export type geometryExtent = Extent;

  /**
   * Geometry types.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Geometry)
   */
  export type geometryGeometry = Extent | Multipoint | Point | Polygon | Polyline | Mesh;

  /**
   * Mesh.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Mesh)
   */
  export type geometryMesh = Mesh;

  /**
   * Multipoint.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Multipoint)
   */
  export type geometryMultipoint = Multipoint;

  /**
   * Point.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Point)
   */
  export type geometryPoint = Point;

  /**
   * Polygon.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Polygon)
   */
  export type geometryPolygon = Polygon;

  /**
   * Polyline.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#Polyline)
   */
  export type geometryPolyline = Polyline;

  /**
   * Spatial Reference.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry.html#SpatialReference)
   */
  export type geometrySpatialReference = SpatialReference;

  interface Graphic extends Accessor, JSONSupport {
    /**
     * Name-value pairs of fields and field values associated with the graphic.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#attributes)
     */
    attributes: any;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#geometry)
     */
    geometry: Geometry;
    /**
     * If applicable, references the layer in which the graphic is stored.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#layer)
     */
    layer: Layer;
    /**
     * The template for displaying content in a [Popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html)when the graphic is selected. The [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) may be used to accessa graphic's [attributes](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#attributes) and display their values in the view'sdefault popup. See the documentation for [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) for details onhow to display attribute values in the popup.As of 4.8 to get the actual `popupTemplate` of the graphic, see the [getEffectivePopupTemplate()](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#getEffectivePopupTemplate)method that either returns this value or the `popupTemplate` of the graphic's layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#popupTemplate)
     */
    popupTemplate: PopupTemplate;
    /**
     * The [Symbol](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-Symbol.html) for the graphic. Choosing a symbol for a graphic depends on the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html) type (SceneView or MapView),and the [geometry type](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html#type) of the graphic.Each graphic may have its own symbol specified when the parent layer is a [GraphicsLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html).For a [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html) the symbol of each graphic should not be set by the developer since thegraphics' rendering properties are determined by the layer's [renderer](https://developers.arcgis.com/javascript/latest/api-reference/esri-renderers-Renderer.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#symbol)
     */
    symbol: Symbol;
    /**
     * Indicates the visibility of the graphic.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#visible)
     *
     * @default true
     */
    visible: boolean;

    /**
     * Creates a deep clone of the graphic object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#clone)
     *
     *
     */
    clone(): Graphic;
    /**
     * Returns the value of the specified attribute.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#getAttribute)
     *
     * @param name The name of the attribute.
     *
     */
    getAttribute(name: string): any;
    /**
     * Returns the popup template applicable for the graphic.It's either the value of [popupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#popupTemplate) orthe `popupTemplate` from the graphic's layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#getEffectivePopupTemplate)
     *
     * @param defaultPopupTemplateEnabled Whether support for default popup templates  is enabled. When true, a default popup template may be created automatically if neither  the graphic nor its layer have a popup template defined.
     *
     */
    getEffectivePopupTemplate(defaultPopupTemplateEnabled?: boolean): PopupTemplate;
    /**
     * Sets a new value to the specified attribute.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#setAttribute)
     *
     * @param name The name of the attribute to set.
     * @param newValue The new value to set on the named attribute.
     *
     */
    setAttribute(name: string, newValue: any): void;
  }

  interface GraphicConstructor {
    new (properties?: GraphicProperties): Graphic;

    fromJSON(json: any): Graphic;
  }

  export const Graphic: GraphicConstructor;

  interface GraphicProperties {
    /**
     * Name-value pairs of fields and field values associated with the graphic.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#attributes)
     */
    attributes?: any;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#geometry)
     */
    geometry?: GeometryProperties;
    /**
     * If applicable, references the layer in which the graphic is stored.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#layer)
     */
    layer?: LayerProperties;
    /**
     * The template for displaying content in a [Popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html)when the graphic is selected. The [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) may be used to accessa graphic's [attributes](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#attributes) and display their values in the view'sdefault popup. See the documentation for [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) for details onhow to display attribute values in the popup.As of 4.8 to get the actual `popupTemplate` of the graphic, see the [getEffectivePopupTemplate()](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#getEffectivePopupTemplate)method that either returns this value or the `popupTemplate` of the graphic's layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#popupTemplate)
     */
    popupTemplate?: PopupTemplateProperties;
    /**
     * The [Symbol](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-Symbol.html) for the graphic. Choosing a symbol for a graphic depends on the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html) type (SceneView or MapView),and the [geometry type](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Geometry.html#type) of the graphic.Each graphic may have its own symbol specified when the parent layer is a [GraphicsLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html).For a [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html) the symbol of each graphic should not be set by the developer since thegraphics' rendering properties are determined by the layer's [renderer](https://developers.arcgis.com/javascript/latest/api-reference/esri-renderers-Renderer.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#symbol)
     */
    symbol?: SymbolProperties;
    /**
     * Indicates the visibility of the graphic.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#visible)
     *
     * @default true
     */
    visible?: boolean;
  }

  interface Ground extends Accessor, Loadable, JSONSupport {
    /**
     * A collection of[ElevationLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html)that define the elevation or terrain that makes up the ground surface. When elevation layers are added to theground, the topographical variations of the surface are rendered in 3D as they would appear in the real world.![elev-default](https://developers.arcgis.com/javascript/assets/img/apiref/ground/elev-default.png)When the layers collection is empty, the ground surface is flat.![no-elev](https://developers.arcgis.com/javascript/assets/img/apiref/ground/no-elev.png)
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#layers)
     */
    layers: Collection<ElevationLayer>;
    /**
     * Indicates whether the instance has loaded. When `true`,the properties of the object can be accessed. A Ground is considered loadedwhen its [layers](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#layers) are fully created, but not yet loaded.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#loaded)
     *
     * @default false
     */
    readonly loaded: boolean;
    /**
     * Specifies the user navigation constraints relative tothe ground surface.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#navigationConstraint)
     */
    navigationConstraint: GroundNavigationConstraint;
    /**
     * Opacity of the ground, including surface default color and the basemap (without reference layers).This property can be used for a see-through ground effect.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#opacity)
     *
     * @default 1
     */
    opacity: number;
    /**
     * The color of the ground surface, displayed underneath the basemap.If this is null, a grid is displayed instead. The alpha value in thecolor is ignored. Use the [opacity](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#opacity) property to control theopacity of the ground.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#surfaceColor)
     *
     * @default null
     */
    surfaceColor: Color;

    /**
     * Creates a deep clone of this object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#clone)
     *
     *
     */
    clone(): Ground;
    /**
     * Creates an elevation sampler for the given extent by querying the ground layersfor elevation data and caching it so values may be sampled quickly afterwards.The sampler uses the elevation data from the first layer that has data available.For getting elevation data from a specific layer use[ElevationLayer.createElevationSampler()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#createElevationSampler).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#createElevationSampler)
     *
     * @param extent The extent for which to create the sampler.
     * @param options Additional sampler options.
     * @param options.noDataValue The value to use when there is no data available.
     *
     */
    createElevationSampler(extent: Extent, options?: GroundCreateElevationSamplerOptions): IPromise<ElevationSampler>;
    /**
     * Loads all the externally loadable resources associated with the ground.For the ground this will load all the layers.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#loadAll)
     *
     *
     */
    loadAll(): IPromise<Ground>;
    /**
     * Queries the ground layer services for elevation values for the given geometry. Thereturned result contains a copy of the geometry with z-values sampled fromelevation data from the first layer that has data available.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#queryElevation)
     *
     * @param geometry The geometry to sample.
     * @param options Additional query options.
     * @param options.returnSampleInfo Indicates whether to return additional sample informationfor each sampled coordinate.
     * @param options.noDataValue The value that appears in the resulting geometry when thereis no data available.
     *
     */
    queryElevation(
      geometry: Point | Multipoint | Polyline,
      options?: GroundQueryElevationOptions
    ): IPromise<ElevationQueryResult>;
  }

  interface GroundConstructor {
    new (properties?: GroundProperties): Ground;

    fromJSON(json: any): Ground;
  }

  export const Ground: GroundConstructor;

  interface GroundProperties extends LoadableProperties {
    /**
     * A collection of[ElevationLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html)that define the elevation or terrain that makes up the ground surface. When elevation layers are added to theground, the topographical variations of the surface are rendered in 3D as they would appear in the real world.![elev-default](https://developers.arcgis.com/javascript/assets/img/apiref/ground/elev-default.png)When the layers collection is empty, the ground surface is flat.![no-elev](https://developers.arcgis.com/javascript/assets/img/apiref/ground/no-elev.png)
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#layers)
     */
    layers?: CollectionProperties<ElevationLayerProperties>;
    /**
     * Specifies the user navigation constraints relative tothe ground surface.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#navigationConstraint)
     */
    navigationConstraint?: GroundNavigationConstraintProperties;
    /**
     * Opacity of the ground, including surface default color and the basemap (without reference layers).This property can be used for a see-through ground effect.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#opacity)
     *
     * @default 1
     */
    opacity?: number;
    /**
     * The color of the ground surface, displayed underneath the basemap.If this is null, a grid is displayed instead. The alpha value in thecolor is ignored. Use the [opacity](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#opacity) property to control theopacity of the ground.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#surfaceColor)
     *
     * @default null
     */
    surfaceColor?: Color | number[] | string;
  }

  /**
   * Object returned when [queryElevation()](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#queryElevation) promise resolves:
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#ElevationQueryResult)
   */
  export interface ElevationQueryResult extends Object {
    /**
     * The geometry with sampled z-values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#ElevationQueryResult)
     */
    geometry: Point | Multipoint | Polyline;
    /**
     * Contains additional information about how the geometry was sampled.                                  This property is present depending on whether the user set `options.returnSampleInfo = true`,                                  for each coordinate in the geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#ElevationQueryResult)
     */
    sampleInfo?: ElevationQueryResultSampleInfo[];
    /**
     * The value used when there is no data available.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#ElevationQueryResult)
     */
    noDataValue: number;
  }

  export interface GroundCreateElevationSamplerOptions extends Object {
    /**
     * The value to use when there is no data available.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#createElevationSampler)
     *
     * @default 0
     */
    noDataValue?: number;
  }

  export interface GroundNavigationConstraintProperties extends Object {
    /**
     * The type of the constraint. It can be one of the following:Value      | Description-----------|--------------------stay-above | User can only navigate above ground surfacenone       | User can navigate above and below the ground surfaceDefault value: stay-above
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#navigationConstraint)
     */
    type?: string;
  }

  export interface GroundNavigationConstraint extends AnonymousAccessor {
    /**
     * The type of the constraint. It can be one of the following:Value      | Description-----------|--------------------stay-above | User can only navigate above ground surfacenone       | User can navigate above and below the ground surfaceDefault value: stay-above
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#navigationConstraint)
     */
    type: string;
  }

  export interface GroundQueryElevationOptions extends Object {
    /**
     * Indicates whether to return additional sample informationfor each sampled coordinate.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#queryElevation)
     *
     * @default false
     */
    returnSampleInfo?: boolean;
    /**
     * The value that appears in the resulting geometry when thereis no data available.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#queryElevation)
     *
     * @default 0
     */
    noDataValue?: number;
  }

  export interface ElevationQueryResultSampleInfo extends Object {
    /**
     * The resolution at which the z-value was sampled.                                  If no data was available for sampling for a given coordinate,                                  the dem resolution value will be -1 for that coordinate.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#ElevationQueryResult)
     */
    demResolution: number;
    /**
     * The elevation source from which                                  the data for the corresponding coordinate was sampled.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-Ground.html#ElevationQueryResult)
     */
    source: ElevationLayer;
  }

  interface Credential extends Accessor {
    /**
     * Token expiration time specified as number of milliseconds since 1 January 1970 00:00:00 UTC.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#expires)
     */
    expires: number;
    /**
     * Indicates that this credential was created to access the [ArcGIS REST Admin service](https://developers.arcgis.com/rest/services-reference/rest-api-admin.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#isAdmin)
     */
    isAdmin: boolean;
    /**
     * The Identity Manager's[setOAuthRedirectionHandler](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#setOAuthRedirectionHandler)returns an object that contains a `state` property. This information is returned for this property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#oAuthState)
     */
    oAuthState: any;
    /**
     * The server url.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#server)
     */
    server: string;
    /**
     * Indicates whether the resources accessed using this credential should be fetched over HTTPS protocol.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#ssl)
     */
    ssl: boolean;
    /**
     * Token generated by the token service using the specified userId and password.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#token)
     */
    token: string;
    /**
     * User associated with the Credential object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#userId)
     */
    userId: string;

    /**
     * Destroys the credential. When the credential is destroyed, you shouldremove any map layers that are using this credential. Any tokensgenerated via OAuth will automatically be revoked.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#destroy)
     *
     *
     */
    destroy(): void;
    /**
     * Generates a new token and updates the Credential's [token](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#token) property withthe newly acquired token. Tokens are typically kept valid using a timer that automaticallytriggers a refresh before the token expires. Use this method in cases where thetimer has been delayed or stopped.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#refreshToken)
     *
     *
     */
    refreshToken(): void;

    on(name: "token-change", eventHandler: CredentialTokenChangeEventHandler): IHandle;

    on(name: "destroy", eventHandler: CredentialDestroyEventHandler): IHandle;
  }

  interface CredentialConstructor {
    new (properties?: CredentialProperties): Credential;
  }

  export const Credential: CredentialConstructor;

  interface CredentialProperties {
    /**
     * Token expiration time specified as number of milliseconds since 1 January 1970 00:00:00 UTC.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#expires)
     */
    expires?: number;
    /**
     * Indicates that this credential was created to access the [ArcGIS REST Admin service](https://developers.arcgis.com/rest/services-reference/rest-api-admin.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#isAdmin)
     */
    isAdmin?: boolean;
    /**
     * The Identity Manager's[setOAuthRedirectionHandler](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#setOAuthRedirectionHandler)returns an object that contains a `state` property. This information is returned for this property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#oAuthState)
     */
    oAuthState?: any;
    /**
     * The server url.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#server)
     */
    server?: string;
    /**
     * Indicates whether the resources accessed using this credential should be fetched over HTTPS protocol.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#ssl)
     */
    ssl?: boolean;
    /**
     * Token generated by the token service using the specified userId and password.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#token)
     */
    token?: string;
    /**
     * User associated with the Credential object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html#userId)
     */
    userId?: string;
  }

  export interface CredentialDestroyEvent {}

  export interface CredentialTokenChangeEvent {}

  interface IdentityManager extends Evented {
    /**
     * Dialog box widget used to challenge the user for their credentials when the application attempts to access a secure resource. This property is available after the dialog-create event has fired.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#dialog)
     */
    dialog: any;
    /**
     * The suggested lifetime of the token in minutes.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#tokenValidity)
     *
     * @default 60
     */
    tokenValidity: number;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#useSignInPage)
     *
     * @default true
     */
    useSignInPage: boolean;

    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#checkAppAccess)
     *
     * @param resUrl The resource URL.
     * @param appId The registered OAuth application id.
     *
     */
    checkAppAccess(resUrl: string, appId: string): IPromise<any>;
    /**
     * Returns the [Credential](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html) if the user has already signed in to access the given resource. If the user has not signed in, then the promise will be rejected and its error callback will be called.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#checkSignInStatus)
     *
     * @param resUrl The resource URL.
     *
     */
    checkSignInStatus(resUrl: string): IPromise<Credential>;
    /**
     * Destroys all credentials. It is good practice to call this method if workingwith an application that contains sign-out functionality as any tokensgenerated via OAuth will automatically be revoked.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#destroyCredentials)
     *
     *
     */
    destroyCredentials(): void;
    /**
     * Returns the [Credential](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html) for the resource identified by the specified url. Optionally, you can provide a userId to find credentials for a specific user.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#findCredential)
     *
     * @param url The URL to a server.
     * @param userId The userId for which you want to obtain credentials.
     *
     */
    findCredential(url: string, userId?: string): Credential;
    /**
     * Returns the [OAuthInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html) configuration for the passed in Portal server URL.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#findOAuthInfo)
     *
     * @param url The URL to a Portal.
     *
     */
    findOAuthInfo(url: string): OAuthInfo;
    /**
     * Returns information about the server that is hosting the specified URL.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#findServerinfo)
     *
     * @param url The URL to the server
     *
     */
    findServerinfo(url: string): ServerInfo;
    /**
     * Returns an object containing a token and its expiration time. It is necessary to provide the [ServerInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-ServerInfo.html) object that contains a token service URL and a user info object containing username and password. This is a helper method typically called by sub-classes to generate tokens.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#generateToken)
     *
     * @param serverInfo A ServerInfo object that contains a token service URL.
     * @param userInfo A user info object containing a user name and password.
     * @param options See the table below for the structure of this object.
     * @param options.serverUrl The server URL.
     * @param options.token The server token.
     * @param options.ssl Indicates if the server requires SSL.
     *
     */
    generateToken(serverInfo: ServerInfo, userInfo: any, options?: IdentityManagerGenerateTokenOptions): IPromise<any>;
    /**
     * Returns a [Credential](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-Credential.html) object that can be used to access the secured resource identified by the input URL.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#getCredential)
     *
     * @param url The URL for the secure resource
     * @param options See the table below for the structure of the **options** object.
     * @param options.error Error object returned by the server from a previous attempt to fetch the given URL.
     * @param options.oAuthPopupConfirmation If set to *false*, the user will not be shown a dialog before the OAuth popup window is opened.
     * @param options.token Token used for a previous unsuccessful attempt to fetch the given URL.
     *
     */
    getCredential(url: string, options?: IdentityManagerGetCredentialOptions): IPromise<Credential>;
    /**
     * Call this method during application initialization with the JSON previously obtained from the [toJSON()](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#toJSON) method used to re-hydrate the state of IdentityManager.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#initialize)
     *
     * @param json The JSON obtained from the [toJSON()](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#toJSON) method.
     *
     */
    initialize(json: any): void;
    /**
     * Indicates if the IdentityManager is busy accepting user input. For example, it returns `true` if the user has invoked [signIn](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#signIn) and is waiting for a response.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#isBusy)
     *
     *
     */
    isBusy(): boolean;
    /**
     * Registers OAuth 2.0 configurations.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#registerOAuthInfos)
     *
     * @param oAuthInfos An array of OAuthInfo objects that defines the OAuth configurations.
     *
     */
    registerOAuthInfos(oAuthInfos: OAuthInfo[]): void;
    /**
     * Register secure servers and the token endpoints.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#registerServers)
     *
     * @param serverInfos An array of ServerInfos objects that defines the secure service and token endpoint. The IdentityManager makes its best guess to determine the location of the secure server and token endpoint. Therefore, in most cases calling this method is not necessary. However, if the location of your server or token endpoint is not standard, use this method to register the location.
     *
     */
    registerServers(serverInfos: ServerInfo[]): void;
    /**
     * Registers the given OAuth 2.0 access token or ArcGIS Server token with the IdentityManager.See [registerOAuthInfos](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#registerOAuthInfos) for additional information.The `registerToken` method is an advanced workflow for pre-registering long-term tokens for when you don't want users to sign in.See also [resource-proxy](https://github.com/Esri/resource-proxy) for another workflow to achieve this result.Once a user logs in, the access token is registered with the IdentityManager. Subsequently, every AJAX request madeby the application forwards this token when accessing web maps and other items stored in ArcGIS Online,or resources on your server.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#registerToken)
     *
     * @param properties See the table below for the structure of the **properties** object.
     * @param properties.expires Token expiration time specified as number of milliseconds since 1 January 1970 00:00:00 UTC.
     * @param properties.server For ArcGIS Online or Portal, this is https://www.arcgis.com/sharing/rest or similar to https://www.example.com/portal/sharing/rest.                                    For ArcGIS Server this is similar to https://www.example.com/arcgis/rest/services.
     * @param properties.ssl Set this to `true` if the user has an ArcGIS Online organizational account and the organization is configured to allow access to resources only through SSL.
     * @param properties.token The access token.
     * @param properties.userId The id of the user who owns the access token.
     *
     */
    registerToken(properties: IdentityManagerRegisterTokenProperties): void;
    /**
     * Once a user successfully logs in, they are redirected back to the application. Use this method ifthe application needs to execute custom logic before the page is redirected. The IdentityManagercalls the custom handler function with an object containing redirection properties.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#setOAuthRedirectionHandler)
     *
     * @param handlerFunction When called,the callback passed to `setOAuthRedirectionHandler` receives an object containing the redirectionproperties.
     *
     */
    setOAuthRedirectionHandler(handlerFunction: HandlerCallback): void;
    /**
     * Use this method in the popup callback page to pass the token and other values back to the IdentityManager.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#setOAuthResponseHash)
     *
     * @param hash The token information in addition to any other values needed to be passed back to the IdentityManager.
     *
     */
    setOAuthResponseHash(hash: string): void;
    /**
     * When accessing secured resources, the IdentityManager may prompt for username and password and send them to the server using a secure connection. Due to potential browser limitations, it may not be possible to establish a secure connection with the server if the application is being run over HTTP protocol. In such cases, the Identity Manager will abort the request to fetch the secured resource.To resolve this issue, configure your web application server with HTTPS support and run the application over HTTPS. This is the recommended solution for production environments. However, for internal development environments that don't have HTTPS support, you can define a protocol error handler that allows the Identity Manager to continue with the process over HTTP protocol.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#setProtocolErrorHandler)
     *
     * @param handlerFunction The function to call when the protocol is mismatched.
     * @param handlerFunction.resourceUrl The secure resource URL.
     * @param handlerFunction.serverInfo ServerInfo object describing the server where the secure resource is hosted.
     *
     */
    setProtocolErrorHandler(handlerFunction: IdentityManagerSetProtocolErrorHandlerHandlerFunction): void;
    /**
     * If your application is on the same domain as *.arcgis.com or ArcGIS Enterprise Server,the IdentityManager will redirect the user to its sign-in page.For instance, let's say an application accesses secure resources from ArcGIS.comor one of its subdomains. Once the application attempts to access this resource,the IdentityManager redirects the user to the ArcGIS.com sign-in page. Once a usersuccessfully logs in, they are redirected back to the application. The sameholds true if the application accesses secure resources from ArcGIS Enterprise asthe IdentityManager will redirect the user to its sign-in page. Use this method ifthe application needs to execute custom logic before the page is redirected by creatinga custom redirection handler. The IdentityManager calls the custom handler function withan object containing the redirection properties.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#setRedirectionHandler)
     *
     * @param handlerFunction The function passed to setRedirectionHandler receives an object containing redirection properties. These properties are listed in the table below.
     * @param handlerFunction.resourceUrl The URL of the secure resource that triggers the redirection to the ArcGIS.com sign-in page.
     * @param handlerFunction.returnUrlParamName The application URL where the sign-in page redirects after a successful login. To create the return URL, append the application's URL to signInPage as a parameter. The *returnUrlParamName* contains the name of the parameter.
     * @param handlerFunction.serverInfo The ServerInfo object describing the server where the secure resource is hosted.
     * @param handlerFunction.signInPage URL of the sign-in page where users will be redirected.
     *
     */
    setRedirectionHandler(handlerFunction: IdentityManagerSetRedirectionHandlerHandlerFunction): void;
    /**
     * Return properties of this object in JSON format. It can be stored in a cookie or persisted in HTML5 LocalStorage and later used to:* Initialize the IdentityManager the next time a user opens your application.* Share the state of the IdentityManager between multiple web pages of your website.This way users will not be asked to sign in repeatedly when they launch your app multiple times or when navigating between multiple web pages in your website.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#toJSON)
     *
     *
     */
    toJSON(): any;
  }

  interface IdentityManagerConstructor {
    new (): IdentityManager;
  }

  export const IdentityManager: IdentityManagerConstructor;

  export type HandlerCallback = (
    authorizeParams: any,
    authorizeUrl: string,
    oAuthInfo: OAuthInfo,
    resourceUrl: string,
    serverInfo: ServerInfo
  ) => void;

  export interface IdentityManagerGenerateTokenOptions extends Object {
    /**
     * The server URL.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#generateToken)
     */
    serverUrl: string;
    /**
     * The server token.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#generateToken)
     */
    token: string;
    /**
     * Indicates if the server requires SSL.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#generateToken)
     */
    ssl: boolean;
  }

  export interface IdentityManagerGetCredentialOptions extends Object {
    /**
     * Error object returned by the server from a previous attempt to fetch the given URL.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#getCredential)
     */
    error?: Error;
    /**
     * If set to *false*, the user will not be shown a dialog before the OAuth popup window is opened.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#getCredential)
     *
     * @default true
     */
    oAuthPopupConfirmation?: boolean;
    /**
     * Token used for a previous unsuccessful attempt to fetch the given URL.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#getCredential)
     */
    token?: string;
  }

  export interface IdentityManagerRegisterTokenProperties extends Object {
    /**
     * Token expiration time specified as number of milliseconds since 1 January 1970 00:00:00 UTC.
     *
     * [Read more...](properties.html)
     */
    expires?: number;
    /**
     * For ArcGIS Online or Portal, this is https://www.arcgis.com/sharing/rest or similar to https://www.example.com/portal/sharing/rest.                                    For ArcGIS Server this is similar to https://www.example.com/arcgis/rest/services.
     *
     * [Read more...](properties.html)
     */
    server: string;
    /**
     * Set this to `true` if the user has an ArcGIS Online organizational account and the organization is configured to allow access to resources only through SSL.
     *
     * [Read more...](properties.html)
     */
    ssl?: boolean;
    /**
     * The access token.
     *
     * [Read more...](properties.html)
     */
    token: string;
    /**
     * The id of the user who owns the access token.
     *
     * [Read more...](properties.html)
     */
    userId?: string;
  }

  export interface IdentityManagerSetProtocolErrorHandlerHandlerFunction extends Object {
    /**
     * The secure resource URL.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#setProtocolErrorHandler)
     */
    resourceUrl: string;
    /**
     * ServerInfo object describing the server where the secure resource is hosted.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#setProtocolErrorHandler)
     */
    serverInfo: ServerInfo;
  }

  export interface IdentityManagerSetRedirectionHandlerHandlerFunction extends Object {
    /**
     * The URL of the secure resource that triggers the redirection to the ArcGIS.com sign-in page.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#setRedirectionHandler)
     */
    resourceUrl: string;
    /**
     * The application URL where the sign-in page redirects after a successful login. To create the return URL, append the application's URL to signInPage as a parameter. The *returnUrlParamName* contains the name of the parameter.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#setRedirectionHandler)
     */
    returnUrlParamName: string;
    /**
     * The ServerInfo object describing the server where the secure resource is hosted.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#setRedirectionHandler)
     */
    serverInfo: ServerInfo;
    /**
     * URL of the sign-in page where users will be redirected.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-IdentityManager.html#setRedirectionHandler)
     */
    signInPage: string;
  }

  interface OAuthInfo extends Accessor, JSONSupport {
    /**
     * The registered application id.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#appId)
     */
    appId: string;
    /**
     * Applications with the same value will share the stored token on the same host.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#authNamespace)
     *
     * @default / (forward slash)
     */
    authNamespace: string;
    /**
     * The number of minutes that the token is valid.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#expiration)
     *
     * @default 20160 (two weeks)
     */
    expiration: number;
    /**
     * The locale for the OAuth sign in page. The default localeis based on your browser/OS and the organization locale.You can use the locale property to changethis. The locale needs to follow the language dash country codesyntax supported by ArcGIS.com.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#locale)
     *
     * @default Based on your browser/OS and the organization locale.
     */
    locale: string;
    /**
     * The minimum time in minutes before a saved token is due to expire thatit should still be considered valid for use.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#minTimeUntilExpiration)
     *
     * @default 30
     */
    minTimeUntilExpiration: number;
    /**
     * Set to `true` to show the OAuth sign in page in a popup window.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#popup)
     *
     * @default false
     */
    popup: boolean;
    /**
     * Applicable if working with the popup user-login workflow.This is a relative page URL that redirects the user back tothe secured application after successful login.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#popupCallbackUrl)
     *
     * @default "oauth-callback.html"
     */
    popupCallbackUrl: string;
    /**
     * The window features passed to[window.open()](https://developer.mozilla.org/en-US/docs/Web/API/Window/open).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#popupWindowFeatures)
     *
     * @default height=490,width=800,resizable,scrollbars,status
     */
    popupWindowFeatures: string;
    /**
     * The ArcGIS Enterprise portal URL.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#portalUrl)
     *
     * @default "https://www.arcgis.com"
     */
    portalUrl: string;

    /**
     * Creates a copy of the OAuthInfo object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#clone)
     *
     *
     */
    clone(): OAuthInfo;
  }

  interface OAuthInfoConstructor {
    new (properties?: OAuthInfoProperties): OAuthInfo;

    fromJSON(json: any): OAuthInfo;
  }

  export const OAuthInfo: OAuthInfoConstructor;

  interface OAuthInfoProperties {
    /**
     * The registered application id.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#appId)
     */
    appId?: string;
    /**
     * Applications with the same value will share the stored token on the same host.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#authNamespace)
     *
     * @default / (forward slash)
     */
    authNamespace?: string;
    /**
     * The number of minutes that the token is valid.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#expiration)
     *
     * @default 20160 (two weeks)
     */
    expiration?: number;
    /**
     * The locale for the OAuth sign in page. The default localeis based on your browser/OS and the organization locale.You can use the locale property to changethis. The locale needs to follow the language dash country codesyntax supported by ArcGIS.com.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#locale)
     *
     * @default Based on your browser/OS and the organization locale.
     */
    locale?: string;
    /**
     * The minimum time in minutes before a saved token is due to expire thatit should still be considered valid for use.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#minTimeUntilExpiration)
     *
     * @default 30
     */
    minTimeUntilExpiration?: number;
    /**
     * Set to `true` to show the OAuth sign in page in a popup window.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#popup)
     *
     * @default false
     */
    popup?: boolean;
    /**
     * Applicable if working with the popup user-login workflow.This is a relative page URL that redirects the user back tothe secured application after successful login.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#popupCallbackUrl)
     *
     * @default "oauth-callback.html"
     */
    popupCallbackUrl?: string;
    /**
     * The window features passed to[window.open()](https://developer.mozilla.org/en-US/docs/Web/API/Window/open).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#popupWindowFeatures)
     *
     * @default height=490,width=800,resizable,scrollbars,status
     */
    popupWindowFeatures?: string;
    /**
     * The ArcGIS Enterprise portal URL.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-OAuthInfo.html#portalUrl)
     *
     * @default "https://www.arcgis.com"
     */
    portalUrl?: string;
  }

  interface ServerInfo extends Accessor, JSONSupport {
    /**
     * The token service URL used to generate tokens for ArcGIS Server Admin resources.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-ServerInfo.html#adminTokenServiceUrl)
     */
    adminTokenServiceUrl: string;
    /**
     * Version of the ArcGIS Server deployed on this server.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-ServerInfo.html#currentVersion)
     */
    currentVersion: number;
    /**
     * The server URL.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-ServerInfo.html#server)
     */
    server: string;
    /**
     * Validity of short-lived token in minutes.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-ServerInfo.html#shortLivedTokenValidity)
     */
    shortLivedTokenValidity: number;
    /**
     * The token service URL used to generate tokens for the secured resources on the server.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-ServerInfo.html#tokenServiceUrl)
     */
    tokenServiceUrl: string;
  }

  interface ServerInfoConstructor {
    new (properties?: ServerInfoProperties): ServerInfo;

    fromJSON(json: any): ServerInfo;
  }

  export const ServerInfo: ServerInfoConstructor;

  interface ServerInfoProperties {
    /**
     * The token service URL used to generate tokens for ArcGIS Server Admin resources.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-ServerInfo.html#adminTokenServiceUrl)
     */
    adminTokenServiceUrl?: string;
    /**
     * Version of the ArcGIS Server deployed on this server.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-ServerInfo.html#currentVersion)
     */
    currentVersion?: number;
    /**
     * The server URL.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-ServerInfo.html#server)
     */
    server?: string;
    /**
     * Validity of short-lived token in minutes.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-ServerInfo.html#shortLivedTokenValidity)
     */
    shortLivedTokenValidity?: number;
    /**
     * The token service URL used to generate tokens for the secured resources on the server.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-identity-ServerInfo.html#tokenServiceUrl)
     */
    tokenServiceUrl?: string;
  }

  interface intl {
    /**
     * Converts a [web map date format string](https://developers.arcgis.com/web-map-specification/objects/format/) to an [Intl.DateTimeFormat](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat#Parameters) options object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#convertDateFormatToIntlOptions)
     *
     * @param format A web map date format string to convert.**Possible Values**: short-date | short-date-short-time | short-date-short-time-24 | short-date-long-time | short-date-long-time-24 | short-date-le | short-date-le-short-time | short-date-le-short-time-24 | short-date-le-long-time | short-date-le-long-time-24 | long-month-day-year | long-month-day-year-short-time | long-month-day-year-short-time-24 | long-month-day-year-long-time | long-month-day-year-long-time-24 | day-short-month-year | day-short-month-year-short-time | day-short-month-year-short-time-24 | day-short-month-year-long-time | day-short-month-year-long-time-24 | long-date | long-date-short-time | long-date-short-time-24 | long-date-long-time | long-date-long-time-24 | long-month-year | short-month-year | year | short-time | long-time
     *
     */
    convertDateFormatToIntlOptions(format?: string): Intl.DateTimeFormatOptions;
    /**
     * Converts a [NumberFormat](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#NumberFormat) to an [Intl.NumberFormatOptions](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat#Parameters) object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#convertNumberFormatToIntlOptions)
     *
     * @param format The [NumberFormat](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#NumberFormat) to convert.
     *
     */
    convertNumberFormatToIntlOptions(format?: NumberFormat): Intl.NumberFormatOptions;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#formatDate)
     *
     * @param value The [Date](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date) object, or the number of milliseconds elapsed since January 1, 1970 00:00:00 UTC, to be formatted.
     * @param formatOptions Date format options.
     *
     */
    formatDate(value: Date | number, formatOptions?: Intl.DateTimeFormatOptions): string;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#formatNumber)
     *
     * @param value Number to be formatted.
     * @param formatOptions Number format options.
     *
     */
    formatNumber(value: number, formatOptions?: Intl.NumberFormatOptions): string;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#substitute)
     *
     * @param template Template string to use for substitution.
     * @param data Data object to be substituted.
     * @param options Options for determining how to substitute keys in the template string.
     *
     */
    substitute(template: string, data: any, options?: SubstituteOptions): string;
  }

  export const intl: intl;

  /**
   * The Web map definition for formatting numbers.  This provides more detail about how a number value should be displayed.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#NumberFormat)
   */
  export interface NumberFormat extends Object {
    /**
     * Indicates if the number should be formatted with a thousands separator.  This is equivalent to [`useGrouping`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat#Parameters).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#NumberFormat)
     */
    digitSeparator?: boolean;
    /**
     * Specifies the number of decimal places that should appear in the formatted number.  Any places beyond this value are rounded.  This is equivalent to defining [`minimumFractionDigits`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat#Parameters)  and [`maximumFractionDigits`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat#Parameters).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#NumberFormat)
     */
    places?: number;
  }

  /**
   * The formatting options for date values.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#SubstituteDateTimeFormatOptions)
   */
  export interface SubstituteDateTimeFormatOptions extends Object {
    /**
     * The type of this format. The value is always `"date"`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#SubstituteDateTimeFormatOptions)
     */
    type: "date";
    /**
     * The date format options for the [Intl.DateTimeFormat](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat) object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#SubstituteDateTimeFormatOptions)
     */
    intlOptions: Intl.DateTimeFormatOptions;
  }

  /**
   * The formatting options for numeric values.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#SubstituteNumberFormatOptions)
   */
  export interface SubstituteNumberFormatOptions extends Object {
    /**
     * The type of this format. The value is always `"number"`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#SubstituteNumberFormatOptions)
     */
    type: "number";
    /**
     * The Intl number format options for the [Intl.NumberFormat](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NumberFormat) object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#SubstituteNumberFormatOptions)
     */
    intlOptions: Intl.NumberFormatOptions;
  }

  /**
   * An object to specify substitution options.Use the format property to define the formatting for each value referenced in the string template.`format` is a key-value pair object. Each key can either be:  - a property of the `data` parameter or [`substitute()`](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#substitute)  - a named formatter than can be referenced in the template string.In the following example, the `time` property from `data` will be formatted as a date with each component in numeric format.```jsconst data = {  time: Date.now()};intl.substitute("Date: {time}", data, {  format: {    time: {      type: "date",      intlOptions: {        year: "numeric",        month: "numeric",        day: "numeric",        hour: "numeric",        minute: "numeric"      }    }  }});```The following example uses a named formatter to format the `time` property twice with different formatting options.```jsconst data = {  time: Date.now()};intl.substitute("In {time:monthFormat} of {time:yearFormat}", data, {  format: {    monthFormat: {      type: "date",      intlOptions: {        month: "long"      }    },    yearFormat: {      type: "date",      intlOptions: {        year: "numeric"      }    }  }});```
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#SubstituteOptions)
   */
  export interface SubstituteOptions extends Object {
    /**
     * A hashmap of string keys to formatting options.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-intl.html#SubstituteOptions)
     */
    format: HashMap<SubstituteDateTimeFormatOptions | SubstituteNumberFormatOptions>;
  }

  interface kernel {
    /**
     * Current version of the ArcGIS API for JavaScript.```jsrequire([  "esri/kernel"], function(esriNS) {  console.log(esriNS.version);});```
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-kernel.html#version)
     */
    readonly version: string;
  }

  export const kernel: kernel;

  interface BaseDynamicLayer extends Layer, ScaleRangeLayer, RefreshableLayer {
    /**
     * Adds a promise to the layer's [loadable](https://developers.arcgis.com/javascript/latest/guide/loadable/index.html) chain.This is typically used in the [load()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseDynamicLayer.html#load) method to ensure that all[loadable](https://developers.arcgis.com/javascript/latest/guide/loadable/index.html) resources required for the layerto function are loaded prior to this layer resolving and becoming [loaded](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseDynamicLayer.html#loaded).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseDynamicLayer.html#addResolvingPromise)
     *
     * @param promiseToLoad A promise that must resolve for the layer  to resolve and move from the `loading` [status](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseDynamicLayer.html#loadStatus) to being  [loaded](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseDynamicLayer.html#loaded).
     *
     */
    addResolvingPromise(promiseToLoad: IPromise<any>): IPromise<any>;
    /**
     * This method fetches the image for the specified extent and size. Override this method if the data returnedfrom the server needs to be processed before it can be displayed. For example, if the server returns binarydata, override this method to convert the binary data to an image.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseDynamicLayer.html#fetchImage)
     *
     * @param extent The extent of the view. This value is provided by the [LayerView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-LayerView.html).
     * @param width The width of the view in pixels. This value is provided by the [LayerView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-LayerView.html).
     * @param height The height of the view in pixels. This value is provided by the [LayerView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-LayerView.html).
     * @param options The parameter options is an object with the following properties.
     * @param options.signal An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     */
    fetchImage(
      extent: Extent,
      width: number,
      height: number,
      options?: BaseDynamicLayerFetchImageOptions
    ): IPromise<HTMLImageElement | HTMLCanvasElement>;
    /**
     * This method returns a URL to an image for a given extent, width, and height.Override this method to construct the URL for the image based on user interaction.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseDynamicLayer.html#getImageUrl)
     *
     * @param extent Extent of the view. This value is populated by the [LayerView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-LayerView.html).
     * @param width Width of the view in pixels. This value is populated by the [LayerView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-LayerView.html).
     * @param height Height of the view in pixels. This value is populated by the [LayerView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-LayerView.html).
     *
     */
    getImageUrl(extent: Extent, width: number, height: number): IPromise<string> | string;

    on(name: "layerview-create", eventHandler: BaseDynamicLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: BaseDynamicLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: BaseDynamicLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface BaseDynamicLayerConstructor {
    new (properties?: BaseDynamicLayerProperties): BaseDynamicLayer;
  }

  export const BaseDynamicLayer: BaseDynamicLayerConstructor;

  interface BaseDynamicLayerProperties extends LayerProperties, ScaleRangeLayerProperties, RefreshableLayerProperties {}

  export interface BaseDynamicLayerFetchImageOptions extends Object {
    /**
     * An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseDynamicLayer.html#fetchImage)
     */
    signal?: AbortSignal;
  }

  export interface BaseDynamicLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface BaseDynamicLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface BaseDynamicLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface BaseElevationLayer extends Layer {
    /**
     * The spatial reference of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#spatialReference)
     *
     * @default {@link module:esri/geometry/SpatialReference#WebMercator SpatialReference.WebMercator}
     */
    spatialReference: SpatialReference;
    /**
     * The tiling scheme information for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#tileInfo)
     */
    tileInfo: TileInfo;

    /**
     * Adds a promise to the layer's [loadable](https://developers.arcgis.com/javascript/latest/guide/loadable/index.html) chain.This is typically used in the [load()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#load) method to ensure that all[loadable](https://developers.arcgis.com/javascript/latest/guide/loadable/index.html) resources required for the layerto function are loaded prior to this layer resolving and becoming [loaded](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#loaded).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#addResolvingPromise)
     *
     * @param promiseToLoad A promise that must resolve for the layer  to resolve and move from the `loading` [status](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#loadStatus) to being  [loaded](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#loaded).
     *
     */
    addResolvingPromise(promiseToLoad: IPromise<any>): IPromise<any>;
    /**
     * Creates an elevation sampler for the given [Extent](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html) by querying the service layerfor elevation data and caching it so values may be sampled quickly afterwards. The resolutionof the cached data can be set using the `demResolution` option. In many cases, `auto`demResolution can be used to get high quality elevation samples without theneed to know exactly where the data in the service is located.This is particularly useful for services which combineelevation data from many sources (such as the world elevation service).If more control, or higher quality samples are required, use either`finest-contiguous` or a fixed `{number}` resolution.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#createElevationSampler)
     *
     * @param extent The extent for which to create the sampler.
     * @param options Additional query options. See the table below.
     * @param options.demResolution Controls the horizontal resolution (cell size) in meters from which elevation data is sampled (defaults to `auto`). See [ElevationLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#queryElevation)for more details.
     * @param options.noDataValue The value to use when there is no data available.
     *
     */
    createElevationSampler(
      extent: Extent,
      options?: BaseElevationLayerCreateElevationSamplerOptions
    ): IPromise<ElevationSampler>;
    /**
     * Fetches a tile at the given level, row, and column present in the view.This method must be overwritten to display custom elevation values in the[Map.ground](https://developers.arcgis.com/javascript/latest/api-reference/esri-Map.html#ground). Note that this method must returna promise that resolves to an object with the properties defined in[ElevationTileData](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#ElevationTileData).See the following samples forexamples of how to overwrite this method:* [Sample - Custom ElevationLayer: Exaggerating elevation](https://developers.arcgis.com/javascript/latest/sample-code/layers-custom-elevation-exaggerated/index.html)* [Sample - Custom ElevationLayer: Thematic data as elevation](https://developers.arcgis.com/javascript/latest/sample-code/layers-custom-elevation-thematic/index.html)
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#fetchTile)
     *
     * @param level The level of detail of the tile to fetch.
     * @param row The row (y) position of the tile to fetch.
     * @param column The column (x) position of the tile to fetch.
     * @param options Optional settings for the tile request.
     * @param options.noDataValue The value representing pixels  in the tile that don't contain an elevation value.
     * @param options.signal An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     */
    fetchTile(
      level: number,
      row: number,
      column: number,
      options?: BaseElevationLayerFetchTileOptions
    ): IPromise<ElevationTileData>;
    /**
     * Returns the bounds of the tile as an array of four numbers that canbe readily converted to an [Extent](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html) object.See the table in the `returns` section below for more details about thevalues returned by this method.This function can be used inside [fetchTile()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#fetchTile) so you can get thebounds of the current tile, convert it to an extent object, and requestthe desired data for the given extent. See the[Custom ElevationLayer: Thematic data as elevation](https://developers.arcgis.com/javascript/latest/sample-code/layers-custom-elevation-thematic/index.html) sample for an example of how this method works.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#getTileBounds)
     *
     * @param level The level of detail (LOD) of the tile.
     * @param row The tile's row (y) position in the dataset.
     * @param column The tiles column (x) position in the dataset.
     * @param out Array for storing the tile bounds or extent.
     *
     */
    getTileBounds(level: number, row: number, column: number, out?: number[]): number[];
    /**
     * Queries the service layer for elevation values for the given geometry. Thereturned result contains a copy of the geometry with z-values sampled fromelevation data from the service. The resolution from which the elevation isqueried can be set using the `demResolution` option. In many cases, `auto`demResolution can be used to get high quality elevation samples without theneed to know exactly where the data in the service is located.This is particularly useful for services which combineelevation data from many sources (such as the world elevation service).If more control, or higher quality samples are required, use either`finest-contiguous` or a fixed `{number}` resolution.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#queryElevation)
     *
     * @param geometry The geometry to use for sampling elevation data.
     * @param options Additional query options. See the table below.
     * @param options.demResolution Controls the horizontal resolution (cell size)  in meters from which elevation data is sampled (defaults to `auto`). See the table below formore details on the different settings.demResolution          | Description-----------------------|-------------`auto`                 | Automatically chooses an appropriate resolution for each coordinate of the input geometry. The current implementation will try to use the finest available resolution given that the total required number of tile requests does not exceed a certain maximum amount (currently 20). Note that this may result in values being sampled from different resolutions.`finest-contiguous`    | Sample elevation from the finest available resolution (cell size) across the entire geometry.`{number}`             | Sample elevation from the resolution closest to the specified resolution (in meters).
     * @param options.returnSampleInfo Indicates whether to return additional sample informationfor each coordinate.
     * @param options.noDataValue The value to use when there is no data available.
     *
     */
    queryElevation(
      geometry: Point | Multipoint | Polyline,
      options?: BaseElevationLayerQueryElevationOptions
    ): IPromise<ElevationLayerElevationQueryResult>;

    on(name: "layerview-create", eventHandler: BaseElevationLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: BaseElevationLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: BaseElevationLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface BaseElevationLayerConstructor {
    new (properties?: BaseElevationLayerProperties): BaseElevationLayer;
  }

  export const BaseElevationLayer: BaseElevationLayerConstructor;

  interface BaseElevationLayerProperties extends LayerProperties {
    /**
     * The spatial reference of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#spatialReference)
     *
     * @default {@link module:esri/geometry/SpatialReference#WebMercator SpatialReference.WebMercator}
     */
    spatialReference?: SpatialReferenceProperties;
    /**
     * The tiling scheme information for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#tileInfo)
     */
    tileInfo?: TileInfoProperties;
  }

  export interface BaseElevationLayerCreateElevationSamplerOptions extends Object {
    /**
     * Controls the horizontal resolution (cell size) in meters from which elevation data is sampled (defaults to `auto`). See [ElevationLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#queryElevation)for more details.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#createElevationSampler)
     *
     * @default auto
     */
    demResolution?: number | string;
    /**
     * The value to use when there is no data available.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#createElevationSampler)
     *
     * @default 0
     */
    noDataValue?: number;
  }

  export interface BaseElevationLayerFetchTileOptions extends Object {
    /**
     * The value representing pixels  in the tile that don't contain an elevation value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#fetchTile)
     */
    noDataValue?: number;
    /**
     * An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#fetchTile)
     */
    signal?: AbortSignal;
  }

  export interface BaseElevationLayerQueryElevationOptions extends Object {
    /**
     * Controls the horizontal resolution (cell size)  in meters from which elevation data is sampled (defaults to `auto`). See the table below formore details on the different settings.demResolution          | Description-----------------------|-------------`auto`                 | Automatically chooses an appropriate resolution for each coordinate of the input geometry. The current implementation will try to use the finest available resolution given that the total required number of tile requests does not exceed a certain maximum amount (currently 20). Note that this may result in values being sampled from different resolutions.`finest-contiguous`    | Sample elevation from the finest available resolution (cell size) across the entire geometry.`{number}`             | Sample elevation from the resolution closest to the specified resolution (in meters).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#queryElevation)
     *
     * @default auto
     */
    demResolution?: number | string;
    /**
     * Indicates whether to return additional sample informationfor each coordinate.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#queryElevation)
     *
     * @default false
     */
    returnSampleInfo?: boolean;
    /**
     * The value to use when there is no data available.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#queryElevation)
     *
     * @default 0
     */
    noDataValue?: number;
  }

  /**
   * Describes elevation contained in the pixels that comprisean elevation tile.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#ElevationTileData)
   */
  export interface ElevationTileData extends Object {
    /**
     * The elevation values of each pixel in the tile.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#ElevationTileData)
     */
    values: number[];
    /**
     * The width of the tile in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#ElevationTileData)
     */
    width: number;
    /**
     * The height of the tile in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#ElevationTileData)
     */
    height: number;
    /**
     * The maximum allowed error of the Z-value for each  value in meters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#ElevationTileData)
     */
    maxZError: number;
    /**
     * Indicating the pixel values where no  elevation data is present.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseElevationLayer.html#ElevationTileData)
     */
    noDataValue: number;
  }

  export interface BaseElevationLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface BaseElevationLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface BaseElevationLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface BaseTileLayer extends Layer, ScaleRangeLayer, RefreshableLayer {
    /**
     * The spatial reference of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#spatialReference)
     *
     * @default {@link module:esri/geometry/SpatialReference#WebMercator SpatialReference.WebMercator}
     */
    spatialReference: SpatialReference;
    /**
     * The tiling scheme information for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#tileInfo)
     */
    tileInfo: TileInfo;

    /**
     * Adds a promise to the layer's [loadable](https://developers.arcgis.com/javascript/latest/guide/loadable/index.html) chain.This is typically used in the [load()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#load) method to ensure that all[loadable](https://developers.arcgis.com/javascript/latest/guide/loadable/index.html) resources required for the layerto function are loaded prior to this layer resolving and becoming [loaded](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#loaded).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#addResolvingPromise)
     *
     * @param promiseToLoad A promise that must resolve for the layer  to resolve and move from the `loading` [status](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#loadStatus) to being  [loaded](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#loaded).
     *
     */
    addResolvingPromise(promiseToLoad: IPromise<any>): IPromise<any>;
    /**
     * This method fetches a tile for the given level, row and column present in the view. Override this method if the data or imagereturned from the server needs to be processed before it can be displayed.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#fetchTile)
     *
     * @param level Level of detail of the tile to fetch. This value is provided by [LayerView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-LayerView.html).
     * @param row The row (y) position of the tile fetch. This value is provided by [LayerView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-LayerView.html).
     * @param col The column (x) position of the tile to fetch. This value is provided by [LayerView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-LayerView.html).
     * @param options Optional settings for the tile request. The options have the following properties.
     * @param options.timestamp Number to append to the tile request to prevent fetching the tile from the browser cache.
     * @param options.signal An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     */
    fetchTile(
      level: number,
      row: number,
      col: number,
      options?: BaseTileLayerFetchTileOptions
    ): IPromise<HTMLImageElement | HTMLCanvasElement>;
    /**
     * Returns the bounds of the tile as an array of four numbers that be readilyconverted to an [Extent](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html) object.The value for each item in the array is described in the following table:Index | Value------|------0 | Minimum x-value1 | Minimum y-value2 | Maximum x-value3 | Maximum y-value
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#getTileBounds)
     *
     * @param level The level of detail (LOD) of the tile.
     * @param row The tile's row (y) position in the dataset.
     * @param column The tiles column (x) position in the dataset.
     * @param out Array for storing the tile bounds or extent.
     *
     */
    getTileBounds(level: number, row: number, column: number, out?: number[]): number[];
    /**
     * This method returns a URL to an image for a given level, row and column.Override this method to construct the URL for the image based on user interaction.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#getTileUrl)
     *
     * @param level Level of detail. This value is provided by the  [LayerView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-LayerView.html).
     * @param row Tile row. This value is provided by the  [LayerView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-LayerView.html).
     * @param col Tile column. This value is provided by the  [LayerView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-LayerView.html).
     *
     */
    getTileUrl(level: number, row: number, col: number): string;

    on(name: "layerview-create", eventHandler: BaseTileLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: BaseTileLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: BaseTileLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface BaseTileLayerConstructor {
    new (properties?: BaseTileLayerProperties): BaseTileLayer;
  }

  export const BaseTileLayer: BaseTileLayerConstructor;

  interface BaseTileLayerProperties extends LayerProperties, ScaleRangeLayerProperties, RefreshableLayerProperties {
    /**
     * The spatial reference of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#spatialReference)
     *
     * @default {@link module:esri/geometry/SpatialReference#WebMercator SpatialReference.WebMercator}
     */
    spatialReference?: SpatialReferenceProperties;
    /**
     * The tiling scheme information for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#tileInfo)
     */
    tileInfo?: TileInfoProperties;
  }

  export interface BaseTileLayerFetchTileOptions extends Object {
    /**
     * Number to append to the tile request to prevent fetching the tile from the browser cache.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#fetchTile)
     */
    timestamp?: boolean;
    /**
     * An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BaseTileLayer.html#fetchTile)
     */
    signal?: AbortSignal;
  }

  export interface BaseTileLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface BaseTileLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface BaseTileLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface BingMapsLayer extends BaseTileLayer {
    /**
     * Expose Bing logo url.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BingMapsLayer.html#bingLogo)
     */
    readonly bingLogo: string;
    /**
     * Copyright information.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BingMapsLayer.html#copyright)
     */
    readonly copyright: string;
    /**
     * Provides culture specific map labels. For more information visit:https://msdn.microsoft.com/en-us/library/ff701709.aspxFor a list of supported culture codes please visit:https://msdn.microsoft.com/en-us/library/hh441729.aspx
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BingMapsLayer.html#culture)
     *
     * @default "en-US"
     */
    culture: string;
    /**
     * Indicates if the layer has attribution data.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BingMapsLayer.html#hasAttributionData)
     */
    readonly hasAttributionData: boolean;
    /**
     * Bing Maps Key.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BingMapsLayer.html#key)
     *
     * @default null
     */
    key: string;
    /**
     * This will alter Geopolitical disputed borders and labels to align with the specified user region.For more information on Bing's region setting please visit:https://msdn.microsoft.com/en-us/library/ff701704.aspxFor a list of supported country codes please visit:see https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BingMapsLayer.html#region)
     *
     * @default null
     */
    region: string;
    /**
     * The three supported maps are:`road` | `aerial` | `hybrid`For more information on Bing map styles please visit:https://msdn.microsoft.com/en-us/library/ff701716.aspx
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BingMapsLayer.html#style)
     *
     * @default "road"
     */
    style: string;

    on(name: "layerview-create", eventHandler: BingMapsLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: BingMapsLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: BingMapsLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface BingMapsLayerConstructor {
    new (properties?: BingMapsLayerProperties): BingMapsLayer;
  }

  export const BingMapsLayer: BingMapsLayerConstructor;

  interface BingMapsLayerProperties extends BaseTileLayerProperties {
    /**
     * Provides culture specific map labels. For more information visit:https://msdn.microsoft.com/en-us/library/ff701709.aspxFor a list of supported culture codes please visit:https://msdn.microsoft.com/en-us/library/hh441729.aspx
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BingMapsLayer.html#culture)
     *
     * @default "en-US"
     */
    culture?: string;
    /**
     * Bing Maps Key.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BingMapsLayer.html#key)
     *
     * @default null
     */
    key?: string;
    /**
     * This will alter Geopolitical disputed borders and labels to align with the specified user region.For more information on Bing's region setting please visit:https://msdn.microsoft.com/en-us/library/ff701704.aspxFor a list of supported country codes please visit:see https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BingMapsLayer.html#region)
     *
     * @default null
     */
    region?: string;
    /**
     * The three supported maps are:`road` | `aerial` | `hybrid`For more information on Bing map styles please visit:https://msdn.microsoft.com/en-us/library/ff701716.aspx
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BingMapsLayer.html#style)
     *
     * @default "road"
     */
    style?: string;
  }

  export interface BingMapsLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface BingMapsLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface BingMapsLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface BuildingSceneLayer extends Layer, SceneService, PortalLayer, ScaleRangeLayer {
    /**
     * The id of the currently active filter.To activate one of the [filters](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#filters) assign its [id](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#id) to this property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#activeFilterId)
     */
    activeFilterId: string;
    /**
     * A flat [Collection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html) of all the [sublayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#sublayers)in the BuildingSublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#allSublayers)
     */
    readonly allSublayers: Collection<BuildingGroupSublayer | BuildingComponentSublayer>;
    /**
     * Specifies how features are placed on the vertical axis (z). This propertyonly affects [BuildingSceneLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html) when using the `absolute-height` mode.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#elevationInfo)
     */
    elevationInfo: BuildingSceneLayerElevationInfo;
    /**
     * Collection of filters that can be used to show or hide specific features in the [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html).Using filters is useful when only a subset of the data in the layer should be displayed.To activate a [BuildingFilter](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html) add it to this [Collection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html) andassign its [id](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#id) to [activeFilterId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#activeFilterId).Once activated, only the features that satisfy the conditions defined by the [filterBlocks](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#filterBlocks)of the filter are displayed in the [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#filters)
     */
    filters: Collection<BuildingFilter>;
    /**
     * Hierarchical structure of sublayers in a BuildingSceneLayer.Usually contains an Overview [BuildingComponentSublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html)and a Full Model [BuildingGroupSublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingGroupSublayer.html).However, some BuildingSceneLayers can contain only the Full Model [BuildingGroupSublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingGroupSublayer.html)or the discipline [BuildingGroupSublayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingGroupSublayer.html) directly.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#sublayers)
     */
    readonly sublayers: Collection<BuildingGroupSublayer | BuildingComponentSublayer>;

    /**
     * Loads the layer and all of its sublayers.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#loadAll)
     *
     *
     */
    loadAll(): IPromise<BuildingSceneLayer>;

    on(name: "layerview-create", eventHandler: BuildingSceneLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: BuildingSceneLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: BuildingSceneLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface BuildingSceneLayerConstructor {
    new (properties?: BuildingSceneLayerProperties): BuildingSceneLayer;

    fromJSON(json: any): BuildingSceneLayer;
  }

  export const BuildingSceneLayer: BuildingSceneLayerConstructor;

  interface BuildingSceneLayerProperties
    extends LayerProperties,
      SceneServiceProperties,
      PortalLayerProperties,
      ScaleRangeLayerProperties {
    /**
     * The id of the currently active filter.To activate one of the [filters](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#filters) assign its [id](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#id) to this property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#activeFilterId)
     */
    activeFilterId?: string;
    /**
     * Specifies how features are placed on the vertical axis (z). This propertyonly affects [BuildingSceneLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html) when using the `absolute-height` mode.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#elevationInfo)
     */
    elevationInfo?: BuildingSceneLayerElevationInfo;
    /**
     * Collection of filters that can be used to show or hide specific features in the [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html).Using filters is useful when only a subset of the data in the layer should be displayed.To activate a [BuildingFilter](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html) add it to this [Collection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html) andassign its [id](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#id) to [activeFilterId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#activeFilterId).Once activated, only the features that satisfy the conditions defined by the [filterBlocks](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#filterBlocks)of the filter are displayed in the [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#filters)
     */
    filters?: CollectionProperties<BuildingFilterProperties>;
  }

  export interface BuildingSceneLayerElevationInfo extends Object {
    /**
     * Defines how features are placed on the vertical axis (z).Currently only `absolute-height` mode is supported.Mode | Description------|------------absolute-height | Features are placed at an absolute elevation (z-value) above sea level. This z-value is determined by summing up the `offset` value and the point's z-value. It doesn't take the elevation of the terrain into account. This is the only supported elevation mode for a [BuildingSceneLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#elevationInfo)
     */
    mode: string;
    /**
     * An elevation offset, which is added to the vertical position of each feature.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#elevationInfo)
     *
     * @default 0
     */
    offset?: number;
    /**
     * The unit for `offset` values.**Possible Values:** feet | meters | kilometers | miles | us-feet | yards
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#elevationInfo)
     *
     * @default meters
     */
    unit?: string;
  }

  export interface BuildingSceneLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface BuildingSceneLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface BuildingSceneLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface BuildingComponentSublayer extends BuildingSublayer, Loadable {
    /**
     * The SQL where clause used to filter features on the client. Only the features that satisfy the definitionexpression are displayed in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html). Setting a definition expression is usefulwhen only a subset of the data in the layer should be displayed.Setting the definition expression of a layer automatically updates all layer views.If the definition expression is set after the layer has been added to the map, the view willautomatically refresh itself to display the features that satisfy the new definition expression.Important to note is that the initial loading time of the features remains unchanged, even if they are filtered.This happens because, as opposed to Feature Layers, feature filtering is done client-side. As a result all features need to be downloaded always for filter evaluation.This property is evaluated on the client using the cached attributes and it only supports[standardized SQL](http://doc.arcgis.com/en/arcgis-online/reference/sql-agol.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#definitionExpression)
     */
    definitionExpression: string;
    /**
     * Indicates how the layer should display in the [LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) widget.The possible values are listed below.Value | Description------|------------ show | The layer is visible in the table of contents. hide | The layer is hidden in the table of contents.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#listMode)
     *
     * @default show
     */
    listMode: "show" | "hide";
    /**
     * An array of field names from the service to include with each feature.To fetch the values from all fields in the layer, use `["*"]`. Fields specified in`outFields` will be requested alongside with required fields for [rendering](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#renderer).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#outFields)
     *
     * @default null
     */
    outFields: string[];
    /**
     * Indicates whether to display popups when features in the layer are clicked. The layer needs to have a [popupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#popupTemplate) to define whatinformation should be displayed in the popup. Alternatively, a default popup template may be automatically used if[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled) is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled: boolean;
    /**
     * The popup template for the sublayer. When set, the `popupTemplate`allows users to access attributes and display their values in the[view's popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html#popup) when a feature is selectedusing text and/or charts. See the [PopupTemplate sample](https://developers.arcgis.com/javascript/latest/sample-code/intro-popuptemplate/index.html)for an example of how [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) interacts with a[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html). Setting a [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html)on this layer type is done in the same way as a FeatureLayer.A default popup template is automatically used if no `popupTemplate` has been defined when[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled)is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#popupTemplate)
     */
    popupTemplate: PopupTemplate;
    /**
     * The renderer assigned to the sublayer. The renderer defines how tovisualize each feature in the sublayer. Depending on the renderer type,features may be visualized with the same symbol, or with varying symbolsbased on the values of provided attribute fields or functions.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#renderer)
     */
    renderer: Renderer;
    /**
     * The type for this sublayer is always `building-component`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#type)
     */
    readonly type: "building-component";

    /**
     * Creates a default popup template for the layer, populated with all the fields of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#createPopupTemplate)
     *
     * @param options Options for creating the popup template.
     * @param options.maximumFields The maximum number of fields to include in the  popup template.
     * @param options.ignoreFieldTypes Field types to ignore when creating the popup.  By default the `geometry`, `blob`, `raster`, `guid` and `xml` field types are ignored.
     *
     */
    createPopupTemplate(options?: BuildingComponentSublayerCreatePopupTemplateOptions): PopupTemplate;
    /**
     * Returns the [Field](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html) instance for a field name (case-insensitive).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#getField)
     *
     * @param fieldName Name of the field.
     *
     */
    getField(fieldName: string): Field;
    /**
     * Returns the [Domain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Domain.html) associated with the given field name. The domain can be either a[CodedValueDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-CodedValueDomain.html) or [RangeDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RangeDomain.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#getFieldDomain)
     *
     * @param fieldName Name of the field.
     *
     */
    getFieldDomain(fieldName: string): Domain;
  }

  interface BuildingComponentSublayerConstructor {
    new (properties?: BuildingComponentSublayerProperties): BuildingComponentSublayer;

    fromJSON(json: any): BuildingComponentSublayer;
  }

  export const BuildingComponentSublayer: BuildingComponentSublayerConstructor;

  interface BuildingComponentSublayerProperties extends BuildingSublayerProperties, LoadableProperties {
    /**
     * The SQL where clause used to filter features on the client. Only the features that satisfy the definitionexpression are displayed in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html). Setting a definition expression is usefulwhen only a subset of the data in the layer should be displayed.Setting the definition expression of a layer automatically updates all layer views.If the definition expression is set after the layer has been added to the map, the view willautomatically refresh itself to display the features that satisfy the new definition expression.Important to note is that the initial loading time of the features remains unchanged, even if they are filtered.This happens because, as opposed to Feature Layers, feature filtering is done client-side. As a result all features need to be downloaded always for filter evaluation.This property is evaluated on the client using the cached attributes and it only supports[standardized SQL](http://doc.arcgis.com/en/arcgis-online/reference/sql-agol.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#definitionExpression)
     */
    definitionExpression?: string;
    /**
     * Indicates how the layer should display in the [LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) widget.The possible values are listed below.Value | Description------|------------ show | The layer is visible in the table of contents. hide | The layer is hidden in the table of contents.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#listMode)
     *
     * @default show
     */
    listMode?: "show" | "hide";
    /**
     * An array of field names from the service to include with each feature.To fetch the values from all fields in the layer, use `["*"]`. Fields specified in`outFields` will be requested alongside with required fields for [rendering](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#renderer).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#outFields)
     *
     * @default null
     */
    outFields?: string[];
    /**
     * Indicates whether to display popups when features in the layer are clicked. The layer needs to have a [popupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#popupTemplate) to define whatinformation should be displayed in the popup. Alternatively, a default popup template may be automatically used if[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled) is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled?: boolean;
    /**
     * The popup template for the sublayer. When set, the `popupTemplate`allows users to access attributes and display their values in the[view's popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html#popup) when a feature is selectedusing text and/or charts. See the [PopupTemplate sample](https://developers.arcgis.com/javascript/latest/sample-code/intro-popuptemplate/index.html)for an example of how [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) interacts with a[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html). Setting a [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html)on this layer type is done in the same way as a FeatureLayer.A default popup template is automatically used if no `popupTemplate` has been defined when[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled)is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#popupTemplate)
     */
    popupTemplate?: PopupTemplateProperties;
    /**
     * The renderer assigned to the sublayer. The renderer defines how tovisualize each feature in the sublayer. Depending on the renderer type,features may be visualized with the same symbol, or with varying symbolsbased on the values of provided attribute fields or functions.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#renderer)
     */
    renderer?: RendererProperties;
  }

  export interface BuildingComponentSublayerCreatePopupTemplateOptions extends Object {
    /**
     * The maximum number of fields to include in the  popup template.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#createPopupTemplate)
     *
     * @default 75
     */
    maximumFields?: number;
    /**
     * Field types to ignore when creating the popup.  By default the `geometry`, `blob`, `raster`, `guid` and `xml` field types are ignored.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingComponentSublayer.html#createPopupTemplate)
     */
    ignoreFieldTypes?: string[];
  }

  interface BuildingGroupSublayer extends BuildingSublayer {
    /**
     * Indicates how the layer should display in the [LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) widget.The possible values are listed below.Value | Description------|------------ show | The layer is visible in the table of contents. hide | The layer is hidden in the table of contents. hide-children | Hide the children layers from the table of contents.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingGroupSublayer.html#listMode)
     *
     * @default show
     */
    listMode: "show" | "hide" | "hide-children";
    /**
     * A [Collection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html) of sublayers.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingGroupSublayer.html#sublayers)
     */
    readonly sublayers: Collection<BuildingGroupSublayer | BuildingComponentSublayer>;
    /**
     * The type for this sublayer is always `building-group`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingGroupSublayer.html#type)
     */
    readonly type: "building-group";

    /**
     * Loads all contained sublayers.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingGroupSublayer.html#loadAll)
     *
     *
     */
    loadAll(): IPromise<BuildingSceneLayer>;
  }

  interface BuildingGroupSublayerConstructor {
    new (properties?: BuildingGroupSublayerProperties): BuildingGroupSublayer;

    fromJSON(json: any): BuildingGroupSublayer;
  }

  export const BuildingGroupSublayer: BuildingGroupSublayerConstructor;

  interface BuildingGroupSublayerProperties extends BuildingSublayerProperties {
    /**
     * Indicates how the layer should display in the [LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) widget.The possible values are listed below.Value | Description------|------------ show | The layer is visible in the table of contents. hide | The layer is hidden in the table of contents. hide-children | Hide the children layers from the table of contents.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingGroupSublayer.html#listMode)
     *
     * @default show
     */
    listMode?: "show" | "hide" | "hide-children";
  }

  interface BuildingSublayer extends Accessor {
    /**
     * The sublayer's layer id as defined by the Scene Service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingSublayer.html#id)
     */
    readonly id: number;
    /**
     * The modelName is a standard name for each sublayer. For example the sublayercontaining the doors in a building has the modelName "Doors". Use thisproperty to retrieve sublayers in a [BuildingSceneLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingSublayer.html#modelName)
     */
    readonly modelName: string;
    /**
     * Opacity of the sublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingSublayer.html#opacity)
     *
     * @default 1
     */
    opacity: number;
    /**
     * The title of the sublayer used to identify it in places such as the [LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html)and [Legend](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Legend.html) widgets.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingSublayer.html#title)
     */
    title: string;
    /**
     * Indicates if the sublayer is visible in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingSublayer.html#visible)
     *
     * @default true
     */
    visible: boolean;
  }

  interface BuildingSublayerConstructor {
    new (properties?: BuildingSublayerProperties): BuildingSublayer;

    fromJSON(json: any): BuildingSublayer;
  }

  export const BuildingSublayer: BuildingSublayerConstructor;

  interface BuildingSublayerProperties {
    /**
     * Opacity of the sublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingSublayer.html#opacity)
     *
     * @default 1
     */
    opacity?: number;
    /**
     * The title of the sublayer used to identify it in places such as the [LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html)and [Legend](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Legend.html) widgets.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingSublayer.html#title)
     */
    title?: string;
    /**
     * Indicates if the sublayer is visible in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-buildingSublayers-BuildingSublayer.html#visible)
     *
     * @default true
     */
    visible?: boolean;
  }

  interface CSVLayer extends Layer, PortalLayer, ScaleRangeLayer, TemporalLayer {
    /**
     * Describes the layer's supported capabilities.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    readonly capabilities: CSVLayerCapabilities;
    /**
     * Copyright information for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#copyright)
     */
    copyright: string;
    /**
     * The SQL where clause used to filter features on the client. Only the features that satisfy the definitionexpression are displayed in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html). Setting a definition expression is usefulwhen the dataset is large and you don't want to bring all features to the client for analysis.Definition expressions may be set when a layer is constructed prior to it loading in the view orafter it has been added to the map. If the definition expression is set after the layer has been added to the map, the view willautomatically refresh itself to display the features that satisfy the new definition expression.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#definitionExpression)
     */
    definitionExpression: string;
    /**
     * The column delimiter. See the table below for possible values.| Value  | Description|| --- | --- || `,`    | comma || ` `    | space || `;`    | semicolon || `|`    | pipe || `\t`     | tab-delimited |
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#delimiter)
     */
    delimiter: string;
    /**
     * Specifies how graphics are placed on the vertical axis (z). This property may only be usedin a [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html). See the [ElevationInfo sample](https://developers.arcgis.com/javascript/latest/sample-code/scene-elevationinfo/index.html)for an example of how this property may be used.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#elevationInfo)
     */
    elevationInfo: CSVLayerElevationInfo;
    /**
     * Configures the method for decluttering overlapping features in the view. If this property is not set (or set to `null`),every feature is drawn individually.Currently this property is only supported in 3D [SceneViews](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html) for point features with non-draped[Icons](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-IconSymbol3DLayer.html) or [Text](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-TextSymbol3DLayer.html)symbol layers.![declutter](https://developers.arcgis.com/javascript/assets/img/samples/city-points-declutter.gif)
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#featureReduction)
     */
    featureReduction: CSVLayerFeatureReduction;
    /**
     * An array of fields in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#fields)
     */
    fields: Field[];
    /**
     * A convenient property that can be used to make case-insensitive lookups for a field by name.It can also provide a list of the [date fields](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FieldsIndex.html#dateFields) in a layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#fieldsIndex)
     */
    readonly fieldsIndex: FieldsIndex;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#labelingInfo)
     */
    labelingInfo: LabelClass[];
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#labelsVisible)
     *
     * @default true
     */
    labelsVisible: boolean;
    /**
     * The latitude field name.If not specified, the API will look for following field names in the CSV source:"lat", "latitude", "y", "ycenter", "latitude83", "latdecdeg", "POINT-Y".
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#latitudeField)
     */
    latitudeField: string;
    /**
     * The longitude field name.If not specified, the API will look for following field names in the CSV source:"lon", "lng", "long", "longitude", "x", "xcenter", "longitude83", "longdecdeg", "POINT-X".
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#longitudeField)
     */
    longitudeField: string;
    /**
     * The name of an `oid` [field](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#fields) containinga unique value or identifier for each feature in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#objectIdField)
     */
    objectIdField: string;
    /**
     * An array of field names to include in the CSVLayer. If not specified, the layer will include all fields.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#outFields)
     */
    outFields: string[];
    /**
     * Indicates whether to display popups when features in the layer are clicked. The layer needs to have a [popupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#popupTemplate) to define whatinformation should be displayed in the popup. Alternatively, a default popup template may be automatically used if[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled) is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled: boolean;
    /**
     * The popup template for the layer. When set on the layer, the `popupTemplate`allows users to access attributes and display their values in the[view's popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html#popup) when a feature is selectedusing text and/or charts. See the [PopupTemplate sample](https://developers.arcgis.com/javascript/latest/sample-code/intro-popuptemplate/index.html)for an example of how [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) interacts with a[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).A default popup template is automatically used if no `popupTemplate` has been defined when[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled)is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#popupTemplate)
     */
    popupTemplate: PopupTemplate;
    /**
     * The renderer assigned to the layer. The renderer defines how tovisualize each feature in the layer. Depending on the renderer type,features may be visualized with the same symbol, or with varying symbolsbased on the values of provided attribute fields or functions.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#renderer)
     */
    renderer: Renderer;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#screenSizePerspectiveEnabled)
     *
     * @default true
     */
    screenSizePerspectiveEnabled: boolean;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#spatialReference)
     *
     * @default SpatialReference.WGS84
     */
    spatialReference: SpatialReference;
    /**
     * The URL of the CSV file.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#url)
     */
    url: string;

    /**
     * Creates a popup template for the layer, populated with all the fields of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#createPopupTemplate)
     *
     * @param options Options for creating the popup template.
     * @param options.maximumFields The maximum number of fields to include in the  popup template.
     * @param options.ignoreFieldTypes Field types to ignore when creating the popup.  By default the `geometry`, `blob`, `raster`, `guid` and `xml` field types are ignored.
     *
     */
    createPopupTemplate(options?: CSVLayerCreatePopupTemplateOptions): PopupTemplate;
    /**
     * Creates query parameters that can be used to fetch features thatsatisfy the layer's current filters, and definitions.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#createQuery)
     *
     *
     */
    createQuery(): Query;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#queryExtent)
     *
     * @param query Specifies the attributes and spatial filter of the query.When no parameters are passed to this method, all features in the client are returned. To only return featuresvisible in the view, set the `geometry` parameter in the query object to the view's extent.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryExtent(query?: Query | QueryProperties, options?: CSVLayerQueryExtentOptions): IPromise<any>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#queryFeatureCount)
     *
     * @param query Specifies the attributes and spatial filter of the query.When no parameters are passed to this method, all features in the client are returned. To only return featuresvisible in the view, set the `geometry` parameter in the query object to the view's extent.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryFeatureCount(query?: Query | QueryProperties, options?: CSVLayerQueryFeatureCountOptions): IPromise<number>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#queryFeatures)
     *
     * @param query Specifies the attributes and spatial filter of the query.When no parameters are passed to this method, all features in the client are returned. To only return featuresvisible in the view, set the `geometry` parameter in the query object to the view's extent.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryFeatures(query?: Query | QueryProperties, options?: CSVLayerQueryFeaturesOptions): IPromise<FeatureSet>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#queryObjectIds)
     *
     * @param query Specifies the attributes and spatial filter of the query.When no parameters are passed to this method, all features in the client are returned. To only return featuresvisible in the view, set the `geometry` parameter in the query object to the view's extent.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryObjectIds(query?: Query | QueryProperties, options?: CSVLayerQueryObjectIdsOptions): IPromise<number[]>;

    on(name: "layerview-create", eventHandler: CSVLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: CSVLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: CSVLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface CSVLayerConstructor {
    new (properties?: CSVLayerProperties): CSVLayer;

    fromJSON(json: any): CSVLayer;
  }

  export const CSVLayer: CSVLayerConstructor;

  interface CSVLayerProperties
    extends LayerProperties,
      PortalLayerProperties,
      ScaleRangeLayerProperties,
      TemporalLayerProperties {
    /**
     * Copyright information for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#copyright)
     */
    copyright?: string;
    /**
     * The SQL where clause used to filter features on the client. Only the features that satisfy the definitionexpression are displayed in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html). Setting a definition expression is usefulwhen the dataset is large and you don't want to bring all features to the client for analysis.Definition expressions may be set when a layer is constructed prior to it loading in the view orafter it has been added to the map. If the definition expression is set after the layer has been added to the map, the view willautomatically refresh itself to display the features that satisfy the new definition expression.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#definitionExpression)
     */
    definitionExpression?: string;
    /**
     * The column delimiter. See the table below for possible values.| Value  | Description|| --- | --- || `,`    | comma || ` `    | space || `;`    | semicolon || `|`    | pipe || `\t`     | tab-delimited |
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#delimiter)
     */
    delimiter?: string;
    /**
     * Specifies how graphics are placed on the vertical axis (z). This property may only be usedin a [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html). See the [ElevationInfo sample](https://developers.arcgis.com/javascript/latest/sample-code/scene-elevationinfo/index.html)for an example of how this property may be used.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#elevationInfo)
     */
    elevationInfo?: CSVLayerElevationInfo;
    /**
     * Configures the method for decluttering overlapping features in the view. If this property is not set (or set to `null`),every feature is drawn individually.Currently this property is only supported in 3D [SceneViews](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html) for point features with non-draped[Icons](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-IconSymbol3DLayer.html) or [Text](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-TextSymbol3DLayer.html)symbol layers.![declutter](https://developers.arcgis.com/javascript/assets/img/samples/city-points-declutter.gif)
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#featureReduction)
     */
    featureReduction?: CSVLayerFeatureReduction;
    /**
     * An array of fields in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#fields)
     */
    fields?: FieldProperties[];
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#labelingInfo)
     */
    labelingInfo?: LabelClassProperties[];
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#labelsVisible)
     *
     * @default true
     */
    labelsVisible?: boolean;
    /**
     * The latitude field name.If not specified, the API will look for following field names in the CSV source:"lat", "latitude", "y", "ycenter", "latitude83", "latdecdeg", "POINT-Y".
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#latitudeField)
     */
    latitudeField?: string;
    /**
     * The longitude field name.If not specified, the API will look for following field names in the CSV source:"lon", "lng", "long", "longitude", "x", "xcenter", "longitude83", "longdecdeg", "POINT-X".
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#longitudeField)
     */
    longitudeField?: string;
    /**
     * The name of an `oid` [field](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#fields) containinga unique value or identifier for each feature in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#objectIdField)
     */
    objectIdField?: string;
    /**
     * An array of field names to include in the CSVLayer. If not specified, the layer will include all fields.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#outFields)
     */
    outFields?: string[];
    /**
     * Indicates whether to display popups when features in the layer are clicked. The layer needs to have a [popupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#popupTemplate) to define whatinformation should be displayed in the popup. Alternatively, a default popup template may be automatically used if[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled) is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled?: boolean;
    /**
     * The popup template for the layer. When set on the layer, the `popupTemplate`allows users to access attributes and display their values in the[view's popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html#popup) when a feature is selectedusing text and/or charts. See the [PopupTemplate sample](https://developers.arcgis.com/javascript/latest/sample-code/intro-popuptemplate/index.html)for an example of how [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) interacts with a[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).A default popup template is automatically used if no `popupTemplate` has been defined when[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled)is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#popupTemplate)
     */
    popupTemplate?: PopupTemplateProperties;
    /**
     * The renderer assigned to the layer. The renderer defines how tovisualize each feature in the layer. Depending on the renderer type,features may be visualized with the same symbol, or with varying symbolsbased on the values of provided attribute fields or functions.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#renderer)
     */
    renderer?: RendererProperties;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#screenSizePerspectiveEnabled)
     *
     * @default true
     */
    screenSizePerspectiveEnabled?: boolean;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#spatialReference)
     *
     * @default SpatialReference.WGS84
     */
    spatialReference?: SpatialReferenceProperties;
    /**
     * The URL of the CSV file.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#url)
     */
    url?: string;
  }

  export interface CSVLayerCapabilities extends Object {
    /**
     * Describes characteristics of the data in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    data: CSVLayerCapabilitiesData;
    /**
     * Describes editing capabilities that can be performed on the features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    editing: CSVLayerCapabilitiesEditing;
    /**
     * Describes operations that can be performed on features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    operations: CSVLayerCapabilitiesOperations;
    /**
     * Describes [query](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html)operations that can be performed on features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    query: CSVLayerCapabilitiesQuery;
    /**
     * Indicates if the layer's query operation supports querying features or records related to features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    queryRelated: CSVLayerCapabilitiesQueryRelated;
  }

  export interface CSVLayerCapabilitiesData extends Object {
    /**
     * Indicates if the attachment is enabled on the layer. At this current time, the CSVLayer doesn’t support attachments.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsAttachment: boolean;
    /**
     * Indicates if the features in the layer support M values. Requires ArcGIS Server service 10.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsM: boolean;
    /**
     * Indicates if the features in the layer support Z values. Requires ArcGIS Server service 10.1 or greater.See [elevationInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#elevationInfo) for details regarding placement andrendering of features with z-values in 3D [SceneViews](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsZ: boolean;
  }

  export interface CSVLayerCapabilitiesEditing extends Object {
    /**
     * Indicates if anonymous users can delete features created by others.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsDeleteByAnonymous: boolean;
    /**
     * Indicates if logged in users can delete features created by others.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsDeleteByOthers: boolean;
    /**
     * Indicates if the geometry of the features in the layer can be edited.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsGeometryUpdate: boolean;
    /**
     * Indicates if the `globalid` values provided by the client are used in [applyEdits](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#applyEdits).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsGlobalId: boolean;
    /**
     * Indicates if the `rollbackOnFailure` parameter can be set to `true` or `false` when running the synchronizeReplica operation.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsRollbackOnFailure: boolean;
    /**
     * Indicates if anonymous users can update features created by others.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsUpdateByAnonymous: boolean;
    /**
     * Indicates if logged in users can update features created by others.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsUpdateByOthers: boolean;
    /**
     * Indicates if `m-values` must be provided when updating features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsUpdateWithoutM: boolean;
    /**
     * Indicates if the layer supports uploading attachments by [UploadId](https://developers.arcgis.com/rest/services-reference/item.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsUploadWithItemId: boolean;
  }

  export interface CSVLayerCapabilitiesOperations extends Object {
    /**
     * Indicates if new features can be [added](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#applyEdits) to the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsAdd: boolean;
    /**
     * Indicates if features can be [deleted](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#applyEdits) from the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsDelete: boolean;
    /**
     * Indicates if features in the layer can be [updated](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#applyEdits).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsUpdate: boolean;
    /**
     * Indicates if features in the layer can be [edited](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#applyEdits). Use `supportsAdd`, `supportsUpdate` and `supportsDelete` to determine which editing operations are supported.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsEditing: boolean;
    /**
     * Indicates if values of one or more field values in the layercan be updated. See the [Calculate REST operation](https://developers.arcgis.com/rest/services-reference/calculate-feature-service-layer-.htm)document for more information.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsCalculate: boolean;
    /**
     * Indicates if features in the layer can be [queried](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#queryFeatures).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsQuery: boolean;
    /**
     * Indicates if the layer supports[REST API queryAttachments](https://developers.arcgis.com/rest/services-reference/query-attachments-feature-service-layer-.htm)operation, which is supported with hosted feature services at version 10.5 and greater.If `false`, [queryAttachments() method](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#queryAttachments) can only return attachments for one feature at a time.If `true`, `queryAttachments()` can return attachments for array of [objectIds](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-AttachmentQuery.html#objectIds).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsQueryAttachments: boolean;
    /**
     * Indicates if the layer supports a SQL-92 expression or where clause. This operation isonly supported in ArcGIS Online hosted feature services.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsValidateSql: boolean;
    /**
     * Indicates if resized attachments are supported in the layer.This is useful for showing thumbnails in [Popups](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsResizeAttachments: boolean;
  }

  export interface CSVLayerCapabilitiesQuery extends Object {
    /**
     * Indicates if the geometry centroid associated with each polygon feature can be returned. This operation isonly supported in ArcGIS Online hosted feature services.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsCentroid: boolean;
    /**
     * Indicates if the layer's query operation supports a buffer distance for input geometries.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsDistance: boolean;
    /**
     * Indicates if the layer supports queries for distinct values based on fields specified in the [outFields](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#outFields).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsDistinct: boolean;
    /**
     * Indicates if the query operation supports `disjoint` [spatial relationship](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html#spatialRelationship). This is valid only for[hosted feature services](http://doc.arcgis.com/en/arcgis-online/share-maps/hosted-web-layers.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsDisjointSpatialRelationship: boolean;
    /**
     * Indicates if the layer's query response includes the extent of features.At 10.3, this option is only available for hosted feature services. At 10.3.1, it is available for hosted and non-hosted feature services.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsExtent: boolean;
    /**
     * Indicates if the layer's query response contains geometry attributes, including shape area and length attributes.This operation is only supported in ArcGIS Online hosted feature services.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsGeometryProperties: boolean;
    /**
     * Indicates if the layer supports the [having](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html#having) clause on the service. Requires an ArcGIS Server service 10.6.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsHavingClause: boolean;
    /**
     * Indicates if features returned in the query response can be ordered by one or more fields. Requires an ArcGIS Server service 10.3 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsOrderBy: boolean;
    /**
     * Indicates if the query response supports pagination. Requires an ArcGIS Server service 10.3 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsPagination: boolean;
    /**
     * Indicates if the query response includes the [query geometry](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-FeatureSet.html#queryGeometry). This is valid only for[hosted feature services](http://doc.arcgis.com/en/arcgis-online/share-maps/hosted-web-layers.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsQueryGeometry: boolean;
    /**
     * Indicates if the query operation supports the projection of geometries onto a virtual grid. Requires an ArcGIS Server service 10.6.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsQuantization: boolean;
    /**
     * Indicates if the query operation supports quantization designed to be used in edit mode (highest resolution at the given spatial reference). Requires an ArcGIS Server service 10.6.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsQuantizationEditMode: boolean;
    /**
     * Indicates if the number of features returned by the query operation can be controlled.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsResultType: boolean;
    /**
     * Indicates if the query operation supports SQL expressions.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsSqlExpression: boolean;
    /**
     * Indicates if the query operation supports using standardized queries.Learn more about [standardized queries here](http://server.arcgis.com/en/server/latest/administer/linux/about-standardized-queries.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsStandardizedQueriesOnly: boolean;
    /**
     * Indicates if the layer supports field-based statistical functions. Requires ArcGIS Server service 10.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsStatistics: boolean;
    /**
     * Indicates if the layer supports historic moment query. Requires ArcGIS Server service 10.5 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsHistoricMoment: boolean;
  }

  export interface CSVLayerCapabilitiesQueryRelated extends Object {
    /**
     * Indicates if the layer's query response includes the number of features or records related to features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsCount: boolean;
    /**
     * Indicates if the related features or records returned in the query response can be ordered by one or more fields.Requires ArcGIS Server service 10.3 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsOrderBy: boolean;
    /**
     * Indicates if the query response supports pagination for related features or records. Requires ArcGIS Server service 10.3 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#capabilities)
     */
    supportsPagination: boolean;
  }

  export interface CSVLayerCreatePopupTemplateOptions extends Object {
    /**
     * The maximum number of fields to include in the  popup template.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#createPopupTemplate)
     *
     * @default 75
     */
    maximumFields?: number;
    /**
     * Field types to ignore when creating the popup.  By default the `geometry`, `blob`, `raster`, `guid` and `xml` field types are ignored.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#createPopupTemplate)
     */
    ignoreFieldTypes?: string[];
  }

  export interface CSVLayerElevationInfo extends Object {
    /**
     * Defines how the graphic is placed with respect to the terrain surface.See the table below for a list of possible values.Mode | Description------|------------on-the-ground | Graphics are draped on the terrain surface. This is the default value for [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) geometries rendered with [ObjectSymbol3DLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-ObjectSymbol3DLayer.html).relative-to-ground | Graphics are placed at an elevation relative to the terrain surface. The graphic's elevation is determined by summing up the terrain elevation and the result of `featureExpressionInfo` (if defined). This is the default value for [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) geometries rendered with [IconSymbol3DLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-IconSymbol3DLayer.html).absolute-height | Graphics are placed at an absolute elevation (z-value) above sea level. This z-value is determined by the result of `featureExpressionInfo` (if defined). This mode doesn't take the elevation of the terrain into account.relative-to-scene | Graphics are aligned to buildings and other objects part of 3D Object [SceneLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html) or [IntegratedMeshLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-IntegratedMeshLayer.html), depending on which has higher elevation. If the graphic is not directly above a building or any other feature, it is aligned to the terrain surface elevation. If defined, the result of `featureExpressionInfo` is added to the 3D Object/terrain surface elevation.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#elevationInfo)
     */
    mode: string;
    /**
     * An elevation offset, which is added to the vertical position of the graphic. If `unit` is not defined,the offset is in `meters`.When `mode = "on-the-ground"`, this property has no effect.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#elevationInfo)
     */
    offset?: number;
    /**
     * This object contains information about setting a custom z-value on the feature.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#elevationInfo)
     */
    featureExpressionInfo?: CSVLayerElevationInfoFeatureExpressionInfo;
    /**
     * The unit for `featureExpressionInfo` and `offset` values.**Possible Values:** feet | meters | kilometers | miles | us-feet | yards
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#elevationInfo)
     */
    unit?: string;
  }

  export interface CSVLayerElevationInfoFeatureExpressionInfo extends Object {
    /**
     * An [Arcade expression](https://developers.arcgis.com/javascript/latest/guide/arcade/index.html) evaluating to a number that determines the z-value of the feature. When `mode = "on-the-ground"`, this property has no effect. For line and polygon geometries the result of the expression is the same for all vertices of a feature.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#elevationInfo)
     */
    expression?: string;
  }

  export interface CSVLayerFeatureReduction extends Object {
    /**
     * Type of the decluttering method. The only supported type at the moment is`selection`. In this method, some of the overlapping features are hidden such that none of the remaining featuresintersect on screen. Label deconfliction also respects this option and hides labels that would overlap with the features of this layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#featureReduction)
     */
    type: string;
  }

  export interface CSVLayerQueryExtentOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#queryExtent)
     */
    signal?: AbortSignal;
  }

  export interface CSVLayerQueryFeatureCountOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#queryFeatureCount)
     */
    signal?: AbortSignal;
  }

  export interface CSVLayerQueryFeaturesOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#queryFeatures)
     */
    signal?: AbortSignal;
  }

  export interface CSVLayerQueryObjectIdsOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html#queryObjectIds)
     */
    signal?: AbortSignal;
  }

  export interface CSVLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface CSVLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface CSVLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface ElevationLayer extends Layer, ArcGISCachedService, PortalLayer {
    /**
     * URL pointing to the Elevation layer resource on an ArcGIS Image Server.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#url)
     */
    url: string;

    /**
     * Creates an elevation sampler for the given [Extent](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html) by querying the service layerfor elevation data and caching it so values may be sampled quickly afterwards. The resolutionof the cached data can be set using the `demResolution` option. In many cases, `auto`demResolution can be used to get high quality elevation samples without theneed to know exactly where the data in the service is located.This is particularly useful for services which combineelevation data from many sources (such as the world elevation service).If more control, or higher quality samples are required, use either`finest-contiguous` or a fixed `{number}` resolution.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#createElevationSampler)
     *
     * @param extent The extent for which to create the sampler.
     * @param options Additional query options. See the table below.
     * @param options.demResolution Controls the horizontal resolution (cell size) in meters from which elevation data is sampled (defaults to `auto`). See [ElevationLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#queryElevation)for more details.
     * @param options.noDataValue The value to use when there is no data available.
     *
     */
    createElevationSampler(
      extent: Extent,
      options?: ElevationLayerCreateElevationSamplerOptions
    ): IPromise<ElevationSampler>;
    /**
     * Requests a tile from the service and decodes the data into a lineararray of elevation values.The returned promise resolves with a plain object describing the obtainedelevation data for the tile. The object has the following properties:Property  | Type         | Description----------|--------------|------------values    | Float32Array | The elevation values contained in the tile.width     | number       | The number of elevation values in one row of the tile.height    | number       | The number of elevation values in one column of the tile.maxZError | number       | The upper bound for the compression error on the elevation values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#fetchTile)
     *
     * @param level the tile level.
     * @param row the tile row.
     * @param column the tile column.
     * @param options Optional settings for the tile request.
     * @param options.noDataValue The value representing pixels  in the tile that don't contain an elevation value.
     * @param options.signal An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     */
    fetchTile(
      level: number,
      row: number,
      column: number,
      options?: ElevationLayerFetchTileOptions
    ): IPromise<ElevationTileData>;
    /**
     * This method returns a URL to a tile for a given level, row and column.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#getTileUrl)
     *
     * @param level The requested tile's level.
     * @param row The requested tile's row.
     * @param col The requested tile's column.
     *
     */
    getTileUrl(level: number, row: number, col: number): string;
    /**
     * Queries the service layer for elevation values for the given geometry. Thereturned result contains a copy of the geometry with z-values sampled fromelevation data from the service. The resolution from which the elevation isqueried can be set using the `demResolution` option. In many cases, `auto`demResolution can be used to get high quality elevation samples without theneed to know exactly where the data in the service is located.This is particularly useful for services which combineelevation data from many sources (such as the world elevation service).If more control, or higher quality samples are required, use either`finest-contiguous` or a fixed `{number}` resolution.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#queryElevation)
     *
     * @param geometry The geometry to use for sampling elevation data.
     * @param options Additional query options. See the table below.
     * @param options.demResolution Controls the horizontal resolution (cell size)  in meters from which elevation data is sampled (defaults to `auto`). See the table below formore details on the different settings.demResolution          | Description-----------------------|-------------`auto`                 | Automatically chooses an appropriate resolution for each coordinate of the input geometry. The current implementation will try to use the finest available resolution given that the total required number of tile requests does not exceed a certain maximum amount (currently 20). Note that this may result in values being sampled from different resolutions.`finest-contiguous`    | Sample elevation from the finest available resolution (cell size) across the entire geometry.`{number}`             | Sample elevation from the resolution closest to the specified resolution (in meters).
     * @param options.returnSampleInfo Indicates whether to return additional sample information  for each coordinate.
     * @param options.noDataValue The value to use when there is no data available.
     * @param options.signal An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     */
    queryElevation(
      geometry: Point | Multipoint | Polyline,
      options?: ElevationLayerQueryElevationOptions
    ): IPromise<ElevationLayerElevationQueryResult>;

    on(name: "layerview-create", eventHandler: ElevationLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: ElevationLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: ElevationLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface ElevationLayerConstructor {
    new (properties?: ElevationLayerProperties): ElevationLayer;

    fromJSON(json: any): ElevationLayer;
  }

  export const ElevationLayer: ElevationLayerConstructor;

  interface ElevationLayerProperties extends LayerProperties, ArcGISCachedServiceProperties, PortalLayerProperties {
    /**
     * URL pointing to the Elevation layer resource on an ArcGIS Image Server.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#url)
     */
    url?: string;
  }

  export interface ElevationLayerCreateElevationSamplerOptions extends Object {
    /**
     * Controls the horizontal resolution (cell size) in meters from which elevation data is sampled (defaults to `auto`). See [ElevationLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#queryElevation)for more details.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#createElevationSampler)
     *
     * @default auto
     */
    demResolution?: number | string;
    /**
     * The value to use when there is no data available.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#createElevationSampler)
     *
     * @default 0
     */
    noDataValue?: number;
  }

  export interface ElevationLayerFetchTileOptions extends Object {
    /**
     * The value representing pixels  in the tile that don't contain an elevation value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#fetchTile)
     */
    noDataValue?: number;
    /**
     * An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#fetchTile)
     */
    signal?: AbortSignal;
  }

  export interface ElevationLayerQueryElevationOptions extends Object {
    /**
     * Controls the horizontal resolution (cell size)  in meters from which elevation data is sampled (defaults to `auto`). See the table below formore details on the different settings.demResolution          | Description-----------------------|-------------`auto`                 | Automatically chooses an appropriate resolution for each coordinate of the input geometry. The current implementation will try to use the finest available resolution given that the total required number of tile requests does not exceed a certain maximum amount (currently 20). Note that this may result in values being sampled from different resolutions.`finest-contiguous`    | Sample elevation from the finest available resolution (cell size) across the entire geometry.`{number}`             | Sample elevation from the resolution closest to the specified resolution (in meters).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#queryElevation)
     *
     * @default auto
     */
    demResolution?: number | string;
    /**
     * Indicates whether to return additional sample information  for each coordinate.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#queryElevation)
     *
     * @default false
     */
    returnSampleInfo?: boolean;
    /**
     * The value to use when there is no data available.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#queryElevation)
     *
     * @default 0
     */
    noDataValue?: number;
    /**
     * An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#queryElevation)
     */
    signal?: AbortSignal;
  }

  /**
   * Object returned when [queryElevation()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#queryElevation) promise resolves:
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#ElevationQueryResult)
   */
  export interface ElevationLayerElevationQueryResult extends Object {
    /**
     * The geometry with sampled z-values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#ElevationQueryResult)
     */
    geometry: Point | Multipoint | Polyline;
    /**
     * Contains additional information about how the geometry was sampled.                                  This property is present depending on whether the user set `options.returnSampleInfo = true`,                                  for each coordinate in the geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#ElevationQueryResult)
     */
    sampleInfo?: ElevationLayerElevationQueryResultSampleInfo[];
    /**
     * The value used when there is no data available.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#ElevationQueryResult)
     */
    noDataValue: number;
  }

  export interface ElevationLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface ElevationLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface ElevationLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  export interface ElevationLayerElevationQueryResultSampleInfo extends Object {
    /**
     * The resolution at which the z-value was sampled.                                  If no data was available for sampling for a given coordinate,                                  the dem resolution value will be -1 for that coordinate.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html#ElevationQueryResult)
     */
    demResolution: number;
  }

  interface FeatureLayer extends Layer, PortalLayer, ScaleRangeLayer, RefreshableLayer, TemporalLayer {
    /**
     * Describes the layer's supported capabilities.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    readonly capabilities: FeatureLayerCapabilities;
    /**
     * Copyright information for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#copyright)
     */
    copyright: string;
    /**
     * The SQL where clause used to filter features on the client. Only the features that satisfy the definitionexpression are displayed in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html). Setting a definition expression is usefulwhen the dataset is large and you don't want to bring all features to the client for analysis.Definition expressions may be set when a layer is constructed prior to it loading in the view orafter it has been added to the map. If the definition expression is set after the layer has been added to the map, the view willautomatically refresh itself to display the features that satisfy the new definition expression.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#definitionExpression)
     */
    definitionExpression: string;
    /**
     * The name of the layer's primary display field. The value of this property matches the name of one of the fields of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#displayField)
     */
    displayField: string;
    /**
     * An object that allows you to create a dynamic layer with dataeither from map service sublayers or data from a registered workspace.See [DynamicMapLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicMapLayer)for creating dynamic layers from map service layers for on the flyrendering, labeling, and filtering (definition expressions). To createdynamic layers from other sources in registered workspaces such as tables and table joins,see [DynamicDataLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicDataLayer).If you already have a [Sublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html) instance, youcan call the [createFeatureLayer()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#createFeatureLayer)method on the Sublayer to construct the layer for you.This only applies to map services with[dynamic layers](https://enterprise.arcgis.com/en/server/latest/publish-services/linux/about-dynamic-layers.htm) enabled.Therefore, the [url](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#url) of the FeatureLayer instance must point to a map service urlending with `/dynamicLayer`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#dynamicDataSource)
     */
    dynamicDataSource: DynamicMapLayer | DynamicDataLayer;
    /**
     * The editor tracking fields, which record who adds or edits the data through the feature serviceand when edits are made.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#editFieldsInfo)
     */
    readonly editFieldsInfo: EditFieldsInfo;
    /**
     * If present, this value specifies information about editing.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#editingInfo)
     */
    readonly editingInfo: EditingInfo;
    /**
     * Specifies how features are placed on the vertical axis (z). This property may only be usedin a [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html). See the [ElevationInfo sample](https://developers.arcgis.com/javascript/latest/sample-code/scene-elevationinfo/index.html)for an example of how this property may be used.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#elevationInfo)
     */
    elevationInfo: FeatureLayerElevationInfo;
    /**
     * Configures the method for decluttering overlapping features in the view. If this property is not set (or set to `null`),every feature is drawn individually.Currently this property is only supported in 3D [SceneViews](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html) for point features with non-draped[Icons](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-IconSymbol3DLayer.html) or [Text](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-TextSymbol3DLayer.html)symbol layers.![declutter](https://developers.arcgis.com/javascript/assets/img/samples/city-points-declutter.gif)
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#featureReduction)
     */
    featureReduction: FeatureLayerFeatureReduction;
    /**
     * An array of fields in the layer. Each field represents an attributethat may contain a value for each feature in the layer. For example,a field named `POP_2015`, stores information about total population as anumeric value for each feature; this value represents the total numberof people living within the geographic bounds of the feature.This property must be set in the constructor when creating a FeatureLayerfrom client-side [features](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html). To create FeatureLayers fromclient-side features you must also set the [source](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#source),[objectIdField](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#objectIdField), [spatialReference](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#spatialReference),[geometryType](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#geometryType), [renderer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#renderer), and [type](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#type) properties.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#fields)
     */
    fields: Field[];
    /**
     * A convenient property that can be used to make case-insensitive lookups for a field by name.It can also provide a list of the [date fields](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FieldsIndex.html#dateFields) in a layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#fieldsIndex)
     */
    readonly fieldsIndex: FieldsIndex;
    /**
     * The version of the geodatabase of the feature service data. Readthe [Overview of versioning](https://desktop.arcgis.com/en/arcmap/latest/manage-data/geodatabases/an-overview-of-versioning.htm) topic for more detailsabout this capability.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#gdbVersion)
     */
    readonly gdbVersion: string;
    /**
     * The geometry type of features in the layer. All features must be of the same type.This property is read-only when the layer is created from a [url](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#url).When creating a FeatureLayer from client-side features, this property isinferred by the geometryType of the features provided in the layer's [source](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#source)property.**Possible Values:** point | multipoint | polyline | polygon | multipatch | mesh
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#geometryType)
     */
    geometryType: string;
    /**
     * Indicates whether the client-side features in the layer have `M` (measurement) values.Use the `supportsM` property in the FeatureLayer's [capabilities.data](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)object to verify if `M` values are supported on [feature service](https://developers.arcgis.com/rest/services-reference/feature-service.htm) features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#hasM)
     *
     * @default undefined
     */
    readonly hasM: boolean;
    /**
     * Indicates whether the client-side features in the layer have `Z` (elevation) values.Refer to [elevationInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#elevationInfo) for details regarding placement and renderingof features with z-values in 3D [SceneViews](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html).Use the `supportsZ` property in the FeatureLayer's [capabilities.data](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)object to verify if `Z` values are supported on [feature service](https://developers.arcgis.com/rest/services-reference/feature-service.htm) features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#hasZ)
     *
     * @default undefined
     */
    readonly hasZ: boolean;
    /**
     * The historic moment to query. If historicMoment is not specified, the querywill apply to the current features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#historicMoment)
     */
    historicMoment: Date;
    /**
     * Returns `true` if the layer is loaded from a non-spatial table in a service. Non-spatial table does not havea spatial column that represents geographic features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#isTable)
     *
     * @default false
     */
    isTable: boolean;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#labelingInfo)
     */
    labelingInfo: LabelClass[];
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#labelsVisible)
     *
     * @default true
     */
    labelsVisible: boolean;
    /**
     * The layer ID, or layer index, of a Feature Service layer. This is particularly useful whenloading a single FeatureLayer with the [portalItem](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#portalItem) property from a service containingmultiple layers. You can specify this value in one of two scenarios:* When loading the layer via the [portalItem](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#portalItem) property.* When pointing the layer [url](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#url) directly to the Feature Service.If a layerId is not specified in either of the above scenarios, then the first layerin the service (`layerId = 0`) is selected.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#layerId)
     */
    layerId: number;
    /**
     * Indicates whether the layer will be included in the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled: boolean;
    /**
     * The name of an `oid` [field](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#fields) containinga unique value or identifier for each feature in the layer.This is required when constructing a FeatureLayer from a collectionof client-side [features](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#objectIdField)
     */
    objectIdField: string;
    /**
     * An array of field names from the service to include with each feature.To fetch the values from all fields in the layer, use `["*"]`. Fields specified in`outFields` will be requested alongside with required fields for [rendering](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#renderer),[labeling](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#labelingInfo) and setting the [elevation info](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#elevationInfo) for the layer.The required fields and `outFields` are used to populate[FeatureLayerView.availableFields](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-FeatureLayerView.html#availableFields).Set this property to include the fields that will be used for client-side[queries](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-FeatureLayerView.html#queryFeatures)if the fields are not part of required fields used for rendering.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#outFields)
     *
     * @default null
     */
    outFields: string[];
    /**
     * Indicates whether to display popups when features in the layer are clicked. The layer needs to have a [popupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#popupTemplate) to define whatinformation should be displayed in the popup. Alternatively, a default popup template may be automatically used if[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled) is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled: boolean;
    /**
     * The popup template for the layer. When set on the layer, the `popupTemplate`allows users to access attributes and display their values in the[view's popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html#popup) when a feature is selectedusing text and/or charts. See the [PopupTemplate sample](https://developers.arcgis.com/javascript/latest/sample-code/intro-popuptemplate/index.html)for an example of how [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) interacts with a[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).A default popup template is automatically used if no `popupTemplate` has been defined when[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled)is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#popupTemplate)
     */
    popupTemplate: PopupTemplate;
    /**
     * Array of [relationships](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Relationship.html) set up for the layer. Each object in the array describes the layer's[relationship](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Relationship.html) with another layer or table.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#relationships)
     */
    readonly relationships: Relationship[];
    /**
     * The renderer assigned to the layer. The renderer defines how tovisualize each feature in the layer. Depending on the renderer type,features may be visualized with the same symbol, or with varying symbolsbased on the values of provided attribute fields or functions.However, when creating a FeatureLayer from client-side features, this property mustbe specified in the layer's constructor along with the[source](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#source),[fields](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#fields), [objectIdField](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#objectIdField) properties.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#renderer)
     */
    renderer: Renderer;
    /**
     * When `true`, indicates that M values will be returned. When`false`, indicates that M values will never be returned. The layer viewdetermines whether to include M values in feature queries when theproperty value is `undefined`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#returnM)
     *
     * @default undefined
     */
    returnM: boolean;
    /**
     * When `true`, indicates that Z values will always be returned. When`false`, indicates that Z values will never be returned. The layer viewdetermines whether to include Z values in feature queries when theproperty value is `undefined`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#returnZ)
     *
     * @default undefined
     */
    returnZ: boolean;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#screenSizePerspectiveEnabled)
     *
     * @default true
     */
    screenSizePerspectiveEnabled: boolean;
    /**
     * A collection of [Graphic](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html) objects used to create a FeatureLayer.The geometry of each feature all must have a matching [geometryType](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#geometryType).This property should only be used when creating a FeatureLayer from client-side features.When creating a FeatureLayer from client-side features, the [fields](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#fields),[objectIdField](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#objectIdField), [renderer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#renderer), and [type](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#type) properties must also be set.Use [applyEdits()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#applyEdits) method to add, remove, and update featuresfrom a layer at runtime. Once `applyEdits()` resolves successfully, use [queryFeatures()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryFeatures)to return updated features.The [spatialReference](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#spatialReference) and [geometryType](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#geometryType) propertiesare determined based on the features provided to this property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#source)
     */
    source: Collection<Graphic>;
    /**
     * The spatial reference of the layer. When creating the layer from a[url](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#url), the spatial reference is read from the service.When creating a FeatureLayer from client-side features, this property isinferred from the geometries of the features provided in the [source](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#source)property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#spatialReference)
     */
    spatialReference: SpatialReference;
    /**
     * An array of feature templates defined in the feature layer.See [ArcGIS Pro subtypes document](https://pro.arcgis.com/en/pro-app/help/data/geodatabases/overview/an-overview-of-subtypes.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#templates)
     */
    templates: FeatureTemplate[];
    /**
     * The name of the field holding the type ID or subtypes for the features.See [ArcGIS Pro subtypes document](https://pro.arcgis.com/en/pro-app/help/data/geodatabases/overview/an-overview-of-subtypes.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#typeIdField)
     */
    readonly typeIdField: string;
    /**
     * An array of subtypes defined in the feature service exposed by ArcGIS REST API.Each item includes information about the type, such as the type ID, name, and definition expression.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#types)
     */
    types: FeatureType[];
    /**
     * The URL of the REST endpoint of the layer, non-spatial table or service. The URL may either point to aresource on ArcGIS Enterprise or ArcGIS Online.If the url points directly to a service, then the layer must be specified in the[layerId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#layerId) property. If no [layerId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#layerId) is given, then the first layer in the service will be loaded.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#url)
     */
    url: string;
    /**
     * The version of ArcGIS Server in which the layer is published.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#version)
     */
    readonly version: number;

    /**
     * Adds an attachment to a feature. This operation is available only if the layer's[capabilities.data.supportsAttachment](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities) is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#addAttachment)
     *
     * @param feature Feature to which the attachment is to be added.
     * @param attachment HTML form that contains a file upload field pointing to the file to be added as an attachment.
     *
     */
    addAttachment(feature: Graphic, attachment: HTMLFormElement | FormData): IPromise<FeatureEditResult>;
    /**
     * Applies edits to features in a layer. New features can be created and existingfeatures can be updated or deleted. Feature geometries and/or attributes may be modified.Only applicable to layers in a[feature service](https://developers.arcgis.com/rest/services-reference/feature-service.htm)and client-side features set through the layer's [source](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#source).If client-side features are added, removed or updated at runtime using [applyEdits()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#applyEdits)then use [queryFeatures()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryFeatures) to return updated features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#applyEdits)
     *
     * @param edits Object containing features to be added, updated or deleted.
     * @param edits.addFeatures Array of features to be added.Values of non nullable fields must be provided when adding new features. Date fields must have[numeric](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTime) valuesrepresenting universal time.
     * @param edits.updateFeatures Array of features to be updated. Each feature must have valid[objectId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#objectIdField). Values of non nullable fields must be provided when updating features. Date fields must have[numeric](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTime) valuesrepresenting universal time.
     * @param edits.deleteFeatures An array of features orobjects to be deleted. When an array of features is passed, each feature must have a valid[objectId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#objectIdField). When an array of objects is used, each object must have a valid`objectId` property.
     *
     */
    applyEdits(edits: FeatureLayerApplyEditsEdits): IPromise<any>;
    /**
     * Creates a popup template for the layer, populated with all the fields of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#createPopupTemplate)
     *
     * @param options Options for creating the popup template.
     * @param options.maximumFields The maximum number of fields to include in the  popup template.
     * @param options.ignoreFieldTypes Field types to ignore when creating the popup.  By default the `geometry`, `blob`, `raster`, `guid` and `xml` field types are ignored.
     *
     */
    createPopupTemplate(options?: FeatureLayerCreatePopupTemplateOptions): PopupTemplate;
    /**
     * Creates query parameter object that can be used to fetch features thatsatisfy the layer's configurations such as [definitionExpression](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#definitionExpression),[gdbVersion](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#gdbVersion), and [historicMoment](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#historicMoment).It will return `Z` and `M` values based on the layer's [data capabilities](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities).It sets the query parameter's [outFields](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html#outFields) property to `["*"]`.The results will include geometries of features and values for all[available fields](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-FeatureLayerView.html#availableFields) for[client-side queries](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-FeatureLayerView.html#queryFeatures)or all fields in the layer for [server side queries](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryFeatures).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#createQuery)
     *
     *
     */
    createQuery(): Query;
    /**
     * Deletes attachments from a feature. This operation is available only if the layer's[capabilities.data.supportsAttachment](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities) is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#deleteAttachments)
     *
     * @param feature Feature containing attachments to be deleted.
     * @param attachmentIds Ids of the attachments to be deleted.
     *
     */
    deleteAttachments(feature: Graphic, attachmentIds: number[]): IPromise<FeatureEditResult>;
    /**
     * Returns a [FeatureType](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureType.html) describing the feature's type.This is applicable if the layer containing the feature has a [typeIdField](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#typeIdField).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#getFeatureType)
     *
     * @param feature A feature from this layer.
     *
     */
    getFeatureType(feature: Graphic): FeatureType;
    /**
     * Returns the [Field](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html) instance for a field name (case-insensitive).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#getField)
     *
     * @param fieldName Name of the field.
     *
     */
    getField(fieldName: string): Field;
    /**
     * Returns the [Domain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Domain.html) associated with the given field name. The domain can be either a[CodedValueDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-CodedValueDomain.html) or [RangeDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RangeDomain.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#getFieldDomain)
     *
     * @param fieldName Name of the field.
     * @param options An object specifying additional options. See the                     object specification table below for the required properties of this object.
     * @param options.feature The feature to which the [Domain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Domain.html) is assigned.
     *
     */
    getFieldDomain(fieldName: string, options?: FeatureLayerGetFieldDomainOptions): Domain;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryAttachments)
     *
     * @param attachmentQuery Specifies the attachment parameters for query.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryAttachments(
      attachmentQuery: AttachmentQuery | AttachmentQueryProperties,
      options?: FeatureLayerQueryAttachmentsOptions
    ): IPromise<any>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryExtent)
     *
     * @param query Specifies the attributes and spatialfilter of the query. If no parameters are specified, then the extent and count of all featuressatisfying the layer's configuration/filters are returned.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryExtent(query?: Query | QueryProperties, options?: FeatureLayerQueryExtentOptions): IPromise<any>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryFeatureCount)
     *
     * @param query Specifies the attributes andspatial filter of the query. If no parameters are specified, the total number of featuressatisfying the layer's configuration/filters is returned.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryFeatureCount(
      query?: Query | QueryProperties,
      options?: FeatureLayerQueryFeatureCountOptions
    ): IPromise<number>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryFeatures)
     *
     * @param query Specifies the attributes and spatialfilter of the query. If no parameters are specified, then all features satisfying the layer'sconfiguration/filters are returned.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryFeatures(query?: Query | QueryProperties, options?: FeatureLayerQueryFeaturesOptions): IPromise<FeatureSet>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryObjectIds)
     *
     * @param query Specifies the attributes and spatialfilter of the query. If no parameters are specified, then the Object IDs of all featuressatisfying the layer's configuration/filters are returned.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryObjectIds(query?: Query | QueryProperties, options?: FeatureLayerQueryObjectIdsOptions): IPromise<number[]>;
    /**
     * Executes a [RelationshipQuery](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-RelationshipQuery.html) against the feature service andreturns [FeatureSets](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-FeatureSet.html) grouped by source layer or table objectIds.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryRelatedFeatures)
     *
     * @param relationshipQuery Specifies relationship parametersfor querying related features or records from a layer or a table.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryRelatedFeatures(
      relationshipQuery: RelationshipQuery | RelationshipQueryProperties,
      options?: FeatureLayerQueryRelatedFeaturesOptions
    ): IPromise<any>;
    /**
     * Updates an existing attachment for a feature. This operation is available only if the layer's[capabilities.data.supportsAttachment](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities) is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#updateAttachment)
     *
     * @param feature The feature containing the attachment to be updated.
     * @param attachmentId Id of the attachment to be updated.
     * @param attachment HTML form that contains a file upload field pointing to the file to be added as an attachment.
     *
     */
    updateAttachment(
      feature: Graphic,
      attachmentId: number,
      attachment: HTMLFormElement | FormData
    ): IPromise<FeatureEditResult>;

    on(name: "layerview-create", eventHandler: FeatureLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: FeatureLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: FeatureLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface FeatureLayerConstructor {
    new (properties?: FeatureLayerProperties): FeatureLayer;

    fromJSON(json: any): FeatureLayer;
  }

  export const FeatureLayer: FeatureLayerConstructor;

  interface FeatureLayerProperties
    extends LayerProperties,
      PortalLayerProperties,
      ScaleRangeLayerProperties,
      RefreshableLayerProperties,
      TemporalLayerProperties {
    /**
     * Copyright information for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#copyright)
     */
    copyright?: string;
    /**
     * The SQL where clause used to filter features on the client. Only the features that satisfy the definitionexpression are displayed in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html). Setting a definition expression is usefulwhen the dataset is large and you don't want to bring all features to the client for analysis.Definition expressions may be set when a layer is constructed prior to it loading in the view orafter it has been added to the map. If the definition expression is set after the layer has been added to the map, the view willautomatically refresh itself to display the features that satisfy the new definition expression.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#definitionExpression)
     */
    definitionExpression?: string;
    /**
     * The name of the layer's primary display field. The value of this property matches the name of one of the fields of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#displayField)
     */
    displayField?: string;
    /**
     * An object that allows you to create a dynamic layer with dataeither from map service sublayers or data from a registered workspace.See [DynamicMapLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicMapLayer)for creating dynamic layers from map service layers for on the flyrendering, labeling, and filtering (definition expressions). To createdynamic layers from other sources in registered workspaces such as tables and table joins,see [DynamicDataLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicDataLayer).If you already have a [Sublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html) instance, youcan call the [createFeatureLayer()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#createFeatureLayer)method on the Sublayer to construct the layer for you.This only applies to map services with[dynamic layers](https://enterprise.arcgis.com/en/server/latest/publish-services/linux/about-dynamic-layers.htm) enabled.Therefore, the [url](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#url) of the FeatureLayer instance must point to a map service urlending with `/dynamicLayer`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#dynamicDataSource)
     */
    dynamicDataSource?: DynamicMapLayer | DynamicDataLayer;
    /**
     * Specifies how features are placed on the vertical axis (z). This property may only be usedin a [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html). See the [ElevationInfo sample](https://developers.arcgis.com/javascript/latest/sample-code/scene-elevationinfo/index.html)for an example of how this property may be used.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#elevationInfo)
     */
    elevationInfo?: FeatureLayerElevationInfo;
    /**
     * Configures the method for decluttering overlapping features in the view. If this property is not set (or set to `null`),every feature is drawn individually.Currently this property is only supported in 3D [SceneViews](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html) for point features with non-draped[Icons](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-IconSymbol3DLayer.html) or [Text](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-TextSymbol3DLayer.html)symbol layers.![declutter](https://developers.arcgis.com/javascript/assets/img/samples/city-points-declutter.gif)
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#featureReduction)
     */
    featureReduction?: FeatureLayerFeatureReduction;
    /**
     * An array of fields in the layer. Each field represents an attributethat may contain a value for each feature in the layer. For example,a field named `POP_2015`, stores information about total population as anumeric value for each feature; this value represents the total numberof people living within the geographic bounds of the feature.This property must be set in the constructor when creating a FeatureLayerfrom client-side [features](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html). To create FeatureLayers fromclient-side features you must also set the [source](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#source),[objectIdField](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#objectIdField), [spatialReference](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#spatialReference),[geometryType](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#geometryType), [renderer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#renderer), and [type](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#type) properties.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#fields)
     */
    fields?: FieldProperties[];
    /**
     * The geometry type of features in the layer. All features must be of the same type.This property is read-only when the layer is created from a [url](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#url).When creating a FeatureLayer from client-side features, this property isinferred by the geometryType of the features provided in the layer's [source](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#source)property.**Possible Values:** point | multipoint | polyline | polygon | multipatch | mesh
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#geometryType)
     */
    geometryType?: string;
    /**
     * The historic moment to query. If historicMoment is not specified, the querywill apply to the current features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#historicMoment)
     */
    historicMoment?: DateProperties;
    /**
     * Returns `true` if the layer is loaded from a non-spatial table in a service. Non-spatial table does not havea spatial column that represents geographic features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#isTable)
     *
     * @default false
     */
    isTable?: boolean;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#labelingInfo)
     */
    labelingInfo?: LabelClassProperties[];
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#labelsVisible)
     *
     * @default true
     */
    labelsVisible?: boolean;
    /**
     * The layer ID, or layer index, of a Feature Service layer. This is particularly useful whenloading a single FeatureLayer with the [portalItem](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#portalItem) property from a service containingmultiple layers. You can specify this value in one of two scenarios:* When loading the layer via the [portalItem](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#portalItem) property.* When pointing the layer [url](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#url) directly to the Feature Service.If a layerId is not specified in either of the above scenarios, then the first layerin the service (`layerId = 0`) is selected.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#layerId)
     */
    layerId?: number;
    /**
     * Indicates whether the layer will be included in the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled?: boolean;
    /**
     * The name of an `oid` [field](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#fields) containinga unique value or identifier for each feature in the layer.This is required when constructing a FeatureLayer from a collectionof client-side [features](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#objectIdField)
     */
    objectIdField?: string;
    /**
     * An array of field names from the service to include with each feature.To fetch the values from all fields in the layer, use `["*"]`. Fields specified in`outFields` will be requested alongside with required fields for [rendering](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#renderer),[labeling](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#labelingInfo) and setting the [elevation info](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#elevationInfo) for the layer.The required fields and `outFields` are used to populate[FeatureLayerView.availableFields](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-FeatureLayerView.html#availableFields).Set this property to include the fields that will be used for client-side[queries](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-FeatureLayerView.html#queryFeatures)if the fields are not part of required fields used for rendering.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#outFields)
     *
     * @default null
     */
    outFields?: string[];
    /**
     * Indicates whether to display popups when features in the layer are clicked. The layer needs to have a [popupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#popupTemplate) to define whatinformation should be displayed in the popup. Alternatively, a default popup template may be automatically used if[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled) is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled?: boolean;
    /**
     * The popup template for the layer. When set on the layer, the `popupTemplate`allows users to access attributes and display their values in the[view's popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html#popup) when a feature is selectedusing text and/or charts. See the [PopupTemplate sample](https://developers.arcgis.com/javascript/latest/sample-code/intro-popuptemplate/index.html)for an example of how [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) interacts with a[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).A default popup template is automatically used if no `popupTemplate` has been defined when[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled)is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#popupTemplate)
     */
    popupTemplate?: PopupTemplateProperties;
    /**
     * The renderer assigned to the layer. The renderer defines how tovisualize each feature in the layer. Depending on the renderer type,features may be visualized with the same symbol, or with varying symbolsbased on the values of provided attribute fields or functions.However, when creating a FeatureLayer from client-side features, this property mustbe specified in the layer's constructor along with the[source](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#source),[fields](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#fields), [objectIdField](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#objectIdField) properties.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#renderer)
     */
    renderer?: RendererProperties;
    /**
     * When `true`, indicates that M values will be returned. When`false`, indicates that M values will never be returned. The layer viewdetermines whether to include M values in feature queries when theproperty value is `undefined`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#returnM)
     *
     * @default undefined
     */
    returnM?: boolean;
    /**
     * When `true`, indicates that Z values will always be returned. When`false`, indicates that Z values will never be returned. The layer viewdetermines whether to include Z values in feature queries when theproperty value is `undefined`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#returnZ)
     *
     * @default undefined
     */
    returnZ?: boolean;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#screenSizePerspectiveEnabled)
     *
     * @default true
     */
    screenSizePerspectiveEnabled?: boolean;
    /**
     * A collection of [Graphic](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html) objects used to create a FeatureLayer.The geometry of each feature all must have a matching [geometryType](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#geometryType).This property should only be used when creating a FeatureLayer from client-side features.When creating a FeatureLayer from client-side features, the [fields](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#fields),[objectIdField](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#objectIdField), [renderer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#renderer), and [type](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#type) properties must also be set.Use [applyEdits()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#applyEdits) method to add, remove, and update featuresfrom a layer at runtime. Once `applyEdits()` resolves successfully, use [queryFeatures()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryFeatures)to return updated features.The [spatialReference](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#spatialReference) and [geometryType](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#geometryType) propertiesare determined based on the features provided to this property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#source)
     */
    source?: CollectionProperties<GraphicProperties>;
    /**
     * The spatial reference of the layer. When creating the layer from a[url](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#url), the spatial reference is read from the service.When creating a FeatureLayer from client-side features, this property isinferred from the geometries of the features provided in the [source](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#source)property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#spatialReference)
     */
    spatialReference?: SpatialReferenceProperties;
    /**
     * An array of feature templates defined in the feature layer.See [ArcGIS Pro subtypes document](https://pro.arcgis.com/en/pro-app/help/data/geodatabases/overview/an-overview-of-subtypes.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#templates)
     */
    templates?: FeatureTemplateProperties[];
    /**
     * An array of subtypes defined in the feature service exposed by ArcGIS REST API.Each item includes information about the type, such as the type ID, name, and definition expression.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#types)
     */
    types?: FeatureTypeProperties[];
    /**
     * The URL of the REST endpoint of the layer, non-spatial table or service. The URL may either point to aresource on ArcGIS Enterprise or ArcGIS Online.If the url points directly to a service, then the layer must be specified in the[layerId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#layerId) property. If no [layerId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#layerId) is given, then the first layer in the service will be loaded.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#url)
     */
    url?: string;
  }

  /**
   * The fields that record who addsor edits data in the feature service and when the edit is made.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#EditFieldsInfo)
   */
  export interface EditFieldsInfo extends Object {
    /**
     * The name of the field that stores the name of the user who created the feature.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#EditFieldsInfo)
     */
    creatorField: string;
    /**
     * The name of the field that stores the date and time the feature was created.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#EditFieldsInfo)
     */
    creationDateField: string;
    /**
     * The name of the field that stores the name of the user who last edited the feature.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#EditFieldsInfo)
     */
    editorField: string;
    /**
     * The name of the field that stores the date and time the feature was last edited.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#EditFieldsInfo)
     */
    editDateField: string;
  }

  /**
   * Specifies information about editing.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#EditingInfo)
   */
  export interface EditingInfo extends Object {
    /**
     * Indicates the last time the layer was edited. This value gets updated every time the layer's data is edited or when any of its properties change.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#EditingInfo)
     */
    lastEditDate: Date;
  }

  /**
   * FeatureEditResult represents the result of adding, updating or deleting a feature.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#FeatureEditResult)
   */
  export interface FeatureEditResult extends Object {
    /**
     * Object Id of the feature that was edited.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#FeatureEditResult)
     */
    objectId: number;
    /**
     * If the edit failed, the edit result includes an error.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#FeatureEditResult)
     */
    error: FeatureEditResultError;
  }

  export interface FeatureLayerApplyEditsEdits extends Object {
    /**
     * Array of features to be added.Values of non nullable fields must be provided when adding new features. Date fields must have[numeric](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTime) valuesrepresenting universal time.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#applyEdits)
     */
    addFeatures?: Graphic[];
    /**
     * Array of features to be updated. Each feature must have valid[objectId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#objectIdField). Values of non nullable fields must be provided when updating features. Date fields must have[numeric](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTime) valuesrepresenting universal time.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#applyEdits)
     */
    updateFeatures?: Graphic[];
    /**
     * An array of features orobjects to be deleted. When an array of features is passed, each feature must have a valid[objectId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#objectIdField). When an array of objects is used, each object must have a valid`objectId` property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#applyEdits)
     */
    deleteFeatures?: Graphic[] | any[];
  }

  export interface FeatureLayerCapabilities extends Object {
    /**
     * Describes characteristics of the data in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    data: FeatureLayerCapabilitiesData;
    /**
     * Describes editing capabilities that can be performed on the features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    editing: FeatureLayerCapabilitiesEditing;
    /**
     * Describes the metadata contained on features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    metadata: FeatureLayerCapabilitiesMetadata;
    /**
     * Describes operations that can be performed on features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    operations: FeatureLayerCapabilitiesOperations;
    /**
     * Describes [query](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html)operations that can be performed on features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    query: FeatureLayerCapabilitiesQuery;
    /**
     * Indicates if the layer's query operation supports querying features or records related to features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    queryRelated: FeatureLayerCapabilitiesQueryRelated;
  }

  export interface FeatureLayerCapabilitiesData extends Object {
    /**
     * Indicates if the attachment is enabled on the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsAttachment: boolean;
    /**
     * Indicates if the features in the layer support M values. Requires ArcGIS Server service 10.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsM: boolean;
    /**
     * Indicates if the features in the layer support Z values. Requires ArcGIS Server service 10.1 or greater.See [elevationInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#elevationInfo) for details regarding placement andrendering of features with z-values in 3D [SceneViews](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsZ: boolean;
  }

  export interface FeatureLayerCapabilitiesEditing extends Object {
    /**
     * Indicates if anonymous users can delete features created by others.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsDeleteByAnonymous: boolean;
    /**
     * Indicates if logged in users can delete features created by others.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsDeleteByOthers: boolean;
    /**
     * Indicates if the geometry of the features in the layer can be edited.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsGeometryUpdate: boolean;
    /**
     * Indicates if the `globalid` values provided by the client are used in [applyEdits](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#applyEdits).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsGlobalId: boolean;
    /**
     * Indicates if the `rollbackOnFailure` parameter can be set to `true` or `false` when running the synchronizeReplica operation.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsRollbackOnFailure: boolean;
    /**
     * Indicates if anonymous users can update features created by others.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsUpdateByAnonymous: boolean;
    /**
     * Indicates if logged in users can update features created by others.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsUpdateByOthers: boolean;
    /**
     * Indicates if `m-values` must be provided when updating features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsUpdateWithoutM: boolean;
    /**
     * Indicates if the layer supports uploading attachments by [UploadId](https://developers.arcgis.com/rest/services-reference/item.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsUploadWithItemId: boolean;
  }

  export interface FeatureLayerCapabilitiesMetadata extends Object {
    /**
     * Indicates whether to provide a user-defined field description.See [Describe attribute fields](https://doc.arcgis.com/en/arcgis-online/manage-data/describe-fields.htm) for additional information.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsAdvancedFieldProperties: boolean;
  }

  export interface FeatureLayerCapabilitiesOperations extends Object {
    /**
     * Indicates if new features can be [added](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#applyEdits) to the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsAdd: boolean;
    /**
     * Indicates if features can be [deleted](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#applyEdits) from the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsDelete: boolean;
    /**
     * Indicates if features in the layer can be [updated](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#applyEdits).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsUpdate: boolean;
    /**
     * Indicates if features in the layer can be [edited](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#applyEdits). Use `supportsAdd`, `supportsUpdate` and `supportsDelete` to determine which editing operations are supported.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsEditing: boolean;
    /**
     * Indicates if values of one or more field values in the layercan be updated. See the [Calculate REST operation](https://developers.arcgis.com/rest/services-reference/calculate-feature-service-layer-.htm)document for more information.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsCalculate: boolean;
    /**
     * Indicates if features in the layer can be [queried](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryFeatures).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsQuery: boolean;
    /**
     * Indicates if the layer supports[REST API queryAttachments](https://developers.arcgis.com/rest/services-reference/query-attachments-feature-service-layer-.htm)operation, which is supported with hosted feature services at version 10.5 and greater.If `false`, [queryAttachments() method](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryAttachments) can only return attachments for one feature at a time.If `true`, `queryAttachments()` can return attachments for array of [objectIds](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-AttachmentQuery.html#objectIds).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsQueryAttachments: boolean;
    /**
     * Indicates if the layer supports a SQL-92 expression or where clause. This operation isonly supported in ArcGIS Online hosted feature services.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsValidateSql: boolean;
    /**
     * Indicates if resized attachments are supported in the feature layer.This is useful for showing thumbnails in [Popups](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsResizeAttachments: boolean;
  }

  export interface FeatureLayerCapabilitiesQuery extends Object {
    /**
     * Indicates if the geometry centroid associated with each polygon feature can be returned. This operation isonly supported in ArcGIS Online hosted feature services.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsCentroid: boolean;
    /**
     * Indicates if the layer's query operation supports a buffer distance for input geometries.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsDistance: boolean;
    /**
     * Indicates if the layer supports queries for distinct values based on fields specified in the [outFields](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#outFields).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsDistinct: boolean;
    /**
     * Indicates if the query operation supports `disjoint` [spatial relationship](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html#spatialRelationship). This is valid only for[hosted feature services](http://doc.arcgis.com/en/arcgis-online/share-maps/hosted-web-layers.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsDisjointSpatialRelationship: boolean;
    /**
     * Indicates if the layer's query response includes the extent of features.At 10.3, this option is only available for hosted feature services. At 10.3.1, it is available for hosted and non-hosted feature services.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsExtent: boolean;
    /**
     * Indicates if the layer's query response contains geometry attributes, including shape area and length attributes.This operation is supported in ArcGIS Online hosted feature services created since December 2016 and ArcGIS Enterprise feature services since version 10.7.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsGeometryProperties: boolean;
    /**
     * Indicates if the layer supports the [having](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html#having) clause on the service. Requires an ArcGIS Server service 10.6.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsHavingClause: boolean;
    /**
     * Indicates if features returned in the query response can be ordered by one or more fields. Requires an ArcGIS Server service 10.3 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsOrderBy: boolean;
    /**
     * Indicates if the query response supports pagination. Requires an ArcGIS Server service 10.3 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsPagination: boolean;
    /**
     * Indicates if the query response includes the [query geometry](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-FeatureSet.html#queryGeometry). This is valid only for[hosted feature services](http://doc.arcgis.com/en/arcgis-online/share-maps/hosted-web-layers.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsQueryGeometry: boolean;
    /**
     * Indicates if the query operation supports the projection of geometries onto a virtual grid. Requires an ArcGIS Server service 10.6.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsQuantization: boolean;
    /**
     * Indicates if the query operation supports quantization designed to be used in edit mode (highest resolution at the given spatial reference). Requires an ArcGIS Server service 10.6.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsQuantizationEditMode: boolean;
    /**
     * Indicates if the number of features returned by the query operation can be controlled.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsResultType: boolean;
    /**
     * Indicates if the query operation supports SQL expressions.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsSqlExpression: boolean;
    /**
     * Indicates if the query operation supports using standardized queries.Learn more about [standardized queries here](http://server.arcgis.com/en/server/latest/administer/linux/about-standardized-queries.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsStandardizedQueriesOnly: boolean;
    /**
     * Indicates if the layer supports field-based statistical functions. Requires ArcGIS Server service 10.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsStatistics: boolean;
    /**
     * Indicates if the layer supports historic moment query. Requires ArcGIS Server service 10.5 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsHistoricMoment: boolean;
  }

  export interface FeatureLayerCapabilitiesQueryRelated extends Object {
    /**
     * Indicates if the layer's query response includes the number of features or records related to features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsCount: boolean;
    /**
     * Indicates if the related features or records returned in the query response can be ordered by one or more fields.Requires ArcGIS Server service 10.3 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsOrderBy: boolean;
    /**
     * Indicates if the query response supports pagination for related features or records. Requires ArcGIS Server service 10.3 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#capabilities)
     */
    supportsPagination: boolean;
  }

  export interface FeatureLayerCreatePopupTemplateOptions extends Object {
    /**
     * The maximum number of fields to include in the  popup template.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#createPopupTemplate)
     *
     * @default 75
     */
    maximumFields?: number;
    /**
     * Field types to ignore when creating the popup.  By default the `geometry`, `blob`, `raster`, `guid` and `xml` field types are ignored.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#createPopupTemplate)
     */
    ignoreFieldTypes?: string[];
  }

  export interface FeatureLayerElevationInfo extends Object {
    /**
     * Defines how the feature is placed with respect to the terrain surface. If the geometry consists of multiplepoints (e.g. lines or polygons), the elevation is evaluated separately for each point. See the table below for a list of possible values.Mode | Description------|------------on-the-ground | Features are draped on the terrain surface. This is the default value for features with [Polyline](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html) or [Polygon](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html) geometries and features with [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) geometries rendered with [ObjectSymbol3DLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-ObjectSymbol3DLayer.html).relative-to-ground | Features are placed at an elevation relative to the terrain surface. The feature's elevation is determined by summing up the terrain elevation and the geometry's z-value (if present). If `featureExpressionInfo` is defined, the result of the expression is used instead of the geometry’s z-value. `relative-to-ground` is the default value for [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) geometries rendered with [IconSymbol3DLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-IconSymbol3DLayer.html).absolute-height | Features are placed at an absolute elevation (z-value) above sea level. This z-value is determined by the geometry's z-value (if present). If `featureExpressionInfo` is defined, the result of the expression is used instead of the geometry’s z-value. This mode doesn't take the elevation of the terrain into account. This is the default value of features with any geometry type where [hasZ](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#hasZ) is `true`.relative-to-scene | Features are aligned to buildings and other objects part of 3D Object [SceneLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html) or [IntegratedMeshLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-IntegratedMeshLayer.html), depending on which has higher elevation. If the feature is not directly above a building or any other feature, it is aligned to the terrain surface elevation. If defined, the result of `featureExpressionInfo` is added to the 3D Object/terrain surface elevation. In this mode z-values are ignored.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#elevationInfo)
     */
    mode: string;
    /**
     * An elevation offset, which is added to the vertical position of the feature. If `unit` is not defined, the offsetis in `meters`.When `mode = "on-the-ground"`, this property has no effect.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#elevationInfo)
     */
    offset?: number;
    /**
     * This object contains information about setting a custom z-value on the feature.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#elevationInfo)
     */
    featureExpressionInfo?: FeatureLayerElevationInfoFeatureExpressionInfo;
    /**
     * The unit for `featureExpressionInfo` and `offset` values. It doesn't apply to z-values.**Possible Values:** feet | meters | kilometers | miles | us-feet | yards
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#elevationInfo)
     */
    unit?: string;
  }

  export interface FeatureLayerElevationInfoFeatureExpressionInfo extends Object {
    /**
     * An [Arcade expression](https://developers.arcgis.com/javascript/latest/guide/arcade/index.html) evaluating to a number that determinesthe z-value of the feature. If the geometry has z-values, they will be ignored and `featureExpressionInfo` will be used to calculate the verticalposition of the feature. When `mode = "on-the-ground"`, this property has no effect. For line and polygon geometries the result of the expressionis the same for all vertices of a feature.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#elevationInfo)
     */
    expression?: string;
  }

  export interface FeatureLayerFeatureReduction extends Object {
    /**
     * Type of the decluttering method. The only supported type at the moment is`"selection"`. In this method, some of the overlapping features are hidden such that none of the remaining featuresintersect on screen. Label deconfliction also respects this option and hides labels that would overlap with the features of this layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#featureReduction)
     */
    type: string;
  }

  export interface FeatureLayerGetFieldDomainOptions extends Object {
    /**
     * The feature to which the [Domain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Domain.html) is assigned.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#getFieldDomain)
     */
    feature: Graphic;
  }

  export interface FeatureLayerQueryAttachmentsOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryAttachments)
     */
    signal?: AbortSignal;
  }

  export interface FeatureLayerQueryExtentOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryExtent)
     */
    signal?: AbortSignal;
  }

  export interface FeatureLayerQueryFeatureCountOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryFeatureCount)
     */
    signal?: AbortSignal;
  }

  export interface FeatureLayerQueryFeaturesOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryFeatures)
     */
    signal?: AbortSignal;
  }

  export interface FeatureLayerQueryObjectIdsOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryObjectIds)
     */
    signal?: AbortSignal;
  }

  export interface FeatureLayerQueryRelatedFeaturesOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#queryRelatedFeatures)
     */
    signal?: AbortSignal;
  }

  export interface FeatureLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface FeatureLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface FeatureLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  export interface FeatureEditResultError extends Object {
    /**
     * Error name.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#FeatureEditResult)
     */
    name: string;
    /**
     * Message describing the error.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#FeatureEditResult)
     */
    message: string;
  }

  interface GeoJSONLayer extends Layer, ScaleRangeLayer, TemporalLayer {
    /**
     * Describes the layer's supported capabilities.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    readonly capabilities: GeoJSONLayerCapabilities;
    /**
     * Copyright information for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#copyright)
     */
    copyright: string;
    /**
     * The SQL where clause used to filter features on the client. Only the features that satisfy the definitionexpression are displayed in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html).Definition expressions may be set when a layer is constructed prior to it loading in the view orafter it has been added to the map. If the definition expression is set after the layer has been added to the map, the view willautomatically refresh itself to display the features that satisfy the new definition expression.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#definitionExpression)
     */
    definitionExpression: string;
    /**
     * The name of the layer's primary display field. The value of this property matches the name of one of the fields of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#displayField)
     */
    displayField: string;
    /**
     * Specifies how graphics are placed on the vertical axis (z). This property may only be usedin a [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html). See the [ElevationInfo sample](https://developers.arcgis.com/javascript/latest/sample-code/scene-elevationinfo/index.html)for an example of how this property may be used.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#elevationInfo)
     */
    elevationInfo: GeoJSONLayerElevationInfo;
    /**
     * Configures the method for decluttering overlapping features in the view. If this property is not set (or set to `null`),every feature is drawn individually.Currently this property is only supported in 3D [SceneViews](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html) for point features with non-draped[Icons](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-IconSymbol3DLayer.html) or [Text](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-TextSymbol3DLayer.html)symbol layers.![declutter](https://developers.arcgis.com/javascript/assets/img/samples/city-points-declutter.gif)
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#featureReduction)
     */
    featureReduction: GeoJSONLayerFeatureReduction;
    /**
     * An array of fields in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#fields)
     */
    fields: Field[];
    /**
     * A convenient property that can be used to make case-insensitive lookups for a field by name.It can also provide a list of the [date fields](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FieldsIndex.html#dateFields) in a layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#fieldsIndex)
     */
    readonly fieldsIndex: FieldsIndex;
    /**
     * The geometry type of features in the layer. All features must be of the same type.**Possible Values:** point | multipoint | polyline | polygon
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#geometryType)
     */
    geometryType: string;
    /**
     * Indicates whether the client-side features in the layer have `Z` (elevation) values.Refer to [elevationInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#elevationInfo) for details regarding placement and renderingof features with z-values in 3D [SceneViews](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html).Use the `supportsZ` property in the layer's [capabilities.data](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)object to verify if `Z` values are supported on the features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#hasZ)
     *
     * @default undefined
     */
    readonly hasZ: boolean;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#labelingInfo)
     */
    labelingInfo: LabelClass[];
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#labelsVisible)
     *
     * @default true
     */
    labelsVisible: boolean;
    /**
     * Indicates whether the layer will be included in the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled: boolean;
    /**
     * The name of an `oid` [field](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#fields) containinga unique value or identifier for each feature in the layer.`id` property of the feature object in the GeoJSON will be used as ObjectID.If `id` property is not present and `objectIDField` is not specified, `ObjectID` field will be generated for each feature.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#objectIdField)
     */
    objectIdField: string;
    /**
     * Indicates whether to display popups when features in the layer are clicked. The layer needs to have a [popupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#popupTemplate) to define whatinformation should be displayed in the popup. Alternatively, a default popup template may be automatically used if[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled) is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled: boolean;
    /**
     * The popup template for the layer. When set on the layer, the `popupTemplate`allows users to access attributes and display their values in the[view's popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html#popup) when a feature is selectedusing text and/or charts. See the [PopupTemplate sample](https://developers.arcgis.com/javascript/latest/sample-code/intro-popuptemplate/index.html)for an example of how [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) interacts with a[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).A default popup template is automatically used if no `popupTemplate` has been defined when[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled)is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#popupTemplate)
     */
    popupTemplate: PopupTemplate;
    /**
     * The renderer assigned to the layer. The renderer defines how tovisualize each feature in the layer. Depending on the renderer type,features may be visualized with the same symbol, or with varying symbolsbased on the values of provided attribute fields or functions. If not specified,a default renderer will be generated based on the geometry type.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#renderer)
     */
    renderer: Renderer;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#screenSizePerspectiveEnabled)
     *
     * @default true
     */
    screenSizePerspectiveEnabled: boolean;
    /**
     * The spatial reference of the layer. The default value is WGS84.This property can be set explicitly to project the longitude and latitudecoordinates when the layer parses the GeoJSON file. While not required, explicitly settingthe spatial reference of the layer will improve the performancewhen projecting to a spatial reference other than the one used by thecoordinates in the raw data.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#spatialReference)
     *
     * @default SpatialReference.WGS84
     */
    spatialReference: SpatialReference;
    /**
     * An array of feature templates defined in the layer.See [ArcGIS Pro subtypes document](https://pro.arcgis.com/en/pro-app/help/data/geodatabases/overview/an-overview-of-subtypes.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#templates)
     */
    templates: FeatureTemplate[];
    /**
     * The URL of the GeoJSON file.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#url)
     */
    url: string;

    /**
     * Applies edits to features in a layer. New features can be created and existingfeatures can be updated or deleted on the cilent side. Feature geometries and/or attributes may be modified.If client-side features are added, removed or updated at runtime using [applyEdits()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#applyEdits)then use [queryFeatures()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#queryFeatures) to return updated features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#applyEdits)
     *
     * @param edits Object containing features to be added, updated or deleted.
     * @param edits.addFeatures Array of features to be added.Values of non nullable fields must be provided when adding new features. Date fields must have[numeric](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTime) valuesrepresenting universal time.
     * @param edits.updateFeatures Array of features to be updated. Each feature must have valid[objectId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#objectIdField). Values of non nullable fields must be provided when updating features. Date fields must have[numeric](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTime) valuesrepresenting universal time.
     * @param edits.deleteFeatures An array of features orobjects to be deleted. When an array of features is passed, each feature must have a valid[objectId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#objectIdField). When an array of objects is used, each object must have a valid`objectId` property.
     *
     */
    applyEdits(edits: GeoJSONLayerApplyEditsEdits): IPromise<any>;
    /**
     * Creates a popup template for the layer, populated with all the fields of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#createPopupTemplate)
     *
     * @param options Options for creating the popup template.
     * @param options.maximumFields The maximum number of fields to include in the  popup template.
     * @param options.ignoreFieldTypes Field types to ignore when creating the popup.  By default the `geometry`, `blob`, `raster`, `guid` and `xml` field types are ignored.
     *
     */
    createPopupTemplate(options?: GeoJSONLayerCreatePopupTemplateOptions): PopupTemplate;
    /**
     * Creates query parameter object that can be used to fetch features thatsatisfy the layer's configurations such as [definitionExpression](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#definitionExpression).It will return `Z` and `M` values based on the layer's [data capabilities](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities).It sets the query parameter's [outFields](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html#outFields) property to `["*"]`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#createQuery)
     *
     *
     */
    createQuery(): Query;
    /**
     * Returns the [Field](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html) instance for a field name (case-insensitive).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#getField)
     *
     * @param fieldName Name of the field.
     *
     */
    getField(fieldName: string): Field;
    /**
     * Returns the Domain associated with the given field name. The domain can be either a CodedValueDomain or RangeDomain.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#getFieldDomain)
     *
     * @param fieldName Name of the field.
     * @param options An object specifying additional options. See the                     object specification table below for the required properties of this object.
     * @param options.feature The feature to which the [Domain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Domain.html) is assigned.
     *
     */
    getFieldDomain(fieldName: string, options?: GeoJSONLayerGetFieldDomainOptions): Domain;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#queryExtent)
     *
     * @param query Specifies the attributes and spatialfilter of the query. If no parameters are specified, then the extent and count of all featuressatisfying the layer's configuration/filters are returned.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryExtent(query?: Query | QueryProperties, options?: GeoJSONLayerQueryExtentOptions): IPromise<any>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#queryFeatureCount)
     *
     * @param query Specifies the attributes andspatial filter of the query. If no parameters are specified, the total number of featuressatisfying the layer's configuration/filters is returned.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryFeatureCount(
      query?: Query | QueryProperties,
      options?: GeoJSONLayerQueryFeatureCountOptions
    ): IPromise<number>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#queryFeatures)
     *
     * @param query Specifies the attributes and spatialfilter of the query. If no parameters are specified, then all features satisfying the layer'sconfiguration/filters are returned.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryFeatures(query?: Query | QueryProperties, options?: GeoJSONLayerQueryFeaturesOptions): IPromise<FeatureSet>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#queryObjectIds)
     *
     * @param query Specifies the attributes and spatialfilter of the query. If no parameters are specified, then the Object IDs of all featuressatisfying the layer's configuration/filters are returned.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryObjectIds(query?: Query | QueryProperties, options?: GeoJSONLayerQueryObjectIdsOptions): IPromise<number[]>;

    on(name: "layerview-create", eventHandler: GeoJSONLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: GeoJSONLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: GeoJSONLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface GeoJSONLayerConstructor {
    new (properties?: GeoJSONLayerProperties): GeoJSONLayer;
  }

  export const GeoJSONLayer: GeoJSONLayerConstructor;

  interface GeoJSONLayerProperties extends LayerProperties, ScaleRangeLayerProperties, TemporalLayerProperties {
    /**
     * Copyright information for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#copyright)
     */
    copyright?: string;
    /**
     * The SQL where clause used to filter features on the client. Only the features that satisfy the definitionexpression are displayed in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html).Definition expressions may be set when a layer is constructed prior to it loading in the view orafter it has been added to the map. If the definition expression is set after the layer has been added to the map, the view willautomatically refresh itself to display the features that satisfy the new definition expression.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#definitionExpression)
     */
    definitionExpression?: string;
    /**
     * The name of the layer's primary display field. The value of this property matches the name of one of the fields of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#displayField)
     */
    displayField?: string;
    /**
     * Specifies how graphics are placed on the vertical axis (z). This property may only be usedin a [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html). See the [ElevationInfo sample](https://developers.arcgis.com/javascript/latest/sample-code/scene-elevationinfo/index.html)for an example of how this property may be used.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#elevationInfo)
     */
    elevationInfo?: GeoJSONLayerElevationInfo;
    /**
     * Configures the method for decluttering overlapping features in the view. If this property is not set (or set to `null`),every feature is drawn individually.Currently this property is only supported in 3D [SceneViews](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html) for point features with non-draped[Icons](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-IconSymbol3DLayer.html) or [Text](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-TextSymbol3DLayer.html)symbol layers.![declutter](https://developers.arcgis.com/javascript/assets/img/samples/city-points-declutter.gif)
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#featureReduction)
     */
    featureReduction?: GeoJSONLayerFeatureReduction;
    /**
     * An array of fields in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#fields)
     */
    fields?: FieldProperties[];
    /**
     * The geometry type of features in the layer. All features must be of the same type.**Possible Values:** point | multipoint | polyline | polygon
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#geometryType)
     */
    geometryType?: string;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#labelingInfo)
     */
    labelingInfo?: LabelClassProperties[];
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#labelsVisible)
     *
     * @default true
     */
    labelsVisible?: boolean;
    /**
     * Indicates whether the layer will be included in the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled?: boolean;
    /**
     * The name of an `oid` [field](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#fields) containinga unique value or identifier for each feature in the layer.`id` property of the feature object in the GeoJSON will be used as ObjectID.If `id` property is not present and `objectIDField` is not specified, `ObjectID` field will be generated for each feature.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#objectIdField)
     */
    objectIdField?: string;
    /**
     * Indicates whether to display popups when features in the layer are clicked. The layer needs to have a [popupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#popupTemplate) to define whatinformation should be displayed in the popup. Alternatively, a default popup template may be automatically used if[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled) is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled?: boolean;
    /**
     * The popup template for the layer. When set on the layer, the `popupTemplate`allows users to access attributes and display their values in the[view's popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html#popup) when a feature is selectedusing text and/or charts. See the [PopupTemplate sample](https://developers.arcgis.com/javascript/latest/sample-code/intro-popuptemplate/index.html)for an example of how [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) interacts with a[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).A default popup template is automatically used if no `popupTemplate` has been defined when[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled)is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#popupTemplate)
     */
    popupTemplate?: PopupTemplateProperties;
    /**
     * The renderer assigned to the layer. The renderer defines how tovisualize each feature in the layer. Depending on the renderer type,features may be visualized with the same symbol, or with varying symbolsbased on the values of provided attribute fields or functions. If not specified,a default renderer will be generated based on the geometry type.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#renderer)
     */
    renderer?: RendererProperties;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#screenSizePerspectiveEnabled)
     *
     * @default true
     */
    screenSizePerspectiveEnabled?: boolean;
    /**
     * The spatial reference of the layer. The default value is WGS84.This property can be set explicitly to project the longitude and latitudecoordinates when the layer parses the GeoJSON file. While not required, explicitly settingthe spatial reference of the layer will improve the performancewhen projecting to a spatial reference other than the one used by thecoordinates in the raw data.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#spatialReference)
     *
     * @default SpatialReference.WGS84
     */
    spatialReference?: SpatialReferenceProperties;
    /**
     * An array of feature templates defined in the layer.See [ArcGIS Pro subtypes document](https://pro.arcgis.com/en/pro-app/help/data/geodatabases/overview/an-overview-of-subtypes.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#templates)
     */
    templates?: FeatureTemplateProperties[];
    /**
     * The URL of the GeoJSON file.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#url)
     */
    url?: string;
  }

  export interface GeoJSONLayerApplyEditsEdits extends Object {
    /**
     * Array of features to be added.Values of non nullable fields must be provided when adding new features. Date fields must have[numeric](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTime) valuesrepresenting universal time.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#applyEdits)
     */
    addFeatures?: Graphic[];
    /**
     * Array of features to be updated. Each feature must have valid[objectId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#objectIdField). Values of non nullable fields must be provided when updating features. Date fields must have[numeric](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTime) valuesrepresenting universal time.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#applyEdits)
     */
    updateFeatures?: Graphic[];
    /**
     * An array of features orobjects to be deleted. When an array of features is passed, each feature must have a valid[objectId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#objectIdField). When an array of objects is used, each object must have a valid`objectId` property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#applyEdits)
     */
    deleteFeatures?: Graphic[] | any[];
  }

  export interface GeoJSONLayerCapabilities extends Object {
    /**
     * Describes characteristics of the data in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    data: GeoJSONLayerCapabilitiesData;
    /**
     * Describes editing capabilities that can be performed on the features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    editing: GeoJSONLayerCapabilitiesEditing;
    /**
     * Describes operations that can be performed on features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    operations: GeoJSONLayerCapabilitiesOperations;
    /**
     * Describes [query](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html)operations that can be performed on features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    query: GeoJSONLayerCapabilitiesQuery;
    /**
     * Indicates if the layer's query operation supports querying features or records related to features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    queryRelated: GeoJSONLayerCapabilitiesQueryRelated;
  }

  export interface GeoJSONLayerCapabilitiesData extends Object {
    /**
     * Indicates if the attachment is enabled on the layer. At this current time, the GeoJSONLayer doesn’t support attachments.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsAttachment: boolean;
    /**
     * Indicates if the features in the layer support M values. Requires ArcGIS Server service 10.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsM: boolean;
    /**
     * Indicates if the features in the layer support Z values. Requires ArcGIS Server service 10.1 or greater.See [elevationInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#elevationInfo) for details regarding placement andrendering of features with z-values in 3D [SceneViews](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsZ: boolean;
  }

  export interface GeoJSONLayerCapabilitiesEditing extends Object {
    /**
     * Indicates if anonymous users can delete features created by others.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsDeleteByAnonymous: boolean;
    /**
     * Indicates if logged in users can delete features created by others.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsDeleteByOthers: boolean;
    /**
     * Indicates if the geometry of the features in the layer can be edited.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsGeometryUpdate: boolean;
    /**
     * Indicates if the `globalid` values provided by the client are used in [applyEdits](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#applyEdits).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsGlobalId: boolean;
    /**
     * Indicates if the `rollbackOnFailure` parameter can be set to `true` or `false` when running the synchronizeReplica operation.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsRollbackOnFailure: boolean;
    /**
     * Indicates if anonymous users can update features created by others.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsUpdateByAnonymous: boolean;
    /**
     * Indicates if logged in users can update features created by others.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsUpdateByOthers: boolean;
    /**
     * Indicates if `m-values` must be provided when updating features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsUpdateWithoutM: boolean;
    /**
     * Indicates if the layer supports uploading attachments by [UploadId](https://developers.arcgis.com/rest/services-reference/item.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsUploadWithItemId: boolean;
  }

  export interface GeoJSONLayerCapabilitiesOperations extends Object {
    /**
     * Indicates if new features can be [added](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#applyEdits) to the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsAdd: boolean;
    /**
     * Indicates if features can be [deleted](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#applyEdits) from the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsDelete: boolean;
    /**
     * Indicates if features in the layer can be [updated](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#applyEdits).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsUpdate: boolean;
    /**
     * Indicates if features in the layer can be [edited](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#applyEdits). Use `supportsAdd`, `supportsUpdate` and `supportsDelete` to determine which editing operations are supported.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsEditing: boolean;
    /**
     * Indicates if values of one or more field values in the layercan be updated. See the [Calculate REST operation](https://developers.arcgis.com/rest/services-reference/calculate-feature-service-layer-.htm)document for more information.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsCalculate: boolean;
    /**
     * Indicates if features in the layer can be [queried](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#queryFeatures).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsQuery: boolean;
    /**
     * Indicates if the layer supports[REST API queryAttachments](https://developers.arcgis.com/rest/services-reference/query-attachments-feature-service-layer-.htm)operation, which is supported with hosted feature services at version 10.5 and greater.If `false`, [queryAttachments() method](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#queryAttachments) can only return attachments for one feature at a time.If `true`, `queryAttachments()` can return attachments for array of [objectIds](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-AttachmentQuery.html#objectIds).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsQueryAttachments: boolean;
    /**
     * Indicates if the layer supports a SQL-92 expression or where clause. This operation isonly supported in ArcGIS Online hosted feature services.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsValidateSql: boolean;
    /**
     * Indicates if resized attachments are supported in the layer.This is useful for showing thumbnails in [Popups](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsResizeAttachments: boolean;
  }

  export interface GeoJSONLayerCapabilitiesQuery extends Object {
    /**
     * Indicates if the geometry centroid associated with each polygon feature can be returned. This operation isonly supported in ArcGIS Online hosted feature services.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsCentroid: boolean;
    /**
     * Indicates if the layer's query operation supports a buffer distance for input geometries.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsDistance: boolean;
    /**
     * Indicates if the layer supports queries for distinct values based on fields specified in the [outFields](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#outFields).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsDistinct: boolean;
    /**
     * Indicates if the query operation supports `disjoint` [spatial relationship](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html#spatialRelationship). This is valid only for[hosted feature services](http://doc.arcgis.com/en/arcgis-online/share-maps/hosted-web-layers.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsDisjointSpatialRelationship: boolean;
    /**
     * Indicates if the layer's query response includes the extent of features.At 10.3, this option is only available for hosted feature services. At 10.3.1, it is available for hosted and non-hosted feature services.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsExtent: boolean;
    /**
     * Indicates if the layer's query response contains geometry attributes, including shape area and length attributes.This operation is only supported in ArcGIS Online hosted feature services.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsGeometryProperties: boolean;
    /**
     * Indicates if the layer supports the [having](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html#having) clause on the service. Requires an ArcGIS Server service 10.6.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsHavingClause: boolean;
    /**
     * Indicates if features returned in the query response can be ordered by one or more fields. Requires an ArcGIS Server service 10.3 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsOrderBy: boolean;
    /**
     * Indicates if the query response supports pagination. Requires an ArcGIS Server service 10.3 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsPagination: boolean;
    /**
     * Indicates if the query response includes the [query geometry](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-FeatureSet.html#queryGeometry). This is valid only for[hosted feature services](http://doc.arcgis.com/en/arcgis-online/share-maps/hosted-web-layers.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsQueryGeometry: boolean;
    /**
     * Indicates if the query operation supports the projection of geometries onto a virtual grid. Requires an ArcGIS Server service 10.6.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsQuantization: boolean;
    /**
     * Indicates if the query operation supports quantization designed to be used in edit mode (highest resolution at the given spatial reference). Requires an ArcGIS Server service 10.6.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsQuantizationEditMode: boolean;
    /**
     * Indicates if the number of features returned by the query operation can be controlled.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsResultType: boolean;
    /**
     * Indicates if the query operation supports SQL expressions.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsSqlExpression: boolean;
    /**
     * Indicates if the query operation supports using standardized queries.Learn more about [standardized queries here](http://server.arcgis.com/en/server/latest/administer/linux/about-standardized-queries.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsStandardizedQueriesOnly: boolean;
    /**
     * Indicates if the layer supports field-based statistical functions. Requires ArcGIS Server service 10.1 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsStatistics: boolean;
    /**
     * Indicates if the layer supports historic moment query. Requires ArcGIS Server service 10.5 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsHistoricMoment: boolean;
  }

  export interface GeoJSONLayerCapabilitiesQueryRelated extends Object {
    /**
     * Indicates if the layer's query response includes the number of features or records related to features in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsCount: boolean;
    /**
     * Indicates if the related features or records returned in the query response can be ordered by one or more fields.Requires ArcGIS Server service 10.3 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsOrderBy: boolean;
    /**
     * Indicates if the query response supports pagination for related features or records. Requires ArcGIS Server service 10.3 or greater.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#capabilities)
     */
    supportsPagination: boolean;
  }

  export interface GeoJSONLayerCreatePopupTemplateOptions extends Object {
    /**
     * The maximum number of fields to include in the  popup template.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#createPopupTemplate)
     *
     * @default 75
     */
    maximumFields?: number;
    /**
     * Field types to ignore when creating the popup.  By default the `geometry`, `blob`, `raster`, `guid` and `xml` field types are ignored.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#createPopupTemplate)
     */
    ignoreFieldTypes?: string[];
  }

  export interface GeoJSONLayerElevationInfo extends Object {
    /**
     * Defines how the graphic is placed with respect to the terrain surface.See the table below for a list of possible values.Mode | Description------|------------on-the-ground | Graphics are draped on the terrain surface. This is the default value for [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) geometries rendered with [ObjectSymbol3DLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-ObjectSymbol3DLayer.html).relative-to-ground | Graphics are placed at an elevation relative to the terrain surface. The graphic's elevation is determined by summing up the terrain elevation and the result of `featureExpressionInfo` (if defined). This is the default value for [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) geometries rendered with [IconSymbol3DLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-IconSymbol3DLayer.html).absolute-height | Graphics are placed at an absolute elevation (z-value) above sea level. This z-value is determined by the result of `featureExpressionInfo` (if defined). This mode doesn't take the elevation of the terrain into account.relative-to-scene | Graphics are aligned to buildings and other objects part of 3D Object [SceneLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html) or [IntegratedMeshLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-IntegratedMeshLayer.html), depending on which has higher elevation. If the graphic is not directly above a building or any other feature, it is aligned to the terrain surface elevation. If defined, the result of `featureExpressionInfo` is added to the 3D Object/terrain surface elevation.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#elevationInfo)
     */
    mode: string;
    /**
     * An elevation offset, which is added to the vertical position of the graphic. If `unit` is not defined,the offset is in `meters`.When `mode = "on-the-ground"`, this property has no effect.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#elevationInfo)
     */
    offset?: number;
    /**
     * This object contains information about setting a custom z-value on the feature.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#elevationInfo)
     */
    featureExpressionInfo?: GeoJSONLayerElevationInfoFeatureExpressionInfo;
    /**
     * The unit for `featureExpressionInfo` and `offset` values.**Possible Values:** feet | meters | kilometers | miles | us-feet | yards
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#elevationInfo)
     */
    unit?: string;
  }

  export interface GeoJSONLayerElevationInfoFeatureExpressionInfo extends Object {
    /**
     * An [Arcade expression](https://developers.arcgis.com/javascript/latest/guide/arcade/index.html) evaluating to a number that determines the z-value of the feature. When `mode = "on-the-ground"`, this property has no effect. For line and polygon geometries the result of the expression is the same for all vertices of a feature.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#elevationInfo)
     */
    expression?: string;
  }

  export interface GeoJSONLayerFeatureReduction extends Object {
    /**
     * Type of the decluttering method. The only supported type at the moment is`selection`. In this method, some of the overlapping features are hidden such that none of the remaining featuresintersect on screen. Label deconfliction also respects this option and hides labels that would overlap with the features of this layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#featureReduction)
     */
    type: string;
  }

  export interface GeoJSONLayerGetFieldDomainOptions extends Object {
    /**
     * The feature to which the [Domain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Domain.html) is assigned.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#getFieldDomain)
     */
    feature: Graphic;
  }

  export interface GeoJSONLayerQueryExtentOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#queryExtent)
     */
    signal?: AbortSignal;
  }

  export interface GeoJSONLayerQueryFeatureCountOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#queryFeatureCount)
     */
    signal?: AbortSignal;
  }

  export interface GeoJSONLayerQueryFeaturesOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#queryFeatures)
     */
    signal?: AbortSignal;
  }

  export interface GeoJSONLayerQueryObjectIdsOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html#queryObjectIds)
     */
    signal?: AbortSignal;
  }

  export interface GeoJSONLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface GeoJSONLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface GeoJSONLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface GeoRSSLayer extends Layer, ScaleRangeLayer {
    /**
     * Symbol used to represent line features from the GeoRSS feed.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoRSSLayer.html#lineSymbol)
     */
    lineSymbol: SimpleLineSymbol;
    /**
     * Symbol used to represent point features from the GeoRSS feed.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoRSSLayer.html#pointSymbol)
     */
    pointSymbol: PictureMarkerSymbol;
    /**
     * Symbol used to represent polygon features from the GeoRSS feed.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoRSSLayer.html#polygonSymbol)
     */
    polygonSymbol: SimpleFillSymbol;
    /**
     * The URL pointing to a GeoRSS file. This must be publicly available.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoRSSLayer.html#url)
     */
    url: string;

    on(name: "layerview-create", eventHandler: GeoRSSLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: GeoRSSLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: GeoRSSLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface GeoRSSLayerConstructor {
    new (properties?: GeoRSSLayerProperties): GeoRSSLayer;
  }

  export const GeoRSSLayer: GeoRSSLayerConstructor;

  interface GeoRSSLayerProperties extends LayerProperties, ScaleRangeLayerProperties {
    /**
     * Symbol used to represent line features from the GeoRSS feed.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoRSSLayer.html#lineSymbol)
     */
    lineSymbol?: SimpleLineSymbolProperties;
    /**
     * Symbol used to represent point features from the GeoRSS feed.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoRSSLayer.html#pointSymbol)
     */
    pointSymbol?: PictureMarkerSymbolProperties;
    /**
     * Symbol used to represent polygon features from the GeoRSS feed.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoRSSLayer.html#polygonSymbol)
     */
    polygonSymbol?: SimpleFillSymbolProperties;
    /**
     * The URL pointing to a GeoRSS file. This must be publicly available.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoRSSLayer.html#url)
     */
    url?: string;
  }

  export interface GeoRSSLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface GeoRSSLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface GeoRSSLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface GraphicsLayer extends Layer, ScaleRangeLayer {
    /**
     * Specifies how graphics are placed on the vertical axis (z). This property may only be usedin a [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html). See the [ElevationInfo sample](https://developers.arcgis.com/javascript/latest/sample-code/scene-elevationinfo/index.html)for an example of how this property may be used.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#elevationInfo)
     */
    elevationInfo: GraphicsLayerElevationInfo;
    /**
     * A collection of [graphics](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html) in the layer.Each graphic is a vector representation of the location of areal-world feature. Each graphic in a single GraphicsLayer may contain either a[Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html), [Polyline](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html), or[Polygon](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html) [geometry](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#geometry). In addition, each[Graphic](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html) in the collectionmay contain its own [attributes](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#attributes),[Symbol](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-Symbol.html), and [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html).To add a graphic to the GraphicsLayer use [add()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#add), or[GraphicsLayer.graphics.add()](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html#add).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#graphics)
     */
    graphics: Collection<Graphic>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#screenSizePerspectiveEnabled)
     *
     * @default true
     */
    screenSizePerspectiveEnabled: boolean;
    /**
     * For [GraphicsLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html) the type is `graphics`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#type)
     */
    readonly type: "graphics";

    /**
     * Adds a graphic to the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#add)
     *
     * @param graphic The graphic to add to the layer.
     *
     */
    add(graphic: Graphic): void;
    /**
     * Adds an array of graphics to the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#addMany)
     *
     * @param graphics The graphic(s) to add to the layer.
     *
     */
    addMany(graphics: Graphic[]): void;
    /**
     * Removes a graphic from the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#remove)
     *
     * @param graphic The graphic to remove from the layer.
     *
     */
    remove(graphic: Graphic): void;
    /**
     * Clears all the graphics from the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#removeAll)
     *
     *
     */
    removeAll(): void;
    /**
     * Removes an array of graphics from the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#removeMany)
     *
     * @param graphics The graphics to remove from the layer.
     *
     */
    removeMany(graphics: Graphic[]): void;

    on(name: "layerview-create", eventHandler: GraphicsLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: GraphicsLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: GraphicsLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface GraphicsLayerConstructor {
    new (properties?: GraphicsLayerProperties): GraphicsLayer;
  }

  export const GraphicsLayer: GraphicsLayerConstructor;

  interface GraphicsLayerProperties extends LayerProperties, ScaleRangeLayerProperties {
    /**
     * Specifies how graphics are placed on the vertical axis (z). This property may only be usedin a [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html). See the [ElevationInfo sample](https://developers.arcgis.com/javascript/latest/sample-code/scene-elevationinfo/index.html)for an example of how this property may be used.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#elevationInfo)
     */
    elevationInfo?: GraphicsLayerElevationInfo;
    /**
     * A collection of [graphics](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html) in the layer.Each graphic is a vector representation of the location of areal-world feature. Each graphic in a single GraphicsLayer may contain either a[Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html), [Polyline](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html), or[Polygon](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polygon.html) [geometry](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#geometry). In addition, each[Graphic](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html) in the collectionmay contain its own [attributes](https://developers.arcgis.com/javascript/latest/api-reference/esri-Graphic.html#attributes),[Symbol](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-Symbol.html), and [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html).To add a graphic to the GraphicsLayer use [add()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#add), or[GraphicsLayer.graphics.add()](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html#add).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#graphics)
     */
    graphics?: CollectionProperties<GraphicProperties>;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#screenSizePerspectiveEnabled)
     *
     * @default true
     */
    screenSizePerspectiveEnabled?: boolean;
  }

  export interface GraphicsLayerElevationInfo extends Object {
    /**
     * Defines how the graphic is placed with respect to the terrain surface. If the geometry consists of multiple points(e.g. lines or polygons), the elevation is evaluated separately for each point.See the table below for a list of possible values.Mode | Description------|------------on-the-ground | Graphics are placed on the terrain surface.relative-to-ground | Graphics are placed at an elevation relative to the terrain surface. The graphic's elevation is determined by summing the terrain elevation and the geometry's z-value (if present). In case `featureExpressionInfo` is defined, the result of the expression is used instead of the geometry’s z-value.absolute-height | Graphics are placed at an absolute elevation (z-value) above sea level. This z-value is determined by the geometry's z-value (if present). If `featureExpressionInfo` is defined, the result of the expression is used instead of the geometry’s z-value. It doesn't take the elevation of the terrain into account.relative-to-scene | Graphics are aligned to buildings and other objects part of 3D Object [SceneLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html) or [IntegratedMeshLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-IntegratedMeshLayer.html), depending on which has higher elevation. If the graphic is not directly above a building or any other feature, it is aligned to the terrain surface elevation. If defined, the result of `featureExpressionInfo` is added to the 3D Object/terrain surface elevation. In this mode z-values are ignored.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#elevationInfo)
     */
    mode: string;
    /**
     * An elevation offset, which is added to the vertical position of the graphic. If `unit` is not defined, the offset isin `meters`.When `mode = "on-the-ground"`, this property has no effect.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#elevationInfo)
     */
    offset?: number;
    /**
     * This object contains information about setting a custom z-value on the feature.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#elevationInfo)
     */
    featureExpressionInfo?: GraphicsLayerElevationInfoFeatureExpressionInfo;
    /**
     * The unit for `featureExpressionInfo` and `offset` values. It doesn't apply to z-values.**Possible Values:** feet | meters | kilometers | miles | us-feet | yards
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#elevationInfo)
     */
    unit?: string;
  }

  export interface GraphicsLayerElevationInfoFeatureExpressionInfo extends Object {
    /**
     * An [Arcade expression](https://developers.arcgis.com/javascript/latest/guide/arcade/index.html) evaluating to a number that determinesthe z-value of the feature. If the geometry has z-values, they will be ignored and only `featureExpressionInfo` is used to calculate the verticalposition of the graphic. When `mode = "on-the-ground"`, this property has no effect. For line and polygon geometries the result of the expressionis the same for all vertices of a feature.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GraphicsLayer.html#elevationInfo)
     */
    expression?: string;
  }

  export interface GraphicsLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface GraphicsLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface GraphicsLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface GroupLayer extends Layer, LayersMixin, PortalLayer {
    /**
     * Indicates how to manage the visibility of the children layers. Possible valuesare described in the table below.Value | Description------|------------independent | Each child layer manages its visibility independent from other layers.inherited | Each child layer's visibility matches the [GroupLayer’s visibility](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GroupLayer.html#visible).exclusive | Only one child layer is visible at a time.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GroupLayer.html#visibilityMode)
     */
    visibilityMode: string;

    /**
     * Loads all the externally loadable resources associated with the group layer.For the group layer this will load all the layers.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GroupLayer.html#loadAll)
     *
     *
     */
    loadAll(): IPromise<GroupLayer>;

    on(name: "layerview-create", eventHandler: GroupLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: GroupLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: GroupLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface GroupLayerConstructor {
    new (properties?: GroupLayerProperties): GroupLayer;

    fromJSON(json: any): GroupLayer;
  }

  export const GroupLayer: GroupLayerConstructor;

  interface GroupLayerProperties extends LayerProperties, LayersMixinProperties, PortalLayerProperties {
    /**
     * Indicates how to manage the visibility of the children layers. Possible valuesare described in the table below.Value | Description------|------------independent | Each child layer manages its visibility independent from other layers.inherited | Each child layer's visibility matches the [GroupLayer’s visibility](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GroupLayer.html#visible).exclusive | Only one child layer is visible at a time.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GroupLayer.html#visibilityMode)
     */
    visibilityMode?: string;
  }

  export interface GroupLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface GroupLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface GroupLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface ImageryLayer
    extends Layer,
      ArcGISImageService,
      PortalLayer,
      RefreshableLayer,
      ScaleRangeLayer,
      TemporalLayer {
    /**
     * Indicates whether the layer will be included in the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled: boolean;
    /**
     * Indicates whether to display popups when features in the layer are clicked.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled: boolean;
    /**
     * The popup template for the layer. When set on the layer, the popupTemplateallows users to access attributes and display their values using text and/or chartsin the [view's popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html#popup) when a pixel is clicked.See [this sample](https://developers.arcgis.com/javascript/latest/sample-code/layers-imagery-popup/index.html)for an example of how [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) interacts with an[ImageryLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html).A default popup template is automatically used if no `popupTemplate` has been defined when[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled)is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html#popupTemplate)
     */
    popupTemplate: PopupTemplate;

    /**
     * Creates a default popup template for the layer, populated with all the fields of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html#createPopupTemplate)
     *
     * @param options the options.
     * @param options.maximumFields the maximum number of fields to include in the  popup template.
     * @param options.ignoreFieldTypes field types to ignore when creating the popup.  By default the `geometry`, `blob`, `raster`, `guid` and `xml` field types are ignored.
     *
     */
    createPopupTemplate(options?: ImageryLayerCreatePopupTemplateOptions): PopupTemplate;
    /**
     * Executes the [pixelFilter](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html#pixelFilter) function and redraws the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html#redraw)
     *
     *
     */
    redraw(): void;

    on(name: "layerview-create", eventHandler: ImageryLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: ImageryLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: ImageryLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface ImageryLayerConstructor {
    new (properties?: ImageryLayerProperties): ImageryLayer;

    fromJSON(json: any): ImageryLayer;
  }

  export const ImageryLayer: ImageryLayerConstructor;

  interface ImageryLayerProperties
    extends LayerProperties,
      ArcGISImageServiceProperties,
      PortalLayerProperties,
      RefreshableLayerProperties,
      ScaleRangeLayerProperties,
      TemporalLayerProperties {
    /**
     * Indicates whether the layer will be included in the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled?: boolean;
    /**
     * Indicates whether to display popups when features in the layer are clicked.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled?: boolean;
    /**
     * The popup template for the layer. When set on the layer, the popupTemplateallows users to access attributes and display their values using text and/or chartsin the [view's popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html#popup) when a pixel is clicked.See [this sample](https://developers.arcgis.com/javascript/latest/sample-code/layers-imagery-popup/index.html)for an example of how [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) interacts with an[ImageryLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html).A default popup template is automatically used if no `popupTemplate` has been defined when[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled)is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html#popupTemplate)
     */
    popupTemplate?: PopupTemplateProperties;
  }

  export interface ImageryLayerCreatePopupTemplateOptions extends Object {
    /**
     * the maximum number of fields to include in the  popup template.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html#createPopupTemplate)
     *
     * @default 75
     */
    maximumFields?: number;
    /**
     * field types to ignore when creating the popup.  By default the `geometry`, `blob`, `raster`, `guid` and `xml` field types are ignored.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html#createPopupTemplate)
     */
    ignoreFieldTypes?: string[];
  }

  export interface ImageryLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface ImageryLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface ImageryLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface IntegratedMeshLayer extends Layer, SceneService, PortalLayer, ScaleRangeLayer {
    /**
     * Specifies how the mesh is placed on the vertical axis (z). This propertyonly affects [IntegratedMeshLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-IntegratedMeshLayer.html) when using the `absolute-height` mode.Integrated mesh layers always render in front of the ground surface, so setting negative offset values will not render thembelow the ground.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-IntegratedMeshLayer.html#elevationInfo)
     */
    elevationInfo: IntegratedMeshLayerElevationInfo;

    on(name: "layerview-create", eventHandler: IntegratedMeshLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: IntegratedMeshLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: IntegratedMeshLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface IntegratedMeshLayerConstructor {
    new (properties?: IntegratedMeshLayerProperties): IntegratedMeshLayer;

    fromJSON(json: any): IntegratedMeshLayer;
  }

  export const IntegratedMeshLayer: IntegratedMeshLayerConstructor;

  interface IntegratedMeshLayerProperties
    extends LayerProperties,
      SceneServiceProperties,
      PortalLayerProperties,
      ScaleRangeLayerProperties {
    /**
     * Specifies how the mesh is placed on the vertical axis (z). This propertyonly affects [IntegratedMeshLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-IntegratedMeshLayer.html) when using the `absolute-height` mode.Integrated mesh layers always render in front of the ground surface, so setting negative offset values will not render thembelow the ground.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-IntegratedMeshLayer.html#elevationInfo)
     */
    elevationInfo?: IntegratedMeshLayerElevationInfo;
  }

  export interface IntegratedMeshLayerElevationInfo extends Object {
    /**
     * Defines how the mesh is placed on the vertical axis (z).Currently only `absolute-height` is supported.Mode | Description------|------------absolute-height | The mesh is placed at an absolute elevation (z-value) above sea level. This z-value is determined by summing up the `offset` value and the mesh's z-value. It doesn't take the elevation of the terrain into account. This is the only supported elevation mode for an IntegratedMeshLayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-IntegratedMeshLayer.html#elevationInfo)
     */
    mode: string;
    /**
     * An elevation offset, which is added to the vertical position of the mesh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-IntegratedMeshLayer.html#elevationInfo)
     *
     * @default 0
     */
    offset?: number;
    /**
     * The unit for `offset` values.**Possible Values:** feet | meters | kilometers | miles | us-feet | yards
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-IntegratedMeshLayer.html#elevationInfo)
     *
     * @default meters
     */
    unit?: string;
  }

  export interface IntegratedMeshLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface IntegratedMeshLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface IntegratedMeshLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface KMLLayer extends Layer, PortalLayer, ScaleRangeLayer {
    /**
     * A collection of [KMLSublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html)s.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-KMLLayer.html#sublayers)
     */
    sublayers: Collection<KMLSublayer>;
    /**
     * The publicly accessible URL for a .kml or .kmz file.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-KMLLayer.html#url)
     */
    url: string;

    on(name: "layerview-create", eventHandler: KMLLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: KMLLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: KMLLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface KMLLayerConstructor {
    new (properties?: KMLLayerProperties): KMLLayer;

    fromJSON(json: any): KMLLayer;
  }

  export const KMLLayer: KMLLayerConstructor;

  interface KMLLayerProperties extends LayerProperties, PortalLayerProperties, ScaleRangeLayerProperties {
    /**
     * A collection of [KMLSublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html)s.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-KMLLayer.html#sublayers)
     */
    sublayers?: CollectionProperties<KMLSublayerProperties>;
    /**
     * The publicly accessible URL for a .kml or .kmz file.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-KMLLayer.html#url)
     */
    url?: string;
  }

  export interface KMLLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface KMLLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface KMLLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface Layer extends Accessor, Loadable, Evented {
    /**
     * The full extent of the layer. By default, this is worldwide. This property may be usedto set the extent of the view to match a layer's extent so that its featuresappear to fill the view. See the sample snippet below.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#fullExtent)
     */
    fullExtent: Extent;
    /**
     * The unique ID assigned to the layer. If not set by the developer, it is automaticallygenerated when the layer is loaded.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#id)
     */
    id: string;
    /**
     * Indicates how the layer should display in the [LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) widget.The possible values are listed below.Value | Description------|------------ show | The layer is visible in the table of contents. hide | The layer is hidden in the table of contents. hide-children | If the layer is a [GroupLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GroupLayer.html), [BuildingSceneLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html), [KMLLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-KMLLayer.html), [MapImageLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html), [TileLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-TileLayer.html) or [WMSLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-WMSLayer.html), hide the children layers from the table of contents.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#listMode)
     *
     * @default show
     */
    listMode: "show" | "hide" | "hide-children";
    /**
     * Indicates whether the layer's resources have loaded. When `true`,all the properties of the object can be accessed.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#loaded)
     *
     * @default false
     */
    readonly loaded: boolean;
    /**
     * The opacity of the layer. This value can range between `1` and `0`, where `0` is 100 percenttransparent and `1` is completely opaque.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#opacity)
     *
     * @default 1
     */
    opacity: number;
    /**
     * The title of the layer used to identify it in places such as the [Legend](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Legend.html)and [LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) widgets.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#title)
     */
    title: string;
    /**
     * The layer type provides a convenient way to check the type of the layerwithout the need to import specific layer modules.**Possible values:** base-dynamic | base-elevation | base-tile | bing-maps | elevation | feature  | graphics | group | imagery |  integrated-mesh | map-image | open-street-map | point-cloud | scene |  stream | tile | unknown | unsupported | vector-tile | web-tile
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#type)
     */
    readonly type: string;
    /**
     * Indicates if the layer is visible in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html). When `false`,the layer may still be added to a [Map](https://developers.arcgis.com/javascript/latest/api-reference/esri-Map.html)instance that is referenced in a view, but its features will not be visible in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#visible)
     *
     * @default true
     */
    visible: boolean;

    /**
     * Called by the views, such as [MapView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-MapView.html) and[SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html), when the layer is added to the[Map.layers](https://developers.arcgis.com/javascript/latest/api-reference/esri-Map.html#layers) collection and a layer view mustbe created for it. **This method is used internally and there is no use case for invoking it directly**.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#createLayerView)
     *
     * @param view The parent view.
     * @param options An object specifying additional options. See the                           object specification table below for the required properties of this object.
     * @param options.signal A signal to abort the creation of the layerview.
     *
     */
    createLayerView(view: any, options?: LayerCreateLayerViewOptions): void;
    /**
     * Fetches custom attribution data for the layer when it becomes available.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#fetchAttributionData)
     *
     *
     */
    fetchAttributionData(): IPromise<any>;
  }

  interface LayerConstructor {
    new (properties?: LayerProperties): Layer;

    /**
     * Creates a new layer instance from an ArcGIS Server URL. Dependingon the URL, the returned layer type may be a [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html), [TileLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-TileLayer.html),[MapImageLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html), [SceneLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html), [StreamLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html),[ElevationLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ElevationLayer.html) or [GroupLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GroupLayer.html).This is useful when you work with various ArcGIS Server URLs, butyou don't necessarily know which layer type(s) they create. Thismethod creates the appropriate layer type for you. In case of a feature serviceor a scene service, when the URL points to the service and the service has multiple layers,the returned promise will resolve to a [GroupLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GroupLayer.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#fromArcGISServerUrl)
     *
     * @param params Input parameters for creating the layer.
     * @param params.url The ArcGIS Server URL used to create the layer.
     * @param params.properties Set any of the layer's properties herefor constructing the layer instance (e.g. popupTemplate, renderer, etc.).
     *
     */
    fromArcGISServerUrl(params: LayerFromArcGISServerUrlParams): IPromise<Layer>;
    /**
     * Creates a new layer instance of the appropriate layer class from anArcGIS Online or ArcGIS Enterprise[portal item](https://developers.arcgis.com/javascript/latest/api-reference/esri-portal-PortalItem.html). If the item points toa feature service with multiple layers, then a [GroupLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GroupLayer.html)is created. If the item points to a service with a single layer, then it resolvesto a layer of the same type of class as the service.See also: [isLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-portal-PortalItem.html#isLayer)
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#fromPortalItem)
     *
     * @param params The parameters for loading the portal item.
     * @param params.portalItem The object representing an ArcGISOnline or ArcGIS Enterprise portal item from which to load the layer.
     *
     */
    fromPortalItem(params: LayerFromPortalItemParams): IPromise<Layer>;
  }

  export const Layer: LayerConstructor;

  interface LayerProperties extends LoadableProperties {
    /**
     * The full extent of the layer. By default, this is worldwide. This property may be usedto set the extent of the view to match a layer's extent so that its featuresappear to fill the view. See the sample snippet below.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#fullExtent)
     */
    fullExtent?: ExtentProperties;
    /**
     * The unique ID assigned to the layer. If not set by the developer, it is automaticallygenerated when the layer is loaded.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#id)
     */
    id?: string;
    /**
     * Indicates how the layer should display in the [LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) widget.The possible values are listed below.Value | Description------|------------ show | The layer is visible in the table of contents. hide | The layer is hidden in the table of contents. hide-children | If the layer is a [GroupLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GroupLayer.html), [BuildingSceneLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html), [KMLLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-KMLLayer.html), [MapImageLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html), [TileLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-TileLayer.html) or [WMSLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-WMSLayer.html), hide the children layers from the table of contents.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#listMode)
     *
     * @default show
     */
    listMode?: "show" | "hide" | "hide-children";
    /**
     * The opacity of the layer. This value can range between `1` and `0`, where `0` is 100 percenttransparent and `1` is completely opaque.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#opacity)
     *
     * @default 1
     */
    opacity?: number;
    /**
     * The title of the layer used to identify it in places such as the [Legend](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Legend.html)and [LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) widgets.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#title)
     */
    title?: string;
    /**
     * Indicates if the layer is visible in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html). When `false`,the layer may still be added to a [Map](https://developers.arcgis.com/javascript/latest/api-reference/esri-Map.html)instance that is referenced in a view, but its features will not be visible in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#visible)
     *
     * @default true
     */
    visible?: boolean;
  }

  export interface LayerCreateLayerViewOptions extends Object {
    /**
     * A signal to abort the creation of the layerview.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#createLayerView)
     */
    signal?: AbortSignal;
  }

  export interface LayerFromArcGISServerUrlParams extends Object {
    /**
     * The ArcGIS Server URL used to create the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#fromArcGISServerUrl)
     */
    url: string;
    /**
     * Set any of the layer's properties herefor constructing the layer instance (e.g. popupTemplate, renderer, etc.).
     *
     * [Read more...](properties.html)
     */
    properties?: any;
  }

  export interface LayerFromPortalItemParams extends Object {
    /**
     * The object representing an ArcGISOnline or ArcGIS Enterprise portal item from which to load the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-Layer.html#fromPortalItem)
     */
    portalItem: PortalItem;
  }

  interface MapImageLayer
    extends Layer,
      SublayersOwner,
      ArcGISMapService,
      ScaleRangeLayer,
      RefreshableLayer,
      TemporalLayer {
    /**
     * A flat [Collection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html) of all the [sublayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#sublayers)in the MapImageLayer including the sublayers of its sublayers.All sublayers are referenced in the order in which they are drawn in the view (bottom to top).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#allSublayers)
     */
    readonly allSublayers: Collection<Sublayer>;
    /**
     * The output dots per inch (DPI) of the MapImageLayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#dpi)
     *
     * @default 96
     */
    dpi: number;
    /**
     * The version of the geodatabase of the map service data. Readthe [Overview of versioning](https://desktop.arcgis.com/en/arcmap/latest/manage-data/geodatabases/an-overview-of-versioning.htm) topic for more detailsabout this capability.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#gdbVersion)
     */
    gdbVersion: string;
    /**
     * The output image type.**Possible Values:** png | png8 | png24 | png32 | jpg | pdf | bmp | gif | svg | pngjpg
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#imageFormat)
     *
     * @default png24
     */
    imageFormat: string;
    /**
     * Indicates the maximum height of the image exported by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#imageMaxHeight)
     *
     * @default 2048
     */
    imageMaxHeight: number;
    /**
     * Indicates the maximum width of the image exported by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#imageMaxWidth)
     *
     * @default 2048
     */
    imageMaxWidth: number;
    /**
     * Indicates whether the background of the image exported by the service is transparent.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#imageTransparency)
     *
     * @default true
     */
    imageTransparency: boolean;
    /**
     * The portal item from which the layer is loaded. This will load the layeralong with any overridden properties (e.g. renderers, definition expressions, etc.) savedto the portal item, not the map service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#portalItem)
     */
    portalItem: PortalItem;
    /**
     * A [Collection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html) of [Sublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html) objectsthat allow you to alterthe properties of one or more sublayers of the MapImageLayer. If this propertyis not specified, all the sublayers from the service are displayed as defined in theservice. If an empty array is passed to this property then none of the sublayersfrom the service are displayed in the layer.All sublayers are referenced in the order in which they are drawn in the view (bottom to top).They may be [added](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html#add),[removed](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html#remove), or[reordered](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html#reorder) using the[Collection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html) methods. Because [Sublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html) extends[Accessor](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Accessor.html), its properties may be[watched](https://developers.arcgis.com/javascript/latest/guide/working-with-props/index.html#watchProperties).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#sublayers)
     */
    sublayers: Collection<Sublayer>;
    /**
     * The URL to the REST endpoint of the map service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#url)
     */
    url: string;

    /**
     * Gets the parameters of the exported image to use when calling the[export REST operation](https://developers.arcgis.com/rest/services-reference/export-map.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#createExportImageParameters)
     *
     * @param extent The extent of the exported image
     * @param width The width of the exported image
     * @param height The height of the exported image
     * @param options The parameter options is an object with the following properties.
     * @param options.rotation The rotation in degrees of the exported image. Available since ArcGIS Server 10.3.
     * @param options.pixelRatio The pixel ratio to apply to the dpi of the exported image.
     * @param options.timeExtent The time instant or time extent of content to render.
     *
     */
    createExportImageParameters(
      extent: Extent,
      width: number,
      height: number,
      options?: MapImageLayerCreateExportImageParametersOptions
    ): any;
    /**
     * This method fetches the image for the specified extent and size.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#fetchImage)
     *
     * @param extent The extent of the view.
     * @param width The width of the view in pixels.
     * @param height The height of the view in pixels.
     * @param options The parameter options is an object with the following properties.
     * @param options.rotation The rotation in degrees of the exported image. Available since ArcGIS Server 10.3.
     * @param options.pixelRatio The ratio of the resolution in physical pixels of the image to the resolution it will be displayed at.
     * @param options.timeExtent The time instant or time extent of content to render.
     * @param options.signal An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     */
    fetchImage(
      extent: Extent,
      width: number,
      height: number,
      options?: MapImageLayerFetchImageOptions
    ): IPromise<HTMLImageElement>;
    /**
     * This method returns a URL to an image for a given extent, width and height.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#getImageUrl)
     *
     * @param extent The extent of the exported image.
     * @param width The width of the view in pixels.
     * @param height The height of the view in pixels.
     * @param options The parameter options is an object with the following properties.
     * @param options.pixelRatio The ratio of the resolution in physical pixels of the image to the resolution it will be displayed at.
     * @param options.rotation The rotation in degrees of the exported image. Available since ArcGIS Server 10.3.
     *
     */
    getImageUrl(
      extent: Extent,
      width: number,
      height: number,
      options?: MapImageLayerGetImageUrlOptions
    ): IPromise<string> | string;

    on(name: "layerview-create", eventHandler: MapImageLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: MapImageLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: MapImageLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface MapImageLayerConstructor {
    new (properties?: MapImageLayerProperties): MapImageLayer;

    fromJSON(json: any): MapImageLayer;
  }

  export const MapImageLayer: MapImageLayerConstructor;

  interface MapImageLayerProperties
    extends LayerProperties,
      ArcGISMapServiceProperties,
      ScaleRangeLayerProperties,
      RefreshableLayerProperties,
      TemporalLayerProperties {
    /**
     * The output dots per inch (DPI) of the MapImageLayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#dpi)
     *
     * @default 96
     */
    dpi?: number;
    /**
     * The version of the geodatabase of the map service data. Readthe [Overview of versioning](https://desktop.arcgis.com/en/arcmap/latest/manage-data/geodatabases/an-overview-of-versioning.htm) topic for more detailsabout this capability.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#gdbVersion)
     */
    gdbVersion?: string;
    /**
     * The output image type.**Possible Values:** png | png8 | png24 | png32 | jpg | pdf | bmp | gif | svg | pngjpg
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#imageFormat)
     *
     * @default png24
     */
    imageFormat?: string;
    /**
     * Indicates the maximum height of the image exported by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#imageMaxHeight)
     *
     * @default 2048
     */
    imageMaxHeight?: number;
    /**
     * Indicates the maximum width of the image exported by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#imageMaxWidth)
     *
     * @default 2048
     */
    imageMaxWidth?: number;
    /**
     * Indicates whether the background of the image exported by the service is transparent.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#imageTransparency)
     *
     * @default true
     */
    imageTransparency?: boolean;
    /**
     * The portal item from which the layer is loaded. This will load the layeralong with any overridden properties (e.g. renderers, definition expressions, etc.) savedto the portal item, not the map service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#portalItem)
     */
    portalItem?: PortalItemProperties;
    /**
     * A [Collection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html) of [Sublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html) objectsthat allow you to alterthe properties of one or more sublayers of the MapImageLayer. If this propertyis not specified, all the sublayers from the service are displayed as defined in theservice. If an empty array is passed to this property then none of the sublayersfrom the service are displayed in the layer.All sublayers are referenced in the order in which they are drawn in the view (bottom to top).They may be [added](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html#add),[removed](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html#remove), or[reordered](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html#reorder) using the[Collection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html) methods. Because [Sublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html) extends[Accessor](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Accessor.html), its properties may be[watched](https://developers.arcgis.com/javascript/latest/guide/working-with-props/index.html#watchProperties).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#sublayers)
     */
    sublayers?: CollectionProperties<SublayerProperties>;
    /**
     * The URL to the REST endpoint of the map service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#url)
     */
    url?: string;
  }

  export interface MapImageLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface MapImageLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface MapImageLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  export interface MapImageLayerCreateExportImageParametersOptions extends Object {
    /**
     * The rotation in degrees of the exported image. Available since ArcGIS Server 10.3.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#createExportImageParameters)
     */
    rotation?: number;
    /**
     * The pixel ratio to apply to the dpi of the exported image.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#createExportImageParameters)
     */
    pixelRatio?: number;
    /**
     * The time instant or time extent of content to render.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#createExportImageParameters)
     */
    timeExtent?: any;
  }

  export interface MapImageLayerFetchImageOptions extends Object {
    /**
     * The rotation in degrees of the exported image. Available since ArcGIS Server 10.3.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#fetchImage)
     */
    rotation?: number;
    /**
     * The ratio of the resolution in physical pixels of the image to the resolution it will be displayed at.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#fetchImage)
     */
    pixelRatio?: number;
    /**
     * The time instant or time extent of content to render.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#fetchImage)
     */
    timeExtent?: any;
    /**
     * An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#fetchImage)
     */
    signal?: AbortSignal;
  }

  export interface MapImageLayerGetImageUrlOptions extends Object {
    /**
     * The ratio of the resolution in physical pixels of the image to the resolution it will be displayed at.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#getImageUrl)
     */
    pixelRatio?: number;
    /**
     * The rotation in degrees of the exported image. Available since ArcGIS Server 10.3.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#getImageUrl)
     */
    rotation?: number;
  }

  interface MapNotesLayer extends Layer, PortalLayer, ScaleRangeLayer {
    on(name: "layerview-create", eventHandler: MapNotesLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: MapNotesLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: MapNotesLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface MapNotesLayerConstructor {
    new (properties?: MapNotesLayerProperties): MapNotesLayer;

    fromJSON(json: any): MapNotesLayer;
  }

  export const MapNotesLayer: MapNotesLayerConstructor;

  interface MapNotesLayerProperties extends LayerProperties, PortalLayerProperties, ScaleRangeLayerProperties {}

  export interface MapNotesLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface MapNotesLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface MapNotesLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface ArcGISCachedService {
    /**
     * The copyright text as defined by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISCachedService.html#copyright)
     */
    copyright: string;
    /**
     * The spatial reference of the layer as defined by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISCachedService.html#spatialReference)
     */
    readonly spatialReference: SpatialReference;
    /**
     * Contains information about the tiling scheme for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISCachedService.html#tileInfo)
     */
    tileInfo: TileInfo;
  }

  interface ArcGISCachedServiceConstructor {
    new (properties?: ArcGISCachedServiceProperties): ArcGISCachedService;

    fromJSON(json: any): ArcGISCachedService;
  }

  export const ArcGISCachedService: ArcGISCachedServiceConstructor;

  interface ArcGISCachedServiceProperties {
    /**
     * The copyright text as defined by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISCachedService.html#copyright)
     */
    copyright?: string;
    /**
     * Contains information about the tiling scheme for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISCachedService.html#tileInfo)
     */
    tileInfo?: TileInfoProperties;
  }

  interface ArcGISImageService {
    /**
     * The compression quality value. Controls how much loss the image will be subjected to by the compression algorithm.Valid value ranges of compression quality are from 0 to 100. Only valid when using `jpg` or `jpgpng` [image format](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#format).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#compressionQuality)
     */
    compressionQuality: number;
    /**
     * Controls the tolerance of the lerc compression algorithm.The tolerance defines the maximum possible error of pixel values in the compressed image. It's a double value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#compressionTolerance)
     *
     * @default 0.01
     */
    compressionTolerance: number;
    /**
     * The copyright text as defined by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#copyright)
     */
    copyright: string;
    /**
     * The SQL where clause used to filter rasters on the client. Only the rasters that satisfy the definitionexpression are displayed in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#definitionExpression)
     */
    definitionExpression: string;
    /**
     * An array of fields in the layer for which a [Domain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Domain.html) has been defined.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#domainFields)
     */
    domainFields: Field[];
    /**
     * An array of fields in the layer. Each field represents an attributethat may contain a value for each raster in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#fields)
     */
    fields: Field[];
    /**
     * The format of the exported image.**Possible Values:** png | png8 | png24 | png32 | jpg | bmp | jpgpng | lerc | tiff
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#format)
     */
    format: string;
    /**
     * Indicates if the layer has [multidimensionalInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#multidimensionalInfo).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#hasMultidimensions)
     */
    hasMultidimensions: boolean;
    /**
     * Indicates if the Image Service has a [raster attribute table](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#rasterAttributeTable).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#hasRasterAttributeTable)
     */
    hasRasterAttributeTable: boolean;
    /**
     * Indicates the maximum height of the image exported by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#imageMaxHeight)
     *
     * @default 4100
     */
    imageMaxHeight: number;
    /**
     * Indicates the maximum width of the image exported by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#imageMaxWidth)
     *
     * @default 15000
     */
    imageMaxWidth: number;
    /**
     * Defines how to interpolate pixel values.**Possible Values:**  nearest | bilinear | cubic | majority
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#interpolation)
     */
    interpolation: string;
    /**
     * Defines how overlapping images should be mosaicked.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#mosaicRule)
     */
    mosaicRule: MosaicRule;
    /**
     * The multidimensional information associated with the layerif the layer's [hasMultidimensions](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#hasMultidimensions) propertyis `true`. If defined, multidimensional information contains various dimensionsof data for a particular value, such as time, depth, altitude, etc. Definingslices of particular dimensions in the layer is handled with the[multidimensionalDefinition](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#multidimensionalDefinition)property of the [mosaicRule](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#mosaicRule).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#multidimensionalInfo)
     *
     * @default null
     */
    multidimensionalInfo: any;
    /**
     * The pixel value representing no available information.Can be a number (same value for all bands) or array (specific value for each band).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#noData)
     */
    noData: number | number[];
    /**
     * Interpretation of the [noData](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#noData) setting.**Possible values:**Value | Description |----- | ----------- |any | Pixel is transparent if any band matches `noData` value.all | Pixel is transparent only if all bands match `noData` value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#noDataInterpretation)
     */
    noDataInterpretation: string;
    /**
     * The name of an `oid` [field](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#fields) containinga unique value or identifier for each raster in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#objectIdField)
     */
    objectIdField: string;
    /**
     * A function that processes [pixelData](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-ImageryLayerView.html#pixelData).The `pixelData` object contains a[pixelBlock](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html) property that givesyou access to all of the pixels in the raster on the client.Inside the `pixelFilter` you may loop through all the[pixels](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#pixels) found in the`pixelBlock` property of the `pixelData` object and process them.This function may be used to hide some pixels from the view, alter theirvalues, and change their color.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#pixelFilter)
     */
    pixelFilter: Function;
    /**
     * Raster source pixel type.**Possible Values:**Value | Range of values that each cell can contain |----- | ------------------------------------------- |unknown | Pixel type is unknown |s8 | -128 to 127 |s16 | -32768 to 32767 |s32 | -2147483648 to 2147483647 |u8 | 0 to 255 |u16 | 0 to 65535u32 | 0 to 4294967295f32 | -3.402823466e+38 to 3.402823466e+38f64 | 0 to 18446744073709551616
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#pixelType)
     */
    pixelType: "s8" | "s16" | "s32" | "u8" | "u16" | "u32" | "f32" | "f64";
    /**
     * The raster attribute table associated with the service. To access theraster attribute table, the layer must be [loaded](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#loaded).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#rasterAttributeTable)
     */
    rasterAttributeTable: any;
    /**
     * Prefix used to define the fields from the raster attribute table.It's primarily used for [popups](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html)
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#rasterAttributeTableFieldPrefix)
     */
    rasterAttributeTableFieldPrefix: string;
    /**
     * A complete list of fields that consists of fields from the layer, pixel value fieldsand the attribute table fields. This list is used for layer's[popupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html#popupTemplate).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#rasterFields)
     */
    readonly rasterFields: Field[];
    /**
     * The renderer assigned to the layer. The renderer defines how to visualize pixels in the layer.Depending on the renderer type, the pixels may be [stretched](https://developers.arcgis.com/javascript/latest/api-reference/esri-renderers-StretchRenderer.html)across the color ramp, [classified](https://developers.arcgis.com/javascript/latest/api-reference/esri-renderers-ClassBreaksRenderer.html) orhave [different symbols](https://developers.arcgis.com/javascript/latest/api-reference/esri-renderers-UniqueValueRenderer.html) based on values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#renderer)
     */
    renderer: Renderer;
    /**
     * Specifies the rule for how the requested image should be rendered.When renderingRule applied, the server returns an updated serviceinformation that reflects a custom processing as defined by the rendering rule.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#renderingRule)
     */
    renderingRule: RasterFunction;
    /**
     * Source raster information of the image service. The layer must be[loaded](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html#loaded) before serviceRasterInfo can be accessed.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#serviceRasterInfo)
     */
    readonly serviceRasterInfo: RasterInfo;
    /**
     * The spatial reference of the image service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#spatialReference)
     */
    readonly spatialReference: SpatialReference;
    /**
     * The URL to the REST endpoint of the layer. The URL may either pointto a resource on ArcGIS Enterprise or ArcGIS Online.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#url)
     */
    url: string;
    /**
     * The version of ArcGIS Server in which the image service is published.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#version)
     */
    readonly version: number;

    /**
     * Returns an image using the[export REST operation](https://developers.arcgis.com/rest/services-reference/export-image.htm) that displaysdata from an [ImageryLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-ImageryLayer.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#fetchImage)
     *
     * @param extent The extent of the image  to export.
     * @param width The width of the image in pixels.
     * @param height The height of the image in pixels.
     * @param options The parameter options is an object with the following properties.
     * @param options.signal An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     */
    fetchImage(
      extent: Extent,
      width: number,
      height: number,
      options?: ArcGISImageServiceFetchImageOptions
    ): IPromise<any>;
    /**
     * Generates raster info for the specified rendering rule.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#generateRasterInfo)
     *
     * @param renderingRule Rendering rule for the requested raster info.
     *
     */
    generateRasterInfo(renderingRule: RasterFunction): IPromise<RasterInfo>;
  }

  interface ArcGISImageServiceConstructor {
    new (properties?: ArcGISImageServiceProperties): ArcGISImageService;

    fromJSON(json: any): ArcGISImageService;
  }

  export const ArcGISImageService: ArcGISImageServiceConstructor;

  interface ArcGISImageServiceProperties {
    /**
     * The compression quality value. Controls how much loss the image will be subjected to by the compression algorithm.Valid value ranges of compression quality are from 0 to 100. Only valid when using `jpg` or `jpgpng` [image format](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#format).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#compressionQuality)
     */
    compressionQuality?: number;
    /**
     * Controls the tolerance of the lerc compression algorithm.The tolerance defines the maximum possible error of pixel values in the compressed image. It's a double value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#compressionTolerance)
     *
     * @default 0.01
     */
    compressionTolerance?: number;
    /**
     * The copyright text as defined by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#copyright)
     */
    copyright?: string;
    /**
     * The SQL where clause used to filter rasters on the client. Only the rasters that satisfy the definitionexpression are displayed in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#definitionExpression)
     */
    definitionExpression?: string;
    /**
     * An array of fields in the layer for which a [Domain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Domain.html) has been defined.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#domainFields)
     */
    domainFields?: FieldProperties[];
    /**
     * An array of fields in the layer. Each field represents an attributethat may contain a value for each raster in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#fields)
     */
    fields?: FieldProperties[];
    /**
     * The format of the exported image.**Possible Values:** png | png8 | png24 | png32 | jpg | bmp | jpgpng | lerc | tiff
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#format)
     */
    format?: string;
    /**
     * Indicates if the layer has [multidimensionalInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#multidimensionalInfo).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#hasMultidimensions)
     */
    hasMultidimensions?: boolean;
    /**
     * Indicates if the Image Service has a [raster attribute table](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#rasterAttributeTable).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#hasRasterAttributeTable)
     */
    hasRasterAttributeTable?: boolean;
    /**
     * Indicates the maximum height of the image exported by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#imageMaxHeight)
     *
     * @default 4100
     */
    imageMaxHeight?: number;
    /**
     * Indicates the maximum width of the image exported by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#imageMaxWidth)
     *
     * @default 15000
     */
    imageMaxWidth?: number;
    /**
     * Defines how to interpolate pixel values.**Possible Values:**  nearest | bilinear | cubic | majority
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#interpolation)
     */
    interpolation?: string;
    /**
     * Defines how overlapping images should be mosaicked.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#mosaicRule)
     */
    mosaicRule?: MosaicRuleProperties;
    /**
     * The multidimensional information associated with the layerif the layer's [hasMultidimensions](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#hasMultidimensions) propertyis `true`. If defined, multidimensional information contains various dimensionsof data for a particular value, such as time, depth, altitude, etc. Definingslices of particular dimensions in the layer is handled with the[multidimensionalDefinition](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#multidimensionalDefinition)property of the [mosaicRule](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#mosaicRule).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#multidimensionalInfo)
     *
     * @default null
     */
    multidimensionalInfo?: any;
    /**
     * The pixel value representing no available information.Can be a number (same value for all bands) or array (specific value for each band).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#noData)
     */
    noData?: number | number[];
    /**
     * Interpretation of the [noData](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#noData) setting.**Possible values:**Value | Description |----- | ----------- |any | Pixel is transparent if any band matches `noData` value.all | Pixel is transparent only if all bands match `noData` value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#noDataInterpretation)
     */
    noDataInterpretation?: string;
    /**
     * The name of an `oid` [field](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#fields) containinga unique value or identifier for each raster in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#objectIdField)
     */
    objectIdField?: string;
    /**
     * A function that processes [pixelData](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-ImageryLayerView.html#pixelData).The `pixelData` object contains a[pixelBlock](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html) property that givesyou access to all of the pixels in the raster on the client.Inside the `pixelFilter` you may loop through all the[pixels](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#pixels) found in the`pixelBlock` property of the `pixelData` object and process them.This function may be used to hide some pixels from the view, alter theirvalues, and change their color.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#pixelFilter)
     */
    pixelFilter?: Function;
    /**
     * Raster source pixel type.**Possible Values:**Value | Range of values that each cell can contain |----- | ------------------------------------------- |unknown | Pixel type is unknown |s8 | -128 to 127 |s16 | -32768 to 32767 |s32 | -2147483648 to 2147483647 |u8 | 0 to 255 |u16 | 0 to 65535u32 | 0 to 4294967295f32 | -3.402823466e+38 to 3.402823466e+38f64 | 0 to 18446744073709551616
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#pixelType)
     */
    pixelType?: "s8" | "s16" | "s32" | "u8" | "u16" | "u32" | "f32" | "f64";
    /**
     * The raster attribute table associated with the service. To access theraster attribute table, the layer must be [loaded](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#loaded).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#rasterAttributeTable)
     */
    rasterAttributeTable?: any;
    /**
     * Prefix used to define the fields from the raster attribute table.It's primarily used for [popups](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html)
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#rasterAttributeTableFieldPrefix)
     */
    rasterAttributeTableFieldPrefix?: string;
    /**
     * The renderer assigned to the layer. The renderer defines how to visualize pixels in the layer.Depending on the renderer type, the pixels may be [stretched](https://developers.arcgis.com/javascript/latest/api-reference/esri-renderers-StretchRenderer.html)across the color ramp, [classified](https://developers.arcgis.com/javascript/latest/api-reference/esri-renderers-ClassBreaksRenderer.html) orhave [different symbols](https://developers.arcgis.com/javascript/latest/api-reference/esri-renderers-UniqueValueRenderer.html) based on values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#renderer)
     */
    renderer?: RendererProperties;
    /**
     * Specifies the rule for how the requested image should be rendered.When renderingRule applied, the server returns an updated serviceinformation that reflects a custom processing as defined by the rendering rule.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#renderingRule)
     */
    renderingRule?: RasterFunctionProperties;
    /**
     * The URL to the REST endpoint of the layer. The URL may either pointto a resource on ArcGIS Enterprise or ArcGIS Online.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#url)
     */
    url?: string;
  }

  export interface ArcGISImageServiceFetchImageOptions extends Object {
    /**
     * An [AbortSignal](https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal) to abort the request.  If canceled, the promise will be rejected with an error named `AbortError`.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISImageService.html#fetchImage)
     */
    signal?: AbortSignal;
  }

  interface ArcGISMapService {
    /**
     * Indicates the layer's supported capabilities.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#capabilities)
     */
    readonly capabilities: ArcGISMapServiceCapabilities;
    /**
     * The copyright text as defined by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#copyright)
     */
    copyright: string;
    /**
     * The full extent of the layer as defined by the map service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#fullExtent)
     */
    fullExtent: Extent;
    /**
     * Indicates whether the layer will be included in the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled: boolean;
    /**
     * The spatial reference of the layer as defined by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#spatialReference)
     */
    readonly spatialReference: SpatialReference;
    /**
     * The version of ArcGIS Server in which the map service is published.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#version)
     */
    readonly version: number;
  }

  interface ArcGISMapServiceConstructor {
    new (properties?: ArcGISMapServiceProperties): ArcGISMapService;

    fromJSON(json: any): ArcGISMapService;
  }

  export const ArcGISMapService: ArcGISMapServiceConstructor;

  interface ArcGISMapServiceProperties {
    /**
     * The copyright text as defined by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#copyright)
     */
    copyright?: string;
    /**
     * The full extent of the layer as defined by the map service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#fullExtent)
     */
    fullExtent?: ExtentProperties;
    /**
     * Indicates whether the layer will be included in the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled?: boolean;
  }

  export interface ArcGISMapServiceCapabilities extends Object {
    /**
     * Indicates options supported by the exportMap operation. Will be `null` if the `supportsExportMap` is `false`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#capabilities)
     */
    exportMap: ArcGISMapServiceCapabilitiesExportMap;
    /**
     * Indicates options supported by the exportTiles operation. Will be `null` if the `supportsExportTiles` is `false`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#capabilities)
     */
    exportTiles: ArcGISMapServiceCapabilitiesExportTiles;
    /**
     * Indicates operations that can be performed on the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#capabilities)
     */
    operations: ArcGISMapServiceCapabilitiesOperations;
  }

  export interface ArcGISMapServiceCapabilitiesExportMap extends Object {
    /**
     * Indicates if sublayers can be added, removed, or reordered.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#capabilities)
     */
    supportsSublayersChanges: boolean;
    /**
     * Indicates if sublayers rendering can be modified or added using dynamic layers.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#capabilities)
     */
    supportsDynamicLayers: boolean;
    /**
     * Indicates if sublayers [visibility](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#visible) can be changed.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#capabilities)
     */
    supportsSublayerVisibility: boolean;
    /**
     * Indicates if sublayers [definition expression](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#definitionExpression) can be set.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#capabilities)
     */
    supportsSublayerDefinitionExpression: boolean;
  }

  export interface ArcGISMapServiceCapabilitiesExportTiles extends Object {
    /**
     * Specifies the maximum number of tiles that can be exported to a cache dataset or a tile package.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#capabilities)
     */
    maxExportTilesCount: number;
  }

  export interface ArcGISMapServiceCapabilitiesOperations extends Object {
    /**
     * Indicates if features in the sublayers can be [queried](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#queryFeatures).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#capabilities)
     */
    supportsQuery: boolean;
    /**
     * Indicates if the service can generate images.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#capabilities)
     */
    supportsExportMap: boolean;
    /**
     * Indicates if the tiles from the service can be exported.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#capabilities)
     */
    supportsExportTiles: boolean;
    /**
     * Indicates if the service exposes a tile map that describes the presence of tiles.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ArcGISMapService.html#capabilities)
     */
    supportsTileMap: boolean;
  }

  interface PortalLayer {
    /**
     * The portal item from which the layer is loaded. If the portal item referencesa Feature Service or Scene Service, then you can specify a single layerto load with the [layerId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-PortalLayer.html#layerId) property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-PortalLayer.html#portalItem)
     */
    portalItem: PortalItem;
  }

  interface PortalLayerConstructor {
    new (properties?: PortalLayerProperties): PortalLayer;

    fromJSON(json: any): PortalLayer;
  }

  export const PortalLayer: PortalLayerConstructor;

  interface PortalLayerProperties {
    /**
     * The portal item from which the layer is loaded. If the portal item referencesa Feature Service or Scene Service, then you can specify a single layerto load with the [layerId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-PortalLayer.html#layerId) property.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-PortalLayer.html#portalItem)
     */
    portalItem?: PortalItemProperties;
  }

  interface RefreshableLayer {
    /**
     * Refresh interval of the layer in minutes. Value of `0` indicates no refresh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-RefreshableLayer.html#refreshInterval)
     *
     * @default 0
     */
    refreshInterval: number;

    /**
     * Fetches all the data for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-RefreshableLayer.html#refresh)
     *
     *
     */
    refresh(): void;
  }

  interface RefreshableLayerConstructor {
    new (): RefreshableLayer;
  }

  export const RefreshableLayer: RefreshableLayerConstructor;

  interface RefreshableLayerProperties {
    /**
     * Refresh interval of the layer in minutes. Value of `0` indicates no refresh.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-RefreshableLayer.html#refreshInterval)
     *
     * @default 0
     */
    refreshInterval?: number;
  }

  interface ScaleRangeLayer {
    /**
     * The maximum scale (most zoomed in) at which the layer is visible in the view.If the map is zoomed in beyond this scale, the layer will not be visible.A value of `0` means the layer does not have a maximum scale.The maxScale value should always be smaller than the [minScale](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ScaleRangeLayer.html#minScale) value,and greater than or equal to the service specification.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ScaleRangeLayer.html#maxScale)
     *
     * @default 0
     */
    maxScale: number;
    /**
     * The minimum scale (most zoomed out) at which the layer is visible in the view.If the map is zoomed out beyond this scale, the layer will not be visible.A value of `0` means the layer does not have a minimum scale.The minScale value should always be larger than the [maxScale](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ScaleRangeLayer.html#maxScale) value,and lesser than or equal to the service specification.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ScaleRangeLayer.html#minScale)
     *
     * @default 0
     */
    minScale: number;
  }

  interface ScaleRangeLayerConstructor {
    new (): ScaleRangeLayer;
  }

  export const ScaleRangeLayer: ScaleRangeLayerConstructor;

  interface ScaleRangeLayerProperties {
    /**
     * The maximum scale (most zoomed in) at which the layer is visible in the view.If the map is zoomed in beyond this scale, the layer will not be visible.A value of `0` means the layer does not have a maximum scale.The maxScale value should always be smaller than the [minScale](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ScaleRangeLayer.html#minScale) value,and greater than or equal to the service specification.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ScaleRangeLayer.html#maxScale)
     *
     * @default 0
     */
    maxScale?: number;
    /**
     * The minimum scale (most zoomed out) at which the layer is visible in the view.If the map is zoomed out beyond this scale, the layer will not be visible.A value of `0` means the layer does not have a minimum scale.The minScale value should always be larger than the [maxScale](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ScaleRangeLayer.html#maxScale) value,and lesser than or equal to the service specification.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-ScaleRangeLayer.html#minScale)
     *
     * @default 0
     */
    minScale?: number;
  }

  interface SceneService {
    /**
     * The copyright text as defined by the scene service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#copyright)
     */
    copyright: string;
    /**
     * The layer ID, or layer index, of a Scene Service layer. This is particularly useful whenloading a single layer with the [portalItem](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#portalItem) property from a service containingmultiple layers. You can specify this value in one of two scenarios:* When loading the layer via the [portalItem](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#portalItem) property.* When pointing the layer [url](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#url) directly to the Scene Service.If a layerId is not specified in either of the above scenarios, then the first layerin the service (`layerId = 0`) is selected.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#layerId)
     */
    layerId: number;
    /**
     * The spatial reference of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#spatialReference)
     */
    spatialReference: SpatialReference;
    /**
     * The URL of the REST endpoint of the layer or scene service. The URL may either point to aresource on ArcGIS Enterprise or ArcGIS Online.The layer may be specified using the [layerId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#layerId) property when the url points directly to a service and not a specific layer.If [layerId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#layerId) is not specified, then it will default to the first layer in the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#url)
     */
    url: string;
    /**
     * The version of the scene service specification used for this service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#version)
     */
    readonly version: SceneServiceVersion;
  }

  interface SceneServiceConstructor {
    new (properties?: SceneServiceProperties): SceneService;

    fromJSON(json: any): SceneService;
  }

  export const SceneService: SceneServiceConstructor;

  interface SceneServiceProperties {
    /**
     * The copyright text as defined by the scene service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#copyright)
     */
    copyright?: string;
    /**
     * The layer ID, or layer index, of a Scene Service layer. This is particularly useful whenloading a single layer with the [portalItem](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#portalItem) property from a service containingmultiple layers. You can specify this value in one of two scenarios:* When loading the layer via the [portalItem](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#portalItem) property.* When pointing the layer [url](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#url) directly to the Scene Service.If a layerId is not specified in either of the above scenarios, then the first layerin the service (`layerId = 0`) is selected.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#layerId)
     */
    layerId?: number;
    /**
     * The spatial reference of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#spatialReference)
     */
    spatialReference?: SpatialReferenceProperties;
    /**
     * The URL of the REST endpoint of the layer or scene service. The URL may either point to aresource on ArcGIS Enterprise or ArcGIS Online.The layer may be specified using the [layerId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#layerId) property when the url points directly to a service and not a specific layer.If [layerId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#layerId) is not specified, then it will default to the first layer in the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#url)
     */
    url?: string;
  }

  export interface SceneServiceVersion extends Object {
    /**
     * The major version of the scene layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#version)
     */
    major: number;
    /**
     * The minor version of the scene layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#version)
     */
    minor: number;
    /**
     * The complete version string of the scene layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SceneService.html#version)
     */
    versionString: string;
  }

  interface SublayersOwner {
    /**
     * Returns a deep clone of a map service's[sublayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html) as defined by the service.This is useful for scenarios when the developer is unfamiliar with theservice sublayers and needs to "reset" the layer's sublayers to matchthose defined by the service.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SublayersOwner.html#createServiceSublayers)
     *
     *
     */
    createServiceSublayers(): Collection<Sublayer>;
    /**
     * Returns the sublayer with the given layerId.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-SublayersOwner.html#findSublayerById)
     *
     * @param id The [id](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#id)of the sublayer.
     *
     */
    findSublayerById(id: number): Sublayer;
  }

  interface SublayersOwnerConstructor {
    new (): SublayersOwner;
  }

  export const SublayersOwner: SublayersOwnerConstructor;

  interface TemporalLayer {
    /**
     * The time info provides information such as date fields that store[start](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#startField)and [end](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#endField) timefor each feature and the [full time extent](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#fullTimeExtent)for the layer. The `timeInfo` along with its `startField` and `endField` properties must be set at thetime of layer initialization if it is being set for[GeoJSONLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html), [CSVLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html) or[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html) initialized from[client-side features](esri-layers-FeatureLayer.html#creating-a-featurelayer).The [full time extent](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#fullTimeExtent) for the timeInfo isautomatically calculated based on `start` and `end` fields.The timeInfo parameters cannot be changed after the layer is [loaded](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#load).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-TemporalLayer.html#timeInfo)
     *
     * @default null
     */
    timeInfo: TimeInfo;
  }

  interface TemporalLayerConstructor {
    new (): TemporalLayer;
  }

  export const TemporalLayer: TemporalLayerConstructor;

  interface TemporalLayerProperties {
    /**
     * The time info provides information such as date fields that store[start](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#startField)and [end](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#endField) timefor each feature and the [full time extent](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#fullTimeExtent)for the layer. The `timeInfo` along with its `startField` and `endField` properties must be set at thetime of layer initialization if it is being set for[GeoJSONLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-GeoJSONLayer.html), [CSVLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-CSVLayer.html) or[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html) initialized from[client-side features](esri-layers-FeatureLayer.html#creating-a-featurelayer).The [full time extent](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#fullTimeExtent) for the timeInfo isautomatically calculated based on `start` and `end` fields.The timeInfo parameters cannot be changed after the layer is [loaded](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#load).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-mixins-TemporalLayer.html#timeInfo)
     *
     * @default null
     */
    timeInfo?: TimeInfoProperties;
  }

  interface OpenStreetMapLayer extends WebTileLayer {
    on(name: "layerview-create", eventHandler: OpenStreetMapLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: OpenStreetMapLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: OpenStreetMapLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface OpenStreetMapLayerConstructor {
    new (properties?: OpenStreetMapLayerProperties): OpenStreetMapLayer;
  }

  export const OpenStreetMapLayer: OpenStreetMapLayerConstructor;

  interface OpenStreetMapLayerProperties extends WebTileLayerProperties {}

  export interface OpenStreetMapLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface OpenStreetMapLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface OpenStreetMapLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  interface PointCloudFilter extends Accessor, JSONSupport {
    /**
     * The field used for applying the filter.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudFilter.html#field)
     */
    field: string;
    /**
     * The type of filter.**Possible values**: value | bitfield | return
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudFilter.html#type)
     */
    readonly type: "value" | "bitfield" | "return";
  }

  interface PointCloudFilterConstructor {
    new (properties?: PointCloudFilterProperties): PointCloudFilter;

    fromJSON(json: any): PointCloudFilter;
  }

  export const PointCloudFilter: PointCloudFilterConstructor;

  interface PointCloudFilterProperties {
    /**
     * The field used for applying the filter.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudFilter.html#field)
     */
    field?: string;
  }

  interface PointCloudReturnFilter extends PointCloudFilter {
    /**
     * An array of return types used to filter points. Possible values for the return types are: * `firstOfMany`: the point was the first to be collected in a series of many returns * `last`: the last point in a series of many returns or a single point * `lastOfMany`: the last point in a series of many returns * `single`: all the points that were collected from laser pulses with a single return
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudReturnFilter.html#includedReturns)
     */
    includedReturns: ("firstOfMany" | "last" | "lastOfMany" | "single")[];
    /**
     * For PointCloudReturnFilter the type is always `return`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudReturnFilter.html#type)
     */
    readonly type: "return";
  }

  interface PointCloudReturnFilterConstructor {
    new (properties?: PointCloudReturnFilterProperties): PointCloudReturnFilter;

    fromJSON(json: any): PointCloudReturnFilter;
  }

  export const PointCloudReturnFilter: PointCloudReturnFilterConstructor;

  interface PointCloudReturnFilterProperties extends PointCloudFilterProperties {
    /**
     * An array of return types used to filter points. Possible values for the return types are: * `firstOfMany`: the point was the first to be collected in a series of many returns * `last`: the last point in a series of many returns or a single point * `lastOfMany`: the last point in a series of many returns * `single`: all the points that were collected from laser pulses with a single return
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudReturnFilter.html#includedReturns)
     */
    includedReturns?: ("firstOfMany" | "last" | "lastOfMany" | "single")[];
  }

  interface PointCloudValueFilter extends PointCloudFilter {
    /**
     * Whether points should be included or excluded from the filter.**Possible values:** include | exclude
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudValueFilter.html#mode)
     *
     * @default "exclude"
     */
    mode: "include" | "exclude";
    /**
     * For PointCloudValueFilter the type is always `value`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudValueFilter.html#type)
     */
    readonly type: "value";
    /**
     * An array of numeric values representing the classification codesthat the filter should apply.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudValueFilter.html#values)
     */
    values: number[];
  }

  interface PointCloudValueFilterConstructor {
    new (properties?: PointCloudValueFilterProperties): PointCloudValueFilter;

    fromJSON(json: any): PointCloudValueFilter;
  }

  export const PointCloudValueFilter: PointCloudValueFilterConstructor;

  interface PointCloudValueFilterProperties extends PointCloudFilterProperties {
    /**
     * Whether points should be included or excluded from the filter.**Possible values:** include | exclude
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudValueFilter.html#mode)
     *
     * @default "exclude"
     */
    mode?: "include" | "exclude";
    /**
     * An array of numeric values representing the classification codesthat the filter should apply.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudValueFilter.html#values)
     */
    values?: number[];
  }

  interface PointCloudLayer extends Layer, SceneService, PortalLayer, ScaleRangeLayer {
    /**
     * Specifies how points are placed on the vertical axis (z). This propertyonly affects [PointCloudLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html) when using the `absolute-height` mode.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html#elevationInfo)
     */
    elevationInfo: PointCloudLayerElevationInfo;
    /**
     * An array of fields accessible in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html#fields)
     */
    fields: Field[];
    /**
     * An array of [pointCloudFilters](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudFilter.html) used to filter points.Only the points that satisfy all the filters are displayed in the view. There are two types of filters that can beset: [PointCloudValueFilter](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudValueFilter.html) filters points based on classification values and[PointCloudReturnFilter](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudReturnFilter.html) filters points based on return values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html#filters)
     */
    filters: (PointCloudValueFilter | PointCloudReturnFilter)[];
    /**
     * Indicates whether the layer will be included in the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled: boolean;
    /**
     * The renderer assigned to the layer. The renderer defines how tovisualize each point in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html#renderer)
     */
    renderer: PointCloudRenderer;

    on(name: "layerview-create", eventHandler: PointCloudLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: PointCloudLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: PointCloudLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface PointCloudLayerConstructor {
    new (properties?: PointCloudLayerProperties): PointCloudLayer;

    fromJSON(json: any): PointCloudLayer;
  }

  export const PointCloudLayer: PointCloudLayerConstructor;

  interface PointCloudLayerProperties
    extends LayerProperties,
      SceneServiceProperties,
      PortalLayerProperties,
      ScaleRangeLayerProperties {
    /**
     * Specifies how points are placed on the vertical axis (z). This propertyonly affects [PointCloudLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html) when using the `absolute-height` mode.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html#elevationInfo)
     */
    elevationInfo?: PointCloudLayerElevationInfo;
    /**
     * An array of fields accessible in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html#fields)
     */
    fields?: FieldProperties[];
    /**
     * An array of [pointCloudFilters](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudFilter.html) used to filter points.Only the points that satisfy all the filters are displayed in the view. There are two types of filters that can beset: [PointCloudValueFilter](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudValueFilter.html) filters points based on classification values and[PointCloudReturnFilter](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-pointCloudFilters-PointCloudReturnFilter.html) filters points based on return values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html#filters)
     */
    filters?: (PointCloudValueFilterProperties | PointCloudReturnFilterProperties)[];
    /**
     * Indicates whether the layer will be included in the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled?: boolean;
    /**
     * The renderer assigned to the layer. The renderer defines how tovisualize each point in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html#renderer)
     */
    renderer?: PointCloudRendererProperties;
  }

  export interface PointCloudLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface PointCloudLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface PointCloudLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  export interface PointCloudLayerElevationInfo extends Object {
    /**
     * Defines how the points are placed on the vertical axis (z).Currently only `absolute-height` mode is supported.Mode | Description------|------------absolute-height | Points are placed at an absolute elevation (z-value) above sea level. This z-value is determined by summing up the `offset` value and the point's z-value. It doesn't take the elevation of the terrain into account. This is the only supported elevation mode for a [PointCloudLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html#elevationInfo)
     */
    mode: string;
    /**
     * An elevation offset, which is added to the vertical position of each point.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html#elevationInfo)
     *
     * @default 0
     */
    offset?: number;
    /**
     * The unit for `offset` values.**Possible Values:** feet | meters | kilometers | miles | us-feet | yards
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-PointCloudLayer.html#elevationInfo)
     *
     * @default meters
     */
    unit?: string;
  }

  interface SceneLayer extends Layer, SceneService, PortalLayer, ScaleRangeLayer {
    /**
     * The SQL where clause used to filter features on the client. Only the features that satisfy the definitionexpression are displayed in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html). Setting a definition expression is usefulwhen only a subset of the data in the layer should be displayed.Setting the definition expression of a layer automatically updates all layer views.If the definition expression is set after the layer has been added to the map, the view willautomatically refresh itself to display the features that satisfy the new definition expression.Important to note is that the initial loading time of the features remains unchanged, even if they are filtered.This happens because, as opposed to Feature Layers, feature filtering is done client-side. As a result all features need to be downloaded always for filter evaluation.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#definitionExpression)
     */
    definitionExpression: string;
    /**
     * Specifies how graphics are placed on the vertical axis (z). See the [ElevationInfo sample](https://developers.arcgis.com/javascript/latest/sample-code/scene-elevationinfo/index.html)for an example of how this property may be used.This property only affects 3D Object [SceneLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html) when using the `absolute-height` mode. [SceneLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html) with[Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) geometries support all the elevation modes listed below.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#elevationInfo)
     */
    elevationInfo: SceneLayerElevationInfo;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#featureReduction)
     */
    featureReduction: SceneLayerFeatureReduction;
    /**
     * An array of fields accessible in the layer. Depending on the scene service, fields mayhave limited support for certain capabilities. Use[getFieldUsageInfo()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#getFieldUsageInfo) to querythe contexts (rendering, labeling, popups or querying) for which a particular field may be used.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#fields)
     */
    readonly fields: Field[];
    /**
     * A convenient property that can be used to make case-insensitive lookups for a field by name.It can also provide a list of the [date fields](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FieldsIndex.html#dateFields) in a layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#fieldsIndex)
     */
    readonly fieldsIndex: FieldsIndex;
    /**
     * The geometry type of features in the layer.**Possible Values:** point | mesh
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#geometryType)
     */
    geometryType: string;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#labelingInfo)
     */
    labelingInfo: LabelClass[];
    /**
     * Indicates whether to display labels for this layer. If `true`, labels willappear as defined in the [labelingInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#labelingInfo) property.This property is only relevant to SceneLayers with[Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) geometries. This property has no effecton SceneLayers with other geometry types.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#labelsVisible)
     *
     * @default true
     */
    labelsVisible: boolean;
    /**
     * Indicates whether the layer will be included in the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled: boolean;
    /**
     * The name of the field containing each graphic's Object ID.If this is not explicitly specified, this is automaticallyderived from the [fields](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#fields) of the service by takingthe first field of type `oid`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#objectIdField)
     */
    objectIdField: string;
    /**
     * An array of field names from the service to include with each feature.To fetch the values from all fields in the layer, use `["*"]`. Fields specified in`outFields` will be requested alongside with required fields for [rendering](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#renderer),[labeling](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#labelingInfo) and setting the [elevation info](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#elevationInfo) for the layer.The required fields and `outFields` are used to populate[SceneLayerView.availableFields](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-SceneLayerView.html#availableFields).Set this property to include the fields that will be used for client-side[queries](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-SceneLayerView.html#queryFeatures)if the fields are not part of required fields used for rendering.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#outFields)
     *
     * @default null
     */
    outFields: string[];
    /**
     * Indicates whether to display popups when features in the layer are clicked. The layer needs to have a [popupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#popupTemplate) to define whatinformation should be displayed in the popup. Alternatively, a default popup template may be automatically used if[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled) is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled: boolean;
    /**
     * The popup template for the layer. When set on the layer, the `popupTemplate`allows users to access attributes and display their values in the[view's popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html#popup) when a feature is selectedusing text and/or charts. See the [PopupTemplate sample](https://developers.arcgis.com/javascript/latest/sample-code/intro-popuptemplate/index.html)for an example of how [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) interacts with a[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html). Setting a [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html)on this layer type is done in the same way as a FeatureLayer.A default popup template is automatically used if no `popupTemplate` has been defined when[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled)is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#popupTemplate)
     */
    popupTemplate: PopupTemplate;
    /**
     * The renderer assigned to the layer. The renderer defines how tovisualize each feature in the layer. Depending on the renderer type,features may be visualized with the same symbol, or with varying symbolsbased on the values of provided attribute fields or functions.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#renderer)
     */
    renderer: Renderer;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#screenSizePerspectiveEnabled)
     *
     * @default true
     */
    screenSizePerspectiveEnabled: boolean;

    /**
     * Creates a default popup template for the layer, populated with all the fields of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#createPopupTemplate)
     *
     * @param options Options for creating the popup template.
     * @param options.maximumFields The maximum number of fields to include in the  popup template.
     * @param options.ignoreFieldTypes Field types to ignore when creating the popup.  By default the `geometry`, `blob`, `raster`, `guid` and `xml` field types are ignored.
     *
     */
    createPopupTemplate(options?: SceneLayerCreatePopupTemplateOptions): PopupTemplate;
    /**
     * Creates a query object that can be used to fetch features thatsatisfy the layer's current definition expression. The query shouldonly be used on the layer and not on the layer view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#createQuery)
     *
     *
     */
    createQuery(): Query;
    /**
     * Returns the [Field](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html) instance for a field name (case-insensitive).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#getField)
     *
     * @param fieldName Name of the field.
     *
     */
    getField(fieldName: string): Field;
    /**
     * Returns the [Domain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Domain.html) associated with the given field name. The domain can be either a[CodedValueDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-CodedValueDomain.html) or [RangeDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RangeDomain.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#getFieldDomain)
     *
     * @param fieldName Name of the field.
     *
     */
    getFieldDomain(fieldName: string): Domain;
    /**
     * Gets field usage information. The usage of a field depends on whether it is storedas part of the scene service cache. The returned object contains the following usage information:Property              | Type    | Description----------------------|---------|------------supportsRenderer      | boolean | Indicates that a field can be used in a renderer (e.g. in visual variables), [see renderer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#renderer).supportsLabelingInfo  | boolean | Indicates that a field can be used for labeling, [see labelingInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#labelingInfo).supportsPopupTemplate | boolean | Indicates that a field can be used in a popup template, [see popupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#popupTemplate).supportsLayerQuery    | boolean | Indicates that a field can be used in layer queries, [see queryFeatures()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#queryFeatures).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#getFieldUsageInfo)
     *
     * @param fieldName The name of the field to get usage info for.
     *
     */
    getFieldUsageInfo(fieldName: string): any;
    /**
     * Executes a [Query](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html) against the service and returns the 2D[Extent](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Extent.html) of features that satisfy the query.At the moment the 3D Extent can be returned by using[SceneLayerView.queryExtent()](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-SceneLayerView.html#queryExtent),but this will return the 3D extent only for features currently in the view.The query succeeds only if the layer's `supportsLayerQuery` capability is enabled. Use the[getFieldUsageInfo()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#getFieldUsageInfo) method to check if the layer supports queries.If querying is not enabled, then an errorwith the name `scenelayer:query-not-available` is thrown. Read more about queries in the [Querying](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#querying)section of the class description above.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#queryExtent)
     *
     * @param query Specifies the query parameters.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryExtent(query?: Query | QueryProperties, options?: SceneLayerQueryExtentOptions): IPromise<any>;
    /**
     * Executes a [Query](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html) against the feature service and returns the number ofthe features that satisfy the query. The query succeeds only ifthe layer's `supportsLayerQuery` capability is enabled. Use the[getFieldUsageInfo()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#getFieldUsageInfo) method to check if the layer supports queries.If querying is not enabled, then an errorwith the name `scenelayer:query-not-available` is thrown. Read more about queries in the [Querying](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#querying)section of the class description above.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#queryFeatureCount)
     *
     * @param query Specifies the query parameters.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryFeatureCount(query?: Query | QueryProperties, options?: SceneLayerQueryFeatureCountOptions): IPromise<number>;
    /**
     * Executes a [Query](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html) against the service and returns a[FeatureSet](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-FeatureSet.html). The query succeeds only ifthe layer's `supportsLayerQuery` capability is enabled. Use the[getFieldUsageInfo()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#getFieldUsageInfo) method to check if the layer supports queries.If querying is not enabled, then an errorwith the name `scenelayer:query-not-available` is thrown. Read more about queries in the [Querying](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#querying)section of the class description above.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#queryFeatures)
     *
     * @param query Specifies the query parameters.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryFeatures(query?: Query | QueryProperties, options?: SceneLayerQueryFeaturesOptions): IPromise<FeatureSet>;
    /**
     * Executes a [Query](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html) against the service and returns an array of theObjectIDs of features that satisfy the input query. The query succeeds only ifthe layer's `supportsLayerQuery` capability is enabled. Use the[getFieldUsageInfo()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#getFieldUsageInfo) method to check if the layer supports queries.If querying is not enabled, then an errorwith the name `scenelayer:query-not-available` is thrown. Read more about queries in the [Querying](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#querying)section of the class description above.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#queryObjectIds)
     *
     * @param query Specifies the query parameters.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryObjectIds(query?: Query | QueryProperties, options?: SceneLayerQueryObjectIdsOptions): IPromise<number[]>;

    on(name: "layerview-create", eventHandler: SceneLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: SceneLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: SceneLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface SceneLayerConstructor {
    new (properties?: SceneLayerProperties): SceneLayer;

    fromJSON(json: any): SceneLayer;
  }

  export const SceneLayer: SceneLayerConstructor;

  interface SceneLayerProperties
    extends LayerProperties,
      SceneServiceProperties,
      PortalLayerProperties,
      ScaleRangeLayerProperties {
    /**
     * The SQL where clause used to filter features on the client. Only the features that satisfy the definitionexpression are displayed in the [View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html). Setting a definition expression is usefulwhen only a subset of the data in the layer should be displayed.Setting the definition expression of a layer automatically updates all layer views.If the definition expression is set after the layer has been added to the map, the view willautomatically refresh itself to display the features that satisfy the new definition expression.Important to note is that the initial loading time of the features remains unchanged, even if they are filtered.This happens because, as opposed to Feature Layers, feature filtering is done client-side. As a result all features need to be downloaded always for filter evaluation.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#definitionExpression)
     */
    definitionExpression?: string;
    /**
     * Specifies how graphics are placed on the vertical axis (z). See the [ElevationInfo sample](https://developers.arcgis.com/javascript/latest/sample-code/scene-elevationinfo/index.html)for an example of how this property may be used.This property only affects 3D Object [SceneLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html) when using the `absolute-height` mode. [SceneLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html) with[Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) geometries support all the elevation modes listed below.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#elevationInfo)
     */
    elevationInfo?: SceneLayerElevationInfo;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#featureReduction)
     */
    featureReduction?: SceneLayerFeatureReduction;
    /**
     * The geometry type of features in the layer.**Possible Values:** point | mesh
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#geometryType)
     */
    geometryType?: string;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#labelingInfo)
     */
    labelingInfo?: LabelClassProperties[];
    /**
     * Indicates whether to display labels for this layer. If `true`, labels willappear as defined in the [labelingInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#labelingInfo) property.This property is only relevant to SceneLayers with[Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) geometries. This property has no effecton SceneLayers with other geometry types.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#labelsVisible)
     *
     * @default true
     */
    labelsVisible?: boolean;
    /**
     * Indicates whether the layer will be included in the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled?: boolean;
    /**
     * The name of the field containing each graphic's Object ID.If this is not explicitly specified, this is automaticallyderived from the [fields](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#fields) of the service by takingthe first field of type `oid`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#objectIdField)
     */
    objectIdField?: string;
    /**
     * An array of field names from the service to include with each feature.To fetch the values from all fields in the layer, use `["*"]`. Fields specified in`outFields` will be requested alongside with required fields for [rendering](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#renderer),[labeling](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#labelingInfo) and setting the [elevation info](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#elevationInfo) for the layer.The required fields and `outFields` are used to populate[SceneLayerView.availableFields](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-SceneLayerView.html#availableFields).Set this property to include the fields that will be used for client-side[queries](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-SceneLayerView.html#queryFeatures)if the fields are not part of required fields used for rendering.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#outFields)
     *
     * @default null
     */
    outFields?: string[];
    /**
     * Indicates whether to display popups when features in the layer are clicked. The layer needs to have a [popupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#popupTemplate) to define whatinformation should be displayed in the popup. Alternatively, a default popup template may be automatically used if[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled) is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled?: boolean;
    /**
     * The popup template for the layer. When set on the layer, the `popupTemplate`allows users to access attributes and display their values in the[view's popup](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html#popup) when a feature is selectedusing text and/or charts. See the [PopupTemplate sample](https://developers.arcgis.com/javascript/latest/sample-code/intro-popuptemplate/index.html)for an example of how [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html) interacts with a[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html). Setting a [PopupTemplate](https://developers.arcgis.com/javascript/latest/api-reference/esri-PopupTemplate.html)on this layer type is done in the same way as a FeatureLayer.A default popup template is automatically used if no `popupTemplate` has been defined when[Popup.defaultPopupTemplateEnabled](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Popup.html#defaultPopupTemplateEnabled)is set to `true`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#popupTemplate)
     */
    popupTemplate?: PopupTemplateProperties;
    /**
     * The renderer assigned to the layer. The renderer defines how tovisualize each feature in the layer. Depending on the renderer type,features may be visualized with the same symbol, or with varying symbolsbased on the values of provided attribute fields or functions.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#renderer)
     */
    renderer?: RendererProperties;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#screenSizePerspectiveEnabled)
     *
     * @default true
     */
    screenSizePerspectiveEnabled?: boolean;
  }

  export interface SceneLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface SceneLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface SceneLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  export interface SceneLayerCreatePopupTemplateOptions extends Object {
    /**
     * The maximum number of fields to include in the  popup template.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#createPopupTemplate)
     *
     * @default 75
     */
    maximumFields?: number;
    /**
     * Field types to ignore when creating the popup.  By default the `geometry`, `blob`, `raster`, `guid` and `xml` field types are ignored.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#createPopupTemplate)
     */
    ignoreFieldTypes?: string[];
  }

  export interface SceneLayerElevationInfo extends Object {
    /**
     * Defines how the graphic is placed with respect to the terrain surface.See the table below for a list of possible values.Mode | Description------|------------on-the-ground | Graphics are draped on the terrain surface. This is the default value for features with [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) geometries rendered with [ObjectSymbol3DLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-ObjectSymbol3DLayer.html).relative-to-ground | The graphic is placed at an elevation relative to the terrain surface. The graphic's elevation is determined by summing up the terrain elevation, the `offset` value and the geometry's z-value (if present). This is the default value for [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) geometries rendered with [IconSymbol3DLayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-symbols-IconSymbol3DLayer.html).absolute-height | Graphics are placed at an absolute elevation (z-value) above sea level. This z-value is determined by summing up the `offset` value and the geometry's z-value (if present). It doesn't take the elevation of the terrain into account. This is the default value for features with 3D Object geometries and [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html) geometries where [hasZ](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#hasZ) is `true`.relative-to-scene | Graphics are aligned to buildings and other objects part of 3D Object [SceneLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html) or [IntegratedMeshLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-IntegratedMeshLayer.html), depending on which has higher elevation. If the graphic is not directly above a building or any other feature, it is aligned to the terrain surface elevation. If present, z-values will be ignored.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#elevationInfo)
     */
    mode: string;
    /**
     * An elevation offset which is added to the vertical position of the graphic.When `mode = "on-the-ground"`, this property has no effect.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#elevationInfo)
     *
     * @default 0
     */
    offset?: number;
    /**
     * The unit for `offset` values.**Possible Values:** feet | meters | kilometers | miles | us-feet | yards
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#elevationInfo)
     *
     * @default meters
     */
    unit?: string;
  }

  export interface SceneLayerFeatureReduction extends Object {
    /**
     * Type of the decluttering method. The only supported type at the moment is`"selection"`. In this method, some of the overlapping features are hidden such that none of the remaining featuresintersect on screen. Label deconfliction also respects this option and hides labels that would overlap with the features of this layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#featureReduction)
     */
    type: string;
  }

  export interface SceneLayerQueryExtentOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#queryExtent)
     */
    signal?: AbortSignal;
  }

  export interface SceneLayerQueryFeatureCountOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#queryFeatureCount)
     */
    signal?: AbortSignal;
  }

  export interface SceneLayerQueryFeaturesOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#queryFeatures)
     */
    signal?: AbortSignal;
  }

  export interface SceneLayerQueryObjectIdsOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-SceneLayer.html#queryObjectIds)
     */
    signal?: AbortSignal;
  }

  interface StreamLayer extends FeatureLayer {
    /**
     * Contains the attribute and spatial filters used to filter messages sent to theclient by a Stream Service.This property can be set in the constructor but is `read-only` after the layeris created. To change thefilter after the layer is created, use the [updateFilter()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#updateFilter) method.**Use definitionExpression or geometryDefinition instead.**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#filter)
     */
    readonly filter: StreamLayerFilter;
    /**
     * An extent object used to filter features. Only features intersecting theextent are displayed in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#geometryDefinition)
     */
    geometryDefinition: Extent;
    /**
     * Maximum number of features to show per [trackId](https://enterprise.arcgis.com/en/geoevent/latest/get-started/essential-geoevent-server-vocabulary.htm#ESRI_SECTION1_F45BBCE9ADFA4E57AF38DD225921EFCD).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#maximumTrackPoints)
     */
    maximumTrackPoints: number;
    /**
     * Options for purging stale features. Use these options to avoid overloading thebrowser with graphics.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#purgeOptions)
     */
    purgeOptions: StreamLayerPurgeOptions;

    /**
     * Updates the [filter](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#filter) on the layer. The filter is updated on all views thatcontain the layer. If the input `filterChanges` object is `undefined` or `null`,the spatial and attribute filters are removed. To update the filter on a single layer viewassociated with the layer, use the[StreamLayerView.updateFilter()](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-layers-StreamLayerView.html#updateFilter)method after getting the layer view object.Filter changes only apply to incoming features. Features already displayed in theview will be removed automatically.**Use [definitionExpression](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#definitionExpression) or [geometryDefinition](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#definitionExpression) instead.**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#updateFilter)
     *
     * @param filterChanges Updates the spatial and attribute [filters](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#filter)                              on the layer and all of its associated views.                              If `null`, all filters are cleared.
     * @param filterChanges.geometry A spatial filter forfiltering features.Only features that intersect the given geometry are displayed in the view(s).If `null`, the spatial filter is cleared.
     * @param filterChanges.where A SQL where clause used to filter features                       by attributes. If `null`, the attribute filter is cleared.
     *
     */
    updateFilter(filterChanges: StreamLayerUpdateFilterFilterChanges): IPromise<any>;

    on(name: "edits", eventHandler: StreamLayerEditsEventHandler): IHandle;

    on(name: "layerview-create", eventHandler: StreamLayerLayerviewCreateEventHandler): IHandle;

    on(name: "layerview-create-error", eventHandler: StreamLayerLayerviewCreateErrorEventHandler): IHandle;

    on(name: "layerview-destroy", eventHandler: StreamLayerLayerviewDestroyEventHandler): IHandle;
  }

  interface StreamLayerConstructor {
    new (properties?: StreamLayerProperties): StreamLayer;

    fromJSON(json: any): StreamLayer;
  }

  export const StreamLayer: StreamLayerConstructor;

  interface StreamLayerProperties extends FeatureLayerProperties {
    /**
     * Contains the attribute and spatial filters used to filter messages sent to theclient by a Stream Service.This property can be set in the constructor but is `read-only` after the layeris created. To change thefilter after the layer is created, use the [updateFilter()](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#updateFilter) method.**Use definitionExpression or geometryDefinition instead.**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#filter)
     */
    filter?: StreamLayerFilter;
    /**
     * An extent object used to filter features. Only features intersecting theextent are displayed in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#geometryDefinition)
     */
    geometryDefinition?: ExtentProperties;
    /**
     * Maximum number of features to show per [trackId](https://enterprise.arcgis.com/en/geoevent/latest/get-started/essential-geoevent-server-vocabulary.htm#ESRI_SECTION1_F45BBCE9ADFA4E57AF38DD225921EFCD).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#maximumTrackPoints)
     */
    maximumTrackPoints?: number;
    /**
     * Options for purging stale features. Use these options to avoid overloading thebrowser with graphics.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#purgeOptions)
     */
    purgeOptions?: StreamLayerPurgeOptions;
  }

  export interface StreamLayerEditsEvent {
    addedFeatures: StreamLayerEditsEventAddedFeatures[];

    deletedFeatures: StreamLayerEditsEventDeletedFeatures[];

    updatedFeatures: StreamLayerEditsEventUpdatedFeatures[];
  }

  export interface StreamLayerLayerviewCreateErrorEvent {
    error: Error;

    view: View;
  }

  export interface StreamLayerLayerviewCreateEvent {
    layerView: LayerView;

    view: View;
  }

  export interface StreamLayerLayerviewDestroyEvent {
    layerView: LayerView;

    view: View;
  }

  export interface StreamLayerFilter extends Object {
    /**
     * A spatial filter for filtering features.Only features that intersect the given geometry are displayed in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#filter)
     */
    geometry?: Extent;
    /**
     * A SQL where clause used to filter features by attributes.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#filter)
     */
    where?: string;
  }

  export interface StreamLayerPurgeOptions extends Object {
    /**
     * The maximum number of features to display.Excess features are purged from the beginning of the graphics array.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#purgeOptions)
     */
    displayCount: number;
    /**
     * The maximum time in minutes that a feature should be kept.                         After this time, the feature is removed from the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#purgeOptions)
     */
    age: number;
  }

  export interface StreamLayerUpdateFilterFilterChanges extends Object {
    /**
     * A spatial filter forfiltering features.Only features that intersect the given geometry are displayed in the view(s).If `null`, the spatial filter is cleared.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#updateFilter)
     */
    geometry: Extent;
    /**
     * A SQL where clause used to filter features                       by attributes. If `null`, the attribute filter is cleared.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-StreamLayer.html#updateFilter)
     */
    where: string;
  }

  export interface StreamLayerEditsEventAddedFeatures extends Object {
    objectId: number;
  }

  export interface StreamLayerEditsEventDeletedFeatures extends Object {
    objectId: number;
  }

  export interface StreamLayerEditsEventUpdatedFeatures extends Object {
    objectId: number;
  }

  interface AttachmentInfo extends Accessor, JSONSupport {
    /**
     * The content type of the attachment. For example, `'image/jpeg'`.See the [ArcGIS REST API documentation](https://developers.arcgis.com/rest/services-reference/query-attachments-feature-service-layer-.htm)for more information on supported attachment types.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#contentType)
     */
    contentType: string;
    /**
     * An array of [ExifInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#ExifInfo) for the attachment.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#exifInfo)
     */
    exifInfo: ExifInfo[];
    /**
     * The identifier for the attachment.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#id)
     */
    id: number;
    /**
     * Keywords used for the attachments.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#keywords)
     */
    keywords: string;
    /**
     * String value indicating the name of the file attachment.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#name)
     */
    name: string;
    /**
     * The [OrientationInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#OrientationInfo) for the attachment.This is derived from the [exifInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#exifInfo).In order to read this, you must first set the attachment query's [returnMetadata](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-AttachmentQuery.html#returnMetadata)to `true` to get the `exif` info associated with the attachment.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#orientationInfo)
     */
    readonly orientationInfo: OrientationInfo;
    /**
     * The parent or the feature object id of the attachment.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#parentObjectId)
     */
    parentObjectId: number;
    /**
     * The file size of the attachment. This is specified in bytes.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#size)
     */
    size: number;
    /**
     * The URL of the attachment.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#url)
     */
    url: string;

    /**
     * Creates a deep clone of the AttachmentInfo class.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#clone)
     *
     *
     */
    clone(): AttachmentInfo;
  }

  interface AttachmentInfoConstructor {
    new (properties?: AttachmentInfoProperties): AttachmentInfo;

    fromJSON(json: any): AttachmentInfo;
  }

  export const AttachmentInfo: AttachmentInfoConstructor;

  interface AttachmentInfoProperties {
    /**
     * The content type of the attachment. For example, `'image/jpeg'`.See the [ArcGIS REST API documentation](https://developers.arcgis.com/rest/services-reference/query-attachments-feature-service-layer-.htm)for more information on supported attachment types.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#contentType)
     */
    contentType?: string;
    /**
     * An array of [ExifInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#ExifInfo) for the attachment.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#exifInfo)
     */
    exifInfo?: ExifInfo[];
    /**
     * The identifier for the attachment.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#id)
     */
    id?: number;
    /**
     * Keywords used for the attachments.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#keywords)
     */
    keywords?: string;
    /**
     * String value indicating the name of the file attachment.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#name)
     */
    name?: string;
    /**
     * The parent or the feature object id of the attachment.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#parentObjectId)
     */
    parentObjectId?: number;
    /**
     * The file size of the attachment. This is specified in bytes.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#size)
     */
    size?: number;
    /**
     * The URL of the attachment.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#url)
     */
    url?: string;
  }

  /**
   * An array of [Exchangeable image file format](http://www.cipa.jp/std/documents/e/DC-008-Translation-2016-E.pdf) informationfor the attachment. You must set the attachment query's [returnMetadata](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-AttachmentQuery.html#returnMetadata) to `true` to get the `exif`info associated with the attachment.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#ExifInfo)
   */
  export interface ExifInfo extends Object {
    /**
     * The file name.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#ExifInfo)
     */
    name?: string;
    /**
     * Array of tag objects containing the following properties:
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#ExifInfo)
     */
    tags?: ExifInfoTags[];
  }

  /**
   * An object containing properties specific to the orientation of an image attachment.This information is stored within the attachment's [exifInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#exifInfo).In order to read this, you must first set the attachment query's [returnMetadata](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-AttachmentQuery.html#returnMetadata)to `true` to get the `exif` info associated with the attachment.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#OrientationInfo)
   */
  export interface OrientationInfo extends Object {
    /**
     * The identifer for the orientation info.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#OrientationInfo)
     */
    id?: number;
    /**
     * The rotation value for the attached image.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#OrientationInfo)
     */
    rotation?: number;
    /**
     * Indicates whether the image displays mirrored.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#OrientationInfo)
     */
    mirrored?: boolean;
  }

  export interface ExifInfoTags extends Object {
    /**
     * The tag name.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#ExifInfo)
     */
    name: string;
    /**
     * The tag description.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#ExifInfo)
     */
    description: string;
    /**
     * The value of the tag.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-AttachmentInfo.html#ExifInfo)
     */
    value: any;
  }

  interface BuildingFilter extends JSONSupport {
    /**
     * Description of the filter for display in UIs, for example when the filter is edited in ArcGIS Pro.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#description)
     */
    description: string;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#filterBlocks)
     */
    filterBlocks: Collection<BuildingFilterBlock>;
    /**
     * Unique filter id.Assign this id to [BuildingSceneLayer.activeFilterId](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-BuildingSceneLayer.html#activeFilterId) to activate the filter.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#id)
     */
    readonly id: string;
    /**
     * Name of the filter for display in UIs, for example when the filter is edited in ArcGIS Pro.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#name)
     */
    name: string;
  }

  interface BuildingFilterConstructor {
    new (properties?: BuildingFilterProperties): BuildingFilter;

    fromJSON(json: any): BuildingFilter;
  }

  export const BuildingFilter: BuildingFilterConstructor;

  interface BuildingFilterProperties {
    /**
     * Description of the filter for display in UIs, for example when the filter is edited in ArcGIS Pro.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#description)
     */
    description?: string;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#filterBlocks)
     */
    filterBlocks?: CollectionProperties<BuildingFilterBlock>;
    /**
     * Name of the filter for display in UIs, for example when the filter is edited in ArcGIS Pro.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#name)
     */
    name?: string;
  }

  /**
   * Object contained in the [filterBlocks](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#filterBlocks) collection:
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#BuildingFilterBlock)
   */
  export interface BuildingFilterBlock extends Object {
    /**
     * The SQL where clause used to match features to this filter block.                                      Only the features that satisfy the filter expression are displayed in the [SceneView](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-SceneView.html).                                      This property is evaluated on the client using the cached attributes and it only supports                                      [standardized SQL](http://doc.arcgis.com/en/arcgis-online/reference/sql-agol.htm).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#BuildingFilterBlock)
     */
    filterExpression: string;
    /**
     * This object contains information about the filter mode of the filter block. This property can generally be omitted, since only `solid` filter blocks are rendered in the JS API.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#BuildingFilterBlock)
     */
    filterMode?: BuildingFilterBlockFilterMode;
    /**
     * Title of the filter for display in UIs, for example when the filter block is edited in ArcGIS Pro.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#BuildingFilterBlock)
     */
    title?: string;
  }

  export interface BuildingFilterBlockFilterMode extends Object {
    /**
     * Defines how features are drawn while the filter is active. The same filter mode type can only be used once in a filter.                                             To filter multiple elements as solid, add them to a single filter block instead of creating several filter blocks that use the `solid` filter mode.**Possible Values:** solid | wire-frame
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-BuildingFilter.html#BuildingFilterBlock)
     *
     * @default solid
     */
    type?: string;
  }

  interface CodedValueDomain extends Domain {
    /**
     * An array of the coded values in the domain. See the object specification table below for theproperties each item in the array should contain.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-CodedValueDomain.html#codedValues)
     */
    codedValues: CodedValueDomainCodedValues[];
    /**
     * The domain type. This value is always `coded-value`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-CodedValueDomain.html#type)
     */
    readonly type: "coded-value";

    /**
     * Returns the name of the coded-value associated with the specified code.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-CodedValueDomain.html#getName)
     *
     * @param code The code associated with the desired name.
     *
     */
    getName(code: string | number): string;
  }

  interface CodedValueDomainConstructor {
    new (properties?: CodedValueDomainProperties): CodedValueDomain;

    fromJSON(json: any): CodedValueDomain;
  }

  export const CodedValueDomain: CodedValueDomainConstructor;

  interface CodedValueDomainProperties extends DomainProperties {
    /**
     * An array of the coded values in the domain. See the object specification table below for theproperties each item in the array should contain.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-CodedValueDomain.html#codedValues)
     */
    codedValues?: CodedValueDomainCodedValues[];
  }

  export interface CodedValueDomainCodedValues extends Object {
    /**
     * The name of the coded value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-CodedValueDomain.html#codedValues)
     */
    name: string;
    /**
     * The value of the code.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-CodedValueDomain.html#codedValues)
     */
    code: string | number;
  }

  interface DimensionalDefinition extends Accessor, JSONSupport {
    /**
     * The dimension associated with the variable.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-DimensionalDefinition.html#dimensionName)
     */
    dimensionName: string;
    /**
     * Indicates whether the values indicate slices (rather than ranges).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-DimensionalDefinition.html#isSlice)
     *
     * @default false
     */
    isSlice: boolean;
    /**
     * An array of single values or tuples [min, max] each defining a range ofvalid values along the specified dimension.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-DimensionalDefinition.html#values)
     */
    values: (number | number[])[];
    /**
     * The required variable name by which to filter.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-DimensionalDefinition.html#variableName)
     */
    variableName: string;

    /**
     * Creates a clone of the DimensionalDefinition object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-DimensionalDefinition.html#clone)
     *
     *
     */
    clone(): DimensionalDefinition;
  }

  interface DimensionalDefinitionConstructor {
    new (properties?: DimensionalDefinitionProperties): DimensionalDefinition;

    fromJSON(json: any): DimensionalDefinition;
  }

  export const DimensionalDefinition: DimensionalDefinitionConstructor;

  interface DimensionalDefinitionProperties {
    /**
     * The dimension associated with the variable.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-DimensionalDefinition.html#dimensionName)
     */
    dimensionName?: string;
    /**
     * Indicates whether the values indicate slices (rather than ranges).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-DimensionalDefinition.html#isSlice)
     *
     * @default false
     */
    isSlice?: boolean;
    /**
     * An array of single values or tuples [min, max] each defining a range ofvalid values along the specified dimension.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-DimensionalDefinition.html#values)
     */
    values?: (number | number[])[];
    /**
     * The required variable name by which to filter.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-DimensionalDefinition.html#variableName)
     */
    variableName?: string;
  }

  interface Domain extends Accessor, JSONSupport {
    /**
     * The domain name.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Domain.html#name)
     */
    name: string;
    /**
     * The domain type.**Possible Values:** range | coded-value | inherited
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Domain.html#type)
     */
    type: "range" | "coded-value" | "inherited";
  }

  interface DomainConstructor {
    new (properties?: DomainProperties): Domain;

    fromJSON(json: any): Domain;
  }

  export const Domain: DomainConstructor;

  interface DomainProperties {
    /**
     * The domain name.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Domain.html#name)
     */
    name?: string;
    /**
     * The domain type.**Possible Values:** range | coded-value | inherited
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Domain.html#type)
     */
    type?: "range" | "coded-value" | "inherited";
  }

  interface ElevationSampler {
    /**
     * Registers an event handler on the instance. Call this method to hook anevent with a listener. See the [Events summary table](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ElevationSampler.html#events-summary) for a listof listened events.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ElevationSampler.html#on)
     *
     * @param type The name of the event or the events to listen for.
     * @param handler? The function to call when the event is fired, if modifiers were specified.
     *
     */
    on(type: string | string[], handler?: Function): any;
    /**
     * Query elevation for a [Point](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Point.html), [Polyline](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Polyline.html) or[Multipoint](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-Multipoint.html) geometry. A query will return a new geometryfor which the z-values for each coordinate in the geometry are obtained from the elevationsampler. If the geometry used for the query is outside of the elevation sampler extent,then the returned geometry has `0` as z-values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ElevationSampler.html#queryElevation)
     *
     * @param geometry The geometry to use for sampling elevation data.
     *
     */
    queryElevation(geometry: Point | Multipoint | Polyline): Point | Multipoint | Polyline;

    on(name: "changed", eventHandler: ElevationSamplerChangedEventHandler): IHandle;
  }

  interface ElevationSamplerConstructor {
    new (): ElevationSampler;
  }

  export const ElevationSampler: ElevationSamplerConstructor;

  export interface ElevationSamplerChangedEvent {}

  interface FeatureTemplate extends Accessor, JSONSupport {
    /**
     * Description of the feature template.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#description)
     */
    description: string;
    /**
     * Name of the default drawing tool defined for the template to create a feature.**Possible Values:** auto-complete-polygon | circle | ellipse | freehand | line | none | point | polygon | rectangle | arrow | triangle | left-arrow | right-arrow | up-arrow | down-arrow
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#drawingTool)
     */
    drawingTool: string;
    /**
     * Name of the feature template.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#name)
     */
    name: string;
    /**
     * An instance of the prototypical feature described by the [feature template](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html).It specifies default values for the attribute fields and does not contain geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#prototype)
     */
    prototype: any;
    /**
     * An object used to create a thumbnail image that represents a feature type in the feature template.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#thumbnail)
     */
    thumbnail: FeatureTemplateThumbnail;
  }

  interface FeatureTemplateConstructor {
    new (properties?: FeatureTemplateProperties): FeatureTemplate;

    fromJSON(json: any): FeatureTemplate;
  }

  export const FeatureTemplate: FeatureTemplateConstructor;

  interface FeatureTemplateProperties {
    /**
     * Description of the feature template.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#description)
     */
    description?: string;
    /**
     * Name of the default drawing tool defined for the template to create a feature.**Possible Values:** auto-complete-polygon | circle | ellipse | freehand | line | none | point | polygon | rectangle | arrow | triangle | left-arrow | right-arrow | up-arrow | down-arrow
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#drawingTool)
     */
    drawingTool?: string;
    /**
     * Name of the feature template.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#name)
     */
    name?: string;
    /**
     * An instance of the prototypical feature described by the [feature template](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html).It specifies default values for the attribute fields and does not contain geometry.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#prototype)
     */
    prototype?: any;
    /**
     * An object used to create a thumbnail image that represents a feature type in the feature template.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#thumbnail)
     */
    thumbnail?: FeatureTemplateThumbnail;
  }

  export interface FeatureTemplateThumbnail extends Object {
    /**
     * The MIME type of the image.**Possible Values:** image | png | jpg | jpeg
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#thumbnail)
     */
    contentType: any;
    /**
     * The [base64EncodedImageData](https://developer.mozilla.org/en-US/docs/Web/API/WindowBase64/Base64_encoding_and_decoding)presenting the thumbnail image.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#thumbnail)
     */
    imageData: string;
    /**
     * The height of the thumbnail.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#thumbnail)
     */
    height: number;
    /**
     * The width of the thumbnail.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html#thumbnail)
     */
    width: number;
  }

  interface FeatureType extends Accessor, JSONSupport {
    /**
     * Domains associated with the feature type. It is an object where the name of each property corresponds with the name of a fieldcontaining a domain. If a field's domain is an instance of [InheritedDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-InheritedDomain.html), the applicationwill use the domain defined for the field from the layer. If the domain is an instance of[CodedValueDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-CodedValueDomain.html) or [RangeDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RangeDomain.html) then the domain is definedspecifically for the given feature type.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureType.html#domains)
     */
    domains: any;
    /**
     * The feature type identifier.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureType.html#id)
     */
    id: number | string;
    /**
     * The feature type name.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureType.html#name)
     */
    name: string;
    /**
     * Array of [feature templates](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html) associated with the feature type.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureType.html#templates)
     */
    templates: FeatureTemplate[];
  }

  interface FeatureTypeConstructor {
    new (properties?: FeatureTypeProperties): FeatureType;

    fromJSON(json: any): FeatureType;
  }

  export const FeatureType: FeatureTypeConstructor;

  interface FeatureTypeProperties {
    /**
     * Domains associated with the feature type. It is an object where the name of each property corresponds with the name of a fieldcontaining a domain. If a field's domain is an instance of [InheritedDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-InheritedDomain.html), the applicationwill use the domain defined for the field from the layer. If the domain is an instance of[CodedValueDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-CodedValueDomain.html) or [RangeDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RangeDomain.html) then the domain is definedspecifically for the given feature type.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureType.html#domains)
     */
    domains?: any;
    /**
     * The feature type identifier.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureType.html#id)
     */
    id?: number | string;
    /**
     * The feature type name.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureType.html#name)
     */
    name?: string;
    /**
     * Array of [feature templates](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureTemplate.html) associated with the feature type.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FeatureType.html#templates)
     */
    templates?: FeatureTemplateProperties[];
  }

  interface Field extends Accessor, JSONSupport {
    /**
     * The display name for the field.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#alias)
     *
     * @default null
     */
    alias: string;
    /**
     * The default value set for the field.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#defaultValue)
     *
     * @default undefined
     */
    defaultValue: number | string | any | any;
    /**
     * Contains information describing the purpose of each field.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#description)
     */
    description: string;
    /**
     * The domain associated with the field. Domains are used to constrain the values allowedin a field. There are two types of domains: [RangeDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RangeDomain.html)and [CodedValueDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-CodedValueDomain.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#domain)
     *
     * @default null
     */
    domain: Domain;
    /**
     * Indicates whether the field is editable.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#editable)
     *
     * @default true
     */
    editable: boolean;
    /**
     * The field length.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#length)
     *
     * @default -1
     */
    length: number;
    /**
     * The name of the field.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#name)
     *
     * @default null
     */
    name: string;
    /**
     * Indicates if the field can accept `null` values. *Requires ArcGIS Server version 10.1 or greater.*
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#nullable)
     *
     * @default true
     */
    nullable: boolean;
    /**
     * The data type of the field.**Possible Values:** small-integer | integer | single | double |long | string | date | oid | geometry | blob | raster |guid | global-id | xml
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#type)
     *
     * @default null
     */
    type:
      | "small-integer"
      | "integer"
      | "single"
      | "double"
      | "long"
      | "string"
      | "date"
      | "oid"
      | "geometry"
      | "blob"
      | "raster"
      | "guid"
      | "global-id"
      | "xml";
    /**
     * The types of values that can be assigned to a field. See the table below for a list of possible values.| Mode | Description || ------|------------ || name-or-title | Text that represents a name, title, label, or keyword for each feature. || description | Text that provides a longer description of the feature, more than just a name or title. || type-or-category | Types or categories that group features based on common characteristics. || count-or-amount | Integers (no decimal) that represent how many or how much there is of a specific attribute. || percentage-or-ratio | Number values in this field reflect the relationship between different quantities. || measurement | A number that reflects a characteristic that you can precisely measure. || unique-identifier | The values in this field are used to positively distinguish one feature or entity from another. || ordered-or-ranked | The values in this field represent a feature's status in an ordered or ranked list. For example, a feature could be one of the following: `Small, medium, large`, `First, second, third, fourth`, or `Informational, warning, error, failure`.|| binary | Only one of two values are possible for each feature. Some examples include the following: `On or off`, `Yes or no`, `True or false`, or `Inhabited or vacant`. || location-or-place-name | Values in this field represent a geographic location. Examples of values in such a field include a street address, city name, region, building name (such as A.K. Smiley Public Library), attraction name (such as Alameda County Fairgrounds or Cairngorms National Park), postal code, or country. || coordinate | These fields store a geographic coordinate value such as x, y, z, latitude, or longitude. || date-and-time | Values in this field store explicit dates and times or date references such as days of the week, months, or years. || none | No specified type. |
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#valueType)
     */
    valueType:
      | "binary"
      | "coordinate"
      | "count-or-amount"
      | "date-and-time"
      | "description"
      | "location-or-place-name"
      | "measurement"
      | "name-or-title"
      | "none"
      | "ordered-or-ranked"
      | "percentage-or-ratio"
      | "type-or-category"
      | "unique-identifier";
  }

  interface FieldConstructor {
    new (properties?: FieldProperties): Field;

    fromJSON(json: any): Field;
  }

  export const Field: FieldConstructor;

  interface FieldProperties {
    /**
     * The display name for the field.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#alias)
     *
     * @default null
     */
    alias?: string;
    /**
     * The default value set for the field.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#defaultValue)
     *
     * @default undefined
     */
    defaultValue?: number | string | any | any;
    /**
     * Contains information describing the purpose of each field.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#description)
     */
    description?: string;
    /**
     * The domain associated with the field. Domains are used to constrain the values allowedin a field. There are two types of domains: [RangeDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RangeDomain.html)and [CodedValueDomain](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-CodedValueDomain.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#domain)
     *
     * @default null
     */
    domain?: DomainProperties;
    /**
     * Indicates whether the field is editable.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#editable)
     *
     * @default true
     */
    editable?: boolean;
    /**
     * The field length.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#length)
     *
     * @default -1
     */
    length?: number;
    /**
     * The name of the field.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#name)
     *
     * @default null
     */
    name?: string;
    /**
     * Indicates if the field can accept `null` values. *Requires ArcGIS Server version 10.1 or greater.*
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#nullable)
     *
     * @default true
     */
    nullable?: boolean;
    /**
     * The data type of the field.**Possible Values:** small-integer | integer | single | double |long | string | date | oid | geometry | blob | raster |guid | global-id | xml
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#type)
     *
     * @default null
     */
    type?:
      | "small-integer"
      | "integer"
      | "single"
      | "double"
      | "long"
      | "string"
      | "date"
      | "oid"
      | "geometry"
      | "blob"
      | "raster"
      | "guid"
      | "global-id"
      | "xml";
    /**
     * The types of values that can be assigned to a field. See the table below for a list of possible values.| Mode | Description || ------|------------ || name-or-title | Text that represents a name, title, label, or keyword for each feature. || description | Text that provides a longer description of the feature, more than just a name or title. || type-or-category | Types or categories that group features based on common characteristics. || count-or-amount | Integers (no decimal) that represent how many or how much there is of a specific attribute. || percentage-or-ratio | Number values in this field reflect the relationship between different quantities. || measurement | A number that reflects a characteristic that you can precisely measure. || unique-identifier | The values in this field are used to positively distinguish one feature or entity from another. || ordered-or-ranked | The values in this field represent a feature's status in an ordered or ranked list. For example, a feature could be one of the following: `Small, medium, large`, `First, second, third, fourth`, or `Informational, warning, error, failure`.|| binary | Only one of two values are possible for each feature. Some examples include the following: `On or off`, `Yes or no`, `True or false`, or `Inhabited or vacant`. || location-or-place-name | Values in this field represent a geographic location. Examples of values in such a field include a street address, city name, region, building name (such as A.K. Smiley Public Library), attraction name (such as Alameda County Fairgrounds or Cairngorms National Park), postal code, or country. || coordinate | These fields store a geographic coordinate value such as x, y, z, latitude, or longitude. || date-and-time | Values in this field store explicit dates and times or date references such as days of the week, months, or years. || none | No specified type. |
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Field.html#valueType)
     */
    valueType?:
      | "binary"
      | "coordinate"
      | "count-or-amount"
      | "date-and-time"
      | "description"
      | "location-or-place-name"
      | "measurement"
      | "name-or-title"
      | "none"
      | "ordered-or-ranked"
      | "percentage-or-ratio"
      | "type-or-category"
      | "unique-identifier";
  }

  interface FieldsIndex {
    /**
     * An array of date fields or field json objects.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FieldsIndex.html#dateFields)
     *
     * @default []
     */
    dateFields: Field[] | any[];

    /**
     * Returns a field with the specified field name.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FieldsIndex.html#get)
     *
     * @param fieldName The name of the field. The name is case-insensitive.
     *
     */
    get(fieldName: string): Field;
    /**
     * Checks if a field with the specified field name exists in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FieldsIndex.html#has)
     *
     * @param fieldName The name of the field. The name is case-insensitive.
     *
     */
    has(fieldName: string): boolean;
    /**
     * Checks if a field with the specified field name is a date field.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-FieldsIndex.html#isDateField)
     *
     * @param fieldName The name of the field.
     *
     */
    isDateField(fieldName: string): boolean;
  }

  interface FieldsIndexConstructor {
    new (properties?: any): FieldsIndex;
  }

  export const FieldsIndex: FieldsIndexConstructor;

  interface fieldUtils {
    /**
     * Returns an array of field names used in the Arcade expression for calculating the Z values of featuresin the given feature layer's [FeatureLayer.elevationInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#elevationInfo).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-fieldUtils.html#getElevationFields)
     *
     * @param layer The featureLayer to extract fields required for calculating feature Z values.
     *
     */
    getElevationFields(layer: FeatureLayer): IPromise<string[]>;
    /**
     * Returns an array of editor tracking field names for a given feature layer.It includes the fields from the [FeatureLayer.editFieldsInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#editFieldsInfo).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-fieldUtils.html#getFeatureEditFields)
     *
     * @param layer The Feature Layer from which to extract editor tracking fields.
     *
     */
    getFeatureEditFields(layer: FeatureLayer): string[];
    /**
     * Returns an array of field names used in the Arcade expression for labeling featuresin the given feature layer's [FeatureLayer.labelingInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#labelingInfo).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-fieldUtils.html#getLabelingFields)
     *
     * @param layer The Feature Layer from which to extract label fields.
     *
     */
    getLabelingFields(layer: FeatureLayer): IPromise<string[]>;
    /**
     * Returns an array of field names related to time.It includes the fields from the [FeatureLayer.timeInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html#timeInfo),and the `trackIdField`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-fieldUtils.html#getTimeFields)
     *
     * @param layer The Feature Layer from which to extract time fields.
     *
     */
    getTimeFields(layer: FeatureLayer): IPromise<string[]>;
  }

  export const fieldUtils: fieldUtils;

  interface ImageParameters extends Accessor {
    /**
     * Dots per inch setting for an module:esri/layersMapImageLayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#dpi)
     *
     * @default 96
     */
    dpi: number;
    /**
     * Extent of map to be exported.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#extent)
     */
    extent: Extent;
    /**
     * Map image format.**Possible Values:** png | png8 | png24 | png32 | jpg | pdf | bmp | gif | svg
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#format)
     *
     * @default png8
     */
    format: string;
    /**
     * Requested image height in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#height)
     */
    height: number;
    /**
     * Spatial reference of exported map.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#imageSpatialReference)
     */
    imageSpatialReference: SpatialReference;
    /**
     * Array of layer definition expressions that allows you to filter the features of individuallayers in the exported map image. Layer definitions with semicolons or colons are supported ifusing a map service published using ArcGIS Server 10 or later.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#layerDefinitions)
     */
    layerDefinitions: string[];
    /**
     * A list of layer IDs, that represent which layers to include in the exported map. Usein combination with [layerOption](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#layerOption) to specify how layer visibility is handled.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#layerIds)
     */
    layerIds: number[];
    /**
     * The option for displaying or hiding the layer.**Possible Values:** show | hide | include | exclude
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#layerOption)
     */
    layerOption: string;
    /**
     * Indicates whether or not the background of the dynamic image is transparent.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#transparent)
     *
     * @default true
     */
    transparent: boolean;
    /**
     * Requested image width in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#width)
     */
    width: number;

    /**
     * Converts an instance of  [this class]() to its ArcGIS portal JSON representation.See the [Using fromJSON()](https://developers.arcgis.com/javascript/latest/guide/using-fromjson/index.html) topic in the Guide for more information.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#toJSON)
     *
     *
     */
    toJSON(): any;
  }

  interface ImageParametersConstructor {
    new (properties?: ImageParametersProperties): ImageParameters;
  }

  export const ImageParameters: ImageParametersConstructor;

  interface ImageParametersProperties {
    /**
     * Dots per inch setting for an module:esri/layersMapImageLayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#dpi)
     *
     * @default 96
     */
    dpi?: number;
    /**
     * Extent of map to be exported.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#extent)
     */
    extent?: ExtentProperties;
    /**
     * Map image format.**Possible Values:** png | png8 | png24 | png32 | jpg | pdf | bmp | gif | svg
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#format)
     *
     * @default png8
     */
    format?: string;
    /**
     * Requested image height in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#height)
     */
    height?: number;
    /**
     * Spatial reference of exported map.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#imageSpatialReference)
     */
    imageSpatialReference?: SpatialReferenceProperties;
    /**
     * Array of layer definition expressions that allows you to filter the features of individuallayers in the exported map image. Layer definitions with semicolons or colons are supported ifusing a map service published using ArcGIS Server 10 or later.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#layerDefinitions)
     */
    layerDefinitions?: string[];
    /**
     * A list of layer IDs, that represent which layers to include in the exported map. Usein combination with [layerOption](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#layerOption) to specify how layer visibility is handled.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#layerIds)
     */
    layerIds?: number[];
    /**
     * The option for displaying or hiding the layer.**Possible Values:** show | hide | include | exclude
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#layerOption)
     */
    layerOption?: string;
    /**
     * Indicates whether or not the background of the dynamic image is transparent.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#transparent)
     *
     * @default true
     */
    transparent?: boolean;
    /**
     * Requested image width in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-ImageParameters.html#width)
     */
    width?: number;
  }

  interface InheritedDomain extends Domain {
    /**
     * The domain type. This value is always `inherited`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-InheritedDomain.html#type)
     */
    readonly type: "inherited";
  }

  interface InheritedDomainConstructor {
    new (properties?: InheritedDomainProperties): InheritedDomain;

    fromJSON(json: any): InheritedDomain;
  }

  export const InheritedDomain: InheritedDomainConstructor;

  interface InheritedDomainProperties extends DomainProperties {}

  interface KMLSublayer extends Accessor, JSONSupport {
    /**
     * Description for the KML sublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#description)
     */
    description: string;
    /**
     * The id for the KML sublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#id)
     */
    id: number;
    /**
     * The [KMLLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-KMLLayer.html) to which the sublayer belongs.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#layer)
     */
    layer: KMLLayer;
    /**
     * Network link info for the current layer. A link info object with properties that describe the network link.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#networkLink)
     */
    networkLink: any;
    /**
     * A collection of [KMLSublayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#sublayers)
     */
    sublayers: Collection<KMLSublayer>;
    /**
     * The title of the KML sublayer used to identify it in places such as the[LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) and [Legend](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Legend.html) widgets.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#title)
     */
    title: string;
    /**
     * Indicates if the sublayer is visible in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#visible)
     */
    visible: boolean;
  }

  interface KMLSublayerConstructor {
    new (properties?: KMLSublayerProperties): KMLSublayer;

    fromJSON(json: any): KMLSublayer;
  }

  export const KMLSublayer: KMLSublayerConstructor;

  interface KMLSublayerProperties {
    /**
     * Description for the KML sublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#description)
     */
    description?: string;
    /**
     * The id for the KML sublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#id)
     */
    id?: number;
    /**
     * The [KMLLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-KMLLayer.html) to which the sublayer belongs.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#layer)
     */
    layer?: KMLLayerProperties;
    /**
     * Network link info for the current layer. A link info object with properties that describe the network link.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#networkLink)
     */
    networkLink?: any;
    /**
     * A collection of [KMLSublayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#sublayers)
     */
    sublayers?: CollectionProperties<KMLSublayerProperties>;
    /**
     * The title of the KML sublayer used to identify it in places such as the[LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) and [Legend](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Legend.html) widgets.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#title)
     */
    title?: string;
    /**
     * Indicates if the sublayer is visible in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-KMLSublayer.html#visible)
     */
    visible?: boolean;
  }

  interface LabelClass extends Accessor, JSONSupport {
    /**
     * Defines the content of label text for [MapImageLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html).If working with [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html), use[labelExpressionInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpressionInfo) instead.Attribute values may be included in labels using SQL syntax. To include anattribute value in a label, wrap the name of the field in square brackets `[]`.See the example snippet below.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpression)
     *
     * @default null
     */
    labelExpression: string;
    /**
     * Defines the content of label text for [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).If working with [MapImageLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html), use[labelExpression](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpression) instead.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpressionInfo)
     *
     * @default null
     */
    labelExpressionInfo: LabelClassLabelExpressionInfo;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelPlacement)
     *
     * @default null
     */
    labelPlacement: string;
    /**
     * The maximum scale (most zoomed in) at which labels are visible in the view.A value of `0` means the label's visibility does not have a maximum scale.The maxScale value should always be smaller than the [minScale](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#minScale) value,and greater than or equal to the service specification.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#maxScale)
     *
     * @default 0
     */
    maxScale: number;
    /**
     * The minimum scale (most zoomed out) at which labels are visible in the view.A value of `0` means the label's visibility does not have a minimum scale.The minScale value should always be larger than the [maxScale](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#maxScale) value,and lesser than or equal to the service specification.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#minScale)
     *
     * @default 0
     */
    minScale: number;
    /**
     * Defines the symbol used for rendering the label. If not set, the default symbol will be used. See the examplebelow.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#symbol)
     */
    symbol: TextSymbol | LabelSymbol3D;
    /**
     * Indicates whether to use domain names if the fields in the [labelExpression](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpression)or [labelExpressionInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpressionInfo) have domains.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#useCodedValues)
     */
    useCodedValues: boolean;
    /**
     * A SQL where clause used to determine the features to which the label class should be applied.When specified, only features evaluating to `true` based on this expression will be labeled.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#where)
     *
     * @default null
     */
    where: string;

    /**
     * Creates a deep clone of the LabelClass.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#clone)
     *
     *
     */
    clone(): LabelClass;
  }

  interface LabelClassConstructor {
    new (properties?: LabelClassProperties): LabelClass;

    fromJSON(json: any): LabelClass;
  }

  export const LabelClass: LabelClassConstructor;

  interface LabelClassProperties {
    /**
     * Defines the content of label text for [MapImageLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html).If working with [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html), use[labelExpressionInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpressionInfo) instead.Attribute values may be included in labels using SQL syntax. To include anattribute value in a label, wrap the name of the field in square brackets `[]`.See the example snippet below.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpression)
     *
     * @default null
     */
    labelExpression?: string;
    /**
     * Defines the content of label text for [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).If working with [MapImageLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html), use[labelExpression](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpression) instead.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpressionInfo)
     *
     * @default null
     */
    labelExpressionInfo?: LabelClassLabelExpressionInfo;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelPlacement)
     *
     * @default null
     */
    labelPlacement?: string;
    /**
     * The maximum scale (most zoomed in) at which labels are visible in the view.A value of `0` means the label's visibility does not have a maximum scale.The maxScale value should always be smaller than the [minScale](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#minScale) value,and greater than or equal to the service specification.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#maxScale)
     *
     * @default 0
     */
    maxScale?: number;
    /**
     * The minimum scale (most zoomed out) at which labels are visible in the view.A value of `0` means the label's visibility does not have a minimum scale.The minScale value should always be larger than the [maxScale](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#maxScale) value,and lesser than or equal to the service specification.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#minScale)
     *
     * @default 0
     */
    minScale?: number;
    /**
     * Defines the symbol used for rendering the label. If not set, the default symbol will be used. See the examplebelow.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#symbol)
     */
    symbol?: TextSymbolProperties | LabelSymbol3DProperties;
    /**
     * Indicates whether to use domain names if the fields in the [labelExpression](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpression)or [labelExpressionInfo](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpressionInfo) have domains.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#useCodedValues)
     */
    useCodedValues?: boolean;
    /**
     * A SQL where clause used to determine the features to which the label class should be applied.When specified, only features evaluating to `true` based on this expression will be labeled.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#where)
     *
     * @default null
     */
    where?: string;
  }

  export interface LabelClassLabelExpressionInfo extends Object {
    /**
     * The SQL expression defining the content of the label text.**Deprecated as of v4.5. Use `expression` instead.**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpressionInfo)
     */
    value?: string;
    /**
     * An [Arcade](https://developers.arcgis.com/javascript/latest/guide/arcade/index.html)expression that evaluates to a string used to label features in the layer.The most simple expressions return field values. For example, to label a layerof cities with their names, simply reference the field value with the globalvariable: `$feature.CITY_NAME`. Expressions can be more sophisticated and uselogical functions. This may be useful if you want to use classed labels.For example, the following expression appends `city` to the end of the labelif the feature's population field contains a number greater than 10,000. Otherwise,`town` is appended to the end of the label. Additionally, you can use `TextFormatting.NewLine`to add a new line to the label.`IIF($feature.POPULATION > 10000, $feature.NAME + ' city', $feature.NAME + ' town')`
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html#labelExpressionInfo)
     */
    expression: string;
  }

  interface LOD extends Accessor, JSONSupport {
    /**
     * ID for each level. The top most level is `0`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LOD.html#level)
     */
    level: number;
    /**
     * String to be used when constructing a URL to access a tile from this LOD. If `levelValue` is not defined,level will be used for the tile access URL. This property is useful when an LOD object represents aWMTS TileMatrix with non-numeric matrix identifiers.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LOD.html#levelValue)
     */
    levelValue: string;
    /**
     * Resolution in map units of each pixel in a tile for each level.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LOD.html#resolution)
     */
    resolution: number;
    /**
     * Scale for each level.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LOD.html#scale)
     */
    scale: number;
  }

  interface LODConstructor {
    new (properties?: LODProperties): LOD;

    fromJSON(json: any): LOD;
  }

  export const LOD: LODConstructor;

  interface LODProperties {
    /**
     * ID for each level. The top most level is `0`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LOD.html#level)
     */
    level?: number;
    /**
     * String to be used when constructing a URL to access a tile from this LOD. If `levelValue` is not defined,level will be used for the tile access URL. This property is useful when an LOD object represents aWMTS TileMatrix with non-numeric matrix identifiers.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LOD.html#levelValue)
     */
    levelValue?: string;
    /**
     * Resolution in map units of each pixel in a tile for each level.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LOD.html#resolution)
     */
    resolution?: number;
    /**
     * Scale for each level.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LOD.html#scale)
     */
    scale?: number;
  }

  interface MapImage extends Accessor, JSONSupport {
    /**
     * The extent of the exported map.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#extent)
     */
    extent: Extent;
    /**
     * The requested image height in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#height)
     */
    height: number;
    /**
     * URL to the returned image. The image format must be of a type supported by the HTML `<img>` tag.**Possible Values:** gif | jpg | png | bmp
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#href)
     */
    href: string;
    /**
     * The opacity of the image. Value can be any number between `0` and `1` where `0`is 100% transparent, `0.5` is 50% transparent and `1` is fully opaque.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#opacity)
     *
     * @default 1
     */
    opacity: number;
    /**
     * Scale of the requested dynamic map.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#scale)
     */
    scale: number;
    /**
     * Indicates if the requested image is visible in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#visible)
     *
     * @default true
     */
    visible: boolean;
    /**
     * The requested image width in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#width)
     */
    width: number;
  }

  interface MapImageConstructor {
    new (properties?: MapImageProperties): MapImage;

    fromJSON(json: any): MapImage;
  }

  export const MapImage: MapImageConstructor;

  interface MapImageProperties {
    /**
     * The extent of the exported map.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#extent)
     */
    extent?: ExtentProperties;
    /**
     * The requested image height in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#height)
     */
    height?: number;
    /**
     * URL to the returned image. The image format must be of a type supported by the HTML `<img>` tag.**Possible Values:** gif | jpg | png | bmp
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#href)
     */
    href?: string;
    /**
     * The opacity of the image. Value can be any number between `0` and `1` where `0`is 100% transparent, `0.5` is 50% transparent and `1` is fully opaque.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#opacity)
     *
     * @default 1
     */
    opacity?: number;
    /**
     * Scale of the requested dynamic map.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#scale)
     */
    scale?: number;
    /**
     * Indicates if the requested image is visible in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#visible)
     *
     * @default true
     */
    visible?: boolean;
    /**
     * The requested image width in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MapImage.html#width)
     */
    width?: number;
  }

  interface MosaicRule extends Accessor, JSONSupport {
    /**
     * Indicates whether the sort should be ascending. This property applies to all mosaic[methods](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#method) where an ordering is defined except `seamline`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#ascending)
     *
     * @default true
     */
    ascending: boolean;
    /**
     * The rendering rule applied on items before mosaicking.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#itemRenderingRule)
     */
    itemRenderingRule: RasterFunction;
    /**
     * An array of raster Ids. All the rasters with the given list of raster Ids areselected to participate in the mosaic. The rasters will be visible at all pixelsizes regardless of the minimum and maximum pixel size range of the locked rasters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#lockRasterIds)
     */
    lockRasterIds: number[];
    /**
     * The mosaic method determines how the selected rasters are ordered.The mosaic method defines how the mosaicked image is created from these input rasters.**Possible Values:**Value | Description |----- | ----------- |none | Orders rasters based on the order of [objectIds](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#objectIds) in the mosaic dataset attribute table.center | Enables rasters to be sorted based their ZOrder, then PixelSize, and then by a default order where rasters that have their centers closest to the view center are placed on top.nadir | Enables rasters to be sorted by the ZOrder, then PixelSize, and then by the distance between the nadir position and view center. This is similar to the Closest to Center method but uses the nadir point to a raster, which may be different than the center, especially for oblique imagery.viewpoint | Orders rasters based on the ZOrder, then PixelSize, and then by a user-defined location and nadir location for the rasters using the [viewpoint](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#viewpoint).attribute | Enables raster ordering based on ZOrder, then PixelSize, and then by a defined metadata attribute and its difference from a base value.lock-raster | Enables a user to lock the display of single or multiple rasters based on the [lockRasterIds](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#lockRasterIds).northwest | Enables raster ordering by ZOrder, then PixelSize, and then by the shortest distance between the center of a raster to the northwest position.seamline| Cuts the raster using the predefined seamline shape for each raster, using optional feathering along the seams, and orders images based on the ZOrder and then the SOrder fields in the attribute table.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#method)
     */
    method: string;
    /**
     * A multiple dimensional service can have multiple dimensions for one or more variables.Use multiDimensionalDefinitions to filter data based on a slice or rangeof data. For example, a single ImageryLayer may have a `depth` dimension storingsea temperatures for the same pixel location at various depths. Another dimensioncould be `time`, where the same pixel stores multiple values based on a windowof time.This property can be used to filter and display ImageryLayer pixels for specific"slices" in those dimensions (e.g. display sea temperature at 1000m below sea levelfor a specific week in the year).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#multidimensionalDefinition)
     */
    multidimensionalDefinition: DimensionalDefinition[];
    /**
     * Defines a selection using a set of ObjectIDs. This property applies to all mosaic methods.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#objectIds)
     */
    objectIds: number[];
    /**
     * Defines the mosaic operation used to resolve overlapping pixels.**Possible Values:**Value | Description |----- | ----------- |first | The overlapping areas will contain the cells from the first raster dataset listed in the source.last | The overlapping areas will contain the cells from the last raster dataset listed in the source.min | The overlapping areas will contain the minimum cell values from all the overlapping cells.max | The overlapping areas will contain the maximum cell values from all the overlapping cells.mean | The overlapping areas will contain the mean cell values from all the overlapping cells.blend | The overlapping areas will be a blend of the cell values that overlap. This blend value relies on an algorithm that is weight based and dependent on the distance from the cells to the edge within the overlapping area.sum | The overlapping areas will contain the total sum of the cell values from all the overlapping cells.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#operation)
     */
    operation: string;
    /**
     * The name of the attribute field that is used with a constant sortValue to define the mosaickingorder when the mosaic [method](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#method) is set to `attribute`. The ordering is definedby the absolute value of the difference between the specified sort field value and the sort basevalue. For example, if the sort field is `Month` and the sort value is `7 (July)`, then the orderingis defined by `ABS(Month -7)`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#sortField)
     */
    sortField: string;
    /**
     * A constant value defining a reference or base value for the sort field when the mosaic [method](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#method)is set to `attribute`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#sortValue)
     */
    sortValue: string;
    /**
     * Defines the viewpoint location on which the ordering is defined based on thedistance from the viewpoint and the nadir of rasters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#viewpoint)
     */
    viewpoint: Point;
    /**
     * The where clause determines which rasters will participate in the mosaic.This property applies to all mosaic methods.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#where)
     */
    where: string;

    /**
     * Creates a clone of the MosaicRule object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#clone)
     *
     *
     */
    clone(): MosaicRule;
  }

  interface MosaicRuleConstructor {
    new (properties?: MosaicRuleProperties): MosaicRule;

    fromJSON(json: any): MosaicRule;
  }

  export const MosaicRule: MosaicRuleConstructor;

  interface MosaicRuleProperties {
    /**
     * Indicates whether the sort should be ascending. This property applies to all mosaic[methods](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#method) where an ordering is defined except `seamline`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#ascending)
     *
     * @default true
     */
    ascending?: boolean;
    /**
     * The rendering rule applied on items before mosaicking.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#itemRenderingRule)
     */
    itemRenderingRule?: RasterFunctionProperties;
    /**
     * An array of raster Ids. All the rasters with the given list of raster Ids areselected to participate in the mosaic. The rasters will be visible at all pixelsizes regardless of the minimum and maximum pixel size range of the locked rasters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#lockRasterIds)
     */
    lockRasterIds?: number[];
    /**
     * The mosaic method determines how the selected rasters are ordered.The mosaic method defines how the mosaicked image is created from these input rasters.**Possible Values:**Value | Description |----- | ----------- |none | Orders rasters based on the order of [objectIds](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#objectIds) in the mosaic dataset attribute table.center | Enables rasters to be sorted based their ZOrder, then PixelSize, and then by a default order where rasters that have their centers closest to the view center are placed on top.nadir | Enables rasters to be sorted by the ZOrder, then PixelSize, and then by the distance between the nadir position and view center. This is similar to the Closest to Center method but uses the nadir point to a raster, which may be different than the center, especially for oblique imagery.viewpoint | Orders rasters based on the ZOrder, then PixelSize, and then by a user-defined location and nadir location for the rasters using the [viewpoint](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#viewpoint).attribute | Enables raster ordering based on ZOrder, then PixelSize, and then by a defined metadata attribute and its difference from a base value.lock-raster | Enables a user to lock the display of single or multiple rasters based on the [lockRasterIds](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#lockRasterIds).northwest | Enables raster ordering by ZOrder, then PixelSize, and then by the shortest distance between the center of a raster to the northwest position.seamline| Cuts the raster using the predefined seamline shape for each raster, using optional feathering along the seams, and orders images based on the ZOrder and then the SOrder fields in the attribute table.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#method)
     */
    method?: string;
    /**
     * A multiple dimensional service can have multiple dimensions for one or more variables.Use multiDimensionalDefinitions to filter data based on a slice or rangeof data. For example, a single ImageryLayer may have a `depth` dimension storingsea temperatures for the same pixel location at various depths. Another dimensioncould be `time`, where the same pixel stores multiple values based on a windowof time.This property can be used to filter and display ImageryLayer pixels for specific"slices" in those dimensions (e.g. display sea temperature at 1000m below sea levelfor a specific week in the year).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#multidimensionalDefinition)
     */
    multidimensionalDefinition?: DimensionalDefinitionProperties[];
    /**
     * Defines a selection using a set of ObjectIDs. This property applies to all mosaic methods.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#objectIds)
     */
    objectIds?: number[];
    /**
     * Defines the mosaic operation used to resolve overlapping pixels.**Possible Values:**Value | Description |----- | ----------- |first | The overlapping areas will contain the cells from the first raster dataset listed in the source.last | The overlapping areas will contain the cells from the last raster dataset listed in the source.min | The overlapping areas will contain the minimum cell values from all the overlapping cells.max | The overlapping areas will contain the maximum cell values from all the overlapping cells.mean | The overlapping areas will contain the mean cell values from all the overlapping cells.blend | The overlapping areas will be a blend of the cell values that overlap. This blend value relies on an algorithm that is weight based and dependent on the distance from the cells to the edge within the overlapping area.sum | The overlapping areas will contain the total sum of the cell values from all the overlapping cells.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#operation)
     */
    operation?: string;
    /**
     * The name of the attribute field that is used with a constant sortValue to define the mosaickingorder when the mosaic [method](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#method) is set to `attribute`. The ordering is definedby the absolute value of the difference between the specified sort field value and the sort basevalue. For example, if the sort field is `Month` and the sort value is `7 (July)`, then the orderingis defined by `ABS(Month -7)`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#sortField)
     */
    sortField?: string;
    /**
     * A constant value defining a reference or base value for the sort field when the mosaic [method](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#method)is set to `attribute`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#sortValue)
     */
    sortValue?: string;
    /**
     * Defines the viewpoint location on which the ordering is defined based on thedistance from the viewpoint and the nadir of rasters.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#viewpoint)
     */
    viewpoint?: PointProperties;
    /**
     * The where clause determines which rasters will participate in the mosaic.This property applies to all mosaic methods.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#where)
     */
    where?: string;
  }

  interface PixelBlock extends Accessor {
    /**
     * The height (or number of rows) of the PixelBlock in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#height)
     */
    height: number;
    /**
     * Bit Mask. All pixels are valid when mask is null.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#mask)
     */
    mask: number[] | Uint8Array;
    /**
     * Indicates whether mask should be used as alpha values. If no (default), a pixel is valid when corresponding mask value is truthy
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#maskIsAlpha)
     */
    maskIsAlpha: boolean;
    /**
     * A two dimensional array representing the pixels from the Image Servicedisplayed on the client. The length of the first dimension is the same asthe number of bands in the layer. The length of the second dimension is[height](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#height) * [width](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#width). The length of each band is the same. Thepixels in each band are arranged row by row in this format:`[p_00, p_10, p_20, ... p_10, p_11, ...]` where `p_xy` is the pixel valueat the column `x` and row `y`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#pixels)
     */
    pixels:
      | number[]
      | Int8Array
      | Uint8Array
      | Uint8ClampedArray
      | Int16Array
      | Uint16Array
      | Int32Array
      | Uint32Array
      | Float32Array
      | Float64Array;
    /**
     * The pixel type.**Possible Values:** s8 | s16 | s32 | u8 | u16 | u32 | f32 | f64
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#pixelType)
     */
    pixelType: string;
    /**
     * An array of objects containing numeric statistical properties. Each objecthas the following specification if defined.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#statistics)
     */
    statistics: PixelBlockStatistics[];
    /**
     * Number of valid pixels
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#validPixelCount)
     */
    validPixelCount: number;
    /**
     * The width (or number of columns) of the PixelBlock in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#width)
     */
    width: number;

    /**
     * Adds another plane to the PixelBlock.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#addData)
     *
     * @param planeData The data to add to the PixelBlock.
     * @param planeData.pixels A two dimensional array representing the                                     pixels to add.
     * @param planeData.statistics An array of objects containing                                       numeric statistical properties.                             See [statistics](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#statistics) for details on the specifications                             of each object.
     *
     */
    addData(planeData: PixelBlockAddDataPlaneData): void;
    /**
     * Returns pixels and masks using a single array in bip format(e.g. [p_00_r, p_00_g, p_00_b, p_00_a, p_10_r, p_10_g, p_10_b, p_10_a, .....]).Use this method to get an unsigned 8 bit pixel array.The result can be used to create a webgl texture.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#getAsRGBA)
     *
     *
     */
    getAsRGBA(): Uint8ClampedArray;
    /**
     * Similar to [getAsRGBA](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#getAsRGBA), but returns floating point data.The result can be used to create a webgl texture (OES_texture_float).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#getAsRGBAFloat)
     *
     *
     */
    getAsRGBAFloat(): Float32Array;
    /**
     * Returns the plane band count of the PixelBlock.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#getPlaneCount)
     *
     *
     */
    getPlaneCount(): number;
  }

  interface PixelBlockConstructor {
    new (properties?: PixelBlockProperties): PixelBlock;
  }

  export const PixelBlock: PixelBlockConstructor;

  interface PixelBlockProperties {
    /**
     * The height (or number of rows) of the PixelBlock in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#height)
     */
    height?: number;
    /**
     * Bit Mask. All pixels are valid when mask is null.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#mask)
     */
    mask?: number[] | Uint8Array;
    /**
     * Indicates whether mask should be used as alpha values. If no (default), a pixel is valid when corresponding mask value is truthy
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#maskIsAlpha)
     */
    maskIsAlpha?: boolean;
    /**
     * A two dimensional array representing the pixels from the Image Servicedisplayed on the client. The length of the first dimension is the same asthe number of bands in the layer. The length of the second dimension is[height](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#height) * [width](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#width). The length of each band is the same. Thepixels in each band are arranged row by row in this format:`[p_00, p_10, p_20, ... p_10, p_11, ...]` where `p_xy` is the pixel valueat the column `x` and row `y`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#pixels)
     */
    pixels?:
      | number[]
      | Int8Array
      | Uint8Array
      | Uint8ClampedArray
      | Int16Array
      | Uint16Array
      | Int32Array
      | Uint32Array
      | Float32Array
      | Float64Array;
    /**
     * The pixel type.**Possible Values:** s8 | s16 | s32 | u8 | u16 | u32 | f32 | f64
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#pixelType)
     */
    pixelType?: string;
    /**
     * An array of objects containing numeric statistical properties. Each objecthas the following specification if defined.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#statistics)
     */
    statistics?: PixelBlockStatistics[];
    /**
     * Number of valid pixels
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#validPixelCount)
     */
    validPixelCount?: number;
    /**
     * The width (or number of columns) of the PixelBlock in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#width)
     */
    width?: number;
  }

  export interface PixelBlockAddDataPlaneData extends Object {
    /**
     * A two dimensional array representing the                                     pixels to add.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#addData)
     */
    pixels: number[][];
    /**
     * An array of objects containing                                       numeric statistical properties.                             See [statistics](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#statistics) for details on the specifications                             of each object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#addData)
     */
    statistics: any[];
  }

  export interface PixelBlockStatistics extends Object {
    /**
     * The maximum pixel value in the [pixels](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#pixels) array.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#statistics)
     */
    maxValue?: number;
    /**
     * The minimum pixel value in the [pixels](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#pixels) array.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#statistics)
     */
    minValue?: number;
    /**
     * Value representing areas of no data.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-PixelBlock.html#statistics)
     */
    noDataValue?: number;
  }

  interface RangeDomain extends Domain {
    /**
     * The maximum valid value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RangeDomain.html#maxValue)
     */
    maxValue: number;
    /**
     * The minimum valid value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RangeDomain.html#minValue)
     */
    minValue: number;
    /**
     * The domain type. This value is always `range`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RangeDomain.html#type)
     */
    readonly type: "range";
  }

  interface RangeDomainConstructor {
    new (properties?: RangeDomainProperties): RangeDomain;

    fromJSON(json: any): RangeDomain;
  }

  export const RangeDomain: RangeDomainConstructor;

  interface RangeDomainProperties extends DomainProperties {
    /**
     * The maximum valid value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RangeDomain.html#maxValue)
     */
    maxValue?: number;
    /**
     * The minimum valid value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RangeDomain.html#minValue)
     */
    minValue?: number;
  }

  interface RasterFunction extends Accessor, JSONSupport {
    /**
     * The arguments for the raster function. The structure depends on the function specified.See [raster functions](https://developers.arcgis.com/documentation/common-data-types/raster-function-objects.htm)for a list of functions and their arguments.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterFunction.html#functionArguments)
     */
    functionArguments: any;
    /**
     * The raster function name.See [raster functions](https://developers.arcgis.com/documentation/common-data-types/raster-function-objects.htm)for a list of functions and their arguments.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterFunction.html#functionName)
     */
    functionName: string;
    /**
     * Defines the pixel type of the output image.**Possible Values:** c128 | c64 | f32 | f64 | s16 | s32 | s8 | u1 | u16| u2 | u32 | u4 | u8 | unknown
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterFunction.html#outputPixelType)
     *
     * @default unknown
     */
    outputPixelType: string;
    /**
     * The variable name for the raster function.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterFunction.html#variableName)
     */
    variableName: string;
  }

  interface RasterFunctionConstructor {
    new (properties?: RasterFunctionProperties): RasterFunction;

    fromJSON(json: any): RasterFunction;
  }

  export const RasterFunction: RasterFunctionConstructor;

  interface RasterFunctionProperties {
    /**
     * The arguments for the raster function. The structure depends on the function specified.See [raster functions](https://developers.arcgis.com/documentation/common-data-types/raster-function-objects.htm)for a list of functions and their arguments.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterFunction.html#functionArguments)
     */
    functionArguments?: any;
    /**
     * The raster function name.See [raster functions](https://developers.arcgis.com/documentation/common-data-types/raster-function-objects.htm)for a list of functions and their arguments.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterFunction.html#functionName)
     */
    functionName?: string;
    /**
     * Defines the pixel type of the output image.**Possible Values:** c128 | c64 | f32 | f64 | s16 | s32 | s8 | u1 | u16| u2 | u32 | u4 | u8 | unknown
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterFunction.html#outputPixelType)
     *
     * @default unknown
     */
    outputPixelType?: string;
    /**
     * The variable name for the raster function.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterFunction.html#variableName)
     */
    variableName?: string;
  }

  interface RasterInfo extends JSONSupport {
    /**
     * The raster attribute table associated with an imagery layer.It returns categorical mapping of pixel values such asclass, group, or category. or membership.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#attributeTable)
     */
    attributeTable: FeatureSet;
    /**
     * Raster band count.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#bandCount)
     */
    bandCount: number;
    /**
     * Raster colormap that can be used to display the imagery layer.Each element in the array defines the pixel value and the red, green, and blue color values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#colormap)
     */
    colormap: number[][];
    /**
     * Raster data type controls how the data is rendered by default.**Possible Values:**Value | Description |----- | ----------- |generic | Uses the application defaults for resampling and stretching.elevation | Applies bilinear resampling and a Min-Max stretch.thematic | Applies nearest neighbor resampling and a Deviation stretch.processed | No stretch is applied.scientific | Uses the blue to red color ramp to display the data.vector-uv | Uses the U (magnitude component) and V(direction component) components in the vector field renderer.vector-magdir | Uses the magnitude and direction in the vector field renderer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#dataType)
     */
    dataType: string;
    /**
     * The minimum and maximum X and Y coordinates of a bounding box containing all the raster data.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#extent)
     */
    extent: Extent;
    /**
     * Raster histograms return basic name-value pairs for number of bins, min andmax bounding values, counts of pixels in each bin.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#histograms)
     */
    histograms: any[];
    /**
     * Raster key properties.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#keyProperties)
     */
    keyProperties: any;
    /**
     * The multidimensional information associated with the raster.If defined, multidimensional information contains various "dimensions" ofdata for a particular value, such as time, depth, altitude, etc. Definingslices of particular dimensions in the layer is handled with the[multidimensionalDefinition](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#multidimensionalDefinition)property of the [mosaicRule](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#mosaicRule).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#multidimensionalInfo)
     */
    multidimensionalInfo: any;
    /**
     * Raster pixel size.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#pixelSize)
     */
    pixelSize: Point;
    /**
     * Pixel type for the raster data source.**Possible Values:**Value | Range of values that each cell can contain |----- | ------------------------------------------- |unknown | Pixel type is unknown |s8 | -128 to 127 |s16 | -32768 to 32767 |s32 | -2147483648 to 2147483647 |u8 | 0 to 255 |u16 | 0 to 65535u32 | 0 to 4294967295f32 | -3.402823466e+38 to 3.402823466e+38f64 | 0 to 18446744073709551616
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#pixelType)
     */
    pixelType: string;
    /**
     * The spatial reference of the raster.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#spatialReference)
     */
    spatialReference: SpatialReference;
    /**
     * Raster band statistics. These include the minimum value in the raster, maximum value, mean of all values, and standard deviation.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#statistics)
     */
    statistics: RasterInfoStatistics[];
  }

  interface RasterInfoConstructor {
    new (properties?: RasterInfoProperties): RasterInfo;

    fromJSON(json: any): RasterInfo;
  }

  export const RasterInfo: RasterInfoConstructor;

  interface RasterInfoProperties {
    /**
     * The raster attribute table associated with an imagery layer.It returns categorical mapping of pixel values such asclass, group, or category. or membership.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#attributeTable)
     */
    attributeTable?: FeatureSetProperties;
    /**
     * Raster band count.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#bandCount)
     */
    bandCount?: number;
    /**
     * Raster colormap that can be used to display the imagery layer.Each element in the array defines the pixel value and the red, green, and blue color values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#colormap)
     */
    colormap?: number[][];
    /**
     * Raster data type controls how the data is rendered by default.**Possible Values:**Value | Description |----- | ----------- |generic | Uses the application defaults for resampling and stretching.elevation | Applies bilinear resampling and a Min-Max stretch.thematic | Applies nearest neighbor resampling and a Deviation stretch.processed | No stretch is applied.scientific | Uses the blue to red color ramp to display the data.vector-uv | Uses the U (magnitude component) and V(direction component) components in the vector field renderer.vector-magdir | Uses the magnitude and direction in the vector field renderer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#dataType)
     */
    dataType?: string;
    /**
     * The minimum and maximum X and Y coordinates of a bounding box containing all the raster data.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#extent)
     */
    extent?: ExtentProperties;
    /**
     * Raster histograms return basic name-value pairs for number of bins, min andmax bounding values, counts of pixels in each bin.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#histograms)
     */
    histograms?: any[];
    /**
     * Raster key properties.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#keyProperties)
     */
    keyProperties?: any;
    /**
     * The multidimensional information associated with the raster.If defined, multidimensional information contains various "dimensions" ofdata for a particular value, such as time, depth, altitude, etc. Definingslices of particular dimensions in the layer is handled with the[multidimensionalDefinition](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-MosaicRule.html#multidimensionalDefinition)property of the [mosaicRule](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#mosaicRule).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#multidimensionalInfo)
     */
    multidimensionalInfo?: any;
    /**
     * Raster pixel size.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#pixelSize)
     */
    pixelSize?: PointProperties;
    /**
     * Pixel type for the raster data source.**Possible Values:**Value | Range of values that each cell can contain |----- | ------------------------------------------- |unknown | Pixel type is unknown |s8 | -128 to 127 |s16 | -32768 to 32767 |s32 | -2147483648 to 2147483647 |u8 | 0 to 255 |u16 | 0 to 65535u32 | 0 to 4294967295f32 | -3.402823466e+38 to 3.402823466e+38f64 | 0 to 18446744073709551616
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#pixelType)
     */
    pixelType?: string;
    /**
     * The spatial reference of the raster.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#spatialReference)
     */
    spatialReference?: SpatialReferenceProperties;
    /**
     * Raster band statistics. These include the minimum value in the raster, maximum value, mean of all values, and standard deviation.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#statistics)
     */
    statistics?: RasterInfoStatistics[];
  }

  export interface RasterInfoStatistics extends Object {
    /**
     * The minimum pixel value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#statistics)
     */
    min: number;
    /**
     * The maximum pixel value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#statistics)
     */
    max: number;
    /**
     * The standard deviation of calculated pixel values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#statistics)
     */
    stddev: number;
    /**
     * The average of calculated pixel values.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-RasterInfo.html#statistics)
     */
    avg: number;
  }

  interface Relationship extends Accessor {
    /**
     * The cardinality which specifies the number of objects in the origin[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html) related to thenumber of objects in the destination [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).Please see the [Desktop help](http://desktop.arcgis.com/en/arcmap/10.3/manage-data/relationships/relationship-class-properties.htm#GUID-989CB1D1-AC51-4A4C-8D9D-0AB9E647FFFD)for additional information on cardinality.**Possible values:** one-to-one | one-to-many | many-to-many
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Relationship.html#cardinality)
     */
    cardinality: string;
    /**
     * The unique ID for the relationship. These ids for the relationshipsthe [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html) participatesin are listed in the ArcGIS Services directory.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Relationship.html#id)
     */
    id: number;
    /**
     * The field used to establish the relate within the [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Relationship.html#keyField)
     */
    keyField: string;
    /**
     * The name of the relationship.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Relationship.html#name)
     */
    name: string;
    /**
     * The unique ID of the related [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Relationship.html#relatedTableId)
     */
    relatedTableId: number;
  }

  interface RelationshipConstructor {
    new (properties?: RelationshipProperties): Relationship;
  }

  export const Relationship: RelationshipConstructor;

  interface RelationshipProperties {
    /**
     * The cardinality which specifies the number of objects in the origin[FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html) related to thenumber of objects in the destination [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).Please see the [Desktop help](http://desktop.arcgis.com/en/arcmap/10.3/manage-data/relationships/relationship-class-properties.htm#GUID-989CB1D1-AC51-4A4C-8D9D-0AB9E647FFFD)for additional information on cardinality.**Possible values:** one-to-one | one-to-many | many-to-many
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Relationship.html#cardinality)
     */
    cardinality?: string;
    /**
     * The unique ID for the relationship. These ids for the relationshipsthe [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html) participatesin are listed in the ArcGIS Services directory.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Relationship.html#id)
     */
    id?: number;
    /**
     * The field used to establish the relate within the [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Relationship.html#keyField)
     */
    keyField?: string;
    /**
     * The name of the relationship.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Relationship.html#name)
     */
    name?: string;
    /**
     * The unique ID of the related [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Relationship.html#relatedTableId)
     */
    relatedTableId?: number;
  }

  interface Sublayer extends Accessor {
    /**
     * A SQL where clause used to filter features in the image.Only the features that satisfy the definition expression are displayed in the[View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html). Definition expressionsmay be set when a sublayer is constructed prior to it loading in the view or after it hasbeen added to the MapImageLayer. To see if you can use this property, check the`supportsSublayerDefinitionExpression` property of[MapImageLayer.capabilities](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#capabilities).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#definitionExpression)
     */
    definitionExpression: string;
    /**
     * The sublayer's layer ID. When a [source](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#source) is not defined on thelayer, this value represents the id of the sublayer defined by the map service.If creating a [DynamicDataLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicDataLayer) or a [MapDataLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#MapDataLayer)and adding it to the [source](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#source) property of the sublayer, the value of thisproperty can be anything set by the developer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#id)
     */
    id: number;
    /**
     * The label definition for this layer,specified as an array of [LabelClass](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html) objects.Use this property to specify labeling properties for the layer such as label expression, placement, and size.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#labelingInfo)
     */
    labelingInfo: LabelClass[];
    /**
     * Indicates if labels for the sublayer will be visible in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#labelsVisible)
     *
     * @default true
     */
    labelsVisible: boolean;
    /**
     * The [MapImageLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html) or [TileLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-TileLayer.html) to which the sublayer belongs.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#layer)
     */
    layer: MapImageLayer | TileLayer;
    /**
     * Indicates whether the layer will be included in the legend. When `false`, the layer will be excluded from the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled: boolean;
    /**
     * Indicates how the layer should display in the [LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) widget.The possible values are listed below.Value | Description------|------------ show | The layer is visible in the table of contents. hide | The layer is hidden in the table of contents. hide-children | Hide the children layers from the table of contents.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#listMode)
     *
     * @default show
     */
    listMode: "show" | "hide" | "hide-children";
    /**
     * The maximum scale (most zoomed in) at which the layer is visible in the view.If the map is zoomed in beyond this scale, the layer will not be visible.A value of `0` means the layer does not have a maximum scale.The maxScale value should always be smaller than the [minScale](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#minScale) value,and greater than or equal to the service specification.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#maxScale)
     */
    maxScale: number;
    /**
     * The minimum scale (most zoomed out) at which the layer is visible in the view.If the map is zoomed out beyond this scale, the layer will not be visible.A value of `0` means the layer does not have a minimum scale.The minScale value should always be larger than the [maxScale](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#maxScale) value,and lesser than or equal to the service specification.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#minScale)
     */
    minScale: number;
    /**
     * The level of opacity to set on the sublayer on a scalefrom 0.0 - 1.0 where `0` is fully transparent and `1.0` is fully opaque.If the [MapImageLayer.opacity](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#opacity)is set, the actual opacity value of the sublayer will be the value of[MapImageLayer.opacity](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#opacity) multipliedby the sublayer's opacity.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#opacity)
     */
    opacity: number;
    /**
     * Indicates whether to display popups when features in the layer are clicked.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled: boolean;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#popupTemplate)
     */
    popupTemplate: PopupTemplate;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#renderer)
     */
    renderer: Renderer;
    /**
     * An object that allows you to create a dynamic layer with dataeither from the map service sublayers or data from a registered workspace.See [DynamicMapLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicMapLayer)for creating dynamic layers from map service layers for on the flyrendering, labeling, and filtering (definition expressions). To createdynamic layers from other sources in registered workspaces such as tables and table joins,see [DynamicDataLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicDataLayer).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#source)
     */
    source: DynamicMapLayer | DynamicDataLayer;
    /**
     * If a sublayer contains sublayers, thisproperty is a [Collection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html) of [Sublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html)objects belonging to the given sublayer with sublayers.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#sublayers)
     */
    sublayers: Collection<Sublayer>;
    /**
     * The title of the sublayer used to identify it in places such as the[LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) and [Legend](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Legend.html) widgets.This value can be defined in the map service or programmaticallyby the developer. It can also be useful for finding a specificsublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#title)
     */
    title: string;
    /**
     * The URL to the REST endpoint of the sublayer. This allowsyou to view the schema of fields and query tables locatedin registered workspaces.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#url)
     */
    readonly url: string;
    /**
     * Indicates if the layer is visible in the view.To see if you can use this property, check the`supportsSublayerVisibility` property of[MapImageLayer.capabilities](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#capabilities).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#visible)
     */
    visible: boolean;

    /**
     * Creates a deep clone of the sublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#clone)
     *
     *
     */
    clone(): Sublayer;
    /**
     * A convenient method for creating a [FeatureLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-FeatureLayer.html) instancebased on the Sublayer's configuration, including[dynamic sources](https://enterprise.arcgis.com/en/server/latest/publish-services/linux/about-dynamic-layers.htm).This allows you to take advantage of FeatureLayercapabilities not supported in Sublayer, such as the[Smart Mapping creator functions](https://developers.arcgis.com/javascript/latest/api-reference/esri-renderers-smartMapping-creators-color.html).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#createFeatureLayer)
     *
     *
     */
    createFeatureLayer(): IPromise<FeatureLayer>;
    /**
     * Creates a [Query](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-support-Query.html) object withdefault values representing the layer's state, including filters (definitionexpression) on the layer's features.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#createQuery)
     *
     *
     */
    createQuery(): Query;
    /**
     * Executes a [query](https://developers.arcgis.com/javascript/latest/api-reference/esri-tasks-QueryTask.html) against features in the sublayer.To see if you can use this property, check the`supportsQuery` property of[MapImageLayer.capabilities](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#capabilities).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#queryFeatures)
     *
     * @param query Specifies the attributes and spatialfilter of the query. If no parameters are specified, then all features satisfying thelayer's configuration/filters are returned.
     * @param options An object with the following properties.
     * @param options.signal Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     */
    queryFeatures(query?: Query | QueryProperties, options?: SublayerQueryFeaturesOptions): IPromise<FeatureSet>;
    /**
     * Serialize the sublayer for usage in /export
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#toExportImageJSON)
     *
     *
     */
    toExportImageJSON(): void;
  }

  interface SublayerConstructor {
    new (properties?: SublayerProperties): Sublayer;
  }

  export const Sublayer: SublayerConstructor;

  interface SublayerProperties {
    /**
     * A SQL where clause used to filter features in the image.Only the features that satisfy the definition expression are displayed in the[View](https://developers.arcgis.com/javascript/latest/api-reference/esri-views-View.html). Definition expressionsmay be set when a sublayer is constructed prior to it loading in the view or after it hasbeen added to the MapImageLayer. To see if you can use this property, check the`supportsSublayerDefinitionExpression` property of[MapImageLayer.capabilities](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#capabilities).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#definitionExpression)
     */
    definitionExpression?: string;
    /**
     * The sublayer's layer ID. When a [source](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#source) is not defined on thelayer, this value represents the id of the sublayer defined by the map service.If creating a [DynamicDataLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicDataLayer) or a [MapDataLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#MapDataLayer)and adding it to the [source](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#source) property of the sublayer, the value of thisproperty can be anything set by the developer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#id)
     */
    id?: number;
    /**
     * The label definition for this layer,specified as an array of [LabelClass](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-LabelClass.html) objects.Use this property to specify labeling properties for the layer such as label expression, placement, and size.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#labelingInfo)
     */
    labelingInfo?: LabelClassProperties[];
    /**
     * Indicates if labels for the sublayer will be visible in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#labelsVisible)
     *
     * @default true
     */
    labelsVisible?: boolean;
    /**
     * The [MapImageLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html) or [TileLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-TileLayer.html) to which the sublayer belongs.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#layer)
     */
    layer?: MapImageLayerProperties | TileLayerProperties;
    /**
     * Indicates whether the layer will be included in the legend. When `false`, the layer will be excluded from the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled?: boolean;
    /**
     * Indicates how the layer should display in the [LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) widget.The possible values are listed below.Value | Description------|------------ show | The layer is visible in the table of contents. hide | The layer is hidden in the table of contents. hide-children | Hide the children layers from the table of contents.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#listMode)
     *
     * @default show
     */
    listMode?: "show" | "hide" | "hide-children";
    /**
     * The maximum scale (most zoomed in) at which the layer is visible in the view.If the map is zoomed in beyond this scale, the layer will not be visible.A value of `0` means the layer does not have a maximum scale.The maxScale value should always be smaller than the [minScale](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#minScale) value,and greater than or equal to the service specification.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#maxScale)
     */
    maxScale?: number;
    /**
     * The minimum scale (most zoomed out) at which the layer is visible in the view.If the map is zoomed out beyond this scale, the layer will not be visible.A value of `0` means the layer does not have a minimum scale.The minScale value should always be larger than the [maxScale](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#maxScale) value,and lesser than or equal to the service specification.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#minScale)
     */
    minScale?: number;
    /**
     * The level of opacity to set on the sublayer on a scalefrom 0.0 - 1.0 where `0` is fully transparent and `1.0` is fully opaque.If the [MapImageLayer.opacity](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#opacity)is set, the actual opacity value of the sublayer will be the value of[MapImageLayer.opacity](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#opacity) multipliedby the sublayer's opacity.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#opacity)
     */
    opacity?: number;
    /**
     * Indicates whether to display popups when features in the layer are clicked.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#popupEnabled)
     *
     * @default true
     */
    popupEnabled?: boolean;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#popupTemplate)
     */
    popupTemplate?: PopupTemplateProperties;
    /**
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#renderer)
     */
    renderer?: RendererProperties;
    /**
     * An object that allows you to create a dynamic layer with dataeither from the map service sublayers or data from a registered workspace.See [DynamicMapLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicMapLayer)for creating dynamic layers from map service layers for on the flyrendering, labeling, and filtering (definition expressions). To createdynamic layers from other sources in registered workspaces such as tables and table joins,see [DynamicDataLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicDataLayer).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#source)
     */
    source?: DynamicMapLayer | DynamicDataLayer;
    /**
     * If a sublayer contains sublayers, thisproperty is a [Collection](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Collection.html) of [Sublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html)objects belonging to the given sublayer with sublayers.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#sublayers)
     */
    sublayers?: CollectionProperties<SublayerProperties>;
    /**
     * The title of the sublayer used to identify it in places such as the[LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) and [Legend](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Legend.html) widgets.This value can be defined in the map service or programmaticallyby the developer. It can also be useful for finding a specificsublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#title)
     */
    title?: string;
    /**
     * Indicates if the layer is visible in the view.To see if you can use this property, check the`supportsSublayerVisibility` property of[MapImageLayer.capabilities](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-MapImageLayer.html#capabilities).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#visible)
     */
    visible?: boolean;
  }

  /**
   * A dynamic data layer is a layer created on-the-fly with data stored in a[registered workspace](https://server.arcgis.com/en/server/latest/publish-services/windows/overview-register-data-with-arcgis-server.htm). This is data that can be rendered and queried on the fly,but that isn't explicitly exposed as a service sublayer.Depending on the type of data source, these layers are classified asone of the following:Data source | Description------------|------------[TableDataSource](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#TableDataSource) | A feature class with geometries or table without geometries. When a table data source does not contain geometries, it may be used as one of the sources in a [join operation](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#JoinTableDataSource). Feature class tables may be used on their own since they contain a geometry field.[QueryTableDataSource](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#QueryTableDataSource) | A feature class or table that may be queried on the fly with a SQL where clause. This data source is useful for scenarios where you have a table containing unique geometries and another table with multiple records that match to each geometry. You can use the QueryTableDataSource to select only a subset of those matching records (so records in both tables have a one-to-one relationship with each other) and join them to the table with geometries.[RasterDataSource](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#RasterDataSource) | A raster dataset used for visualization purposes only.[JoinTableDataSource](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#JoinTableDataSource) | This data source consists of two data sources joined by a common attribute or key. The left table data source typically contains geometries, while the right source may be a table or query table without geometries.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicDataLayer)
   */
  export interface DynamicDataLayer extends Object {
    /**
     * This value is always `data-layer` and is inferred whenthe `dataSource` property is set.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicDataLayer)
     */
    type: string;
    /**
     * A table,feature class, or raster that resides in a registered workspace (either a folder or geodatabase).The data sources are not visible in the Services Directory by default. They may be viewed, published, and configured usingthe ArcGIS Server Manager.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicDataLayer)
     */
    dataSource: TableDataSource | QueryTableDataSource | RasterDataSource | JoinTableDataSource;
    /**
     * Controls field visibility in the layer. Only specified fields will be visible.If `null`, all fields are visible in the dynamic layer. The specification for a field object isprovided below.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicDataLayer)
     */
    fields: DynamicDataLayerFields[];
  }

  /**
   * A dynamic map layer refers to a layer published in a map service that hasdynamic layers enabled.This layer type may be used to create multiple [sublayers](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#sublayers)that point to the same service layer, but are assigned different definitionexpressions, renderers, and other properties.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicMapLayer)
   */
  export interface DynamicMapLayer extends Object {
    /**
     * This value is always `map-layer` and is inferred whenthe `mapLayerId` property is set.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicMapLayer)
     */
    type: string;
    /**
     * The [id](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#id) of the service sublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicMapLayer)
     */
    mapLayerId: number;
    /**
     * An optional property for specifying the GDB version.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicMapLayer)
     */
    gdbVersion: string;
  }

  /**
   * The result of an on-the-fly join operation at runtime. Nested joins are supported.To use nested joins, set either `leftTableSource` or `rightTableSource` to `join-table`.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#JoinTableDataSource)
   */
  export interface JoinTableDataSource extends Object {
    /**
     * This value is always `join-table` and is inferred when otherjoin table properties of this object are set.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#JoinTableDataSource)
     */
    type: string;
    /**
     * The field name used for joining or matching records in the left table torecords in the right table.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#JoinTableDataSource)
     */
    leftTableKey: string;
    /**
     * The field name used for joining or matching records in the right tableto records in the left table.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#JoinTableDataSource)
     */
    rightTableKey: string;
    /**
     * The left table for joining to the right table source. This can either be a dynamic map layer or a dynamic data layer. The dynamic data layer may contain another join data source used for nested joining.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#JoinTableDataSource)
     */
    leftTableSource: DynamicMapLayer | DynamicDataLayer;
    /**
     * The right table for joining to the left table source. This can either be a dynamic map layer or a dynamic data layer. The dynamic data layer may contain another join data source used for nested joining.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#JoinTableDataSource)
     */
    rightTableSource: DynamicMapLayer | DynamicDataLayer;
    /**
     * The type of join that will be performed.Possible Value | Description---------------|------------left-outer-join | Unmatched records in the left table source are preserved and joined with `null` values in the right table source.left-inner-join | Records in the left table source are discarded if they are unmatched with records in the right table source.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#JoinTableDataSource)
     */
    joinType: string;
  }

  /**
   * A query table is a feature class or table defined by a SQL query on the fly.Query layers allow both spatial and nonspatial informationstored in a database to be easily integrated into map serviceoperations. Since a query table uses SQL to directly query databasetables and views, spatial information used by a query table isnot required to be in a geodatabase.This data source is useful for scenarios where you have a table containingmultiple records that match to a single geometry in either another table or a map service layer.You can use the QueryTableDataSource to select only a subset of those matching recordsand join them to the table with geometriesso records in both tables have a one-to-one relationship with each other.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#QueryTableDataSource)
   */
  export interface QueryTableDataSource extends Object {
    /**
     * This value is always `query-table` andis inferred when the `query` property of this object is set.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#QueryTableDataSource)
     */
    type: string;
    /**
     * The workspace where the data resides (defined in ArcGIS Server Manager).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#QueryTableDataSource)
     */
    workspaceId: string;
    /**
     * The SQL query used to filter records.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#QueryTableDataSource)
     */
    query: string;
    /**
     * The field name(s) containing the unique IDs for eachrecord in the table. This can be a comma separated list if the query table is usedin a [JoinTableDataSource](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#JoinDataTableSource).
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#QueryTableDataSource)
     */
    oidFields: string;
    /**
     * The spatial reference of the geometry of each feature in the table source.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#QueryTableDataSource)
     */
    spatialReference: SpatialReference;
    /**
     * The geometry type of each record in the table.    **Possible Values:** point | multipoint | polyline | polygon | multipatch
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#QueryTableDataSource)
     */
    geometryType: string;
  }

  /**
   * A file-based raster that resides in a registered raster workspace. The raster mayonly be displayed in the view, not queried or assigned a renderer.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#RasterDataSource)
   */
  export interface RasterDataSource extends Object {
    /**
     * This value is always `raster`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#RasterDataSource)
     */
    type: string;
    /**
     * The workspace where the raster resides as defined in the ArcGIS Server Manager.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#RasterDataSource)
     */
    workspaceId: string;
    /**
     * The name of the raster in the registered workspace.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#RasterDataSource)
     */
    dataSourceName: string;
  }

  export interface SublayerQueryFeaturesOptions extends Object {
    /**
     * Signal object that can be used to abort the asynchronous task.  The returned promise will be rejected with an [Error](https://developers.arcgis.com/javascript/latest/api-reference/esri-core-Error.html) named `AbortError` when an abort is signaled.  See also [AbortController](https://developer.mozilla.org/en-US/docs/Web/API/AbortController) for more information on how to construct a controller that can be used to deliver abort signals.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#queryFeatures)
     */
    signal?: AbortSignal;
  }

  /**
   * A table or feature class that resides in a registered workspace (either a folder or geodatabase).In the case of a geodatabase, if versioned, use `version` toswitch to an alternate geodatabase version.
   *
   * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#TableDataSource)
   */
  export interface TableDataSource extends Object {
    /**
     * This value is always `table`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#TableDataSource)
     */
    type: string;
    /**
     * The workspace where the table resides as defined in the ArcGIS Server Manager.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#TableDataSource)
     */
    workspaceId: string;
    /**
     * The name of the table in the registered workspace.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#TableDataSource)
     */
    dataSourceName: string;
    /**
     * References the geodatabase version if multiple versions exist in the geodatabase.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#TableDataSource)
     */
    gdbVersion: string;
  }

  export interface DynamicDataLayerFields extends Object {
    /**
     * The name of the field.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicDataLayer)
     */
    name: string;
    /**
     * The alias of the field.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-Sublayer.html#DynamicDataLayer)
     */
    alias: string;
  }

  interface TileInfo extends Accessor, JSONSupport {
    /**
     * The dots per inch (DPI) of the tiling scheme.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#dpi)
     */
    dpi: number;
    /**
     * Image format of the cached tiles.**Possible Values:** png | png24 | png32 | jpg | dib | tiff | emf | ps | pdf | gif | svg | svgz | mixed | lerc
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#format)
     */
    format: string;
    /**
     * Indicates if the tiling scheme supports wrap around.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#isWrappable)
     */
    isWrappable: boolean;
    /**
     * An array of levels of detail that define the tiling scheme.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#lods)
     */
    lods: LOD[];
    /**
     * The tiling scheme origin.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#origin)
     */
    origin: Point;
    /**
     * Size of tiles in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#size)
     */
    size: number[];
    /**
     * The spatial reference of the tiling schema.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#spatialReference)
     */
    spatialReference: SpatialReference;

    /**
     * Utility method used to convert a scale value to its corresponding zoom value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#scaleToZoom)
     *
     * @param scale The scale value to convert.
     *
     */
    scaleToZoom(scale: number): number;
    /**
     * Utility method used to convert a zoom value to its corresponding scale value.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#zoomToScale)
     *
     * @param zoom The zoom value to convert.
     *
     */
    zoomToScale(zoom: number): number;
  }

  interface TileInfoConstructor {
    new (properties?: TileInfoProperties): TileInfo;

    /**
     * A convenience method used to create a new TileInfo instance with preset properties like [LODs](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#lods). Optionally, properties such as `size`, `scales[]`, anda `[SpatialReference](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html)` can also be set to calculate [LODs](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#lods) for each TileInfo.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#create)
     *
     * @param options An object that contains the size, scales, and/or [SpatialReference](https://developers.arcgis.com/javascript/latest/api-reference/esri-geometry-SpatialReference.html) used tocompute the new TileInfo instance.
     * @param options.size The size of each tile in pixels.
     * @param options.spatialReference The spatial referencefor the new TileInfo instance. If the spatial reference is not WGS84 nor WebMercator,the origin of the TileInfo is `0.0`.
     * @param options.scales An array of scale values to use for the TileInfo.If none are specified, the scales from the [ArcGIS Online basemaps](https://www.arcgis.com/home/group.html?id=702026e41f6641fb85da88efe79dc166#overview) are used from level 0 through 24.
     *
     */
    create(options?: TileInfoCreateOptions): TileInfo;

    fromJSON(json: any): TileInfo;
  }

  export const TileInfo: TileInfoConstructor;

  interface TileInfoProperties {
    /**
     * The dots per inch (DPI) of the tiling scheme.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#dpi)
     */
    dpi?: number;
    /**
     * Image format of the cached tiles.**Possible Values:** png | png24 | png32 | jpg | dib | tiff | emf | ps | pdf | gif | svg | svgz | mixed | lerc
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#format)
     */
    format?: string;
    /**
     * Indicates if the tiling scheme supports wrap around.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#isWrappable)
     */
    isWrappable?: boolean;
    /**
     * An array of levels of detail that define the tiling scheme.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#lods)
     */
    lods?: LODProperties[];
    /**
     * The tiling scheme origin.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#origin)
     */
    origin?: PointProperties;
    /**
     * Size of tiles in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#size)
     */
    size?: number[];
    /**
     * The spatial reference of the tiling schema.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#spatialReference)
     */
    spatialReference?: SpatialReferenceProperties;
  }

  export interface TileInfoCreateOptions extends Object {
    /**
     * The size of each tile in pixels.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#create)
     *
     * @default 256
     */
    size?: number;
    /**
     * The spatial referencefor the new TileInfo instance. If the spatial reference is not WGS84 nor WebMercator,the origin of the TileInfo is `0.0`.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#create)
     *
     * @default WebMercator
     */
    spatialReference?: SpatialReference;
    /**
     * An array of scale values to use for the TileInfo.If none are specified, the scales from the [ArcGIS Online basemaps](https://www.arcgis.com/home/group.html?id=702026e41f6641fb85da88efe79dc166#overview) are used from level 0 through 24.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileInfo.html#create)
     *
     * @default The scales provided by ArcGIS Online basemaps
     */
    scales?: number[];
  }

  interface TileMatrixSet extends Accessor, JSONSupport {
    /**
     * The full extent of the TileMatrixSet.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileMatrixSet.html#fullExtent)
     */
    fullExtent: Extent;
    /**
     * The unique ID assigned to the TileMatrixSet.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileMatrixSet.html#id)
     */
    id: string;
    /**
     * The tiling scheme information for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileMatrixSet.html#tileInfo)
     */
    tileInfo: TileInfo;

    /**
     * Creates a deep clone of this TileMatrixSet.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileMatrixSet.html#clone)
     *
     *
     */
    clone(): TileMatrixSet;
  }

  interface TileMatrixSetConstructor {
    new (properties?: TileMatrixSetProperties): TileMatrixSet;

    fromJSON(json: any): TileMatrixSet;
  }

  export const TileMatrixSet: TileMatrixSetConstructor;

  interface TileMatrixSetProperties {
    /**
     * The full extent of the TileMatrixSet.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileMatrixSet.html#fullExtent)
     */
    fullExtent?: ExtentProperties;
    /**
     * The unique ID assigned to the TileMatrixSet.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileMatrixSet.html#id)
     */
    id?: string;
    /**
     * The tiling scheme information for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TileMatrixSet.html#tileInfo)
     */
    tileInfo?: TileInfoProperties;
  }

  interface TimeInfo extends Accessor, JSONSupport {
    /**
     * The name of the field containing the end time information.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#endField)
     */
    endField: string;
    /**
     * The time extent defines the start time and end time for all data in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#fullTimeExtent)
     *
     * @default null
     */
    fullTimeExtent: TimeExtent;
    /**
     * The time interval defines the granularity of the temporal data and allows you tovisualize the data at specified intervals using the [time slider widget](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-TimeSlider.html).Usually temporal data is collected at regular intervals such as every hour or every day.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#interval)
     */
    interval: TimeInterval;
    /**
     * The name of the field containing the start time information.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#startField)
     */
    startField: string;

    /**
     * Creates a deep clone of TimeInfo object.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#clone)
     *
     *
     */
    clone(): TimeInfo;
  }

  interface TimeInfoConstructor {
    new (properties?: TimeInfoProperties): TimeInfo;

    fromJSON(json: any): TimeInfo;
  }

  export const TimeInfo: TimeInfoConstructor;

  interface TimeInfoProperties {
    /**
     * The name of the field containing the end time information.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#endField)
     */
    endField?: string;
    /**
     * The time extent defines the start time and end time for all data in the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#fullTimeExtent)
     *
     * @default null
     */
    fullTimeExtent?: TimeExtentProperties;
    /**
     * The time interval defines the granularity of the temporal data and allows you tovisualize the data at specified intervals using the [time slider widget](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-TimeSlider.html).Usually temporal data is collected at regular intervals such as every hour or every day.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#interval)
     */
    interval?: TimeIntervalProperties;
    /**
     * The name of the field containing the start time information.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-TimeInfo.html#startField)
     */
    startField?: string;
  }

  interface WMSSublayer extends Accessor {
    /**
     * Description for the WMS sublayer.This defaults to the value of the Abstract property from the WMS GetCapabilities request.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#description)
     */
    description: string;
    /**
     * The full extent of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#fullExtent)
     */
    fullExtent: Extent;
    /**
     * The id for the WMS sublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#id)
     */
    id: number;
    /**
     * The [WMSLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-WMSLayer.html) to which the sublayer belongs.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#layer)
     */
    layer: WMSLayer;
    /**
     * Indicates whether the layer will be included in the legend. When `false`, the layer will be excluded from the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled: boolean;
    /**
     * A string url pointing to a legend image for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#legendUrl)
     */
    legendUrl: string;
    /**
     * Name of the WMS sublayer.This defaults to the value of the Name property from the WMS GetCapabilities request.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#name)
     */
    name: string;
    /**
     * Indicates whether to display popups when features in the layer are clicked.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#popupEnabled)
     *
     * @default false
     */
    popupEnabled: boolean;
    /**
     * Indicates if the layer can be queried, i.e. the service supports GetFeatureInfo with either text/html or text/plain formats.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#queryable)
     *
     * @default false
     */
    queryable: boolean;
    /**
     * List of spatialReferences (WKID) derived from the CRS elements of the first layer in the GetCapabilities request.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#spatialReferences)
     */
    spatialReferences: number[];
    /**
     * A collection of [WMSSublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html)s.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#sublayers)
     */
    sublayers: Collection<WMSSublayer>;
    /**
     * The title of the WMS sublayer used to identify it in places such as the[LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) and [Legend](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Legend.html) widgets.This defaults to the value of the Title property from the WMS GetCapabilities request.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#title)
     */
    title: string;
    /**
     * Indicates if the layer is visible in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#visible)
     */
    visible: boolean;

    /**
     * Creates a deep clone of the WMS sublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#clone)
     *
     *
     */
    clone(): WMSSublayer;
  }

  interface WMSSublayerConstructor {
    new (properties?: WMSSublayerProperties): WMSSublayer;
  }

  export const WMSSublayer: WMSSublayerConstructor;

  interface WMSSublayerProperties {
    /**
     * Description for the WMS sublayer.This defaults to the value of the Abstract property from the WMS GetCapabilities request.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#description)
     */
    description?: string;
    /**
     * The full extent of the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#fullExtent)
     */
    fullExtent?: ExtentProperties;
    /**
     * The id for the WMS sublayer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#id)
     */
    id?: number;
    /**
     * The [WMSLayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-WMSLayer.html) to which the sublayer belongs.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#layer)
     */
    layer?: WMSLayerProperties;
    /**
     * Indicates whether the layer will be included in the legend. When `false`, the layer will be excluded from the legend.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#legendEnabled)
     *
     * @default true
     */
    legendEnabled?: boolean;
    /**
     * A string url pointing to a legend image for the layer.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#legendUrl)
     */
    legendUrl?: string;
    /**
     * Name of the WMS sublayer.This defaults to the value of the Name property from the WMS GetCapabilities request.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#name)
     */
    name?: string;
    /**
     * Indicates whether to display popups when features in the layer are clicked.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#popupEnabled)
     *
     * @default false
     */
    popupEnabled?: boolean;
    /**
     * Indicates if the layer can be queried, i.e. the service supports GetFeatureInfo with either text/html or text/plain formats.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#queryable)
     *
     * @default false
     */
    queryable?: boolean;
    /**
     * List of spatialReferences (WKID) derived from the CRS elements of the first layer in the GetCapabilities request.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#spatialReferences)
     */
    spatialReferences?: number[];
    /**
     * A collection of [WMSSublayer](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html)s.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#sublayers)
     */
    sublayers?: CollectionProperties<WMSSublayerProperties>;
    /**
     * The title of the WMS sublayer used to identify it in places such as the[LayerList](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-LayerList.html) and [Legend](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Legend.html) widgets.This defaults to the value of the Title property from the WMS GetCapabilities request.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#title)
     */
    title?: string;
    /**
     * Indicates if the layer is visible in the view.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMSSublayer.html#visible)
     */
    visible?: boolean;
  }

  interface WMTSStyle extends Accessor, JSONSupport {
    /**
     * Description for the WMTS style.This defaults to the value of the Abstract property from the WMTS GetCapabilities request.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMTSStyle.html#description)
     */
    description: string;
    /**
     * The unique ID assigned to the style.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMTSStyle.html#id)
     */
    id: string;
    /**
     * The URL to the legend which gets used in [Legend](https://developers.arcgis.com/javascript/latest/api-reference/esri-widgets-Legend.html) widget.This defaults to the value of the LegendURL property from the WMTS GetCapabilities request.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMTSStyle.html#legendUrl)
     */
    legendUrl: string;
    /**
     * The title of the WMTS style.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMTSStyle.html#title)
     */
    title: string;

    /**
     * Creates a deep clone of the WMTSStyle.
     *
     * [Read more...](https://developers.arcgis.com/javascript/latest/api-reference/esri-layers-support-WMTSStyle.html#clone)
     *
     *
     */
    clone(): WMTSStyle;
  }

  interface WMTSStyleConstructor {
    new (properties?: WMTSStyleProperties): WMTSStyle;

    fromJSON(json: any): WMTSStyle;
  }

  export const WMTSStyle: WMTSStyleConstructor;

  interface WMTSStyleProperties {
    /**
     * Descript